# coding: utf-8
from sqlalchemy import Column, text, Integer, FLOAT
from sqlalchemy.dialects.mysql import LONGTEXT, VARCHAR, TIMESTAMP
from sqlalchemy.ext.declarative import declarative_base

# db_string = "mysql+pymysql://"+'acqfd'+":"+'acqfd16313302'+"@"+'192.168.10.201'+"/"+'acqfd_test'+"?charset=utf8mb4&binary_prefix=true"
# engine = create_engine(db_string, echo=True)
# Base = declarative_base()

Base = declarative_base()
metadata = Base.metadata


class Deviceinfo(Base):
    __tablename__ = 'deviceinfo'

    pk_id = Column(Integer, primary_key=True, autoincrement=True, unique=True)
    serial_number = Column(VARCHAR(100), nullable=False)
    client_account = Column(VARCHAR(20), nullable=False)
    udid = Column(VARCHAR(100), nullable=False)
    hardware_device_type = Column(VARCHAR(100))
    hardware_device_model = Column(VARCHAR(100))
    hardware_device_brand = Column(VARCHAR(100))
    hardware_cpu_architecture = Column(VARCHAR(100))
    hardware_cpu_cores = Column(VARCHAR(100))
    hardware_memory_size = Column(VARCHAR(100))
    hardware_gpu_name = Column(VARCHAR(200))
    hardware_is_battery_charging = Column(VARCHAR(10))
    hardware_battery_level = Column(VARCHAR(10))
    hardware_audio_fp = Column(VARCHAR(100))
    hardware_pointing_method = Column(VARCHAR(100))
    hardware_max_touch_points = Column(VARCHAR(10))
    # hardware_connection = Column(VARCHAR(10))
    os_name = Column(VARCHAR(100))
    os_version = Column(VARCHAR(100))
    os_platform = Column(VARCHAR(100))
    os_local_datetime = Column(VARCHAR(100))
    os_local_timezone = Column(VARCHAR(100))
    os_local_timezone_offset = Column(VARCHAR(100))
    os_screen_orientation = Column(VARCHAR(100))
    os_screen_resolution_width = Column(VARCHAR(10))
    os_screen_resolution_height = Column(VARCHAR(10))
    os_screen_pixel_ratio = Column(VARCHAR(30))
    os_screen_color_depth = Column(VARCHAR(20))
    ip_source = Column(VARCHAR(20))
    ip_foundation = Column(VARCHAR(20))
    ip_intranet = Column(VARCHAR(100))
    ip_src_latitude = Column(VARCHAR(15))
    ip_src_longitude = Column(VARCHAR(15))
    ip_src_timezone = Column(VARCHAR(100))
    ip_src_country = Column(VARCHAR(100))
    ip_request = Column(VARCHAR(20))
    ip_latitude = Column(VARCHAR(15))
    ip_longitude = Column(VARCHAR(15))
    ip_timezone = Column(VARCHAR(100))
    ip_country = Column(VARCHAR(100))
    # ip_region = Column(VARCHAR(100))
    # ip_city = Column(VARCHAR(100))
    # ip_suburb = Column(VARCHAR(100))
    # ip_city_district = Column(VARCHAR(100))
    # ip_village = Column(VARCHAR(100))
    # ip_road = Column(VARCHAR(100))
    ip_isp = Column(VARCHAR(100))
    ip_hostname = Column(VARCHAR(100))
    ip_is_proxy = Column(VARCHAR(10))
    ip_is_tor = Column(VARCHAR(10))
    ip_is_vpn = Column(VARCHAR(10))
    ip_cloud_server = Column(VARCHAR(100))
    # ip_dnsbl = Column(VARCHAR(10))
    # ip_surbl = Column(VARCHAR(10))
    browser_name = Column(VARCHAR(100))
    browser_version = Column(VARCHAR(100))
    browser_engine = Column(VARCHAR(100))
    browser_resolution_width = Column(VARCHAR(10))
    browser_resolution_height = Column(VARCHAR(10))
    browser_url = Column(VARCHAR(500))
    browser_useragent = Column(VARCHAR(500))
    browser_req_useragent = Column(VARCHAR(500))
    browser_plugins = Column(LONGTEXT)
    browser_mimetypes = Column(VARCHAR(500))
    browser_language = Column(VARCHAR(100))
    browser_language_fp = Column(VARCHAR(100))
    browser_is_support_canvas = Column(VARCHAR(10))
    browser_canvas_fp = Column(VARCHAR(100))
    browser_number_of_available_fonts = Column(VARCHAR(100))
    browser_available_fonts = Column(LONGTEXT)
    browser_fonts_fp = Column(VARCHAR(100))
    browser_is_support_webgl1 = Column(VARCHAR(10))
    browser_is_support_webgl2 = Column(VARCHAR(10))
    browser_webgl_fp = Column(VARCHAR(100))
    # browser_is_tracking_protection = Column(VARCHAR(10))
    browser_is_support_cookies = Column(VARCHAR(10))
    # browser_is_support_flash = Column(VARCHAR(10))
    # browser_is_support_activex = Column(VARCHAR(10))
    # browser_is_support_javaapplet = Column(VARCHAR(10))
    # browser_is_support_audio_context = Column(VARCHAR(10))
    browser_is_support_webrtc = Column(VARCHAR(10))
    browser_is_support_websocket = Column(VARCHAR(10))
    browser_is_support_indexeddb = Column(VARCHAR(10))
    browser_is_support_local_storage = Column(VARCHAR(10))
    browser_is_support_session_storage = Column(VARCHAR(10))
    browser_is_support_open_database = Column(VARCHAR(10))
    browser_http_version = Column(VARCHAR(20))
    # browser_tls_protocol = Column(VARCHAR(20))
    # browser_tls_cipher = Column(VARCHAR(100))
    # browser_accepted_content_types = Column(VARCHAR(100))
    browser_accepted_content_encodings = Column(VARCHAR(100))
    browser_is_private_mode = Column(VARCHAR(10))
    browser_is_use_webdriver = Column(VARCHAR(10))
    browser_is_brave = Column(VARCHAR(10))
    browser_is_tor = Column(VARCHAR(10))
    # browser_is_use_adblock = Column(VARCHAR(10))
    # browser_pageviews = Column(VARCHAR(10))
    # browser_account_login = Column(VARCHAR(100))
    create_time = Column(TIMESTAMP(fsp=6), nullable=False,
                         server_default=text("CURRENT_TIMESTAMP(6)"))


class UDIDHistory(Base):
    __tablename__ = 'udid_history'

    pk_id = Column(Integer, primary_key=True, autoincrement=True, unique=True)
    indexeddb_version = Column(VARCHAR(45))
    indexeddb_pointer = Column(VARCHAR(100))
    internet_ip = Column(VARCHAR(20))
    intranet_ip = Column(VARCHAR(20))
    udid_pointer_id = Column(Integer)
    deviceinfo_id = Column(Integer)
    udid_path = Column(VARCHAR(5))
    create_time = Column(TIMESTAMP(fsp=6), nullable=False,
                         server_default=text("CURRENT_TIMESTAMP(6)"))


class RobotInfo(Base):
    __tablename__ = 'robot_info'

    pk_id = Column(Integer, primary_key=True, autoincrement=True)
    serial_number = Column(VARCHAR(100))
    client_account = Column(VARCHAR(100))
    is_robot = Column(VARCHAR(10))
    robot_val = Column(FLOAT)
    # robot_score = Column(FLOAT)
    # bio_score = Column(FLOAT)
    device_type = Column(VARCHAR(100))
    platform = Column(VARCHAR(100))
    vendor = Column(VARCHAR(100))
    renderer = Column(VARCHAR(100))
    os_name = Column(VARCHAR(100))
    is_emulator = Column(VARCHAR(10))
    is_proxy = Column(VARCHAR(10))
    is_tor = Column(VARCHAR(10))
    is_vpn = Column(VARCHAR(10))
    is_cloud = Column(VARCHAR(10))
    browser_name = Column(VARCHAR(100))
    useragent = Column(VARCHAR(200))
    headless = Column(VARCHAR(10))
    webdriver = Column(VARCHAR(10))
    is_private_mode = Column(VARCHAR(10))
    eval = Column(Integer)
    mouse_enter = Column(VARCHAR(10))
    mouse_click = Column(VARCHAR(10))
    touch_start = Column(VARCHAR(10))
    tab = Column(VARCHAR(10))
    paste = Column(VARCHAR(10))
    focus_on_abnormal = Column(VARCHAR(10))
    keyin_abnormal = Column(VARCHAR(10))
    keydown_avg_time = Column(FLOAT)
    is_change_useragent = Column(VARCHAR(10))
    is_change_plugins = Column(VARCHAR(10))
    is_change_languages = Column(VARCHAR(10))
    is_change_webdriver = Column(VARCHAR(10))
    is_change_eval = Column(VARCHAR(10))
    is_change_platform = Column(VARCHAR(10))
    is_short_page_time = Column(VARCHAR(10))
    page_time = Column(FLOAT)
    # mouse_log = Column(LONGTEXT)
    # events_log = Column(LONGTEXT)
    create_time = Column(TIMESTAMP(fsp=6), nullable=False,
                         server_default=text("CURRENT_TIMESTAMP(6)"))


class RobotInfoV2(Base):
    __tablename__ = 'robot_info_v2'

    pk_id = Column(Integer, primary_key=True, autoincrement=True)
    serial_number = Column(VARCHAR(100))
    client_account = Column(VARCHAR(100))
    # is_robot = Column(VARCHAR(10))
    # robot_val = Column(FLOAT)
    # robot_score = Column(FLOAT)
    # bio_score = Column(FLOAT)
    # device_type = Column(VARCHAR(100))
    platform = Column(VARCHAR(100))
    vendor = Column(VARCHAR(100))
    renderer = Column(VARCHAR(100))
    # os_name = Column(VARCHAR(100))
    # is_emulator = Column(VARCHAR(10))
    # is_proxy = Column(VARCHAR(10))
    # is_tor = Column(VARCHAR(10))
    # is_vpn = Column(VARCHAR(10))
    # is_cloud = Column(VARCHAR(10))
    # browser_name = Column(VARCHAR(100))
    useragent = Column(VARCHAR(200))
    # headless = Column(VARCHAR(10))
    webdriver = Column(VARCHAR(10))
    is_private_mode = Column(VARCHAR(10))
    eval = Column(Integer)
    mouse_enter = Column(VARCHAR(10))
    mouse_click = Column(VARCHAR(10))
    touch_start = Column(VARCHAR(10))
    tab = Column(VARCHAR(10))
    paste = Column(VARCHAR(10))
    # focus_on_abnormal = Column(VARCHAR(10))
    # keyin_abnormal = Column(VARCHAR(10))
    # keydown_avg_time = Column(FLOAT)
    is_change_useragent = Column(VARCHAR(10))
    is_change_plugins = Column(VARCHAR(10))
    is_change_languages = Column(VARCHAR(10))
    is_change_webdriver = Column(VARCHAR(10))
    is_change_eval = Column(VARCHAR(10))
    is_change_platform = Column(VARCHAR(10))
    # is_short_page_time = Column(VARCHAR(10))
    page_time = Column(FLOAT)
    # mouse_log = Column(LONGTEXT)
    # events_log = Column(LONGTEXT)
    resolution_width = Column(VARCHAR(10))
    resolution_height = Column(VARCHAR(10))
    pixel_ratio = Column(VARCHAR(10))
    source_ip = Column(VARCHAR(20))
    create_time = Column(TIMESTAMP(fsp=6), nullable=False,
                         server_default=text("CURRENT_TIMESTAMP(6)"))
