# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository  # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from mailslurp_client.api_client import ApiClient
from mailslurp_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class InboxControllerApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_inbox(self, **kwargs):  # noqa: E501
        """Create an inbox email address. An inbox has a real email address and can send and receive emails. Inboxes can be either `SMTP` or `HTTP` inboxes.  # noqa: E501

        Create a new inbox and with a randomized email address to send and receive from. Pass emailAddress parameter if you wish to use a specific email address. Creating an inbox is required before sending or receiving emails. If writing tests it is recommended that you create a new inbox during each test method so that it is unique and empty.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_inbox(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str a_custom_email_address_to_use_with_the_inbox__defaults_to_null__when_null_mail_slurp_will_assign_a_random_email_address_to_the_inbox_such_as_123mailslurp_com__if_you_use_the_use_domain_pool_option_when_the_email_address_is_null_it_will_generate_an_email_address_with_a_more_varied_domain_ending_such_as_123mailslurp_info_or_123mailslurp_biz__when_a_custom_email_address_is_provided_the_address_is_split_into_a_domain_and_the_domain_is_queried_against_your_user__if_you_have_created_the_domain_in_the_mail_slurp_dashboard_and_verified_it_you_can_use_any_email_address_that_ends_with_the_domain__note_domain_types_must_match_the_inbox_type___so_smtp_inboxes_will_only_work_with_smtp_type_domains__avoid_smtp_inboxes_if_you_need_to_send_emails_as_they_can_only_receive__send_an_email_to_this_address_and_the_inbox_will_receive_and_store_it_for_you__to_retrieve_the_email_use_the_inbox_and_email_controller_endpoints_with_the_inbox_id_:
        :param list[str] tags_that_inbox_has_been_tagged_with__tags_can_be_added_to_inboxes_to_group_different_inboxes_within_an_account__you_can_also_search_for_inboxes_by_tag_in_the_dashboard_ui_:
        :param str optional_name_of_the_inbox__displayed_in_the_dashboard_for_easier_search_and_used_as_the_sender_name_when_sending_emails_:
        :param str optional_description_of_the_inbox_for_labelling_purposes__is_shown_in_the_dashboard_and_can_be_used_with:
        :param bool use_the_mail_slurp_domain_name_pool_with_this_inbox_when_creating_the_email_address__defaults_to_null__if_enabled_the_inbox_will_be_an_email_address_with_a_domain_randomly_chosen_from_a_list_of_the_mail_slurp_domains__this_is_useful_when_the_default_mailslurp_com_email_addresses_used_with_inboxes_are_blocked_or_considered_spam_by_a_provider_or_receiving_service__when_domain_pool_is_enabled_an_email_address_will_be_generated_ending_in_mailslurp_worldinfoxyz______this_means_a_tld_is_randomly_selecting_from_a_list_of__biz__info__xyz_etc_to_add_variance_to_the_generated_email_addresses__when_null_or_false_mail_slurp_uses_the_default_behavior_of_mailslurp_com_or_custom_email_address_provided_by_the_email_address_field__note_this_feature_is_only_available_for_http_inbox_types_:
        :param bool is_the_inbox_a_favorite__marking_an_inbox_as_a_favorite_is_typically_done_in_the_dashboard_for_quick_access_or_filtering:
        :param datetime optional_inbox_expiration_date__if_null_then_this_inbox_is_permanent_and_the_emails_in_it_wont_be_deleted__if_an_expiration_date_is_provided_or_is_required_by_your_plan_the_inbox_will_be_closed_when_the_expiration_time_is_reached__expired_inboxes_still_contain_their_emails_but_can_no_longer_send_or_receive_emails__an_expired_inbox_record_is_created_when_an_inbox_and_the_email_address_and_inbox_id_are_recorded__the_expires_at_property_is_a_timestamp_string_in_iso_date_time_format_yyyy_mm_dd_th_hmmss_sssxxx_:
        :param int number_of_milliseconds_that_inbox_should_exist_for:
        :param bool deprecated__team_access_is_always_true__grant_team_access_to_this_inbox_and_the_emails_that_belong_to_it_for_team_members_of_your_organization_:
        :param str http__default_or_smtp_inbox_type__http_inboxes_are_default_and_best_solution_for_most_cases__smtp_inboxes_are_more_reliable_for_public_inbound_email_consumption__but_do_not_support_sending_emails__when_using_custom_domains_the_domain_type_must_match_the_inbox_type__http_inboxes_are_processed_by_aws_ses_while_smtp_inboxes_use_a_custom_mail_server_running_at_mx_mailslurp_com_:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InboxDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_inbox_with_http_info(**kwargs)  # noqa: E501

    def create_inbox_with_http_info(self, **kwargs):  # noqa: E501
        """Create an inbox email address. An inbox has a real email address and can send and receive emails. Inboxes can be either `SMTP` or `HTTP` inboxes.  # noqa: E501

        Create a new inbox and with a randomized email address to send and receive from. Pass emailAddress parameter if you wish to use a specific email address. Creating an inbox is required before sending or receiving emails. If writing tests it is recommended that you create a new inbox during each test method so that it is unique and empty.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_inbox_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str a_custom_email_address_to_use_with_the_inbox__defaults_to_null__when_null_mail_slurp_will_assign_a_random_email_address_to_the_inbox_such_as_123mailslurp_com__if_you_use_the_use_domain_pool_option_when_the_email_address_is_null_it_will_generate_an_email_address_with_a_more_varied_domain_ending_such_as_123mailslurp_info_or_123mailslurp_biz__when_a_custom_email_address_is_provided_the_address_is_split_into_a_domain_and_the_domain_is_queried_against_your_user__if_you_have_created_the_domain_in_the_mail_slurp_dashboard_and_verified_it_you_can_use_any_email_address_that_ends_with_the_domain__note_domain_types_must_match_the_inbox_type___so_smtp_inboxes_will_only_work_with_smtp_type_domains__avoid_smtp_inboxes_if_you_need_to_send_emails_as_they_can_only_receive__send_an_email_to_this_address_and_the_inbox_will_receive_and_store_it_for_you__to_retrieve_the_email_use_the_inbox_and_email_controller_endpoints_with_the_inbox_id_:
        :param list[str] tags_that_inbox_has_been_tagged_with__tags_can_be_added_to_inboxes_to_group_different_inboxes_within_an_account__you_can_also_search_for_inboxes_by_tag_in_the_dashboard_ui_:
        :param str optional_name_of_the_inbox__displayed_in_the_dashboard_for_easier_search_and_used_as_the_sender_name_when_sending_emails_:
        :param str optional_description_of_the_inbox_for_labelling_purposes__is_shown_in_the_dashboard_and_can_be_used_with:
        :param bool use_the_mail_slurp_domain_name_pool_with_this_inbox_when_creating_the_email_address__defaults_to_null__if_enabled_the_inbox_will_be_an_email_address_with_a_domain_randomly_chosen_from_a_list_of_the_mail_slurp_domains__this_is_useful_when_the_default_mailslurp_com_email_addresses_used_with_inboxes_are_blocked_or_considered_spam_by_a_provider_or_receiving_service__when_domain_pool_is_enabled_an_email_address_will_be_generated_ending_in_mailslurp_worldinfoxyz______this_means_a_tld_is_randomly_selecting_from_a_list_of__biz__info__xyz_etc_to_add_variance_to_the_generated_email_addresses__when_null_or_false_mail_slurp_uses_the_default_behavior_of_mailslurp_com_or_custom_email_address_provided_by_the_email_address_field__note_this_feature_is_only_available_for_http_inbox_types_:
        :param bool is_the_inbox_a_favorite__marking_an_inbox_as_a_favorite_is_typically_done_in_the_dashboard_for_quick_access_or_filtering:
        :param datetime optional_inbox_expiration_date__if_null_then_this_inbox_is_permanent_and_the_emails_in_it_wont_be_deleted__if_an_expiration_date_is_provided_or_is_required_by_your_plan_the_inbox_will_be_closed_when_the_expiration_time_is_reached__expired_inboxes_still_contain_their_emails_but_can_no_longer_send_or_receive_emails__an_expired_inbox_record_is_created_when_an_inbox_and_the_email_address_and_inbox_id_are_recorded__the_expires_at_property_is_a_timestamp_string_in_iso_date_time_format_yyyy_mm_dd_th_hmmss_sssxxx_:
        :param int number_of_milliseconds_that_inbox_should_exist_for:
        :param bool deprecated__team_access_is_always_true__grant_team_access_to_this_inbox_and_the_emails_that_belong_to_it_for_team_members_of_your_organization_:
        :param str http__default_or_smtp_inbox_type__http_inboxes_are_default_and_best_solution_for_most_cases__smtp_inboxes_are_more_reliable_for_public_inbound_email_consumption__but_do_not_support_sending_emails__when_using_custom_domains_the_domain_type_must_match_the_inbox_type__http_inboxes_are_processed_by_aws_ses_while_smtp_inboxes_use_a_custom_mail_server_running_at_mx_mailslurp_com_:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InboxDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'a_custom_email_address_to_use_with_the_inbox__defaults_to_null__when_null_mail_slurp_will_assign_a_random_email_address_to_the_inbox_such_as_123mailslurp_com__if_you_use_the_use_domain_pool_option_when_the_email_address_is_null_it_will_generate_an_email_address_with_a_more_varied_domain_ending_such_as_123mailslurp_info_or_123mailslurp_biz__when_a_custom_email_address_is_provided_the_address_is_split_into_a_domain_and_the_domain_is_queried_against_your_user__if_you_have_created_the_domain_in_the_mail_slurp_dashboard_and_verified_it_you_can_use_any_email_address_that_ends_with_the_domain__note_domain_types_must_match_the_inbox_type___so_smtp_inboxes_will_only_work_with_smtp_type_domains__avoid_smtp_inboxes_if_you_need_to_send_emails_as_they_can_only_receive__send_an_email_to_this_address_and_the_inbox_will_receive_and_store_it_for_you__to_retrieve_the_email_use_the_inbox_and_email_controller_endpoints_with_the_inbox_id_',
            'tags_that_inbox_has_been_tagged_with__tags_can_be_added_to_inboxes_to_group_different_inboxes_within_an_account__you_can_also_search_for_inboxes_by_tag_in_the_dashboard_ui_',
            'optional_name_of_the_inbox__displayed_in_the_dashboard_for_easier_search_and_used_as_the_sender_name_when_sending_emails_',
            'optional_description_of_the_inbox_for_labelling_purposes__is_shown_in_the_dashboard_and_can_be_used_with',
            'use_the_mail_slurp_domain_name_pool_with_this_inbox_when_creating_the_email_address__defaults_to_null__if_enabled_the_inbox_will_be_an_email_address_with_a_domain_randomly_chosen_from_a_list_of_the_mail_slurp_domains__this_is_useful_when_the_default_mailslurp_com_email_addresses_used_with_inboxes_are_blocked_or_considered_spam_by_a_provider_or_receiving_service__when_domain_pool_is_enabled_an_email_address_will_be_generated_ending_in_mailslurp_worldinfoxyz______this_means_a_tld_is_randomly_selecting_from_a_list_of__biz__info__xyz_etc_to_add_variance_to_the_generated_email_addresses__when_null_or_false_mail_slurp_uses_the_default_behavior_of_mailslurp_com_or_custom_email_address_provided_by_the_email_address_field__note_this_feature_is_only_available_for_http_inbox_types_',
            'is_the_inbox_a_favorite__marking_an_inbox_as_a_favorite_is_typically_done_in_the_dashboard_for_quick_access_or_filtering',
            'optional_inbox_expiration_date__if_null_then_this_inbox_is_permanent_and_the_emails_in_it_wont_be_deleted__if_an_expiration_date_is_provided_or_is_required_by_your_plan_the_inbox_will_be_closed_when_the_expiration_time_is_reached__expired_inboxes_still_contain_their_emails_but_can_no_longer_send_or_receive_emails__an_expired_inbox_record_is_created_when_an_inbox_and_the_email_address_and_inbox_id_are_recorded__the_expires_at_property_is_a_timestamp_string_in_iso_date_time_format_yyyy_mm_dd_th_hmmss_sssxxx_',
            'number_of_milliseconds_that_inbox_should_exist_for',
            'deprecated__team_access_is_always_true__grant_team_access_to_this_inbox_and_the_emails_that_belong_to_it_for_team_members_of_your_organization_',
            'http__default_or_smtp_inbox_type__http_inboxes_are_default_and_best_solution_for_most_cases__smtp_inboxes_are_more_reliable_for_public_inbound_email_consumption__but_do_not_support_sending_emails__when_using_custom_domains_the_domain_type_must_match_the_inbox_type__http_inboxes_are_processed_by_aws_ses_while_smtp_inboxes_use_a_custom_mail_server_running_at_mx_mailslurp_com_'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_inbox" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'a_custom_email_address_to_use_with_the_inbox__defaults_to_null__when_null_mail_slurp_will_assign_a_random_email_address_to_the_inbox_such_as_123mailslurp_com__if_you_use_the_use_domain_pool_option_when_the_email_address_is_null_it_will_generate_an_email_address_with_a_more_varied_domain_ending_such_as_123mailslurp_info_or_123mailslurp_biz__when_a_custom_email_address_is_provided_the_address_is_split_into_a_domain_and_the_domain_is_queried_against_your_user__if_you_have_created_the_domain_in_the_mail_slurp_dashboard_and_verified_it_you_can_use_any_email_address_that_ends_with_the_domain__note_domain_types_must_match_the_inbox_type___so_smtp_inboxes_will_only_work_with_smtp_type_domains__avoid_smtp_inboxes_if_you_need_to_send_emails_as_they_can_only_receive__send_an_email_to_this_address_and_the_inbox_will_receive_and_store_it_for_you__to_retrieve_the_email_use_the_inbox_and_email_controller_endpoints_with_the_inbox_id_' in local_var_params and local_var_params['a_custom_email_address_to_use_with_the_inbox__defaults_to_null__when_null_mail_slurp_will_assign_a_random_email_address_to_the_inbox_such_as_123mailslurp_com__if_you_use_the_use_domain_pool_option_when_the_email_address_is_null_it_will_generate_an_email_address_with_a_more_varied_domain_ending_such_as_123mailslurp_info_or_123mailslurp_biz__when_a_custom_email_address_is_provided_the_address_is_split_into_a_domain_and_the_domain_is_queried_against_your_user__if_you_have_created_the_domain_in_the_mail_slurp_dashboard_and_verified_it_you_can_use_any_email_address_that_ends_with_the_domain__note_domain_types_must_match_the_inbox_type___so_smtp_inboxes_will_only_work_with_smtp_type_domains__avoid_smtp_inboxes_if_you_need_to_send_emails_as_they_can_only_receive__send_an_email_to_this_address_and_the_inbox_will_receive_and_store_it_for_you__to_retrieve_the_email_use_the_inbox_and_email_controller_endpoints_with_the_inbox_id_'] is not None:  # noqa: E501
            query_params.append(('A custom email address to use with the inbox. Defaults to null. When null MailSlurp will assign a random email address to the inbox such as &#x60;123@mailslurp.com&#x60;. If you use the &#x60;useDomainPool&#x60; option when the email address is null it will generate an email address with a more varied domain ending such as &#x60;123@mailslurp.info&#x60; or &#x60;123@mailslurp.biz&#x60;. When a custom email address is provided the address is split into a domain and the domain is queried against your user. If you have created the domain in the MailSlurp dashboard and verified it you can use any email address that ends with the domain. Note domain types must match the inbox type - so &#x60;SMTP&#x60; inboxes will only work with &#x60;SMTP&#x60; type domains. Avoid &#x60;SMTP&#x60; inboxes if you need to send emails as they can only receive. Send an email to this address and the inbox will receive and store it for you. To retrieve the email use the Inbox and Email Controller endpoints with the inbox ID.', local_var_params['a_custom_email_address_to_use_with_the_inbox__defaults_to_null__when_null_mail_slurp_will_assign_a_random_email_address_to_the_inbox_such_as_123mailslurp_com__if_you_use_the_use_domain_pool_option_when_the_email_address_is_null_it_will_generate_an_email_address_with_a_more_varied_domain_ending_such_as_123mailslurp_info_or_123mailslurp_biz__when_a_custom_email_address_is_provided_the_address_is_split_into_a_domain_and_the_domain_is_queried_against_your_user__if_you_have_created_the_domain_in_the_mail_slurp_dashboard_and_verified_it_you_can_use_any_email_address_that_ends_with_the_domain__note_domain_types_must_match_the_inbox_type___so_smtp_inboxes_will_only_work_with_smtp_type_domains__avoid_smtp_inboxes_if_you_need_to_send_emails_as_they_can_only_receive__send_an_email_to_this_address_and_the_inbox_will_receive_and_store_it_for_you__to_retrieve_the_email_use_the_inbox_and_email_controller_endpoints_with_the_inbox_id_']))  # noqa: E501
        if 'tags_that_inbox_has_been_tagged_with__tags_can_be_added_to_inboxes_to_group_different_inboxes_within_an_account__you_can_also_search_for_inboxes_by_tag_in_the_dashboard_ui_' in local_var_params and local_var_params['tags_that_inbox_has_been_tagged_with__tags_can_be_added_to_inboxes_to_group_different_inboxes_within_an_account__you_can_also_search_for_inboxes_by_tag_in_the_dashboard_ui_'] is not None:  # noqa: E501
            query_params.append(('Tags that inbox has been tagged with. Tags can be added to inboxes to group different inboxes within an account. You can also search for inboxes by tag in the dashboard UI.', local_var_params['tags_that_inbox_has_been_tagged_with__tags_can_be_added_to_inboxes_to_group_different_inboxes_within_an_account__you_can_also_search_for_inboxes_by_tag_in_the_dashboard_ui_']))  # noqa: E501
            collection_formats['Tags that inbox has been tagged with. Tags can be added to inboxes to group different inboxes within an account. You can also search for inboxes by tag in the dashboard UI.'] = 'multi'  # noqa: E501
        if 'optional_name_of_the_inbox__displayed_in_the_dashboard_for_easier_search_and_used_as_the_sender_name_when_sending_emails_' in local_var_params and local_var_params['optional_name_of_the_inbox__displayed_in_the_dashboard_for_easier_search_and_used_as_the_sender_name_when_sending_emails_'] is not None:  # noqa: E501
            query_params.append(('Optional name of the inbox. Displayed in the dashboard for easier search and used as the sender name when sending emails.', local_var_params['optional_name_of_the_inbox__displayed_in_the_dashboard_for_easier_search_and_used_as_the_sender_name_when_sending_emails_']))  # noqa: E501
        if 'optional_description_of_the_inbox_for_labelling_purposes__is_shown_in_the_dashboard_and_can_be_used_with' in local_var_params and local_var_params['optional_description_of_the_inbox_for_labelling_purposes__is_shown_in_the_dashboard_and_can_be_used_with'] is not None:  # noqa: E501
            query_params.append(('Optional description of the inbox for labelling purposes. Is shown in the dashboard and can be used with', local_var_params['optional_description_of_the_inbox_for_labelling_purposes__is_shown_in_the_dashboard_and_can_be_used_with']))  # noqa: E501
        if 'use_the_mail_slurp_domain_name_pool_with_this_inbox_when_creating_the_email_address__defaults_to_null__if_enabled_the_inbox_will_be_an_email_address_with_a_domain_randomly_chosen_from_a_list_of_the_mail_slurp_domains__this_is_useful_when_the_default_mailslurp_com_email_addresses_used_with_inboxes_are_blocked_or_considered_spam_by_a_provider_or_receiving_service__when_domain_pool_is_enabled_an_email_address_will_be_generated_ending_in_mailslurp_worldinfoxyz______this_means_a_tld_is_randomly_selecting_from_a_list_of__biz__info__xyz_etc_to_add_variance_to_the_generated_email_addresses__when_null_or_false_mail_slurp_uses_the_default_behavior_of_mailslurp_com_or_custom_email_address_provided_by_the_email_address_field__note_this_feature_is_only_available_for_http_inbox_types_' in local_var_params and local_var_params['use_the_mail_slurp_domain_name_pool_with_this_inbox_when_creating_the_email_address__defaults_to_null__if_enabled_the_inbox_will_be_an_email_address_with_a_domain_randomly_chosen_from_a_list_of_the_mail_slurp_domains__this_is_useful_when_the_default_mailslurp_com_email_addresses_used_with_inboxes_are_blocked_or_considered_spam_by_a_provider_or_receiving_service__when_domain_pool_is_enabled_an_email_address_will_be_generated_ending_in_mailslurp_worldinfoxyz______this_means_a_tld_is_randomly_selecting_from_a_list_of__biz__info__xyz_etc_to_add_variance_to_the_generated_email_addresses__when_null_or_false_mail_slurp_uses_the_default_behavior_of_mailslurp_com_or_custom_email_address_provided_by_the_email_address_field__note_this_feature_is_only_available_for_http_inbox_types_'] is not None:  # noqa: E501
            query_params.append(('Use the MailSlurp domain name pool with this inbox when creating the email address. Defaults to null. If enabled the inbox will be an email address with a domain randomly chosen from a list of the MailSlurp domains. This is useful when the default &#x60;@mailslurp.com&#x60; email addresses used with inboxes are blocked or considered spam by a provider or receiving service. When domain pool is enabled an email address will be generated ending in &#x60;@mailslurp.{world,info,xyz,...}&#x60; . This means a TLD is randomly selecting from a list of &#x60;.biz&#x60;, &#x60;.info&#x60;, &#x60;.xyz&#x60; etc to add variance to the generated email addresses. When null or false MailSlurp uses the default behavior of &#x60;@mailslurp.com&#x60; or custom email address provided by the emailAddress field. Note this feature is only available for &#x60;HTTP&#x60; inbox types.', local_var_params['use_the_mail_slurp_domain_name_pool_with_this_inbox_when_creating_the_email_address__defaults_to_null__if_enabled_the_inbox_will_be_an_email_address_with_a_domain_randomly_chosen_from_a_list_of_the_mail_slurp_domains__this_is_useful_when_the_default_mailslurp_com_email_addresses_used_with_inboxes_are_blocked_or_considered_spam_by_a_provider_or_receiving_service__when_domain_pool_is_enabled_an_email_address_will_be_generated_ending_in_mailslurp_worldinfoxyz______this_means_a_tld_is_randomly_selecting_from_a_list_of__biz__info__xyz_etc_to_add_variance_to_the_generated_email_addresses__when_null_or_false_mail_slurp_uses_the_default_behavior_of_mailslurp_com_or_custom_email_address_provided_by_the_email_address_field__note_this_feature_is_only_available_for_http_inbox_types_']))  # noqa: E501
        if 'is_the_inbox_a_favorite__marking_an_inbox_as_a_favorite_is_typically_done_in_the_dashboard_for_quick_access_or_filtering' in local_var_params and local_var_params['is_the_inbox_a_favorite__marking_an_inbox_as_a_favorite_is_typically_done_in_the_dashboard_for_quick_access_or_filtering'] is not None:  # noqa: E501
            query_params.append(('Is the inbox a favorite. Marking an inbox as a favorite is typically done in the dashboard for quick access or filtering', local_var_params['is_the_inbox_a_favorite__marking_an_inbox_as_a_favorite_is_typically_done_in_the_dashboard_for_quick_access_or_filtering']))  # noqa: E501
        if 'optional_inbox_expiration_date__if_null_then_this_inbox_is_permanent_and_the_emails_in_it_wont_be_deleted__if_an_expiration_date_is_provided_or_is_required_by_your_plan_the_inbox_will_be_closed_when_the_expiration_time_is_reached__expired_inboxes_still_contain_their_emails_but_can_no_longer_send_or_receive_emails__an_expired_inbox_record_is_created_when_an_inbox_and_the_email_address_and_inbox_id_are_recorded__the_expires_at_property_is_a_timestamp_string_in_iso_date_time_format_yyyy_mm_dd_th_hmmss_sssxxx_' in local_var_params and local_var_params['optional_inbox_expiration_date__if_null_then_this_inbox_is_permanent_and_the_emails_in_it_wont_be_deleted__if_an_expiration_date_is_provided_or_is_required_by_your_plan_the_inbox_will_be_closed_when_the_expiration_time_is_reached__expired_inboxes_still_contain_their_emails_but_can_no_longer_send_or_receive_emails__an_expired_inbox_record_is_created_when_an_inbox_and_the_email_address_and_inbox_id_are_recorded__the_expires_at_property_is_a_timestamp_string_in_iso_date_time_format_yyyy_mm_dd_th_hmmss_sssxxx_'] is not None:  # noqa: E501
            query_params.append(('Optional inbox expiration date. If null then this inbox is permanent and the emails in it won&#39;t be deleted. If an expiration date is provided or is required by your plan the inbox will be closed when the expiration time is reached. Expired inboxes still contain their emails but can no longer send or receive emails. An ExpiredInboxRecord is created when an inbox and the email address and inbox ID are recorded. The expiresAt property is a timestamp string in ISO DateTime Format yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSXXX.', local_var_params['optional_inbox_expiration_date__if_null_then_this_inbox_is_permanent_and_the_emails_in_it_wont_be_deleted__if_an_expiration_date_is_provided_or_is_required_by_your_plan_the_inbox_will_be_closed_when_the_expiration_time_is_reached__expired_inboxes_still_contain_their_emails_but_can_no_longer_send_or_receive_emails__an_expired_inbox_record_is_created_when_an_inbox_and_the_email_address_and_inbox_id_are_recorded__the_expires_at_property_is_a_timestamp_string_in_iso_date_time_format_yyyy_mm_dd_th_hmmss_sssxxx_']))  # noqa: E501
        if 'number_of_milliseconds_that_inbox_should_exist_for' in local_var_params and local_var_params['number_of_milliseconds_that_inbox_should_exist_for'] is not None:  # noqa: E501
            query_params.append(('Number of milliseconds that inbox should exist for', local_var_params['number_of_milliseconds_that_inbox_should_exist_for']))  # noqa: E501
        if 'deprecated__team_access_is_always_true__grant_team_access_to_this_inbox_and_the_emails_that_belong_to_it_for_team_members_of_your_organization_' in local_var_params and local_var_params['deprecated__team_access_is_always_true__grant_team_access_to_this_inbox_and_the_emails_that_belong_to_it_for_team_members_of_your_organization_'] is not None:  # noqa: E501
            query_params.append(('DEPRECATED (team access is always true). Grant team access to this inbox and the emails that belong to it for team members of your organization.', local_var_params['deprecated__team_access_is_always_true__grant_team_access_to_this_inbox_and_the_emails_that_belong_to_it_for_team_members_of_your_organization_']))  # noqa: E501
        if 'http__default_or_smtp_inbox_type__http_inboxes_are_default_and_best_solution_for_most_cases__smtp_inboxes_are_more_reliable_for_public_inbound_email_consumption__but_do_not_support_sending_emails__when_using_custom_domains_the_domain_type_must_match_the_inbox_type__http_inboxes_are_processed_by_aws_ses_while_smtp_inboxes_use_a_custom_mail_server_running_at_mx_mailslurp_com_' in local_var_params and local_var_params['http__default_or_smtp_inbox_type__http_inboxes_are_default_and_best_solution_for_most_cases__smtp_inboxes_are_more_reliable_for_public_inbound_email_consumption__but_do_not_support_sending_emails__when_using_custom_domains_the_domain_type_must_match_the_inbox_type__http_inboxes_are_processed_by_aws_ses_while_smtp_inboxes_use_a_custom_mail_server_running_at_mx_mailslurp_com_'] is not None:  # noqa: E501
            query_params.append(('HTTP (default) or SMTP inbox type. HTTP inboxes are default and best solution for most cases. SMTP inboxes are more reliable for public inbound email consumption (but do not support sending emails). When using custom domains the domain type must match the inbox type. HTTP inboxes are processed by AWS SES while SMTP inboxes use a custom mail server running at &#x60;mx.mailslurp.com&#x60;.', local_var_params['http__default_or_smtp_inbox_type__http_inboxes_are_default_and_best_solution_for_most_cases__smtp_inboxes_are_more_reliable_for_public_inbound_email_consumption__but_do_not_support_sending_emails__when_using_custom_domains_the_domain_type_must_match_the_inbox_type__http_inboxes_are_processed_by_aws_ses_while_smtp_inboxes_use_a_custom_mail_server_running_at_mx_mailslurp_com_']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InboxDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_inbox_ruleset(self, inbox_id, create_inbox_ruleset_options, **kwargs):  # noqa: E501
        """Create an inbox ruleset  # noqa: E501

        Create a new inbox rule for forwarding, blocking, and allowing emails when sending and receiving  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_inbox_ruleset(inbox_id, create_inbox_ruleset_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: (required)
        :param CreateInboxRulesetOptions create_inbox_ruleset_options: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InboxRulesetDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_inbox_ruleset_with_http_info(inbox_id, create_inbox_ruleset_options, **kwargs)  # noqa: E501

    def create_inbox_ruleset_with_http_info(self, inbox_id, create_inbox_ruleset_options, **kwargs):  # noqa: E501
        """Create an inbox ruleset  # noqa: E501

        Create a new inbox rule for forwarding, blocking, and allowing emails when sending and receiving  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_inbox_ruleset_with_http_info(inbox_id, create_inbox_ruleset_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: (required)
        :param CreateInboxRulesetOptions create_inbox_ruleset_options: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InboxRulesetDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'inbox_id',
            'create_inbox_ruleset_options'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_inbox_ruleset" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'inbox_id' is set
        if self.api_client.client_side_validation and ('inbox_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['inbox_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `inbox_id` when calling `create_inbox_ruleset`")  # noqa: E501
        # verify the required parameter 'create_inbox_ruleset_options' is set
        if self.api_client.client_side_validation and ('create_inbox_ruleset_options' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_inbox_ruleset_options'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_inbox_ruleset_options` when calling `create_inbox_ruleset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'inbox_id' in local_var_params:
            path_params['inboxId'] = local_var_params['inbox_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_inbox_ruleset_options' in local_var_params:
            body_params = local_var_params['create_inbox_ruleset_options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes/{inboxId}/rulesets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InboxRulesetDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_inbox_with_defaults(self, **kwargs):  # noqa: E501
        """Create an inbox with default options. Uses MailSlurp domain pool address and is private.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_inbox_with_defaults(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InboxDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_inbox_with_defaults_with_http_info(**kwargs)  # noqa: E501

    def create_inbox_with_defaults_with_http_info(self, **kwargs):  # noqa: E501
        """Create an inbox with default options. Uses MailSlurp domain pool address and is private.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_inbox_with_defaults_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InboxDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_inbox_with_defaults" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes/withDefaults', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InboxDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_inbox_with_options(self, create_inbox_dto, **kwargs):  # noqa: E501
        """Create an inbox with options. Extended options for inbox creation.  # noqa: E501

        Additional endpoint that allows inbox creation with request body options. Can be more flexible that other methods for some clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_inbox_with_options(create_inbox_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateInboxDto create_inbox_dto: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InboxDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_inbox_with_options_with_http_info(create_inbox_dto, **kwargs)  # noqa: E501

    def create_inbox_with_options_with_http_info(self, create_inbox_dto, **kwargs):  # noqa: E501
        """Create an inbox with options. Extended options for inbox creation.  # noqa: E501

        Additional endpoint that allows inbox creation with request body options. Can be more flexible that other methods for some clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_inbox_with_options_with_http_info(create_inbox_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateInboxDto create_inbox_dto: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InboxDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'create_inbox_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_inbox_with_options" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_inbox_dto' is set
        if self.api_client.client_side_validation and ('create_inbox_dto' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_inbox_dto'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_inbox_dto` when calling `create_inbox_with_options`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_inbox_dto' in local_var_params:
            body_params = local_var_params['create_inbox_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes/withOptions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InboxDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_all_inboxes(self, **kwargs):  # noqa: E501
        """Delete all inboxes  # noqa: E501

        Permanently delete all inboxes and associated email addresses. This will also delete all emails within the inboxes. Be careful as inboxes cannot be recovered once deleted. Note: deleting inboxes will not impact your usage limits. Monthly inbox creation limits are based on how many inboxes were created in the last 30 days, not how many inboxes you currently have.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_all_inboxes(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_all_inboxes_with_http_info(**kwargs)  # noqa: E501

    def delete_all_inboxes_with_http_info(self, **kwargs):  # noqa: E501
        """Delete all inboxes  # noqa: E501

        Permanently delete all inboxes and associated email addresses. This will also delete all emails within the inboxes. Be careful as inboxes cannot be recovered once deleted. Note: deleting inboxes will not impact your usage limits. Monthly inbox creation limits are based on how many inboxes were created in the last 30 days, not how many inboxes you currently have.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_all_inboxes_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_all_inboxes" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_inbox(self, inbox_id, **kwargs):  # noqa: E501
        """Delete inbox  # noqa: E501

        Permanently delete an inbox and associated email address as well as all emails within the given inbox. This action cannot be undone. Note: deleting an inbox will not affect your account usage. Monthly inbox usage is based on how many inboxes you create within 30 days, not how many exist at time of request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_inbox(inbox_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_inbox_with_http_info(inbox_id, **kwargs)  # noqa: E501

    def delete_inbox_with_http_info(self, inbox_id, **kwargs):  # noqa: E501
        """Delete inbox  # noqa: E501

        Permanently delete an inbox and associated email address as well as all emails within the given inbox. This action cannot be undone. Note: deleting an inbox will not affect your account usage. Monthly inbox usage is based on how many inboxes you create within 30 days, not how many exist at time of request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_inbox_with_http_info(inbox_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'inbox_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_inbox" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'inbox_id' is set
        if self.api_client.client_side_validation and ('inbox_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['inbox_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `inbox_id` when calling `delete_inbox`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'inbox_id' in local_var_params:
            path_params['inboxId'] = local_var_params['inbox_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes/{inboxId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def does_inbox_exist(self, email_address, **kwargs):  # noqa: E501
        """Does inbox exist  # noqa: E501

        Check if inboxes exist by email address. Useful if you are sending emails to mailslurp addresses  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.does_inbox_exist(email_address, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str email_address: Email address (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InboxExistsDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.does_inbox_exist_with_http_info(email_address, **kwargs)  # noqa: E501

    def does_inbox_exist_with_http_info(self, email_address, **kwargs):  # noqa: E501
        """Does inbox exist  # noqa: E501

        Check if inboxes exist by email address. Useful if you are sending emails to mailslurp addresses  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.does_inbox_exist_with_http_info(email_address, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str email_address: Email address (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InboxExistsDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'email_address'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method does_inbox_exist" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'email_address' is set
        if self.api_client.client_side_validation and ('email_address' not in local_var_params or  # noqa: E501
                                                        local_var_params['email_address'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `email_address` when calling `does_inbox_exist`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'email_address' in local_var_params and local_var_params['email_address'] is not None:  # noqa: E501
            query_params.append(('emailAddress', local_var_params['email_address']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes/exists', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InboxExistsDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def flush_expired(self, **kwargs):  # noqa: E501
        """Remove expired inboxes  # noqa: E501

        Remove any expired inboxes for your account (instead of waiting for scheduled removal on server)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.flush_expired(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param datetime before: Optional expired at before flag to flush expired inboxes that have expired before the given time
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FlushExpiredInboxesResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.flush_expired_with_http_info(**kwargs)  # noqa: E501

    def flush_expired_with_http_info(self, **kwargs):  # noqa: E501
        """Remove expired inboxes  # noqa: E501

        Remove any expired inboxes for your account (instead of waiting for scheduled removal on server)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.flush_expired_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param datetime before: Optional expired at before flag to flush expired inboxes that have expired before the given time
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FlushExpiredInboxesResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'before'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method flush_expired" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'before' in local_var_params and local_var_params['before'] is not None:  # noqa: E501
            query_params.append(('before', local_var_params['before']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes/expired', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FlushExpiredInboxesResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_inboxes(self, **kwargs):  # noqa: E501
        """List All Inboxes Paginated  # noqa: E501

        List inboxes in paginated form. The results are available on the `content` property of the returned object. This method allows for page index (zero based), page size (how many results to return), and a sort direction (based on createdAt time). You Can also filter by whether an inbox is favorited or use email address pattern. This method is the recommended way to query inboxes. The alternative `getInboxes` method returns a full list of inboxes but is limited to 100 results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_inboxes(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int page: Optional page index in list pagination
        :param int size: Optional page size in list pagination
        :param str sort: Optional createdAt sort direction ASC or DESC
        :param bool favourite: Optionally filter results for favourites only
        :param str search: Optionally filter by search words partial matching ID, tags, name, and email address
        :param str tag: Optionally filter by tags. Will return inboxes that include given tags
        :param bool deprecated__optionally_filter_by_team_access_:
        :param datetime since: Optional filter by created after given date time
        :param datetime before: Optional filter by created before given date time
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PageInboxProjection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_all_inboxes_with_http_info(**kwargs)  # noqa: E501

    def get_all_inboxes_with_http_info(self, **kwargs):  # noqa: E501
        """List All Inboxes Paginated  # noqa: E501

        List inboxes in paginated form. The results are available on the `content` property of the returned object. This method allows for page index (zero based), page size (how many results to return), and a sort direction (based on createdAt time). You Can also filter by whether an inbox is favorited or use email address pattern. This method is the recommended way to query inboxes. The alternative `getInboxes` method returns a full list of inboxes but is limited to 100 results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_inboxes_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int page: Optional page index in list pagination
        :param int size: Optional page size in list pagination
        :param str sort: Optional createdAt sort direction ASC or DESC
        :param bool favourite: Optionally filter results for favourites only
        :param str search: Optionally filter by search words partial matching ID, tags, name, and email address
        :param str tag: Optionally filter by tags. Will return inboxes that include given tags
        :param bool deprecated__optionally_filter_by_team_access_:
        :param datetime since: Optional filter by created after given date time
        :param datetime before: Optional filter by created before given date time
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PageInboxProjection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'page',
            'size',
            'sort',
            'favourite',
            'search',
            'tag',
            'deprecated__optionally_filter_by_team_access_',
            'since',
            'before'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_inboxes" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'favourite' in local_var_params and local_var_params['favourite'] is not None:  # noqa: E501
            query_params.append(('favourite', local_var_params['favourite']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'tag' in local_var_params and local_var_params['tag'] is not None:  # noqa: E501
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'deprecated__optionally_filter_by_team_access_' in local_var_params and local_var_params['deprecated__optionally_filter_by_team_access_'] is not None:  # noqa: E501
            query_params.append(('DEPRECATED. Optionally filter by team access.', local_var_params['deprecated__optionally_filter_by_team_access_']))  # noqa: E501
        if 'since' in local_var_params and local_var_params['since'] is not None:  # noqa: E501
            query_params.append(('since', local_var_params['since']))  # noqa: E501
        if 'before' in local_var_params and local_var_params['before'] is not None:  # noqa: E501
            query_params.append(('before', local_var_params['before']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes/paginated', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageInboxProjection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_emails(self, id_of_inbox_that_emails_belongs_to, **kwargs):  # noqa: E501
        """Get emails in an Inbox. This method is not idempotent as it allows retries and waits if you want certain conditions to be met before returning. For simple listing and sorting of known emails use the email controller instead.  # noqa: E501

        List emails that an inbox has received. Only emails that are sent to the inbox's email address will appear in the inbox. It may take several seconds for any email you send to an inbox's email address to appear in the inbox. To make this endpoint wait for a minimum number of emails use the `minCount` parameter. The server will retry the inbox database until the `minCount` is satisfied or the `retryTimeout` is reached  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_emails(id_of_inbox_that_emails_belongs_to, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_of_inbox_that_emails_belongs_to: (required)
        :param int alias_for_limit__assessed_first_before_assessing_any_passed_limit_:
        :param int limit: Limit the result set, ordered by received date time sort direction. Maximum 100. For more listing options see the email controller
        :param str sort_the_results_by_received_date_and_direction_asc_or_desc:
        :param int retry_timeout: Maximum milliseconds to spend retrying inbox database until minCount emails are returned
        :param int delay_timeout:
        :param int min_count: Minimum acceptable email count. Will cause request to hang (and retry) until minCount is satisfied or retryTimeout is reached.
        :param bool unread_only:
        :param datetime exclude_emails_received_after_this_iso_8601_date_time:
        :param datetime exclude_emails_received_before_this_iso_8601_date_time:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[EmailPreview]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_emails_with_http_info(id_of_inbox_that_emails_belongs_to, **kwargs)  # noqa: E501

    def get_emails_with_http_info(self, id_of_inbox_that_emails_belongs_to, **kwargs):  # noqa: E501
        """Get emails in an Inbox. This method is not idempotent as it allows retries and waits if you want certain conditions to be met before returning. For simple listing and sorting of known emails use the email controller instead.  # noqa: E501

        List emails that an inbox has received. Only emails that are sent to the inbox's email address will appear in the inbox. It may take several seconds for any email you send to an inbox's email address to appear in the inbox. To make this endpoint wait for a minimum number of emails use the `minCount` parameter. The server will retry the inbox database until the `minCount` is satisfied or the `retryTimeout` is reached  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_emails_with_http_info(id_of_inbox_that_emails_belongs_to, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_of_inbox_that_emails_belongs_to: (required)
        :param int alias_for_limit__assessed_first_before_assessing_any_passed_limit_:
        :param int limit: Limit the result set, ordered by received date time sort direction. Maximum 100. For more listing options see the email controller
        :param str sort_the_results_by_received_date_and_direction_asc_or_desc:
        :param int retry_timeout: Maximum milliseconds to spend retrying inbox database until minCount emails are returned
        :param int delay_timeout:
        :param int min_count: Minimum acceptable email count. Will cause request to hang (and retry) until minCount is satisfied or retryTimeout is reached.
        :param bool unread_only:
        :param datetime exclude_emails_received_after_this_iso_8601_date_time:
        :param datetime exclude_emails_received_before_this_iso_8601_date_time:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[EmailPreview], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id_of_inbox_that_emails_belongs_to',
            'alias_for_limit__assessed_first_before_assessing_any_passed_limit_',
            'limit',
            'sort_the_results_by_received_date_and_direction_asc_or_desc',
            'retry_timeout',
            'delay_timeout',
            'min_count',
            'unread_only',
            'exclude_emails_received_after_this_iso_8601_date_time',
            'exclude_emails_received_before_this_iso_8601_date_time'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_emails" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id_of_inbox_that_emails_belongs_to' is set
        if self.api_client.client_side_validation and ('id_of_inbox_that_emails_belongs_to' not in local_var_params or  # noqa: E501
                                                        local_var_params['id_of_inbox_that_emails_belongs_to'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id_of_inbox_that_emails_belongs_to` when calling `get_emails`")  # noqa: E501

        if self.api_client.client_side_validation and 'alias_for_limit__assessed_first_before_assessing_any_passed_limit_' in local_var_params and local_var_params['alias_for_limit__assessed_first_before_assessing_any_passed_limit_'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `alias_for_limit__assessed_first_before_assessing_any_passed_limit_` when calling `get_emails`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_emails`, must be a value less than or equal to `100`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_of_inbox_that_emails_belongs_to' in local_var_params:
            path_params['Id of inbox that emails belongs to'] = local_var_params['id_of_inbox_that_emails_belongs_to']  # noqa: E501

        query_params = []
        if 'alias_for_limit__assessed_first_before_assessing_any_passed_limit_' in local_var_params and local_var_params['alias_for_limit__assessed_first_before_assessing_any_passed_limit_'] is not None:  # noqa: E501
            query_params.append(('Alias for limit. Assessed first before assessing any passed limit.', local_var_params['alias_for_limit__assessed_first_before_assessing_any_passed_limit_']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'sort_the_results_by_received_date_and_direction_asc_or_desc' in local_var_params and local_var_params['sort_the_results_by_received_date_and_direction_asc_or_desc'] is not None:  # noqa: E501
            query_params.append(('Sort the results by received date and direction ASC or DESC', local_var_params['sort_the_results_by_received_date_and_direction_asc_or_desc']))  # noqa: E501
        if 'retry_timeout' in local_var_params and local_var_params['retry_timeout'] is not None:  # noqa: E501
            query_params.append(('retryTimeout', local_var_params['retry_timeout']))  # noqa: E501
        if 'delay_timeout' in local_var_params and local_var_params['delay_timeout'] is not None:  # noqa: E501
            query_params.append(('delayTimeout', local_var_params['delay_timeout']))  # noqa: E501
        if 'min_count' in local_var_params and local_var_params['min_count'] is not None:  # noqa: E501
            query_params.append(('minCount', local_var_params['min_count']))  # noqa: E501
        if 'unread_only' in local_var_params and local_var_params['unread_only'] is not None:  # noqa: E501
            query_params.append(('unreadOnly', local_var_params['unread_only']))  # noqa: E501
        if 'exclude_emails_received_after_this_iso_8601_date_time' in local_var_params and local_var_params['exclude_emails_received_after_this_iso_8601_date_time'] is not None:  # noqa: E501
            query_params.append(('Exclude emails received after this ISO 8601 date time', local_var_params['exclude_emails_received_after_this_iso_8601_date_time']))  # noqa: E501
        if 'exclude_emails_received_before_this_iso_8601_date_time' in local_var_params and local_var_params['exclude_emails_received_before_this_iso_8601_date_time'] is not None:  # noqa: E501
            query_params.append(('Exclude emails received before this ISO 8601 date time', local_var_params['exclude_emails_received_before_this_iso_8601_date_time']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes/{inboxId}/emails', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EmailPreview]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_inbox(self, inbox_id, **kwargs):  # noqa: E501
        """Get Inbox. Returns properties of an inbox.  # noqa: E501

        Returns an inbox's properties, including its email address and ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inbox(inbox_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InboxDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_inbox_with_http_info(inbox_id, **kwargs)  # noqa: E501

    def get_inbox_with_http_info(self, inbox_id, **kwargs):  # noqa: E501
        """Get Inbox. Returns properties of an inbox.  # noqa: E501

        Returns an inbox's properties, including its email address and ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inbox_with_http_info(inbox_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InboxDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'inbox_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_inbox" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'inbox_id' is set
        if self.api_client.client_side_validation and ('inbox_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['inbox_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `inbox_id` when calling `get_inbox`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'inbox_id' in local_var_params:
            path_params['inboxId'] = local_var_params['inbox_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes/{inboxId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InboxDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_inbox_count(self, **kwargs):  # noqa: E501
        """Get total inbox count  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inbox_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_inbox_count_with_http_info(**kwargs)  # noqa: E501

    def get_inbox_count_with_http_info(self, **kwargs):  # noqa: E501
        """Get total inbox count  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inbox_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_inbox_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_inbox_email_count(self, id_of_inbox_that_emails_belongs_to, **kwargs):  # noqa: E501
        """Get email count in inbox  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inbox_email_count(id_of_inbox_that_emails_belongs_to, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_of_inbox_that_emails_belongs_to: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_inbox_email_count_with_http_info(id_of_inbox_that_emails_belongs_to, **kwargs)  # noqa: E501

    def get_inbox_email_count_with_http_info(self, id_of_inbox_that_emails_belongs_to, **kwargs):  # noqa: E501
        """Get email count in inbox  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inbox_email_count_with_http_info(id_of_inbox_that_emails_belongs_to, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_of_inbox_that_emails_belongs_to: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id_of_inbox_that_emails_belongs_to'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_inbox_email_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id_of_inbox_that_emails_belongs_to' is set
        if self.api_client.client_side_validation and ('id_of_inbox_that_emails_belongs_to' not in local_var_params or  # noqa: E501
                                                        local_var_params['id_of_inbox_that_emails_belongs_to'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id_of_inbox_that_emails_belongs_to` when calling `get_inbox_email_count`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_of_inbox_that_emails_belongs_to' in local_var_params:
            path_params['Id of inbox that emails belongs to'] = local_var_params['id_of_inbox_that_emails_belongs_to']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes/{inboxId}/emails/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_inbox_emails_paginated(self, id_of_inbox_that_emails_belongs_to, **kwargs):  # noqa: E501
        """Get inbox emails paginated  # noqa: E501

        Get a paginated list of emails in an inbox. Does not hold connections open.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inbox_emails_paginated(id_of_inbox_that_emails_belongs_to, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_of_inbox_that_emails_belongs_to: (required)
        :param int page: Optional page index in inbox emails list pagination
        :param int size: Optional page size in inbox emails list pagination
        :param str sort: Optional createdAt sort direction ASC or DESC
        :param datetime since: Optional filter by received after given date time
        :param datetime before: Optional filter by received before given date time
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PageEmailPreview
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_inbox_emails_paginated_with_http_info(id_of_inbox_that_emails_belongs_to, **kwargs)  # noqa: E501

    def get_inbox_emails_paginated_with_http_info(self, id_of_inbox_that_emails_belongs_to, **kwargs):  # noqa: E501
        """Get inbox emails paginated  # noqa: E501

        Get a paginated list of emails in an inbox. Does not hold connections open.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inbox_emails_paginated_with_http_info(id_of_inbox_that_emails_belongs_to, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_of_inbox_that_emails_belongs_to: (required)
        :param int page: Optional page index in inbox emails list pagination
        :param int size: Optional page size in inbox emails list pagination
        :param str sort: Optional createdAt sort direction ASC or DESC
        :param datetime since: Optional filter by received after given date time
        :param datetime before: Optional filter by received before given date time
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PageEmailPreview, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id_of_inbox_that_emails_belongs_to',
            'page',
            'size',
            'sort',
            'since',
            'before'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_inbox_emails_paginated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id_of_inbox_that_emails_belongs_to' is set
        if self.api_client.client_side_validation and ('id_of_inbox_that_emails_belongs_to' not in local_var_params or  # noqa: E501
                                                        local_var_params['id_of_inbox_that_emails_belongs_to'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id_of_inbox_that_emails_belongs_to` when calling `get_inbox_emails_paginated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_of_inbox_that_emails_belongs_to' in local_var_params:
            path_params['Id of inbox that emails belongs to'] = local_var_params['id_of_inbox_that_emails_belongs_to']  # noqa: E501

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'since' in local_var_params and local_var_params['since'] is not None:  # noqa: E501
            query_params.append(('since', local_var_params['since']))  # noqa: E501
        if 'before' in local_var_params and local_var_params['before'] is not None:  # noqa: E501
            query_params.append(('before', local_var_params['before']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes/{inboxId}/emails/paginated', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageEmailPreview',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_inbox_sent_emails(self, inbox_id, **kwargs):  # noqa: E501
        """Get Inbox Sent Emails  # noqa: E501

        Returns an inbox's sent email receipts. Call individual sent email endpoints for more details. Note for privacy reasons the full body of sent emails is never stored. An MD5 hash hex is available for comparison instead.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inbox_sent_emails(inbox_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: (required)
        :param int page: Optional page index in inbox sent email list pagination
        :param int optional_page_size_in_inbox_sent_email_list_pagination:
        :param str sort: Optional createdAt sort direction ASC or DESC
        :param str search_filter: Optional sent email search
        :param datetime since: Optional filter by sent after given date time
        :param datetime before: Optional filter by sent before given date time
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PageSentEmailProjection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_inbox_sent_emails_with_http_info(inbox_id, **kwargs)  # noqa: E501

    def get_inbox_sent_emails_with_http_info(self, inbox_id, **kwargs):  # noqa: E501
        """Get Inbox Sent Emails  # noqa: E501

        Returns an inbox's sent email receipts. Call individual sent email endpoints for more details. Note for privacy reasons the full body of sent emails is never stored. An MD5 hash hex is available for comparison instead.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inbox_sent_emails_with_http_info(inbox_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: (required)
        :param int page: Optional page index in inbox sent email list pagination
        :param int optional_page_size_in_inbox_sent_email_list_pagination:
        :param str sort: Optional createdAt sort direction ASC or DESC
        :param str search_filter: Optional sent email search
        :param datetime since: Optional filter by sent after given date time
        :param datetime before: Optional filter by sent before given date time
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PageSentEmailProjection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'inbox_id',
            'page',
            'optional_page_size_in_inbox_sent_email_list_pagination',
            'sort',
            'search_filter',
            'since',
            'before'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_inbox_sent_emails" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'inbox_id' is set
        if self.api_client.client_side_validation and ('inbox_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['inbox_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `inbox_id` when calling `get_inbox_sent_emails`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'inbox_id' in local_var_params:
            path_params['inboxId'] = local_var_params['inbox_id']  # noqa: E501

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'optional_page_size_in_inbox_sent_email_list_pagination' in local_var_params and local_var_params['optional_page_size_in_inbox_sent_email_list_pagination'] is not None:  # noqa: E501
            query_params.append(('Optional page size in inbox sent email list pagination', local_var_params['optional_page_size_in_inbox_sent_email_list_pagination']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'search_filter' in local_var_params and local_var_params['search_filter'] is not None:  # noqa: E501
            query_params.append(('searchFilter', local_var_params['search_filter']))  # noqa: E501
        if 'since' in local_var_params and local_var_params['since'] is not None:  # noqa: E501
            query_params.append(('since', local_var_params['since']))  # noqa: E501
        if 'before' in local_var_params and local_var_params['before'] is not None:  # noqa: E501
            query_params.append(('before', local_var_params['before']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes/{inboxId}/sent', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageSentEmailProjection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_inbox_tags(self, **kwargs):  # noqa: E501
        """Get inbox tags  # noqa: E501

        Get all inbox tags  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inbox_tags(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_inbox_tags_with_http_info(**kwargs)  # noqa: E501

    def get_inbox_tags_with_http_info(self, **kwargs):  # noqa: E501
        """Get inbox tags  # noqa: E501

        Get all inbox tags  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inbox_tags_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_inbox_tags" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes/tags', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_inboxes(self, **kwargs):  # noqa: E501
        """List Inboxes and email addresses  # noqa: E501

        List the inboxes you have created. Note use of the more advanced `getAllEmails` is recommended and allows paginated access using a limit and sort parameter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inboxes(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int size: Optional result size limit. Note an automatic limit of 100 results is applied. See the paginated `getAllEmails` for larger queries.
        :param str sort: Optional createdAt sort direction ASC or DESC
        :param datetime since: Optional filter by created after given date time
        :param datetime before: Optional filter by created before given date time
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InboxDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_inboxes_with_http_info(**kwargs)  # noqa: E501

    def get_inboxes_with_http_info(self, **kwargs):  # noqa: E501
        """List Inboxes and email addresses  # noqa: E501

        List the inboxes you have created. Note use of the more advanced `getAllEmails` is recommended and allows paginated access using a limit and sort parameter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inboxes_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int size: Optional result size limit. Note an automatic limit of 100 results is applied. See the paginated `getAllEmails` for larger queries.
        :param str sort: Optional createdAt sort direction ASC or DESC
        :param datetime since: Optional filter by created after given date time
        :param datetime before: Optional filter by created before given date time
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InboxDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'size',
            'sort',
            'since',
            'before'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_inboxes" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'size' in local_var_params and local_var_params['size'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `size` when calling `get_inboxes`, must be a value less than or equal to `100`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'since' in local_var_params and local_var_params['since'] is not None:  # noqa: E501
            query_params.append(('since', local_var_params['since']))  # noqa: E501
        if 'before' in local_var_params and local_var_params['before'] is not None:  # noqa: E501
            query_params.append(('before', local_var_params['before']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InboxDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_organization_inboxes(self, **kwargs):  # noqa: E501
        """List Organization Inboxes Paginated  # noqa: E501

        List organization inboxes in paginated form. These are inboxes created with `allowTeamAccess` flag enabled. Organization inboxes are `readOnly` for non-admin users. The results are available on the `content` property of the returned object. This method allows for page index (zero based), page size (how many results to return), and a sort direction (based on createdAt time).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organization_inboxes(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int page: Optional page index in list pagination
        :param int size: Optional page size in list pagination
        :param str sort: Optional createdAt sort direction ASC or DESC
        :param str search_filter: Optional search filter
        :param datetime since: Optional filter by created after given date time
        :param datetime before: Optional filter by created before given date time
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PageOrganizationInboxProjection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_organization_inboxes_with_http_info(**kwargs)  # noqa: E501

    def get_organization_inboxes_with_http_info(self, **kwargs):  # noqa: E501
        """List Organization Inboxes Paginated  # noqa: E501

        List organization inboxes in paginated form. These are inboxes created with `allowTeamAccess` flag enabled. Organization inboxes are `readOnly` for non-admin users. The results are available on the `content` property of the returned object. This method allows for page index (zero based), page size (how many results to return), and a sort direction (based on createdAt time).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organization_inboxes_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int page: Optional page index in list pagination
        :param int size: Optional page size in list pagination
        :param str sort: Optional createdAt sort direction ASC or DESC
        :param str search_filter: Optional search filter
        :param datetime since: Optional filter by created after given date time
        :param datetime before: Optional filter by created before given date time
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PageOrganizationInboxProjection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'page',
            'size',
            'sort',
            'search_filter',
            'since',
            'before'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_inboxes" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'search_filter' in local_var_params and local_var_params['search_filter'] is not None:  # noqa: E501
            query_params.append(('searchFilter', local_var_params['search_filter']))  # noqa: E501
        if 'since' in local_var_params and local_var_params['since'] is not None:  # noqa: E501
            query_params.append(('since', local_var_params['since']))  # noqa: E501
        if 'before' in local_var_params and local_var_params['before'] is not None:  # noqa: E501
            query_params.append(('before', local_var_params['before']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes/organization', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageOrganizationInboxProjection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_inbox_rulesets(self, inbox_id, **kwargs):  # noqa: E501
        """List inbox rulesets  # noqa: E501

        List all rulesets attached to an inbox  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_inbox_rulesets(inbox_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: (required)
        :param int page: Optional page index in inbox ruleset list pagination
        :param int size: Optional page size in inbox ruleset list pagination
        :param str sort: Optional createdAt sort direction ASC or DESC
        :param str search_filter: Optional search filter
        :param datetime since: Optional filter by created after given date time
        :param datetime before: Optional filter by created before given date time
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PageInboxRulesetDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_inbox_rulesets_with_http_info(inbox_id, **kwargs)  # noqa: E501

    def list_inbox_rulesets_with_http_info(self, inbox_id, **kwargs):  # noqa: E501
        """List inbox rulesets  # noqa: E501

        List all rulesets attached to an inbox  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_inbox_rulesets_with_http_info(inbox_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: (required)
        :param int page: Optional page index in inbox ruleset list pagination
        :param int size: Optional page size in inbox ruleset list pagination
        :param str sort: Optional createdAt sort direction ASC or DESC
        :param str search_filter: Optional search filter
        :param datetime since: Optional filter by created after given date time
        :param datetime before: Optional filter by created before given date time
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PageInboxRulesetDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'inbox_id',
            'page',
            'size',
            'sort',
            'search_filter',
            'since',
            'before'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_inbox_rulesets" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'inbox_id' is set
        if self.api_client.client_side_validation and ('inbox_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['inbox_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `inbox_id` when calling `list_inbox_rulesets`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'inbox_id' in local_var_params:
            path_params['inboxId'] = local_var_params['inbox_id']  # noqa: E501

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'search_filter' in local_var_params and local_var_params['search_filter'] is not None:  # noqa: E501
            query_params.append(('searchFilter', local_var_params['search_filter']))  # noqa: E501
        if 'since' in local_var_params and local_var_params['since'] is not None:  # noqa: E501
            query_params.append(('since', local_var_params['since']))  # noqa: E501
        if 'before' in local_var_params and local_var_params['before'] is not None:  # noqa: E501
            query_params.append(('before', local_var_params['before']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes/{inboxId}/rulesets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageInboxRulesetDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_inbox_tracking_pixels(self, inbox_id, **kwargs):  # noqa: E501
        """List inbox tracking pixels  # noqa: E501

        List all tracking pixels sent from an inbox  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_inbox_tracking_pixels(inbox_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: (required)
        :param int page: Optional page index in inbox tracking pixel list pagination
        :param int optional_page_size_in_inbox_tracking_pixel_list_pagination:
        :param str sort: Optional createdAt sort direction ASC or DESC
        :param str search_filter: Optional search filter
        :param datetime since: Optional filter by created after given date time
        :param datetime before: Optional filter by created before given date time
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PageTrackingPixelProjection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_inbox_tracking_pixels_with_http_info(inbox_id, **kwargs)  # noqa: E501

    def list_inbox_tracking_pixels_with_http_info(self, inbox_id, **kwargs):  # noqa: E501
        """List inbox tracking pixels  # noqa: E501

        List all tracking pixels sent from an inbox  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_inbox_tracking_pixels_with_http_info(inbox_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: (required)
        :param int page: Optional page index in inbox tracking pixel list pagination
        :param int optional_page_size_in_inbox_tracking_pixel_list_pagination:
        :param str sort: Optional createdAt sort direction ASC or DESC
        :param str search_filter: Optional search filter
        :param datetime since: Optional filter by created after given date time
        :param datetime before: Optional filter by created before given date time
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PageTrackingPixelProjection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'inbox_id',
            'page',
            'optional_page_size_in_inbox_tracking_pixel_list_pagination',
            'sort',
            'search_filter',
            'since',
            'before'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_inbox_tracking_pixels" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'inbox_id' is set
        if self.api_client.client_side_validation and ('inbox_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['inbox_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `inbox_id` when calling `list_inbox_tracking_pixels`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'inbox_id' in local_var_params:
            path_params['inboxId'] = local_var_params['inbox_id']  # noqa: E501

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'optional_page_size_in_inbox_tracking_pixel_list_pagination' in local_var_params and local_var_params['optional_page_size_in_inbox_tracking_pixel_list_pagination'] is not None:  # noqa: E501
            query_params.append(('Optional page size in inbox tracking pixel list pagination', local_var_params['optional_page_size_in_inbox_tracking_pixel_list_pagination']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'search_filter' in local_var_params and local_var_params['search_filter'] is not None:  # noqa: E501
            query_params.append(('searchFilter', local_var_params['search_filter']))  # noqa: E501
        if 'since' in local_var_params and local_var_params['since'] is not None:  # noqa: E501
            query_params.append(('since', local_var_params['since']))  # noqa: E501
        if 'before' in local_var_params and local_var_params['before'] is not None:  # noqa: E501
            query_params.append(('before', local_var_params['before']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes/{inboxId}/tracking-pixels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageTrackingPixelProjection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_email(self, id_of_the_inbox_you_want_to_send_the_email_from, send_email_options, **kwargs):  # noqa: E501
        """Send Email  # noqa: E501

        Send an email from an inbox's email address.  The request body should contain the `SendEmailOptions` that include recipients, attachments, body etc. See `SendEmailOptions` for all available properties. Note the `inboxId` refers to the inbox's id not the inbox's email address. See https://www.mailslurp.com/guides/ for more information on how to send emails. This method does not return a sent email entity due to legacy reasons. To send and get a sent email as returned response use the sister method `sendEmailAndConfirm`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_email(id_of_the_inbox_you_want_to_send_the_email_from, send_email_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_of_the_inbox_you_want_to_send_the_email_from: (required)
        :param SendEmailOptions send_email_options: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.send_email_with_http_info(id_of_the_inbox_you_want_to_send_the_email_from, send_email_options, **kwargs)  # noqa: E501

    def send_email_with_http_info(self, id_of_the_inbox_you_want_to_send_the_email_from, send_email_options, **kwargs):  # noqa: E501
        """Send Email  # noqa: E501

        Send an email from an inbox's email address.  The request body should contain the `SendEmailOptions` that include recipients, attachments, body etc. See `SendEmailOptions` for all available properties. Note the `inboxId` refers to the inbox's id not the inbox's email address. See https://www.mailslurp.com/guides/ for more information on how to send emails. This method does not return a sent email entity due to legacy reasons. To send and get a sent email as returned response use the sister method `sendEmailAndConfirm`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_email_with_http_info(id_of_the_inbox_you_want_to_send_the_email_from, send_email_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_of_the_inbox_you_want_to_send_the_email_from: (required)
        :param SendEmailOptions send_email_options: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id_of_the_inbox_you_want_to_send_the_email_from',
            'send_email_options'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_email" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id_of_the_inbox_you_want_to_send_the_email_from' is set
        if self.api_client.client_side_validation and ('id_of_the_inbox_you_want_to_send_the_email_from' not in local_var_params or  # noqa: E501
                                                        local_var_params['id_of_the_inbox_you_want_to_send_the_email_from'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id_of_the_inbox_you_want_to_send_the_email_from` when calling `send_email`")  # noqa: E501
        # verify the required parameter 'send_email_options' is set
        if self.api_client.client_side_validation and ('send_email_options' not in local_var_params or  # noqa: E501
                                                        local_var_params['send_email_options'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `send_email_options` when calling `send_email`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_of_the_inbox_you_want_to_send_the_email_from' in local_var_params:
            path_params['ID of the inbox you want to send the email from'] = local_var_params['id_of_the_inbox_you_want_to_send_the_email_from']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'send_email_options' in local_var_params:
            body_params = local_var_params['send_email_options']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes/{inboxId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_email_and_confirm(self, id_of_the_inbox_you_want_to_send_the_email_from, send_email_options, **kwargs):  # noqa: E501
        """Send email and return sent confirmation  # noqa: E501

        Sister method for standard `sendEmail` method with the benefit of returning a `SentEmail` entity confirming the successful sending of the email with a link to the sent object created for it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_email_and_confirm(id_of_the_inbox_you_want_to_send_the_email_from, send_email_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_of_the_inbox_you_want_to_send_the_email_from: (required)
        :param SendEmailOptions send_email_options: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SentEmailDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.send_email_and_confirm_with_http_info(id_of_the_inbox_you_want_to_send_the_email_from, send_email_options, **kwargs)  # noqa: E501

    def send_email_and_confirm_with_http_info(self, id_of_the_inbox_you_want_to_send_the_email_from, send_email_options, **kwargs):  # noqa: E501
        """Send email and return sent confirmation  # noqa: E501

        Sister method for standard `sendEmail` method with the benefit of returning a `SentEmail` entity confirming the successful sending of the email with a link to the sent object created for it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_email_and_confirm_with_http_info(id_of_the_inbox_you_want_to_send_the_email_from, send_email_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_of_the_inbox_you_want_to_send_the_email_from: (required)
        :param SendEmailOptions send_email_options: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SentEmailDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id_of_the_inbox_you_want_to_send_the_email_from',
            'send_email_options'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_email_and_confirm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id_of_the_inbox_you_want_to_send_the_email_from' is set
        if self.api_client.client_side_validation and ('id_of_the_inbox_you_want_to_send_the_email_from' not in local_var_params or  # noqa: E501
                                                        local_var_params['id_of_the_inbox_you_want_to_send_the_email_from'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id_of_the_inbox_you_want_to_send_the_email_from` when calling `send_email_and_confirm`")  # noqa: E501
        # verify the required parameter 'send_email_options' is set
        if self.api_client.client_side_validation and ('send_email_options' not in local_var_params or  # noqa: E501
                                                        local_var_params['send_email_options'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `send_email_options` when calling `send_email_and_confirm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_of_the_inbox_you_want_to_send_the_email_from' in local_var_params:
            path_params['ID of the inbox you want to send the email from'] = local_var_params['id_of_the_inbox_you_want_to_send_the_email_from']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'send_email_options' in local_var_params:
            body_params = local_var_params['send_email_options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes/{inboxId}/confirm', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SentEmailDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_test_email(self, inbox_id, **kwargs):  # noqa: E501
        """Send a test email to inbox  # noqa: E501

        Send an inbox a test email to test email receiving is working  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_test_email(inbox_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.send_test_email_with_http_info(inbox_id, **kwargs)  # noqa: E501

    def send_test_email_with_http_info(self, inbox_id, **kwargs):  # noqa: E501
        """Send a test email to inbox  # noqa: E501

        Send an inbox a test email to test email receiving is working  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_test_email_with_http_info(inbox_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'inbox_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_test_email" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'inbox_id' is set
        if self.api_client.client_side_validation and ('inbox_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['inbox_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `inbox_id` when calling `send_test_email`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'inbox_id' in local_var_params:
            path_params['inboxId'] = local_var_params['inbox_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes/{inboxId}/send-test-email', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_inbox_favourited(self, inbox_id, set_inbox_favourited_options, **kwargs):  # noqa: E501
        """Set inbox favourited state  # noqa: E501

        Set and return new favourite state for an inbox  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_inbox_favourited(inbox_id, set_inbox_favourited_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: (required)
        :param SetInboxFavouritedOptions set_inbox_favourited_options: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InboxDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_inbox_favourited_with_http_info(inbox_id, set_inbox_favourited_options, **kwargs)  # noqa: E501

    def set_inbox_favourited_with_http_info(self, inbox_id, set_inbox_favourited_options, **kwargs):  # noqa: E501
        """Set inbox favourited state  # noqa: E501

        Set and return new favourite state for an inbox  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_inbox_favourited_with_http_info(inbox_id, set_inbox_favourited_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: (required)
        :param SetInboxFavouritedOptions set_inbox_favourited_options: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InboxDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'inbox_id',
            'set_inbox_favourited_options'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_inbox_favourited" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'inbox_id' is set
        if self.api_client.client_side_validation and ('inbox_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['inbox_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `inbox_id` when calling `set_inbox_favourited`")  # noqa: E501
        # verify the required parameter 'set_inbox_favourited_options' is set
        if self.api_client.client_side_validation and ('set_inbox_favourited_options' not in local_var_params or  # noqa: E501
                                                        local_var_params['set_inbox_favourited_options'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `set_inbox_favourited_options` when calling `set_inbox_favourited`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'inbox_id' in local_var_params:
            path_params['inboxId'] = local_var_params['inbox_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'set_inbox_favourited_options' in local_var_params:
            body_params = local_var_params['set_inbox_favourited_options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes/{inboxId}/favourite', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InboxDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_inbox(self, inbox_id, update_inbox_options, **kwargs):  # noqa: E501
        """Update Inbox. Change name and description. Email address is not editable.  # noqa: E501

        Update editable fields on an inbox  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_inbox(inbox_id, update_inbox_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: (required)
        :param UpdateInboxOptions update_inbox_options: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InboxDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_inbox_with_http_info(inbox_id, update_inbox_options, **kwargs)  # noqa: E501

    def update_inbox_with_http_info(self, inbox_id, update_inbox_options, **kwargs):  # noqa: E501
        """Update Inbox. Change name and description. Email address is not editable.  # noqa: E501

        Update editable fields on an inbox  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_inbox_with_http_info(inbox_id, update_inbox_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: (required)
        :param UpdateInboxOptions update_inbox_options: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InboxDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'inbox_id',
            'update_inbox_options'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_inbox" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'inbox_id' is set
        if self.api_client.client_side_validation and ('inbox_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['inbox_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `inbox_id` when calling `update_inbox`")  # noqa: E501
        # verify the required parameter 'update_inbox_options' is set
        if self.api_client.client_side_validation and ('update_inbox_options' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_inbox_options'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_inbox_options` when calling `update_inbox`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'inbox_id' in local_var_params:
            path_params['inboxId'] = local_var_params['inbox_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_inbox_options' in local_var_params:
            body_params = local_var_params['update_inbox_options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/inboxes/{inboxId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InboxDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
