import { CfnResource } from 'monocdk';
/**
 * The compliance level of a resource in relation to a rule.
 */
export declare enum NagRuleCompliance {
    COMPLIANT = "Compliant",
    NON_COMPLIANT = "Non-Compliant",
    NOT_APPLICABLE = "N/A"
}
export declare type NagRuleFinding = string;
export declare type NagRuleFindings = NagRuleFinding[];
/**
 * The result of a rule check. Can either be `NagRuleCompliance`
 * or an array of individual findings
 */
export declare type NagRuleResult = NagRuleCompliance | NagRuleFindings;
/**
 * Helper class with methods for rule creation
 */
export declare class NagRules {
    /**
     * Use in cases where a primitive value must be known to pass a rule.
     * https://developer.mozilla.org/en-US/docs/Glossary/Primitive
     * @param node The CfnResource to check.
     * @param parameter The value to attempt to resolve.
     * @returns Return a value if resolves to a primitive data type, otherwise throw an error.
     */
    static resolveIfPrimitive(node: CfnResource, parameter: any): any;
    /**
     * Use in cases where a token resolves to an intrinsic function and the referenced resource must be known to pass a rule.
     * @param node The CfnResource to check.
     * @param parameter The value to attempt to resolve.
     * @returns Return the Logical resource Id if resolves to a intrinsic function, otherwise the resolved provided value.
     */
    static resolveResourceFromInstrinsic(node: CfnResource, parameter: any): any;
}
