# coding: utf-8

"""
    FlashBlade REST API

    A lightweight client for FlashBlade REST API 2.5, developed by Pure Storage, Inc. (http://www.purestorage.com/).

    OpenAPI spec version: 2.5
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re

import six
import typing

from ....properties import Property
if typing.TYPE_CHECKING:
    from pypureclient.flashblade.FB_2_5 import models

class Support(object):
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'id': 'str',
        'phonehome_enabled': 'bool',
        'proxy': 'str',
        'remote_assist_active': 'bool',
        'remote_assist_opened': 'str',
        'remote_assist_expires': 'str',
        'remote_assist_status': 'str',
        'remote_assist_paths': 'list[SupportRemoteAssistPaths]'
    }

    attribute_map = {
        'name': 'name',
        'id': 'id',
        'phonehome_enabled': 'phonehome_enabled',
        'proxy': 'proxy',
        'remote_assist_active': 'remote_assist_active',
        'remote_assist_opened': 'remote_assist_opened',
        'remote_assist_expires': 'remote_assist_expires',
        'remote_assist_status': 'remote_assist_status',
        'remote_assist_paths': 'remote_assist_paths'
    }

    required_args = {
    }

    def __init__(
        self,
        name=None,  # type: str
        id=None,  # type: str
        phonehome_enabled=None,  # type: bool
        proxy=None,  # type: str
        remote_assist_active=None,  # type: bool
        remote_assist_opened=None,  # type: str
        remote_assist_expires=None,  # type: str
        remote_assist_status=None,  # type: str
        remote_assist_paths=None,  # type: List[models.SupportRemoteAssistPaths]
    ):
        """
        Keyword args:
            name (str): Name of the object (e.g., a file system or snapshot).
            id (str): A non-modifiable, globally unique ID chosen by the system.
            phonehome_enabled (bool)
            proxy (str)
            remote_assist_active (bool): The switch to open all remote-assist sessions.
            remote_assist_opened (str): The time when the session opened.
            remote_assist_expires (str): The time when the session expires.
            remote_assist_status (str): The status of the remote-assist sessions. Valid values are `connected`, `partially_connected`, `reconnecting`, and `disconnected`.
            remote_assist_paths (list[SupportRemoteAssistPaths])
        """
        if name is not None:
            self.name = name
        if id is not None:
            self.id = id
        if phonehome_enabled is not None:
            self.phonehome_enabled = phonehome_enabled
        if proxy is not None:
            self.proxy = proxy
        if remote_assist_active is not None:
            self.remote_assist_active = remote_assist_active
        if remote_assist_opened is not None:
            self.remote_assist_opened = remote_assist_opened
        if remote_assist_expires is not None:
            self.remote_assist_expires = remote_assist_expires
        if remote_assist_status is not None:
            self.remote_assist_status = remote_assist_status
        if remote_assist_paths is not None:
            self.remote_assist_paths = remote_assist_paths

    def __setattr__(self, key, value):
        if key not in self.attribute_map:
            raise KeyError("Invalid key `{}` for `Support`".format(key))
        self.__dict__[key] = value

    def __getattribute__(self, item):
        value = object.__getattribute__(self, item)
        if isinstance(value, Property):
            return None
        else:
            return value

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            if hasattr(self, attr):
                value = getattr(self, attr)
                if isinstance(value, list):
                    result[attr] = list(map(
                        lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                        value
                    ))
                elif hasattr(value, "to_dict"):
                    result[attr] = value.to_dict()
                elif isinstance(value, dict):
                    result[attr] = dict(map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict") else item,
                        value.items()
                    ))
                else:
                    result[attr] = value
        if issubclass(Support, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Support):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
