# Generated by Django 2.2.13 on 2020-06-20 20:14

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django_currentuser.db.models.fields
import django_currentuser.middleware
import simple_history.models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('schema', '0065_historicalcameramodel'),
    ]

    operations = [
        migrations.CreateModel(
            name='HistoricalToner',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('name', models.CharField(help_text='Name of the toner', max_length=45)),
                ('formulation', models.CharField(blank=True, help_text='Chemical formulation of the toner', max_length=45, null=True)),
                ('stock_dilution', models.CharField(blank=True, help_text='Stock dilution of the toner', max_length=10, null=True)),
                ('slug', models.SlugField(editable=False, null=True)),
                ('created_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('updated_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('created_by', django_currentuser.db.models.fields.CurrentUserField(blank=True, db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, editable=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('manufacturer', models.ForeignKey(blank=True, db_constraint=False, help_text='Manufacturer of this toner', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='schema.Manufacturer')),
                ('updated_by', django_currentuser.db.models.fields.CurrentUserField(db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, null=True, on_delete=django.db.models.deletion.DO_NOTHING, on_update=True, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical toner',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalPaperStock',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('name', models.CharField(help_text='Name of this paper stock', max_length=45)),
                ('resin_coated', models.BooleanField(blank=True, help_text='Whether the paper is resin-coated', null=True)),
                ('colour', models.BooleanField(blank=True, help_text='Whether this is a colour paper', null=True)),
                ('finish', models.CharField(blank=True, choices=[('Matt', 'Matt'), ('Gloss', 'Gloss'), ('Satin', 'Satin'), ('Semi gloss', 'Semi gloss'), ('Pearl', 'Pearl'), ('Lustre', 'Lustre')], help_text='The finish of the paper surface', max_length=25, null=True)),
                ('created_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('updated_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('created_by', django_currentuser.db.models.fields.CurrentUserField(blank=True, db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, editable=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('manufacturer', models.ForeignKey(blank=True, db_constraint=False, help_text='Manufacturer of this paper stock', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='schema.Manufacturer')),
                ('updated_by', django_currentuser.db.models.fields.CurrentUserField(db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, null=True, on_delete=django.db.models.deletion.DO_NOTHING, on_update=True, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical paper stock',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalNegativeSize',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('name', models.CharField(db_index=True, help_text='Common name of the negative size (e.g. 35mm, 6x7, etc)', max_length=45)),
                ('width', models.DecimalField(blank=True, decimal_places=1, help_text='Width of the negative size in mm', max_digits=4, null=True)),
                ('height', models.DecimalField(blank=True, decimal_places=1, help_text='Height of the negative size in mm', max_digits=4, null=True)),
                ('crop_factor', models.DecimalField(blank=True, decimal_places=2, editable=False, help_text='Crop factor of this negative size', max_digits=4, null=True)),
                ('area', models.PositiveIntegerField(blank=True, editable=False, help_text='Area of this negative size in sq. mm', null=True)),
                ('aspect_ratio', models.DecimalField(blank=True, decimal_places=2, editable=False, help_text='Aspect ratio of this negative size, expressed as a single decimal (e.g. 3:2 is expressed as 1.5)', max_digits=4, null=True)),
                ('created_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('updated_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('created_by', django_currentuser.db.models.fields.CurrentUserField(blank=True, db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, editable=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('updated_by', django_currentuser.db.models.fields.CurrentUserField(db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, null=True, on_delete=django.db.models.deletion.DO_NOTHING, on_update=True, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical negative size',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalMount',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('mount', models.CharField(db_index=True, help_text='Name of this lens mount (e.g. Canon FD)', max_length=45)),
                ('shutter_in_lens', models.BooleanField(blank=True, default=0, help_text='Whether this lens mount system incorporates the shutter into the lens', null=True)),
                ('type', models.CharField(blank=True, choices=[('Bayonet', 'Bayonet'), ('Breech lock', 'Breech lock'), ('Screw', 'Screw'), ('Friction', 'Friction'), ('Lens board', 'Lens board')], help_text='The physical mount type of this lens mount', max_length=15, null=True)),
                ('purpose', models.CharField(blank=True, choices=[('Camera', 'Camera'), ('Enlarger', 'Enlarger'), ('Projector', 'Projector'), ('Telescope', 'Telescope'), ('Microscope', 'Microscope')], help_text='The intended purpose of this lens mount', max_length=15, null=True)),
                ('notes', models.CharField(blank=True, help_text='Freeform notes field', max_length=100, null=True)),
                ('slug', models.SlugField(editable=False, null=True)),
                ('created_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('updated_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('created_by', django_currentuser.db.models.fields.CurrentUserField(blank=True, db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, editable=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('manufacturer', models.ForeignKey(blank=True, db_constraint=False, help_text='Manufacturer who owns this lens mount', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='schema.Manufacturer')),
                ('updated_by', django_currentuser.db.models.fields.CurrentUserField(db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, null=True, on_delete=django.db.models.deletion.DO_NOTHING, on_update=True, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical mount',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalManufacturer',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('name', models.CharField(blank=True, db_index=True, help_text='Name of the manufacturer', max_length=45)),
                ('city', models.CharField(blank=True, help_text='City in which the manufacturer is based', max_length=45, null=True)),
                ('country', models.CharField(blank=True, help_text='Country in which the manufacturer is based', max_length=45, null=True)),
                ('url', models.URLField(blank=True, help_text='URL to the manufacturers main website', max_length=45, null=True, verbose_name='URL')),
                ('founded', models.PositiveIntegerField(blank=True, help_text='Year in which the manufacturer was founded', null=True)),
                ('dissolved', models.PositiveIntegerField(blank=True, help_text='Year in which the manufacturer was dissolved', null=True)),
                ('slug', models.SlugField(editable=False, null=True)),
                ('created_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('updated_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('created_by', django_currentuser.db.models.fields.CurrentUserField(blank=True, db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, editable=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('updated_by', django_currentuser.db.models.fields.CurrentUserField(db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, null=True, on_delete=django.db.models.deletion.DO_NOTHING, on_update=True, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical manufacturer',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalLensModel',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('model', models.CharField(help_text='Model name of this lens', max_length=45)),
                ('disambiguation', models.CharField(blank=True, help_text='Distinguishing notes for lens models with the same name', max_length=45, null=True)),
                ('zoom', models.BooleanField(blank=True, help_text='Whether this is a zoom lens', null=True)),
                ('min_focal_length', models.PositiveIntegerField(blank=True, help_text='Shortest focal length of this lens, in mm', null=True)),
                ('max_focal_length', models.PositiveIntegerField(blank=True, help_text='Longest focal length of this lens, in mm', null=True)),
                ('zoom_ratio', models.DecimalField(blank=True, decimal_places=2, editable=False, help_text='Ratio between minimum and maximum focal lengths', max_digits=4, null=True)),
                ('closest_focus', models.DecimalField(blank=True, decimal_places=2, help_text='The closest focus possible with this lens, in m', max_digits=6, null=True)),
                ('max_aperture', models.DecimalField(blank=True, decimal_places=1, help_text='Maximum (widest) aperture available on this lens (numerical part only, e.g. 2.8)', max_digits=4, null=True)),
                ('min_aperture', models.DecimalField(blank=True, decimal_places=1, help_text='Minimum (narrowest) aperture available on this lens (numerical part only, e.g. 22)', max_digits=4, null=True)),
                ('elements', models.PositiveIntegerField(blank=True, help_text='Number of optical lens elements', null=True)),
                ('groups', models.PositiveIntegerField(blank=True, help_text='Number of optical groups', null=True)),
                ('weight', models.PositiveIntegerField(blank=True, help_text='Weight of this lens, in grammes (g)', null=True)),
                ('nominal_min_angle_diag', models.PositiveIntegerField(blank=True, help_text='Nominal minimum diagonal field of view from manufacturer specs', null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(360)], verbose_name='Min angle of view')),
                ('nominal_max_angle_diag', models.PositiveIntegerField(blank=True, help_text='Nominal maximum diagonal field of view from manufacturer specs', null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(360)], verbose_name='Max angle of view')),
                ('aperture_blades', models.PositiveIntegerField(blank=True, help_text='Number of aperture blades', null=True)),
                ('autofocus', models.BooleanField(blank=True, help_text='Whether this lens has autofocus capability', null=True)),
                ('filter_thread', models.DecimalField(blank=True, decimal_places=1, help_text='Diameter of lens filter thread, in mm', max_digits=4, null=True)),
                ('magnification', models.DecimalField(blank=True, decimal_places=3, help_text='Maximum magnification ratio of the lens, expressed like 0.765', max_digits=5, null=True)),
                ('url', models.URLField(blank=True, help_text='URL to more information about this lens', null=True, verbose_name='URL')),
                ('introduced', models.PositiveIntegerField(blank=True, help_text='Year in which this lens model was introduced', null=True)),
                ('discontinued', models.PositiveIntegerField(blank=True, help_text='Year in which this lens model was discontinued', null=True)),
                ('notes', models.CharField(blank=True, help_text='Freeform notes field', max_length=100, null=True)),
                ('coating', models.CharField(blank=True, choices=[('Uncoated', 'Uncoated'), ('Single coated', 'Single coated'), ('Multi coated', 'Multi coated')], help_text='Type of lens coating', max_length=15, null=True)),
                ('hood', models.CharField(blank=True, help_text='Model number of the compatible lens hood', max_length=45, null=True)),
                ('rectilinear', models.BooleanField(blank=True, default=1, help_text='Whether this is a rectilinear lens', null=True)),
                ('length', models.PositiveIntegerField(blank=True, help_text='Length of lens in mm', null=True)),
                ('diameter', models.PositiveIntegerField(blank=True, help_text='Width of lens in mm', null=True)),
                ('image_circle', models.PositiveIntegerField(blank=True, help_text='Diameter of image circle projected by lens, in mm', null=True)),
                ('shutter_model', models.CharField(blank=True, help_text='Name of the integrated shutter, if any', max_length=45, null=True)),
                ('slug', models.SlugField(editable=False, null=True)),
                ('created_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('updated_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('created_by', django_currentuser.db.models.fields.CurrentUserField(blank=True, db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, editable=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('manufacturer', models.ForeignKey(blank=True, db_constraint=False, help_text='Manufacturer of this lens model', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='schema.Manufacturer')),
                ('mount', models.ForeignKey(blank=True, db_constraint=False, help_text='Mount used by this lens model', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='schema.Mount')),
                ('negative_size', models.ForeignKey(blank=True, db_constraint=False, help_text='Largest negative size that this lens is designed for', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='schema.NegativeSize')),
                ('updated_by', django_currentuser.db.models.fields.CurrentUserField(db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, null=True, on_delete=django.db.models.deletion.DO_NOTHING, on_update=True, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical lens model',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalFormat',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('format', models.CharField(db_index=True, help_text='The name of this film/sensor format', max_length=45)),
                ('created_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('updated_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('created_by', django_currentuser.db.models.fields.CurrentUserField(blank=True, db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, editable=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('updated_by', django_currentuser.db.models.fields.CurrentUserField(db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, null=True, on_delete=django.db.models.deletion.DO_NOTHING, on_update=True, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical format',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalFlashProtocol',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('name', models.CharField(help_text='Name of the flash protocol', max_length=45)),
                ('created_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('updated_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('created_by', django_currentuser.db.models.fields.CurrentUserField(blank=True, db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, editable=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('manufacturer', models.ForeignKey(blank=True, db_constraint=False, help_text='Manufacturer who owns this flash protocol', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='schema.Manufacturer')),
                ('updated_by', django_currentuser.db.models.fields.CurrentUserField(db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, null=True, on_delete=django.db.models.deletion.DO_NOTHING, on_update=True, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical flash protocol',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalFilmStock',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('name', models.CharField(help_text='Name of the filmstock', max_length=45)),
                ('iso', models.PositiveIntegerField(blank=True, help_text='Nominal ISO speed of the film', null=True, verbose_name='ISO')),
                ('colour', models.BooleanField(blank=True, help_text='Whether the film is colour', null=True)),
                ('panchromatic', models.BooleanField(blank=True, help_text='Whether this film is panchromatic', null=True)),
                ('slug', models.SlugField(editable=False, null=True)),
                ('created_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('updated_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('created_by', django_currentuser.db.models.fields.CurrentUserField(blank=True, db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, editable=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('manufacturer', models.ForeignKey(blank=True, db_constraint=False, help_text='Manufacturer of this film', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='schema.Manufacturer')),
                ('process', models.ForeignKey(blank=True, db_constraint=False, help_text='Development process required by this film', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='schema.Process')),
                ('updated_by', django_currentuser.db.models.fields.CurrentUserField(db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, null=True, on_delete=django.db.models.deletion.DO_NOTHING, on_update=True, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical film stock',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalDeveloper',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('name', models.CharField(help_text='Name of the developer', max_length=45)),
                ('for_paper', models.BooleanField(blank=True, help_text='Whether this developer can be used with paper', null=True)),
                ('for_film', models.BooleanField(blank=True, help_text='Whether this developer can be used with film', null=True)),
                ('chemistry', models.CharField(blank=True, help_text='The key chemistry on which this developer is based (e.g. phenidone)', max_length=45, null=True)),
                ('slug', models.SlugField(editable=False, null=True)),
                ('created_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('updated_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('created_by', django_currentuser.db.models.fields.CurrentUserField(blank=True, db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, editable=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('manufacturer', models.ForeignKey(blank=True, db_constraint=False, help_text='Manufacturer of this developer', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='schema.Manufacturer')),
                ('updated_by', django_currentuser.db.models.fields.CurrentUserField(db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, null=True, on_delete=django.db.models.deletion.DO_NOTHING, on_update=True, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical developer',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalBattery',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('name', models.CharField(db_index=True, help_text='Common name of the battery', max_length=45)),
                ('voltage', models.DecimalField(blank=True, decimal_places=2, help_text='Nominal voltage of the battery', max_digits=5, null=True)),
                ('chemistry', models.CharField(blank=True, choices=[('Alkaline', 'Alkaline'), ('Nickel cadmium', 'Nickel cadmium'), ('Nickel metal hydride', 'Nickel metal hydride'), ('Carbon zinc', 'Carbon zinc'), ('Lithium', 'Lithium'), ('Lithium ion', 'Lithium ion'), ('Lithium polymer', 'Lithium polymer'), ('Mercury', 'Mercury'), ('Zinc air', 'Zinc air'), ('Silver oxide', 'Silver oxide')], help_text='Battery chemistry', max_length=45, null=True)),
                ('slug', models.SlugField(editable=False, null=True)),
                ('created_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('updated_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('created_by', django_currentuser.db.models.fields.CurrentUserField(blank=True, db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, editable=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('updated_by', django_currentuser.db.models.fields.CurrentUserField(db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, null=True, on_delete=django.db.models.deletion.DO_NOTHING, on_update=True, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical battery',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
    ]
