# coding: utf-8

"""
    MN Frontoffice CORE & PERE

    Highly available and searchable datastore for MN  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openapi_client.api_client import ApiClient
from openapi_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class PersoonsgegevensApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_get(self, administratie, persoonsnummer, **kwargs):  # noqa: E501
        """Get Persoonsgegevens  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_get(administratie, persoonsnummer, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str administratie: (required)
        :param str persoonsnummer: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PersoonsGegevens
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_get_with_http_info(administratie, persoonsnummer, **kwargs)  # noqa: E501

    def get_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_get_with_http_info(self, administratie, persoonsnummer, **kwargs):  # noqa: E501
        """Get Persoonsgegevens  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_get_with_http_info(administratie, persoonsnummer, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str administratie: (required)
        :param str persoonsnummer: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PersoonsGegevens, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'administratie',
            'persoonsnummer'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'administratie' is set
        if self.api_client.client_side_validation and ('administratie' not in local_var_params or  # noqa: E501
                                                        local_var_params['administratie'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `administratie` when calling `get_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_get`")  # noqa: E501
        # verify the required parameter 'persoonsnummer' is set
        if self.api_client.client_side_validation and ('persoonsnummer' not in local_var_params or  # noqa: E501
                                                        local_var_params['persoonsnummer'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `persoonsnummer` when calling `get_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_get`")  # noqa: E501

        if self.api_client.client_side_validation and 'persoonsnummer' in local_var_params and not re.search(r'^(?:CON-)?(\d+)$', local_var_params['persoonsnummer']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `persoonsnummer` when calling `get_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_get`, must conform to the pattern `/^(?:CON-)?(\d+)$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'administratie' in local_var_params:
            path_params['administratie'] = local_var_params['administratie']  # noqa: E501
        if 'persoonsnummer' in local_var_params:
            path_params['persoonsnummer'] = local_var_params['persoonsnummer']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['HTTPBasic']  # noqa: E501

        return self.api_client.call_api(
            '/v2/persoonsgegevens/{administratie}/{persoonsnummer}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PersoonsGegevens',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_search_core_v2_search_core_administratie_get(self, administratie, **kwargs):  # noqa: E501
        """Get Search Core  # noqa: E501

        Search for Contactgegevens only  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_search_core_v2_search_core_administratie_get(administratie, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str administratie: (required)
        :param str email:
        :param str telefoonnummer:
        :param str werkgevernummer:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Contact]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_search_core_v2_search_core_administratie_get_with_http_info(administratie, **kwargs)  # noqa: E501

    def get_search_core_v2_search_core_administratie_get_with_http_info(self, administratie, **kwargs):  # noqa: E501
        """Get Search Core  # noqa: E501

        Search for Contactgegevens only  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_search_core_v2_search_core_administratie_get_with_http_info(administratie, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str administratie: (required)
        :param str email:
        :param str telefoonnummer:
        :param str werkgevernummer:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Contact], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'administratie',
            'email',
            'telefoonnummer',
            'werkgevernummer'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_search_core_v2_search_core_administratie_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'administratie' is set
        if self.api_client.client_side_validation and ('administratie' not in local_var_params or  # noqa: E501
                                                        local_var_params['administratie'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `administratie` when calling `get_search_core_v2_search_core_administratie_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'administratie' in local_var_params:
            path_params['administratie'] = local_var_params['administratie']  # noqa: E501

        query_params = []
        if 'email' in local_var_params and local_var_params['email'] is not None:  # noqa: E501
            query_params.append(('email', local_var_params['email']))  # noqa: E501
        if 'telefoonnummer' in local_var_params and local_var_params['telefoonnummer'] is not None:  # noqa: E501
            query_params.append(('telefoonnummer', local_var_params['telefoonnummer']))  # noqa: E501
        if 'werkgevernummer' in local_var_params and local_var_params['werkgevernummer'] is not None:  # noqa: E501
            query_params.append(('werkgevernummer', local_var_params['werkgevernummer']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['HTTPBasic']  # noqa: E501

        return self.api_client.call_api(
            '/v2/search/core/{administratie}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Contact]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_search_pere_v2_search_pere_administratie_get(self, administratie, **kwargs):  # noqa: E501
        """Get Search Pere  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_search_pere_v2_search_pere_administratie_get(administratie, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str administratie: (required)
        :param str burgerservicenummer:
        :param str naam:
        :param str relatienummer:
        :param str geboortedatum:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Contact]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_search_pere_v2_search_pere_administratie_get_with_http_info(administratie, **kwargs)  # noqa: E501

    def get_search_pere_v2_search_pere_administratie_get_with_http_info(self, administratie, **kwargs):  # noqa: E501
        """Get Search Pere  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_search_pere_v2_search_pere_administratie_get_with_http_info(administratie, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str administratie: (required)
        :param str burgerservicenummer:
        :param str naam:
        :param str relatienummer:
        :param str geboortedatum:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Contact], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'administratie',
            'burgerservicenummer',
            'naam',
            'relatienummer',
            'geboortedatum'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_search_pere_v2_search_pere_administratie_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'administratie' is set
        if self.api_client.client_side_validation and ('administratie' not in local_var_params or  # noqa: E501
                                                        local_var_params['administratie'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `administratie` when calling `get_search_pere_v2_search_pere_administratie_get`")  # noqa: E501

        if self.api_client.client_side_validation and ('burgerservicenummer' in local_var_params and  # noqa: E501
                                                        len(local_var_params['burgerservicenummer']) < 3):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `burgerservicenummer` when calling `get_search_pere_v2_search_pere_administratie_get`, length must be greater than or equal to `3`")  # noqa: E501
        if self.api_client.client_side_validation and 'burgerservicenummer' in local_var_params and not re.search(r'\d+', local_var_params['burgerservicenummer']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `burgerservicenummer` when calling `get_search_pere_v2_search_pere_administratie_get`, must conform to the pattern `/\d+/`")  # noqa: E501
        if self.api_client.client_side_validation and ('naam' in local_var_params and  # noqa: E501
                                                        len(local_var_params['naam']) < 3):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `naam` when calling `get_search_pere_v2_search_pere_administratie_get`, length must be greater than or equal to `3`")  # noqa: E501
        if self.api_client.client_side_validation and 'relatienummer' in local_var_params and not re.search(r'\d+', local_var_params['relatienummer']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `relatienummer` when calling `get_search_pere_v2_search_pere_administratie_get`, must conform to the pattern `/\d+/`")  # noqa: E501
        if self.api_client.client_side_validation and 'geboortedatum' in local_var_params and not re.search(r'\d+-\d+-\d+', local_var_params['geboortedatum']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `geboortedatum` when calling `get_search_pere_v2_search_pere_administratie_get`, must conform to the pattern `/\d+-\d+-\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'administratie' in local_var_params:
            path_params['administratie'] = local_var_params['administratie']  # noqa: E501

        query_params = []
        if 'burgerservicenummer' in local_var_params and local_var_params['burgerservicenummer'] is not None:  # noqa: E501
            query_params.append(('burgerservicenummer', local_var_params['burgerservicenummer']))  # noqa: E501
        if 'naam' in local_var_params and local_var_params['naam'] is not None:  # noqa: E501
            query_params.append(('naam', local_var_params['naam']))  # noqa: E501
        if 'relatienummer' in local_var_params and local_var_params['relatienummer'] is not None:  # noqa: E501
            query_params.append(('relatienummer', local_var_params['relatienummer']))  # noqa: E501
        if 'geboortedatum' in local_var_params and local_var_params['geboortedatum'] is not None:  # noqa: E501
            query_params.append(('geboortedatum', local_var_params['geboortedatum']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['HTTPBasic']  # noqa: E501

        return self.api_client.call_api(
            '/v2/search/pere/{administratie}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Contact]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_patch(self, administratie, persoonsnummer, persoons_gegevens, **kwargs):  # noqa: E501
        """Patch Persoonsgegevens  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_patch(administratie, persoonsnummer, persoons_gegevens, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str administratie: (required)
        :param str persoonsnummer: (required)
        :param PersoonsGegevens persoons_gegevens: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PersoonsGegevens
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_patch_with_http_info(administratie, persoonsnummer, persoons_gegevens, **kwargs)  # noqa: E501

    def patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_patch_with_http_info(self, administratie, persoonsnummer, persoons_gegevens, **kwargs):  # noqa: E501
        """Patch Persoonsgegevens  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_patch_with_http_info(administratie, persoonsnummer, persoons_gegevens, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str administratie: (required)
        :param str persoonsnummer: (required)
        :param PersoonsGegevens persoons_gegevens: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PersoonsGegevens, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'administratie',
            'persoonsnummer',
            'persoons_gegevens'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_patch" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'administratie' is set
        if self.api_client.client_side_validation and ('administratie' not in local_var_params or  # noqa: E501
                                                        local_var_params['administratie'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `administratie` when calling `patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_patch`")  # noqa: E501
        # verify the required parameter 'persoonsnummer' is set
        if self.api_client.client_side_validation and ('persoonsnummer' not in local_var_params or  # noqa: E501
                                                        local_var_params['persoonsnummer'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `persoonsnummer` when calling `patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_patch`")  # noqa: E501
        # verify the required parameter 'persoons_gegevens' is set
        if self.api_client.client_side_validation and ('persoons_gegevens' not in local_var_params or  # noqa: E501
                                                        local_var_params['persoons_gegevens'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `persoons_gegevens` when calling `patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_patch`")  # noqa: E501

        if self.api_client.client_side_validation and 'persoonsnummer' in local_var_params and not re.search(r'^(?:CON-)?(\d+)$', local_var_params['persoonsnummer']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `persoonsnummer` when calling `patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_patch`, must conform to the pattern `/^(?:CON-)?(\d+)$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'administratie' in local_var_params:
            path_params['administratie'] = local_var_params['administratie']  # noqa: E501
        if 'persoonsnummer' in local_var_params:
            path_params['persoonsnummer'] = local_var_params['persoonsnummer']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'persoons_gegevens' in local_var_params:
            body_params = local_var_params['persoons_gegevens']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['HTTPBasic']  # noqa: E501

        return self.api_client.call_api(
            '/v2/persoonsgegevens/{administratie}/{persoonsnummer}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PersoonsGegevens',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_put(self, administratie, persoonsnummer, persoons_gegevens, **kwargs):  # noqa: E501
        """Patch Persoonsgegevens  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_put(administratie, persoonsnummer, persoons_gegevens, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str administratie: (required)
        :param str persoonsnummer: (required)
        :param PersoonsGegevens persoons_gegevens: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PersoonsGegevens
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_put_with_http_info(administratie, persoonsnummer, persoons_gegevens, **kwargs)  # noqa: E501

    def patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_put_with_http_info(self, administratie, persoonsnummer, persoons_gegevens, **kwargs):  # noqa: E501
        """Patch Persoonsgegevens  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_put_with_http_info(administratie, persoonsnummer, persoons_gegevens, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str administratie: (required)
        :param str persoonsnummer: (required)
        :param PersoonsGegevens persoons_gegevens: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PersoonsGegevens, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'administratie',
            'persoonsnummer',
            'persoons_gegevens'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'administratie' is set
        if self.api_client.client_side_validation and ('administratie' not in local_var_params or  # noqa: E501
                                                        local_var_params['administratie'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `administratie` when calling `patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_put`")  # noqa: E501
        # verify the required parameter 'persoonsnummer' is set
        if self.api_client.client_side_validation and ('persoonsnummer' not in local_var_params or  # noqa: E501
                                                        local_var_params['persoonsnummer'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `persoonsnummer` when calling `patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_put`")  # noqa: E501
        # verify the required parameter 'persoons_gegevens' is set
        if self.api_client.client_side_validation and ('persoons_gegevens' not in local_var_params or  # noqa: E501
                                                        local_var_params['persoons_gegevens'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `persoons_gegevens` when calling `patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_put`")  # noqa: E501

        if self.api_client.client_side_validation and 'persoonsnummer' in local_var_params and not re.search(r'^(?:CON-)?(\d+)$', local_var_params['persoonsnummer']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `persoonsnummer` when calling `patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_put`, must conform to the pattern `/^(?:CON-)?(\d+)$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'administratie' in local_var_params:
            path_params['administratie'] = local_var_params['administratie']  # noqa: E501
        if 'persoonsnummer' in local_var_params:
            path_params['persoonsnummer'] = local_var_params['persoonsnummer']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'persoons_gegevens' in local_var_params:
            body_params = local_var_params['persoons_gegevens']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['HTTPBasic']  # noqa: E501

        return self.api_client.call_api(
            '/v2/persoonsgegevens/{administratie}/{persoonsnummer}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PersoonsGegevens',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
