# openapi-client
Highly available and searchable datastore for MN

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import openapi_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import openapi_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: HTTPBasic
configuration = openapi_client.Configuration(
    username = 'YOUR_USERNAME',
    password = 'YOUR_PASSWORD'
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ContactgegevensApi(api_client)
    administratie = 'administratie_example' # str | 
relatiesoort = 'relatiesoort_example' # str | 
persoonsnummer = 'persoonsnummer_example' # str | 

    try:
        # Get Events
        api_response = api_instance.get_events_v2_contactgegevens_administratie_relatiesoort_persoonsnummer_events_get(administratie, relatiesoort, persoonsnummer)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ContactgegevensApi->get_events_v2_contactgegevens_administratie_relatiesoort_persoonsnummer_events_get: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ContactgegevensApi* | [**get_events_v2_contactgegevens_administratie_relatiesoort_persoonsnummer_events_get**](docs/ContactgegevensApi.md#get_events_v2_contactgegevens_administratie_relatiesoort_persoonsnummer_events_get) | **GET** /v2/contactgegevens/{administratie}/{relatiesoort}/{persoonsnummer}/events | Get Events
*ContactgegevensApi* | [**get_search_core_v2_search_core_administratie_get**](docs/ContactgegevensApi.md#get_search_core_v2_search_core_administratie_get) | **GET** /v2/search/core/{administratie} | Get Search Core
*ContactgegevensApi* | [**get_search_pere_v2_search_pere_administratie_get**](docs/ContactgegevensApi.md#get_search_pere_v2_search_pere_administratie_get) | **GET** /v2/search/pere/{administratie} | Get Search Pere
*ContactgegevensApi* | [**get_snapshot_v2_contactgegevens_administratie_relatiesoort_persoonsnummer_get**](docs/ContactgegevensApi.md#get_snapshot_v2_contactgegevens_administratie_relatiesoort_persoonsnummer_get) | **GET** /v2/contactgegevens/{administratie}/{relatiesoort}/{persoonsnummer} | Get Snapshot
*ContactgegevensApi* | [**put_event_v2_contactgegevens_administratie_relatiesoort_persoonsnummer_events_post**](docs/ContactgegevensApi.md#put_event_v2_contactgegevens_administratie_relatiesoort_persoonsnummer_events_post) | **POST** /v2/contactgegevens/{administratie}/{relatiesoort}/{persoonsnummer}/events | Put Event
*DeveloperToolsApi* | [**get_contact_v2_dev_contact_get**](docs/DeveloperToolsApi.md#get_contact_v2_dev_contact_get) | **GET** /v2/dev/contact | Get Contact
*DeveloperToolsApi* | [**get_settings_v2_dev_settings_get**](docs/DeveloperToolsApi.md#get_settings_v2_dev_settings_get) | **GET** /v2/dev/settings | Get Settings
*PersoonsgegevensApi* | [**get_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_get**](docs/PersoonsgegevensApi.md#get_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_get) | **GET** /v2/persoonsgegevens/{administratie}/{persoonsnummer} | Get Persoonsgegevens
*PersoonsgegevensApi* | [**get_search_core_v2_search_core_administratie_get**](docs/PersoonsgegevensApi.md#get_search_core_v2_search_core_administratie_get) | **GET** /v2/search/core/{administratie} | Get Search Core
*PersoonsgegevensApi* | [**get_search_pere_v2_search_pere_administratie_get**](docs/PersoonsgegevensApi.md#get_search_pere_v2_search_pere_administratie_get) | **GET** /v2/search/pere/{administratie} | Get Search Pere
*PersoonsgegevensApi* | [**patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_patch**](docs/PersoonsgegevensApi.md#patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_patch) | **PATCH** /v2/persoonsgegevens/{administratie}/{persoonsnummer} | Patch Persoonsgegevens
*PersoonsgegevensApi* | [**patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_put**](docs/PersoonsgegevensApi.md#patch_persoonsgegevens_v2_persoonsgegevens_administratie_persoonsnummer_put) | **PUT** /v2/persoonsgegevens/{administratie}/{persoonsnummer} | Patch Persoonsgegevens


## Documentation For Models

 - [AdresMutatie](docs/AdresMutatie.md)
 - [Contact](docs/Contact.md)
 - [ContactgegevensEvent](docs/ContactgegevensEvent.md)
 - [ContactgegevensEventInput](docs/ContactgegevensEventInput.md)
 - [ContactpersoonGegevens](docs/ContactpersoonGegevens.md)
 - [DatumDelen](docs/DatumDelen.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [Partnerschap](docs/Partnerschap.md)
 - [PersoonContactGegevens](docs/PersoonContactGegevens.md)
 - [PersoonsGegevens](docs/PersoonsGegevens.md)
 - [PersoonsGegevensBasic](docs/PersoonsGegevensBasic.md)
 - [Settings](docs/Settings.md)
 - [ValidationError](docs/ValidationError.md)
 - [WerkgegeverContactGegevens](docs/WerkgegeverContactGegevens.md)


## Documentation For Authorization


## HTTPBasic

- **Type**: HTTP basic authentication


## Author




