#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
A test case for bearing sizing with aeronautics specs:
 * low forces
 * high lifetime
"""

import mechanical_components.optimization.bearings as bearings_opt
import numpy as npy

Fa=0 # Axial force
Fr=90 # Radial force
N=1000 # Rotational speed in rad/s
Lnm=24*27*60*N*10 # Millions of cycles

Fa = 0.0 
Fr = 719.3194709167649 
N = 706.1161357892686 
Lnm = 75311.95285357766

for i_bearing, (Fa, Fr, N, Lnm) in enumerate([[0.0, 307.9870364871444, 2027.272247705984, 216221.9841782008],
        [0.0, 144.24709303828226, 2027.272247705984, 216221.9841782008],
        [0.0, 719.3194709167649, 706.1161357892686, 75311.95285357766],
        [0.0, 336.89646106228116, 706.1161357892686, 75311.95285357766],
        [0.0, 612.7229596189956, 1909.1239283611242, 203620.68503598007],
        [0.0, 286.97151273294656, 1909.1239283611242, 203620.68503598007],
        [0.0, 529.5743233720265, 789.195647912004, 84172.93192339031],
        [0.0, 248.02848056664453, 789.195647912004, 84172.93192339031],
        [0.0, 264.7883305466084, 723.8745252930651, 77206.00246564392],
        [0.0, 124.01478772436059, 723.8745252930651, 77206.00246564392],
        [5.858519706541659e-15, 137.20375205901092, 844.6974654676726, 90092.56759687368],
        [0.0, 64.25998514156205, 844.6974654676726, 90092.56759687368],
        [0.0, 31.662127321111686, 356.3688414090466, 38009.09230417576],
        [0.0, 67.6029204964277, 356.3688414090466, 38009.09230417576],
        [0.0, 96.25579725936247, 954.5596739369282, 101810.09824836942],
        [0.0, 92.78795784180433, 954.5596739369282, 101810.09824836942]]):
    print(Fa, Fr, N, Lnm)
    bo=bearings_opt.BearingOptimizer()
    bo.Optimization(d = {'min': 0.01,'max': 0.10},
                B = {'min':0.01,'max':0.08},
                D = {'min':0.02,'max':0.15},
                Lnm = {'min':Lnm, 'max':100000*Lnm},
                Fr = [Fr],
                Fa = [Fa],
                N = [N],
                grade = ['Gr_gn'],
                S = 0.90,
                T = [70],
                t = [30*365*17*3600],
                oil = 'iso_vg_100',
                nb_sol = 10,
                mini = ['mass'],
                typ = 'NF')

    print('Number of solutions: {}'.format(len(bo.solutions)))
    for i,b in enumerate(bo.solutions[:1]):
    #    v=b.VolumeModel()
        print(b.d, b.D)
        b.FreeCADExport('Bearing_aeronautics_{}_{}'.format(i_bearing, i))
    
    


