# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.1
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""Python Orthogonal Array interface"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _oalib
else:
    import _oalib

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _oalib.delete_SwigPyIterator

    def value(self):
        return _oalib.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _oalib.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _oalib.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _oalib.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _oalib.SwigPyIterator_equal(self, x)

    def copy(self):
        return _oalib.SwigPyIterator_copy(self)

    def next(self):
        return _oalib.SwigPyIterator_next(self)

    def __next__(self):
        return _oalib.SwigPyIterator___next__(self)

    def previous(self):
        return _oalib.SwigPyIterator_previous(self)

    def advance(self, n):
        return _oalib.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _oalib.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _oalib.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _oalib.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _oalib.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _oalib.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _oalib.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _oalib:
_oalib.SwigPyIterator_swigregister(SwigPyIterator)


import sys
import numpy as np
import copy
from typing import Optional, List

def reduceGraphNauty(G, colors : Optional[List] = None, verbose : int = 1) -> List:
  """ Return vertex transformation reducing array to normal form

  The reduction is calculated using `Nauty <http://users.cecs.anu.edu.au/~bdm/nauty/>`_

  Args:
      G (numpy array or array_link) :	the graph in incidence matrix form
      colors: an optional vertex coloring
      verbose: Verbosity level
  Returns:
      Relabelling of the vertices
  """
  if isinstance(G, np.ndarray):
      al=array_link()
      al.setarray(G)
  else:
      al = copy.copy(G)
  if colors is None:
    colors = [0] * G.shape[0]
  vertex_permutation = _oalib.reduceNauty ( al, colors, verbose )
  return vertex_permutation

def transformGraphMatrix(G, tr, verbose=1):
    """ Apply a vertex permutation to a graph

    Arguments
    ---------
      G : Numpy array
	the graph in incidence matrix form
      tr : list
	the vertex transformation as a list

    Returns
    -------
      The transformed graph

    """
    al=array_link()
    al.setarray(G)
    alt = _oalib.transformGraph(al, tr, verbose)
    return np.array(alt)


class arraylist_t(object):
    r"""Proxy of C++ std::deque< array_link > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def iterator(self):
        r"""iterator(arraylist_t self) -> SwigPyIterator"""
        return _oalib.arraylist_t_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(arraylist_t self) -> bool"""
        return _oalib.arraylist_t___nonzero__(self)

    def __bool__(self):
        r"""__bool__(arraylist_t self) -> bool"""
        return _oalib.arraylist_t___bool__(self)

    def __len__(self):
        r"""__len__(arraylist_t self) -> std::deque< array_link >::size_type"""
        return _oalib.arraylist_t___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(arraylist_t self, std::deque< array_link >::difference_type i, std::deque< array_link >::difference_type j) -> arraylist_t"""
        return _oalib.arraylist_t___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(arraylist_t self, std::deque< array_link >::difference_type i, std::deque< array_link >::difference_type j)
        __setslice__(arraylist_t self, std::deque< array_link >::difference_type i, std::deque< array_link >::difference_type j, arraylist_t v)
        """
        return _oalib.arraylist_t___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(arraylist_t self, std::deque< array_link >::difference_type i, std::deque< array_link >::difference_type j)"""
        return _oalib.arraylist_t___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(arraylist_t self, std::deque< array_link >::difference_type i)
        __delitem__(arraylist_t self, PySliceObject * slice)
        """
        return _oalib.arraylist_t___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(arraylist_t self, PySliceObject * slice) -> arraylist_t
        __getitem__(arraylist_t self, std::deque< array_link >::difference_type i) -> array_link
        """
        return _oalib.arraylist_t___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(arraylist_t self, PySliceObject * slice, arraylist_t v)
        __setitem__(arraylist_t self, PySliceObject * slice)
        __setitem__(arraylist_t self, std::deque< array_link >::difference_type i, array_link x)
        """
        return _oalib.arraylist_t___setitem__(self, *args)

    def pop(self):
        r"""pop(arraylist_t self) -> array_link"""
        return _oalib.arraylist_t_pop(self)

    def append(self, x):
        r"""append(arraylist_t self, array_link x)"""
        return _oalib.arraylist_t_append(self, x)

    def empty(self):
        r"""empty(arraylist_t self) -> bool"""
        return _oalib.arraylist_t_empty(self)

    def size(self):
        r"""size(arraylist_t self) -> std::deque< array_link >::size_type"""
        return _oalib.arraylist_t_size(self)

    def swap(self, v):
        r"""swap(arraylist_t self, arraylist_t v)"""
        return _oalib.arraylist_t_swap(self, v)

    def begin(self):
        r"""begin(arraylist_t self) -> std::deque< array_link >::iterator"""
        return _oalib.arraylist_t_begin(self)

    def end(self):
        r"""end(arraylist_t self) -> std::deque< array_link >::iterator"""
        return _oalib.arraylist_t_end(self)

    def rbegin(self):
        r"""rbegin(arraylist_t self) -> std::deque< array_link >::reverse_iterator"""
        return _oalib.arraylist_t_rbegin(self)

    def rend(self):
        r"""rend(arraylist_t self) -> std::deque< array_link >::reverse_iterator"""
        return _oalib.arraylist_t_rend(self)

    def clear(self):
        r"""clear(arraylist_t self)"""
        return _oalib.arraylist_t_clear(self)

    def get_allocator(self):
        r"""get_allocator(arraylist_t self) -> std::deque< array_link >::allocator_type"""
        return _oalib.arraylist_t_get_allocator(self)

    def pop_back(self):
        r"""pop_back(arraylist_t self)"""
        return _oalib.arraylist_t_pop_back(self)

    def erase(self, *args):
        r"""
        erase(arraylist_t self, std::deque< array_link >::iterator pos) -> std::deque< array_link >::iterator
        erase(arraylist_t self, std::deque< array_link >::iterator first, std::deque< array_link >::iterator last) -> std::deque< array_link >::iterator
        """
        return _oalib.arraylist_t_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(arraylist_t self) -> arraylist_t
        __init__(arraylist_t self, arraylist_t other) -> arraylist_t
        __init__(arraylist_t self, std::deque< array_link >::size_type size) -> arraylist_t
        __init__(arraylist_t self, std::deque< array_link >::size_type size, array_link value) -> arraylist_t
        """
        _oalib.arraylist_t_swiginit(self, _oalib.new_arraylist_t(*args))

    def push_back(self, x):
        r"""push_back(arraylist_t self, array_link x)"""
        return _oalib.arraylist_t_push_back(self, x)

    def front(self):
        r"""front(arraylist_t self) -> array_link"""
        return _oalib.arraylist_t_front(self)

    def back(self):
        r"""back(arraylist_t self) -> array_link"""
        return _oalib.arraylist_t_back(self)

    def assign(self, n, x):
        r"""assign(arraylist_t self, std::deque< array_link >::size_type n, array_link x)"""
        return _oalib.arraylist_t_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(arraylist_t self, std::deque< array_link >::size_type new_size)
        resize(arraylist_t self, std::deque< array_link >::size_type new_size, array_link x)
        """
        return _oalib.arraylist_t_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(arraylist_t self, std::deque< array_link >::iterator pos, array_link x) -> std::deque< array_link >::iterator
        insert(arraylist_t self, std::deque< array_link >::iterator pos, std::deque< array_link >::size_type n, array_link x)
        """
        return _oalib.arraylist_t_insert(self, *args)

    def pop_front(self):
        r"""pop_front(arraylist_t self)"""
        return _oalib.arraylist_t_pop_front(self)

    def push_front(self, x):
        r"""push_front(arraylist_t self, array_link x)"""
        return _oalib.arraylist_t_push_front(self, x)

    def __repr__(self):
        r"""__repr__(arraylist_t self) -> std::string"""
        return _oalib.arraylist_t___repr__(self)
    __swig_destroy__ = _oalib.delete_arraylist_t

# Register arraylist_t in _oalib:
_oalib.arraylist_t_swigregister(arraylist_t)

class jstructArray(object):
    r"""Proxy of C++ std::vector< jstruct_t > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(jstructArray self) -> SwigPyIterator"""
        return _oalib.jstructArray_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(jstructArray self) -> bool"""
        return _oalib.jstructArray___nonzero__(self)

    def __bool__(self):
        r"""__bool__(jstructArray self) -> bool"""
        return _oalib.jstructArray___bool__(self)

    def __len__(self):
        r"""__len__(jstructArray self) -> std::vector< jstruct_t >::size_type"""
        return _oalib.jstructArray___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(jstructArray self, std::vector< jstruct_t >::difference_type i, std::vector< jstruct_t >::difference_type j) -> jstructArray"""
        return _oalib.jstructArray___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(jstructArray self, std::vector< jstruct_t >::difference_type i, std::vector< jstruct_t >::difference_type j)
        __setslice__(jstructArray self, std::vector< jstruct_t >::difference_type i, std::vector< jstruct_t >::difference_type j, jstructArray v)
        """
        return _oalib.jstructArray___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(jstructArray self, std::vector< jstruct_t >::difference_type i, std::vector< jstruct_t >::difference_type j)"""
        return _oalib.jstructArray___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(jstructArray self, std::vector< jstruct_t >::difference_type i)
        __delitem__(jstructArray self, PySliceObject * slice)
        """
        return _oalib.jstructArray___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(jstructArray self, PySliceObject * slice) -> jstructArray
        __getitem__(jstructArray self, std::vector< jstruct_t >::difference_type i) -> jstruct_t
        """
        return _oalib.jstructArray___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(jstructArray self, PySliceObject * slice, jstructArray v)
        __setitem__(jstructArray self, PySliceObject * slice)
        __setitem__(jstructArray self, std::vector< jstruct_t >::difference_type i, jstruct_t x)
        """
        return _oalib.jstructArray___setitem__(self, *args)

    def pop(self):
        r"""pop(jstructArray self) -> jstruct_t"""
        return _oalib.jstructArray_pop(self)

    def append(self, x):
        r"""append(jstructArray self, jstruct_t x)"""
        return _oalib.jstructArray_append(self, x)

    def empty(self):
        r"""empty(jstructArray self) -> bool"""
        return _oalib.jstructArray_empty(self)

    def size(self):
        r"""size(jstructArray self) -> std::vector< jstruct_t >::size_type"""
        return _oalib.jstructArray_size(self)

    def swap(self, v):
        r"""swap(jstructArray self, jstructArray v)"""
        return _oalib.jstructArray_swap(self, v)

    def begin(self):
        r"""begin(jstructArray self) -> std::vector< jstruct_t >::iterator"""
        return _oalib.jstructArray_begin(self)

    def end(self):
        r"""end(jstructArray self) -> std::vector< jstruct_t >::iterator"""
        return _oalib.jstructArray_end(self)

    def rbegin(self):
        r"""rbegin(jstructArray self) -> std::vector< jstruct_t >::reverse_iterator"""
        return _oalib.jstructArray_rbegin(self)

    def rend(self):
        r"""rend(jstructArray self) -> std::vector< jstruct_t >::reverse_iterator"""
        return _oalib.jstructArray_rend(self)

    def clear(self):
        r"""clear(jstructArray self)"""
        return _oalib.jstructArray_clear(self)

    def get_allocator(self):
        r"""get_allocator(jstructArray self) -> std::vector< jstruct_t >::allocator_type"""
        return _oalib.jstructArray_get_allocator(self)

    def pop_back(self):
        r"""pop_back(jstructArray self)"""
        return _oalib.jstructArray_pop_back(self)

    def erase(self, *args):
        r"""
        erase(jstructArray self, std::vector< jstruct_t >::iterator pos) -> std::vector< jstruct_t >::iterator
        erase(jstructArray self, std::vector< jstruct_t >::iterator first, std::vector< jstruct_t >::iterator last) -> std::vector< jstruct_t >::iterator
        """
        return _oalib.jstructArray_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(jstructArray self) -> jstructArray
        __init__(jstructArray self, jstructArray other) -> jstructArray
        __init__(jstructArray self, std::vector< jstruct_t >::size_type size) -> jstructArray
        __init__(jstructArray self, std::vector< jstruct_t >::size_type size, jstruct_t value) -> jstructArray
        """
        _oalib.jstructArray_swiginit(self, _oalib.new_jstructArray(*args))

    def push_back(self, x):
        r"""push_back(jstructArray self, jstruct_t x)"""
        return _oalib.jstructArray_push_back(self, x)

    def front(self):
        r"""front(jstructArray self) -> jstruct_t"""
        return _oalib.jstructArray_front(self)

    def back(self):
        r"""back(jstructArray self) -> jstruct_t"""
        return _oalib.jstructArray_back(self)

    def assign(self, n, x):
        r"""assign(jstructArray self, std::vector< jstruct_t >::size_type n, jstruct_t x)"""
        return _oalib.jstructArray_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(jstructArray self, std::vector< jstruct_t >::size_type new_size)
        resize(jstructArray self, std::vector< jstruct_t >::size_type new_size, jstruct_t x)
        """
        return _oalib.jstructArray_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(jstructArray self, std::vector< jstruct_t >::iterator pos, jstruct_t x) -> std::vector< jstruct_t >::iterator
        insert(jstructArray self, std::vector< jstruct_t >::iterator pos, std::vector< jstruct_t >::size_type n, jstruct_t x)
        """
        return _oalib.jstructArray_insert(self, *args)

    def reserve(self, n):
        r"""reserve(jstructArray self, std::vector< jstruct_t >::size_type n)"""
        return _oalib.jstructArray_reserve(self, n)

    def capacity(self):
        r"""capacity(jstructArray self) -> std::vector< jstruct_t >::size_type"""
        return _oalib.jstructArray_capacity(self)
    __swig_destroy__ = _oalib.delete_jstructArray

# Register jstructArray in _oalib:
_oalib.jstructArray_swigregister(jstructArray)

class uint8Vector(object):
    r"""Proxy of C++ std::vector< unsigned char > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(uint8Vector self) -> SwigPyIterator"""
        return _oalib.uint8Vector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(uint8Vector self) -> bool"""
        return _oalib.uint8Vector___nonzero__(self)

    def __bool__(self):
        r"""__bool__(uint8Vector self) -> bool"""
        return _oalib.uint8Vector___bool__(self)

    def __len__(self):
        r"""__len__(uint8Vector self) -> std::vector< unsigned char >::size_type"""
        return _oalib.uint8Vector___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(uint8Vector self, std::vector< unsigned char >::difference_type i, std::vector< unsigned char >::difference_type j) -> uint8Vector"""
        return _oalib.uint8Vector___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(uint8Vector self, std::vector< unsigned char >::difference_type i, std::vector< unsigned char >::difference_type j)
        __setslice__(uint8Vector self, std::vector< unsigned char >::difference_type i, std::vector< unsigned char >::difference_type j, uint8Vector v)
        """
        return _oalib.uint8Vector___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(uint8Vector self, std::vector< unsigned char >::difference_type i, std::vector< unsigned char >::difference_type j)"""
        return _oalib.uint8Vector___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(uint8Vector self, std::vector< unsigned char >::difference_type i)
        __delitem__(uint8Vector self, PySliceObject * slice)
        """
        return _oalib.uint8Vector___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(uint8Vector self, PySliceObject * slice) -> uint8Vector
        __getitem__(uint8Vector self, std::vector< unsigned char >::difference_type i) -> std::vector< unsigned char >::value_type const &
        """
        return _oalib.uint8Vector___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(uint8Vector self, PySliceObject * slice, uint8Vector v)
        __setitem__(uint8Vector self, PySliceObject * slice)
        __setitem__(uint8Vector self, std::vector< unsigned char >::difference_type i, std::vector< unsigned char >::value_type const & x)
        """
        return _oalib.uint8Vector___setitem__(self, *args)

    def pop(self):
        r"""pop(uint8Vector self) -> std::vector< unsigned char >::value_type"""
        return _oalib.uint8Vector_pop(self)

    def append(self, x):
        r"""append(uint8Vector self, std::vector< unsigned char >::value_type const & x)"""
        return _oalib.uint8Vector_append(self, x)

    def empty(self):
        r"""empty(uint8Vector self) -> bool"""
        return _oalib.uint8Vector_empty(self)

    def size(self):
        r"""size(uint8Vector self) -> std::vector< unsigned char >::size_type"""
        return _oalib.uint8Vector_size(self)

    def swap(self, v):
        r"""swap(uint8Vector self, uint8Vector v)"""
        return _oalib.uint8Vector_swap(self, v)

    def begin(self):
        r"""begin(uint8Vector self) -> std::vector< unsigned char >::iterator"""
        return _oalib.uint8Vector_begin(self)

    def end(self):
        r"""end(uint8Vector self) -> std::vector< unsigned char >::iterator"""
        return _oalib.uint8Vector_end(self)

    def rbegin(self):
        r"""rbegin(uint8Vector self) -> std::vector< unsigned char >::reverse_iterator"""
        return _oalib.uint8Vector_rbegin(self)

    def rend(self):
        r"""rend(uint8Vector self) -> std::vector< unsigned char >::reverse_iterator"""
        return _oalib.uint8Vector_rend(self)

    def clear(self):
        r"""clear(uint8Vector self)"""
        return _oalib.uint8Vector_clear(self)

    def get_allocator(self):
        r"""get_allocator(uint8Vector self) -> std::vector< unsigned char >::allocator_type"""
        return _oalib.uint8Vector_get_allocator(self)

    def pop_back(self):
        r"""pop_back(uint8Vector self)"""
        return _oalib.uint8Vector_pop_back(self)

    def erase(self, *args):
        r"""
        erase(uint8Vector self, std::vector< unsigned char >::iterator pos) -> std::vector< unsigned char >::iterator
        erase(uint8Vector self, std::vector< unsigned char >::iterator first, std::vector< unsigned char >::iterator last) -> std::vector< unsigned char >::iterator
        """
        return _oalib.uint8Vector_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(uint8Vector self) -> uint8Vector
        __init__(uint8Vector self, uint8Vector other) -> uint8Vector
        __init__(uint8Vector self, std::vector< unsigned char >::size_type size) -> uint8Vector
        __init__(uint8Vector self, std::vector< unsigned char >::size_type size, std::vector< unsigned char >::value_type const & value) -> uint8Vector
        """
        _oalib.uint8Vector_swiginit(self, _oalib.new_uint8Vector(*args))

    def push_back(self, x):
        r"""push_back(uint8Vector self, std::vector< unsigned char >::value_type const & x)"""
        return _oalib.uint8Vector_push_back(self, x)

    def front(self):
        r"""front(uint8Vector self) -> std::vector< unsigned char >::value_type const &"""
        return _oalib.uint8Vector_front(self)

    def back(self):
        r"""back(uint8Vector self) -> std::vector< unsigned char >::value_type const &"""
        return _oalib.uint8Vector_back(self)

    def assign(self, n, x):
        r"""assign(uint8Vector self, std::vector< unsigned char >::size_type n, std::vector< unsigned char >::value_type const & x)"""
        return _oalib.uint8Vector_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(uint8Vector self, std::vector< unsigned char >::size_type new_size)
        resize(uint8Vector self, std::vector< unsigned char >::size_type new_size, std::vector< unsigned char >::value_type const & x)
        """
        return _oalib.uint8Vector_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(uint8Vector self, std::vector< unsigned char >::iterator pos, std::vector< unsigned char >::value_type const & x) -> std::vector< unsigned char >::iterator
        insert(uint8Vector self, std::vector< unsigned char >::iterator pos, std::vector< unsigned char >::size_type n, std::vector< unsigned char >::value_type const & x)
        """
        return _oalib.uint8Vector_insert(self, *args)

    def reserve(self, n):
        r"""reserve(uint8Vector self, std::vector< unsigned char >::size_type n)"""
        return _oalib.uint8Vector_reserve(self, n)

    def capacity(self):
        r"""capacity(uint8Vector self) -> std::vector< unsigned char >::size_type"""
        return _oalib.uint8Vector_capacity(self)
    __swig_destroy__ = _oalib.delete_uint8Vector

# Register uint8Vector in _oalib:
_oalib.uint8Vector_swigregister(uint8Vector)

class charVector(object):
    r"""Proxy of C++ std::vector< signed char > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(charVector self) -> SwigPyIterator"""
        return _oalib.charVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(charVector self) -> bool"""
        return _oalib.charVector___nonzero__(self)

    def __bool__(self):
        r"""__bool__(charVector self) -> bool"""
        return _oalib.charVector___bool__(self)

    def __len__(self):
        r"""__len__(charVector self) -> std::vector< signed char >::size_type"""
        return _oalib.charVector___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(charVector self, std::vector< signed char >::difference_type i, std::vector< signed char >::difference_type j) -> charVector"""
        return _oalib.charVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(charVector self, std::vector< signed char >::difference_type i, std::vector< signed char >::difference_type j)
        __setslice__(charVector self, std::vector< signed char >::difference_type i, std::vector< signed char >::difference_type j, charVector v)
        """
        return _oalib.charVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(charVector self, std::vector< signed char >::difference_type i, std::vector< signed char >::difference_type j)"""
        return _oalib.charVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(charVector self, std::vector< signed char >::difference_type i)
        __delitem__(charVector self, PySliceObject * slice)
        """
        return _oalib.charVector___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(charVector self, PySliceObject * slice) -> charVector
        __getitem__(charVector self, std::vector< signed char >::difference_type i) -> std::vector< signed char >::value_type const &
        """
        return _oalib.charVector___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(charVector self, PySliceObject * slice, charVector v)
        __setitem__(charVector self, PySliceObject * slice)
        __setitem__(charVector self, std::vector< signed char >::difference_type i, std::vector< signed char >::value_type const & x)
        """
        return _oalib.charVector___setitem__(self, *args)

    def pop(self):
        r"""pop(charVector self) -> std::vector< signed char >::value_type"""
        return _oalib.charVector_pop(self)

    def append(self, x):
        r"""append(charVector self, std::vector< signed char >::value_type const & x)"""
        return _oalib.charVector_append(self, x)

    def empty(self):
        r"""empty(charVector self) -> bool"""
        return _oalib.charVector_empty(self)

    def size(self):
        r"""size(charVector self) -> std::vector< signed char >::size_type"""
        return _oalib.charVector_size(self)

    def swap(self, v):
        r"""swap(charVector self, charVector v)"""
        return _oalib.charVector_swap(self, v)

    def begin(self):
        r"""begin(charVector self) -> std::vector< signed char >::iterator"""
        return _oalib.charVector_begin(self)

    def end(self):
        r"""end(charVector self) -> std::vector< signed char >::iterator"""
        return _oalib.charVector_end(self)

    def rbegin(self):
        r"""rbegin(charVector self) -> std::vector< signed char >::reverse_iterator"""
        return _oalib.charVector_rbegin(self)

    def rend(self):
        r"""rend(charVector self) -> std::vector< signed char >::reverse_iterator"""
        return _oalib.charVector_rend(self)

    def clear(self):
        r"""clear(charVector self)"""
        return _oalib.charVector_clear(self)

    def get_allocator(self):
        r"""get_allocator(charVector self) -> std::vector< signed char >::allocator_type"""
        return _oalib.charVector_get_allocator(self)

    def pop_back(self):
        r"""pop_back(charVector self)"""
        return _oalib.charVector_pop_back(self)

    def erase(self, *args):
        r"""
        erase(charVector self, std::vector< signed char >::iterator pos) -> std::vector< signed char >::iterator
        erase(charVector self, std::vector< signed char >::iterator first, std::vector< signed char >::iterator last) -> std::vector< signed char >::iterator
        """
        return _oalib.charVector_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(charVector self) -> charVector
        __init__(charVector self, charVector other) -> charVector
        __init__(charVector self, std::vector< signed char >::size_type size) -> charVector
        __init__(charVector self, std::vector< signed char >::size_type size, std::vector< signed char >::value_type const & value) -> charVector
        """
        _oalib.charVector_swiginit(self, _oalib.new_charVector(*args))

    def push_back(self, x):
        r"""push_back(charVector self, std::vector< signed char >::value_type const & x)"""
        return _oalib.charVector_push_back(self, x)

    def front(self):
        r"""front(charVector self) -> std::vector< signed char >::value_type const &"""
        return _oalib.charVector_front(self)

    def back(self):
        r"""back(charVector self) -> std::vector< signed char >::value_type const &"""
        return _oalib.charVector_back(self)

    def assign(self, n, x):
        r"""assign(charVector self, std::vector< signed char >::size_type n, std::vector< signed char >::value_type const & x)"""
        return _oalib.charVector_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(charVector self, std::vector< signed char >::size_type new_size)
        resize(charVector self, std::vector< signed char >::size_type new_size, std::vector< signed char >::value_type const & x)
        """
        return _oalib.charVector_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(charVector self, std::vector< signed char >::iterator pos, std::vector< signed char >::value_type const & x) -> std::vector< signed char >::iterator
        insert(charVector self, std::vector< signed char >::iterator pos, std::vector< signed char >::size_type n, std::vector< signed char >::value_type const & x)
        """
        return _oalib.charVector_insert(self, *args)

    def reserve(self, n):
        r"""reserve(charVector self, std::vector< signed char >::size_type n)"""
        return _oalib.charVector_reserve(self, n)

    def capacity(self):
        r"""capacity(charVector self) -> std::vector< signed char >::size_type"""
        return _oalib.charVector_capacity(self)
    __swig_destroy__ = _oalib.delete_charVector

# Register charVector in _oalib:
_oalib.charVector_swigregister(charVector)

class intVector(object):
    r"""Proxy of C++ std::vector< int > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(intVector self) -> SwigPyIterator"""
        return _oalib.intVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(intVector self) -> bool"""
        return _oalib.intVector___nonzero__(self)

    def __bool__(self):
        r"""__bool__(intVector self) -> bool"""
        return _oalib.intVector___bool__(self)

    def __len__(self):
        r"""__len__(intVector self) -> std::vector< int >::size_type"""
        return _oalib.intVector___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(intVector self, std::vector< int >::difference_type i, std::vector< int >::difference_type j) -> intVector"""
        return _oalib.intVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(intVector self, std::vector< int >::difference_type i, std::vector< int >::difference_type j)
        __setslice__(intVector self, std::vector< int >::difference_type i, std::vector< int >::difference_type j, intVector v)
        """
        return _oalib.intVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(intVector self, std::vector< int >::difference_type i, std::vector< int >::difference_type j)"""
        return _oalib.intVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(intVector self, std::vector< int >::difference_type i)
        __delitem__(intVector self, PySliceObject * slice)
        """
        return _oalib.intVector___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(intVector self, PySliceObject * slice) -> intVector
        __getitem__(intVector self, std::vector< int >::difference_type i) -> std::vector< int >::value_type const &
        """
        return _oalib.intVector___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(intVector self, PySliceObject * slice, intVector v)
        __setitem__(intVector self, PySliceObject * slice)
        __setitem__(intVector self, std::vector< int >::difference_type i, std::vector< int >::value_type const & x)
        """
        return _oalib.intVector___setitem__(self, *args)

    def pop(self):
        r"""pop(intVector self) -> std::vector< int >::value_type"""
        return _oalib.intVector_pop(self)

    def append(self, x):
        r"""append(intVector self, std::vector< int >::value_type const & x)"""
        return _oalib.intVector_append(self, x)

    def empty(self):
        r"""empty(intVector self) -> bool"""
        return _oalib.intVector_empty(self)

    def size(self):
        r"""size(intVector self) -> std::vector< int >::size_type"""
        return _oalib.intVector_size(self)

    def swap(self, v):
        r"""swap(intVector self, intVector v)"""
        return _oalib.intVector_swap(self, v)

    def begin(self):
        r"""begin(intVector self) -> std::vector< int >::iterator"""
        return _oalib.intVector_begin(self)

    def end(self):
        r"""end(intVector self) -> std::vector< int >::iterator"""
        return _oalib.intVector_end(self)

    def rbegin(self):
        r"""rbegin(intVector self) -> std::vector< int >::reverse_iterator"""
        return _oalib.intVector_rbegin(self)

    def rend(self):
        r"""rend(intVector self) -> std::vector< int >::reverse_iterator"""
        return _oalib.intVector_rend(self)

    def clear(self):
        r"""clear(intVector self)"""
        return _oalib.intVector_clear(self)

    def get_allocator(self):
        r"""get_allocator(intVector self) -> std::vector< int >::allocator_type"""
        return _oalib.intVector_get_allocator(self)

    def pop_back(self):
        r"""pop_back(intVector self)"""
        return _oalib.intVector_pop_back(self)

    def erase(self, *args):
        r"""
        erase(intVector self, std::vector< int >::iterator pos) -> std::vector< int >::iterator
        erase(intVector self, std::vector< int >::iterator first, std::vector< int >::iterator last) -> std::vector< int >::iterator
        """
        return _oalib.intVector_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(intVector self) -> intVector
        __init__(intVector self, intVector other) -> intVector
        __init__(intVector self, std::vector< int >::size_type size) -> intVector
        __init__(intVector self, std::vector< int >::size_type size, std::vector< int >::value_type const & value) -> intVector
        """
        _oalib.intVector_swiginit(self, _oalib.new_intVector(*args))

    def push_back(self, x):
        r"""push_back(intVector self, std::vector< int >::value_type const & x)"""
        return _oalib.intVector_push_back(self, x)

    def front(self):
        r"""front(intVector self) -> std::vector< int >::value_type const &"""
        return _oalib.intVector_front(self)

    def back(self):
        r"""back(intVector self) -> std::vector< int >::value_type const &"""
        return _oalib.intVector_back(self)

    def assign(self, n, x):
        r"""assign(intVector self, std::vector< int >::size_type n, std::vector< int >::value_type const & x)"""
        return _oalib.intVector_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(intVector self, std::vector< int >::size_type new_size)
        resize(intVector self, std::vector< int >::size_type new_size, std::vector< int >::value_type const & x)
        """
        return _oalib.intVector_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(intVector self, std::vector< int >::iterator pos, std::vector< int >::value_type const & x) -> std::vector< int >::iterator
        insert(intVector self, std::vector< int >::iterator pos, std::vector< int >::size_type n, std::vector< int >::value_type const & x)
        """
        return _oalib.intVector_insert(self, *args)

    def reserve(self, n):
        r"""reserve(intVector self, std::vector< int >::size_type n)"""
        return _oalib.intVector_reserve(self, n)

    def capacity(self):
        r"""capacity(intVector self) -> std::vector< int >::size_type"""
        return _oalib.intVector_capacity(self)
    __swig_destroy__ = _oalib.delete_intVector

# Register intVector in _oalib:
_oalib.intVector_swigregister(intVector)

class longVector(object):
    r"""Proxy of C++ std::vector< long > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(longVector self) -> SwigPyIterator"""
        return _oalib.longVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(longVector self) -> bool"""
        return _oalib.longVector___nonzero__(self)

    def __bool__(self):
        r"""__bool__(longVector self) -> bool"""
        return _oalib.longVector___bool__(self)

    def __len__(self):
        r"""__len__(longVector self) -> std::vector< long >::size_type"""
        return _oalib.longVector___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(longVector self, std::vector< long >::difference_type i, std::vector< long >::difference_type j) -> longVector"""
        return _oalib.longVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(longVector self, std::vector< long >::difference_type i, std::vector< long >::difference_type j)
        __setslice__(longVector self, std::vector< long >::difference_type i, std::vector< long >::difference_type j, longVector v)
        """
        return _oalib.longVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(longVector self, std::vector< long >::difference_type i, std::vector< long >::difference_type j)"""
        return _oalib.longVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(longVector self, std::vector< long >::difference_type i)
        __delitem__(longVector self, PySliceObject * slice)
        """
        return _oalib.longVector___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(longVector self, PySliceObject * slice) -> longVector
        __getitem__(longVector self, std::vector< long >::difference_type i) -> std::vector< long >::value_type const &
        """
        return _oalib.longVector___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(longVector self, PySliceObject * slice, longVector v)
        __setitem__(longVector self, PySliceObject * slice)
        __setitem__(longVector self, std::vector< long >::difference_type i, std::vector< long >::value_type const & x)
        """
        return _oalib.longVector___setitem__(self, *args)

    def pop(self):
        r"""pop(longVector self) -> std::vector< long >::value_type"""
        return _oalib.longVector_pop(self)

    def append(self, x):
        r"""append(longVector self, std::vector< long >::value_type const & x)"""
        return _oalib.longVector_append(self, x)

    def empty(self):
        r"""empty(longVector self) -> bool"""
        return _oalib.longVector_empty(self)

    def size(self):
        r"""size(longVector self) -> std::vector< long >::size_type"""
        return _oalib.longVector_size(self)

    def swap(self, v):
        r"""swap(longVector self, longVector v)"""
        return _oalib.longVector_swap(self, v)

    def begin(self):
        r"""begin(longVector self) -> std::vector< long >::iterator"""
        return _oalib.longVector_begin(self)

    def end(self):
        r"""end(longVector self) -> std::vector< long >::iterator"""
        return _oalib.longVector_end(self)

    def rbegin(self):
        r"""rbegin(longVector self) -> std::vector< long >::reverse_iterator"""
        return _oalib.longVector_rbegin(self)

    def rend(self):
        r"""rend(longVector self) -> std::vector< long >::reverse_iterator"""
        return _oalib.longVector_rend(self)

    def clear(self):
        r"""clear(longVector self)"""
        return _oalib.longVector_clear(self)

    def get_allocator(self):
        r"""get_allocator(longVector self) -> std::vector< long >::allocator_type"""
        return _oalib.longVector_get_allocator(self)

    def pop_back(self):
        r"""pop_back(longVector self)"""
        return _oalib.longVector_pop_back(self)

    def erase(self, *args):
        r"""
        erase(longVector self, std::vector< long >::iterator pos) -> std::vector< long >::iterator
        erase(longVector self, std::vector< long >::iterator first, std::vector< long >::iterator last) -> std::vector< long >::iterator
        """
        return _oalib.longVector_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(longVector self) -> longVector
        __init__(longVector self, longVector other) -> longVector
        __init__(longVector self, std::vector< long >::size_type size) -> longVector
        __init__(longVector self, std::vector< long >::size_type size, std::vector< long >::value_type const & value) -> longVector
        """
        _oalib.longVector_swiginit(self, _oalib.new_longVector(*args))

    def push_back(self, x):
        r"""push_back(longVector self, std::vector< long >::value_type const & x)"""
        return _oalib.longVector_push_back(self, x)

    def front(self):
        r"""front(longVector self) -> std::vector< long >::value_type const &"""
        return _oalib.longVector_front(self)

    def back(self):
        r"""back(longVector self) -> std::vector< long >::value_type const &"""
        return _oalib.longVector_back(self)

    def assign(self, n, x):
        r"""assign(longVector self, std::vector< long >::size_type n, std::vector< long >::value_type const & x)"""
        return _oalib.longVector_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(longVector self, std::vector< long >::size_type new_size)
        resize(longVector self, std::vector< long >::size_type new_size, std::vector< long >::value_type const & x)
        """
        return _oalib.longVector_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(longVector self, std::vector< long >::iterator pos, std::vector< long >::value_type const & x) -> std::vector< long >::iterator
        insert(longVector self, std::vector< long >::iterator pos, std::vector< long >::size_type n, std::vector< long >::value_type const & x)
        """
        return _oalib.longVector_insert(self, *args)

    def reserve(self, n):
        r"""reserve(longVector self, std::vector< long >::size_type n)"""
        return _oalib.longVector_reserve(self, n)

    def capacity(self):
        r"""capacity(longVector self) -> std::vector< long >::size_type"""
        return _oalib.longVector_capacity(self)
    __swig_destroy__ = _oalib.delete_longVector

# Register longVector in _oalib:
_oalib.longVector_swigregister(longVector)

class longDeque(object):
    r"""Proxy of C++ std::deque< long > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(longDeque self) -> SwigPyIterator"""
        return _oalib.longDeque_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(longDeque self) -> bool"""
        return _oalib.longDeque___nonzero__(self)

    def __bool__(self):
        r"""__bool__(longDeque self) -> bool"""
        return _oalib.longDeque___bool__(self)

    def __len__(self):
        r"""__len__(longDeque self) -> std::deque< long >::size_type"""
        return _oalib.longDeque___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(longDeque self, std::deque< long >::difference_type i, std::deque< long >::difference_type j) -> longDeque"""
        return _oalib.longDeque___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(longDeque self, std::deque< long >::difference_type i, std::deque< long >::difference_type j)
        __setslice__(longDeque self, std::deque< long >::difference_type i, std::deque< long >::difference_type j, longDeque v)
        """
        return _oalib.longDeque___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(longDeque self, std::deque< long >::difference_type i, std::deque< long >::difference_type j)"""
        return _oalib.longDeque___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(longDeque self, std::deque< long >::difference_type i)
        __delitem__(longDeque self, PySliceObject * slice)
        """
        return _oalib.longDeque___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(longDeque self, PySliceObject * slice) -> longDeque
        __getitem__(longDeque self, std::deque< long >::difference_type i) -> std::deque< long >::value_type const &
        """
        return _oalib.longDeque___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(longDeque self, PySliceObject * slice, longDeque v)
        __setitem__(longDeque self, PySliceObject * slice)
        __setitem__(longDeque self, std::deque< long >::difference_type i, std::deque< long >::value_type const & x)
        """
        return _oalib.longDeque___setitem__(self, *args)

    def pop(self):
        r"""pop(longDeque self) -> std::deque< long >::value_type"""
        return _oalib.longDeque_pop(self)

    def append(self, x):
        r"""append(longDeque self, std::deque< long >::value_type const & x)"""
        return _oalib.longDeque_append(self, x)

    def empty(self):
        r"""empty(longDeque self) -> bool"""
        return _oalib.longDeque_empty(self)

    def size(self):
        r"""size(longDeque self) -> std::deque< long >::size_type"""
        return _oalib.longDeque_size(self)

    def swap(self, v):
        r"""swap(longDeque self, longDeque v)"""
        return _oalib.longDeque_swap(self, v)

    def begin(self):
        r"""begin(longDeque self) -> std::deque< long >::iterator"""
        return _oalib.longDeque_begin(self)

    def end(self):
        r"""end(longDeque self) -> std::deque< long >::iterator"""
        return _oalib.longDeque_end(self)

    def rbegin(self):
        r"""rbegin(longDeque self) -> std::deque< long >::reverse_iterator"""
        return _oalib.longDeque_rbegin(self)

    def rend(self):
        r"""rend(longDeque self) -> std::deque< long >::reverse_iterator"""
        return _oalib.longDeque_rend(self)

    def clear(self):
        r"""clear(longDeque self)"""
        return _oalib.longDeque_clear(self)

    def get_allocator(self):
        r"""get_allocator(longDeque self) -> std::deque< long >::allocator_type"""
        return _oalib.longDeque_get_allocator(self)

    def pop_back(self):
        r"""pop_back(longDeque self)"""
        return _oalib.longDeque_pop_back(self)

    def erase(self, *args):
        r"""
        erase(longDeque self, std::deque< long >::iterator pos) -> std::deque< long >::iterator
        erase(longDeque self, std::deque< long >::iterator first, std::deque< long >::iterator last) -> std::deque< long >::iterator
        """
        return _oalib.longDeque_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(longDeque self) -> longDeque
        __init__(longDeque self, longDeque other) -> longDeque
        __init__(longDeque self, std::deque< long >::size_type size) -> longDeque
        __init__(longDeque self, std::deque< long >::size_type size, std::deque< long >::value_type const & value) -> longDeque
        """
        _oalib.longDeque_swiginit(self, _oalib.new_longDeque(*args))

    def push_back(self, x):
        r"""push_back(longDeque self, std::deque< long >::value_type const & x)"""
        return _oalib.longDeque_push_back(self, x)

    def front(self):
        r"""front(longDeque self) -> std::deque< long >::value_type const &"""
        return _oalib.longDeque_front(self)

    def back(self):
        r"""back(longDeque self) -> std::deque< long >::value_type const &"""
        return _oalib.longDeque_back(self)

    def assign(self, n, x):
        r"""assign(longDeque self, std::deque< long >::size_type n, std::deque< long >::value_type const & x)"""
        return _oalib.longDeque_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(longDeque self, std::deque< long >::size_type new_size)
        resize(longDeque self, std::deque< long >::size_type new_size, std::deque< long >::value_type const & x)
        """
        return _oalib.longDeque_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(longDeque self, std::deque< long >::iterator pos, std::deque< long >::value_type const & x) -> std::deque< long >::iterator
        insert(longDeque self, std::deque< long >::iterator pos, std::deque< long >::size_type n, std::deque< long >::value_type const & x)
        """
        return _oalib.longDeque_insert(self, *args)

    def pop_front(self):
        r"""pop_front(longDeque self)"""
        return _oalib.longDeque_pop_front(self)

    def push_front(self, x):
        r"""push_front(longDeque self, std::deque< long >::value_type const & x)"""
        return _oalib.longDeque_push_front(self, x)
    __swig_destroy__ = _oalib.delete_longDeque

# Register longDeque in _oalib:
_oalib.longDeque_swigregister(longDeque)

class doubleVector(object):
    r"""Proxy of C++ std::vector< double > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(doubleVector self) -> SwigPyIterator"""
        return _oalib.doubleVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(doubleVector self) -> bool"""
        return _oalib.doubleVector___nonzero__(self)

    def __bool__(self):
        r"""__bool__(doubleVector self) -> bool"""
        return _oalib.doubleVector___bool__(self)

    def __len__(self):
        r"""__len__(doubleVector self) -> std::vector< double >::size_type"""
        return _oalib.doubleVector___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(doubleVector self, std::vector< double >::difference_type i, std::vector< double >::difference_type j) -> doubleVector"""
        return _oalib.doubleVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(doubleVector self, std::vector< double >::difference_type i, std::vector< double >::difference_type j)
        __setslice__(doubleVector self, std::vector< double >::difference_type i, std::vector< double >::difference_type j, doubleVector v)
        """
        return _oalib.doubleVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(doubleVector self, std::vector< double >::difference_type i, std::vector< double >::difference_type j)"""
        return _oalib.doubleVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(doubleVector self, std::vector< double >::difference_type i)
        __delitem__(doubleVector self, PySliceObject * slice)
        """
        return _oalib.doubleVector___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(doubleVector self, PySliceObject * slice) -> doubleVector
        __getitem__(doubleVector self, std::vector< double >::difference_type i) -> std::vector< double >::value_type const &
        """
        return _oalib.doubleVector___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(doubleVector self, PySliceObject * slice, doubleVector v)
        __setitem__(doubleVector self, PySliceObject * slice)
        __setitem__(doubleVector self, std::vector< double >::difference_type i, std::vector< double >::value_type const & x)
        """
        return _oalib.doubleVector___setitem__(self, *args)

    def pop(self):
        r"""pop(doubleVector self) -> std::vector< double >::value_type"""
        return _oalib.doubleVector_pop(self)

    def append(self, x):
        r"""append(doubleVector self, std::vector< double >::value_type const & x)"""
        return _oalib.doubleVector_append(self, x)

    def empty(self):
        r"""empty(doubleVector self) -> bool"""
        return _oalib.doubleVector_empty(self)

    def size(self):
        r"""size(doubleVector self) -> std::vector< double >::size_type"""
        return _oalib.doubleVector_size(self)

    def swap(self, v):
        r"""swap(doubleVector self, doubleVector v)"""
        return _oalib.doubleVector_swap(self, v)

    def begin(self):
        r"""begin(doubleVector self) -> std::vector< double >::iterator"""
        return _oalib.doubleVector_begin(self)

    def end(self):
        r"""end(doubleVector self) -> std::vector< double >::iterator"""
        return _oalib.doubleVector_end(self)

    def rbegin(self):
        r"""rbegin(doubleVector self) -> std::vector< double >::reverse_iterator"""
        return _oalib.doubleVector_rbegin(self)

    def rend(self):
        r"""rend(doubleVector self) -> std::vector< double >::reverse_iterator"""
        return _oalib.doubleVector_rend(self)

    def clear(self):
        r"""clear(doubleVector self)"""
        return _oalib.doubleVector_clear(self)

    def get_allocator(self):
        r"""get_allocator(doubleVector self) -> std::vector< double >::allocator_type"""
        return _oalib.doubleVector_get_allocator(self)

    def pop_back(self):
        r"""pop_back(doubleVector self)"""
        return _oalib.doubleVector_pop_back(self)

    def erase(self, *args):
        r"""
        erase(doubleVector self, std::vector< double >::iterator pos) -> std::vector< double >::iterator
        erase(doubleVector self, std::vector< double >::iterator first, std::vector< double >::iterator last) -> std::vector< double >::iterator
        """
        return _oalib.doubleVector_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(doubleVector self) -> doubleVector
        __init__(doubleVector self, doubleVector other) -> doubleVector
        __init__(doubleVector self, std::vector< double >::size_type size) -> doubleVector
        __init__(doubleVector self, std::vector< double >::size_type size, std::vector< double >::value_type const & value) -> doubleVector
        """
        _oalib.doubleVector_swiginit(self, _oalib.new_doubleVector(*args))

    def push_back(self, x):
        r"""push_back(doubleVector self, std::vector< double >::value_type const & x)"""
        return _oalib.doubleVector_push_back(self, x)

    def front(self):
        r"""front(doubleVector self) -> std::vector< double >::value_type const &"""
        return _oalib.doubleVector_front(self)

    def back(self):
        r"""back(doubleVector self) -> std::vector< double >::value_type const &"""
        return _oalib.doubleVector_back(self)

    def assign(self, n, x):
        r"""assign(doubleVector self, std::vector< double >::size_type n, std::vector< double >::value_type const & x)"""
        return _oalib.doubleVector_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(doubleVector self, std::vector< double >::size_type new_size)
        resize(doubleVector self, std::vector< double >::size_type new_size, std::vector< double >::value_type const & x)
        """
        return _oalib.doubleVector_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(doubleVector self, std::vector< double >::iterator pos, std::vector< double >::value_type const & x) -> std::vector< double >::iterator
        insert(doubleVector self, std::vector< double >::iterator pos, std::vector< double >::size_type n, std::vector< double >::value_type const & x)
        """
        return _oalib.doubleVector_insert(self, *args)

    def reserve(self, n):
        r"""reserve(doubleVector self, std::vector< double >::size_type n)"""
        return _oalib.doubleVector_reserve(self, n)

    def capacity(self):
        r"""capacity(doubleVector self) -> std::vector< double >::size_type"""
        return _oalib.doubleVector_capacity(self)
    __swig_destroy__ = _oalib.delete_doubleVector

# Register doubleVector in _oalib:
_oalib.doubleVector_swigregister(doubleVector)

class stringVector(object):
    r"""Proxy of C++ std::vector< std::string > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(stringVector self) -> SwigPyIterator"""
        return _oalib.stringVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(stringVector self) -> bool"""
        return _oalib.stringVector___nonzero__(self)

    def __bool__(self):
        r"""__bool__(stringVector self) -> bool"""
        return _oalib.stringVector___bool__(self)

    def __len__(self):
        r"""__len__(stringVector self) -> std::vector< std::string >::size_type"""
        return _oalib.stringVector___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(stringVector self, std::vector< std::string >::difference_type i, std::vector< std::string >::difference_type j) -> stringVector"""
        return _oalib.stringVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(stringVector self, std::vector< std::string >::difference_type i, std::vector< std::string >::difference_type j)
        __setslice__(stringVector self, std::vector< std::string >::difference_type i, std::vector< std::string >::difference_type j, stringVector v)
        """
        return _oalib.stringVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(stringVector self, std::vector< std::string >::difference_type i, std::vector< std::string >::difference_type j)"""
        return _oalib.stringVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(stringVector self, std::vector< std::string >::difference_type i)
        __delitem__(stringVector self, PySliceObject * slice)
        """
        return _oalib.stringVector___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(stringVector self, PySliceObject * slice) -> stringVector
        __getitem__(stringVector self, std::vector< std::string >::difference_type i) -> std::vector< std::string >::value_type const &
        """
        return _oalib.stringVector___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(stringVector self, PySliceObject * slice, stringVector v)
        __setitem__(stringVector self, PySliceObject * slice)
        __setitem__(stringVector self, std::vector< std::string >::difference_type i, std::vector< std::string >::value_type const & x)
        """
        return _oalib.stringVector___setitem__(self, *args)

    def pop(self):
        r"""pop(stringVector self) -> std::vector< std::string >::value_type"""
        return _oalib.stringVector_pop(self)

    def append(self, x):
        r"""append(stringVector self, std::vector< std::string >::value_type const & x)"""
        return _oalib.stringVector_append(self, x)

    def empty(self):
        r"""empty(stringVector self) -> bool"""
        return _oalib.stringVector_empty(self)

    def size(self):
        r"""size(stringVector self) -> std::vector< std::string >::size_type"""
        return _oalib.stringVector_size(self)

    def swap(self, v):
        r"""swap(stringVector self, stringVector v)"""
        return _oalib.stringVector_swap(self, v)

    def begin(self):
        r"""begin(stringVector self) -> std::vector< std::string >::iterator"""
        return _oalib.stringVector_begin(self)

    def end(self):
        r"""end(stringVector self) -> std::vector< std::string >::iterator"""
        return _oalib.stringVector_end(self)

    def rbegin(self):
        r"""rbegin(stringVector self) -> std::vector< std::string >::reverse_iterator"""
        return _oalib.stringVector_rbegin(self)

    def rend(self):
        r"""rend(stringVector self) -> std::vector< std::string >::reverse_iterator"""
        return _oalib.stringVector_rend(self)

    def clear(self):
        r"""clear(stringVector self)"""
        return _oalib.stringVector_clear(self)

    def get_allocator(self):
        r"""get_allocator(stringVector self) -> std::vector< std::string >::allocator_type"""
        return _oalib.stringVector_get_allocator(self)

    def pop_back(self):
        r"""pop_back(stringVector self)"""
        return _oalib.stringVector_pop_back(self)

    def erase(self, *args):
        r"""
        erase(stringVector self, std::vector< std::string >::iterator pos) -> std::vector< std::string >::iterator
        erase(stringVector self, std::vector< std::string >::iterator first, std::vector< std::string >::iterator last) -> std::vector< std::string >::iterator
        """
        return _oalib.stringVector_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(stringVector self) -> stringVector
        __init__(stringVector self, stringVector other) -> stringVector
        __init__(stringVector self, std::vector< std::string >::size_type size) -> stringVector
        __init__(stringVector self, std::vector< std::string >::size_type size, std::vector< std::string >::value_type const & value) -> stringVector
        """
        _oalib.stringVector_swiginit(self, _oalib.new_stringVector(*args))

    def push_back(self, x):
        r"""push_back(stringVector self, std::vector< std::string >::value_type const & x)"""
        return _oalib.stringVector_push_back(self, x)

    def front(self):
        r"""front(stringVector self) -> std::vector< std::string >::value_type const &"""
        return _oalib.stringVector_front(self)

    def back(self):
        r"""back(stringVector self) -> std::vector< std::string >::value_type const &"""
        return _oalib.stringVector_back(self)

    def assign(self, n, x):
        r"""assign(stringVector self, std::vector< std::string >::size_type n, std::vector< std::string >::value_type const & x)"""
        return _oalib.stringVector_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(stringVector self, std::vector< std::string >::size_type new_size)
        resize(stringVector self, std::vector< std::string >::size_type new_size, std::vector< std::string >::value_type const & x)
        """
        return _oalib.stringVector_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(stringVector self, std::vector< std::string >::iterator pos, std::vector< std::string >::value_type const & x) -> std::vector< std::string >::iterator
        insert(stringVector self, std::vector< std::string >::iterator pos, std::vector< std::string >::size_type n, std::vector< std::string >::value_type const & x)
        """
        return _oalib.stringVector_insert(self, *args)

    def reserve(self, n):
        r"""reserve(stringVector self, std::vector< std::string >::size_type n)"""
        return _oalib.stringVector_reserve(self, n)

    def capacity(self):
        r"""capacity(stringVector self) -> std::vector< std::string >::size_type"""
        return _oalib.stringVector_capacity(self)
    __swig_destroy__ = _oalib.delete_stringVector

# Register stringVector in _oalib:
_oalib.stringVector_swigregister(stringVector)

class map_int_long(object):
    r"""Proxy of C++ std::map< int,long > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(map_int_long self) -> SwigPyIterator"""
        return _oalib.map_int_long_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(map_int_long self) -> bool"""
        return _oalib.map_int_long___nonzero__(self)

    def __bool__(self):
        r"""__bool__(map_int_long self) -> bool"""
        return _oalib.map_int_long___bool__(self)

    def __len__(self):
        r"""__len__(map_int_long self) -> std::map< int,long >::size_type"""
        return _oalib.map_int_long___len__(self)
    def __iter__(self):
        return self.key_iterator()
    def iterkeys(self):
        return self.key_iterator()
    def itervalues(self):
        return self.value_iterator()
    def iteritems(self):
        return self.iterator()

    def __getitem__(self, key):
        r"""__getitem__(map_int_long self, std::map< int,long >::key_type const & key) -> std::map< int,long >::mapped_type const &"""
        return _oalib.map_int_long___getitem__(self, key)

    def __delitem__(self, key):
        r"""__delitem__(map_int_long self, std::map< int,long >::key_type const & key)"""
        return _oalib.map_int_long___delitem__(self, key)

    def has_key(self, key):
        r"""has_key(map_int_long self, std::map< int,long >::key_type const & key) -> bool"""
        return _oalib.map_int_long_has_key(self, key)

    def keys(self):
        r"""keys(map_int_long self) -> PyObject *"""
        return _oalib.map_int_long_keys(self)

    def values(self):
        r"""values(map_int_long self) -> PyObject *"""
        return _oalib.map_int_long_values(self)

    def items(self):
        r"""items(map_int_long self) -> PyObject *"""
        return _oalib.map_int_long_items(self)

    def __contains__(self, key):
        r"""__contains__(map_int_long self, std::map< int,long >::key_type const & key) -> bool"""
        return _oalib.map_int_long___contains__(self, key)

    def key_iterator(self):
        r"""key_iterator(map_int_long self) -> SwigPyIterator"""
        return _oalib.map_int_long_key_iterator(self)

    def value_iterator(self):
        r"""value_iterator(map_int_long self) -> SwigPyIterator"""
        return _oalib.map_int_long_value_iterator(self)

    def __setitem__(self, *args):
        r"""
        __setitem__(map_int_long self, std::map< int,long >::key_type const & key)
        __setitem__(map_int_long self, std::map< int,long >::key_type const & key, std::map< int,long >::mapped_type const & x)
        """
        return _oalib.map_int_long___setitem__(self, *args)

    def asdict(self):
        r"""asdict(map_int_long self) -> PyObject *"""
        return _oalib.map_int_long_asdict(self)

    def __init__(self, *args):
        r"""
        __init__(map_int_long self, std::less< int > const & other) -> map_int_long
        __init__(map_int_long self) -> map_int_long
        __init__(map_int_long self, map_int_long other) -> map_int_long
        """
        _oalib.map_int_long_swiginit(self, _oalib.new_map_int_long(*args))

    def empty(self):
        r"""empty(map_int_long self) -> bool"""
        return _oalib.map_int_long_empty(self)

    def size(self):
        r"""size(map_int_long self) -> std::map< int,long >::size_type"""
        return _oalib.map_int_long_size(self)

    def swap(self, v):
        r"""swap(map_int_long self, map_int_long v)"""
        return _oalib.map_int_long_swap(self, v)

    def begin(self):
        r"""begin(map_int_long self) -> std::map< int,long >::iterator"""
        return _oalib.map_int_long_begin(self)

    def end(self):
        r"""end(map_int_long self) -> std::map< int,long >::iterator"""
        return _oalib.map_int_long_end(self)

    def rbegin(self):
        r"""rbegin(map_int_long self) -> std::map< int,long >::reverse_iterator"""
        return _oalib.map_int_long_rbegin(self)

    def rend(self):
        r"""rend(map_int_long self) -> std::map< int,long >::reverse_iterator"""
        return _oalib.map_int_long_rend(self)

    def clear(self):
        r"""clear(map_int_long self)"""
        return _oalib.map_int_long_clear(self)

    def get_allocator(self):
        r"""get_allocator(map_int_long self) -> std::map< int,long >::allocator_type"""
        return _oalib.map_int_long_get_allocator(self)

    def count(self, x):
        r"""count(map_int_long self, std::map< int,long >::key_type const & x) -> std::map< int,long >::size_type"""
        return _oalib.map_int_long_count(self, x)

    def erase(self, *args):
        r"""
        erase(map_int_long self, std::map< int,long >::key_type const & x) -> std::map< int,long >::size_type
        erase(map_int_long self, std::map< int,long >::iterator position)
        erase(map_int_long self, std::map< int,long >::iterator first, std::map< int,long >::iterator last)
        """
        return _oalib.map_int_long_erase(self, *args)

    def find(self, x):
        r"""find(map_int_long self, std::map< int,long >::key_type const & x) -> std::map< int,long >::iterator"""
        return _oalib.map_int_long_find(self, x)

    def lower_bound(self, x):
        r"""lower_bound(map_int_long self, std::map< int,long >::key_type const & x) -> std::map< int,long >::iterator"""
        return _oalib.map_int_long_lower_bound(self, x)

    def upper_bound(self, x):
        r"""upper_bound(map_int_long self, std::map< int,long >::key_type const & x) -> std::map< int,long >::iterator"""
        return _oalib.map_int_long_upper_bound(self, x)
    __swig_destroy__ = _oalib.delete_map_int_long

# Register map_int_long in _oalib:
_oalib.map_int_long_swigregister(map_int_long)


import numpy

MAXCOLS = _oalib.MAXCOLS

MAXROWS = _oalib.MAXROWS

OACHECK = _oalib.OACHECK

FREQELEM = _oalib.FREQELEM

SYMMBLOCKS = _oalib.SYMMBLOCKS

TPLUSCOLUMN = _oalib.TPLUSCOLUMN

oacolSortName = _oalib.oacolSortName


def compile_information():
    r"""
    compile_information() -> std::string


    Print the compile-time options to string.

    Returns
    -------
    String with compile time information

    """
    return _oalib.compile_information()

def version():
    r"""
    version() -> std::string


    Print version.

    """
    return _oalib.version()

def print_copyright():
    r"""
    print_copyright()


    Print copyright statement.

    """
    return _oalib.print_copyright()

def print_copyright_light():
    r"""
    print_copyright_light()


    Print copyright statement.

    """
    return _oalib.print_copyright_light()

def print_options(*args):
    r"""
    print_options(std::ostream & output_stream)
    print_options()


    Print compile time options to stdout.

    """
    return _oalib.print_options(*args)

def oadevelop():
    r"""
    oadevelop() -> int


    """
    return _oalib.oadevelop()

def has_zlib():
    r"""
    has_zlib() -> int


    Return true if zlib is available and compressed files can be read.

    """
    return _oalib.has_zlib()
class Combinations(object):
    r"""


    C++ includes: mathtools.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _oalib.delete_Combinations

    @staticmethod
    def number_combinations_max_n():
        r"""
        number_combinations_max_n() -> int


        return max number of N that can be calculated with number_combinations

        """
        return _oalib.Combinations_number_combinations_max_n()

    @staticmethod
    def initialize_number_combinations(N):
        r"""
        initialize_number_combinations(int N)


        initialize datastructure for number_combinations, this function is not thread
        safe

        """
        return _oalib.Combinations_initialize_number_combinations(N)

    @staticmethod
    def number_combinations(n, k):
        r"""
        number_combinations(int n, int k) -> long


        Return number of combinations from previously calculated results

        The results should be initialized with initialize_number_combinations

        """
        return _oalib.Combinations_number_combinations(n, k)

    def __init__(self):
        r"""
        __init__(Combinations self) -> Combinations


        C++ includes: mathtools.h

        """
        _oalib.Combinations_swiginit(self, _oalib.new_Combinations())

# Register Combinations in _oalib:
_oalib.Combinations_swigregister(Combinations)

def Combinations_number_combinations_max_n():
    r"""
    Combinations_number_combinations_max_n() -> int


    return max number of N that can be calculated with number_combinations

    """
    return _oalib.Combinations_number_combinations_max_n()

def Combinations_initialize_number_combinations(N):
    r"""
    Combinations_initialize_number_combinations(int N)


    initialize datastructure for number_combinations, this function is not thread
    safe

    """
    return _oalib.Combinations_initialize_number_combinations(N)

def Combinations_number_combinations(n, k):
    r"""
    Combinations_number_combinations(int n, int k) -> long


    Return number of combinations from previously calculated results

    The results should be initialized with initialize_number_combinations

    """
    return _oalib.Combinations_number_combinations(n, k)


def fastrand():
    r"""
    fastrand() -> int


    """
    return _oalib.fastrand()

def seedfastrand(s):
    r"""
    seedfastrand(int s)


    """
    return _oalib.seedfastrand(s)

def fastrandK(k):
    r"""
    fastrandK(int k) -> int


    """
    return _oalib.fastrandK(k)

def set_srand(s):
    r"""
    set_srand(unsigned int s)


    seed the C rand method with the srand function

    """
    return _oalib.set_srand(s)
class indexsort(object):
    r"""


    Class to sort data without moving the data in memory.

    The data is sorted by using a list of indices. A stable sort is being used.

    C++ includes: mathtools.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    indices = property(_oalib.indexsort_indices_get, _oalib.indexsort_indices_set, doc=r"""indices : std::vector<(int,std::allocator<(int)>)>""")

    def __init__(self, nn):
        r"""
        __init__(indexsort self, int nn) -> indexsort


        Constructor for vector class.

        """
        _oalib.indexsort_swiginit(self, _oalib.new_indexsort(nn))

    def show(self):
        r"""
        show(indexsort self)


        """
        return _oalib.indexsort_show(self)

    def issorted(self):
        r"""
        issorted(indexsort self) -> bool


        Returns true of the data is sorted ascending.

        """
        return _oalib.indexsort_issorted(self)

    def issorteddescending(self):
        r"""
        issorteddescending(indexsort self) -> bool


        Returns true of the data is sorted descending.

        """
        return _oalib.indexsort_issorteddescending(self)
    __swig_destroy__ = _oalib.delete_indexsort

# Register indexsort in _oalib:
_oalib.indexsort_swigregister(indexsort)

class symmetry_group(object):
    r"""


    Class to describe the symmetry group of a list of elements.

    The class assumes the list is sorted. The symmetry group is then a direct
    product of full permutation groups.

    We do not implement this using templates because we want to export to Python.

    C++ includes: mathtools.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    gidx = property(_oalib.symmetry_group_gidx_get, _oalib.symmetry_group_gidx_set, doc=r"""gidx : std::vector<(int,std::allocator<(int)>)>""")
    gstart = property(_oalib.symmetry_group_gstart_get, _oalib.symmetry_group_gstart_set, doc=r"""gstart : std::vector<(int,std::allocator<(int)>)>""")
    gsize = property(_oalib.symmetry_group_gsize_get, _oalib.symmetry_group_gsize_set, doc=r"""gsize : std::vector<(int,std::allocator<(int)>)>""")
    ngroups = property(_oalib.symmetry_group_ngroups_get, _oalib.symmetry_group_ngroups_set, doc=r"""ngroups : int""")
    n = property(_oalib.symmetry_group_n_get, _oalib.symmetry_group_n_set, doc=r"""n : int""")
    ascending = property(_oalib.symmetry_group_ascending_get, _oalib.symmetry_group_ascending_set, doc=r"""ascending : bool""")

    def __init__(self, *args):
        r"""
        __init__(symmetry_group self, intVector vals, bool ascending=True, int verbose=0) -> symmetry_group
        __init__(symmetry_group self, doubleVector vals, bool ascending=True, int verbose=0) -> symmetry_group
        __init__(symmetry_group self, std::vector< float,std::allocator< float > > const & vals, bool ascending=True, int verbose=0) -> symmetry_group
        __init__(symmetry_group self, std::vector< short,std::allocator< short > > const & vals, bool ascending=True, int verbose=0) -> symmetry_group
        __init__(symmetry_group self, std::vector< unsigned int,std::allocator< unsigned int > > const & vals, bool ascending=True, int verbose=0) -> symmetry_group
        __init__(symmetry_group self, vector_mvalue_t_double vals, bool ascending=True, int verbose=0) -> symmetry_group
        __init__(symmetry_group self, vector_mvalue_t_int vals, bool ascending=True, int verbose=0) -> symmetry_group
        __init__(symmetry_group self, symmetry_group sgx) -> symmetry_group
        __init__(symmetry_group self) -> symmetry_group


        default constructor

        """
        _oalib.symmetry_group_swiginit(self, _oalib.new_symmetry_group(*args))

    def permsize(self):
        r"""
        permsize(symmetry_group self) -> symmetry_group::perm_return_type


        Return size of the group of all permutations respecting the symmetry

        The return type can overflow quickly. For larger group sizes use permsize_large

        """
        return _oalib.symmetry_group_permsize(self)

    def permsize_large(self):
        r"""
        permsize_large(symmetry_group self) -> InfInt


        return size of the group of all permutations respecting the symmetry

        """
        return _oalib.symmetry_group_permsize_large(self)

    def checkIndices(self):
        r"""
        checkIndices(symmetry_group self) -> intVector


        list with indices set to check for symmetry reductions

        """
        return _oalib.symmetry_group_checkIndices(self)

    def __repr__(self):
        r"""
        __repr__(symmetry_group self) -> std::string


        representation function (for python interface)

        """
        return _oalib.symmetry_group___repr__(self)

    def show(self, verbose=1):
        r"""
        show(symmetry_group self, int verbose=1)


        show the symmetry group

        """
        return _oalib.symmetry_group_show(self, verbose)
    __swig_destroy__ = _oalib.delete_symmetry_group

# Register symmetry_group in _oalib:
_oalib.symmetry_group_swigregister(symmetry_group)

class symmetry_group_walker(object):
    r"""


    Class to walk over all elements of a symmetry group

    The elements are generated by walking over all product permutations.

    C++ includes: mathtools.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    sg = property(_oalib.symmetry_group_walker_sg_get, _oalib.symmetry_group_walker_sg_set, doc=r"""sg : symmetry_group""")
    perms = property(_oalib.symmetry_group_walker_perms_get, _oalib.symmetry_group_walker_perms_set, doc=r"""perms : std::vector<(std::vector<(int,std::allocator<(int)>)>,std::allocator<(std::vector<(int,std::allocator<(int)>)>)>)>""")

    def __init__(self, sg):
        r"""
        __init__(symmetry_group_walker self, symmetry_group sg) -> symmetry_group_walker


        """
        _oalib.symmetry_group_walker_swiginit(self, _oalib.new_symmetry_group_walker(sg))

    def show(self, verbose=1):
        r"""
        show(symmetry_group_walker self, int verbose=1)


        show all elements in the symmetry group

        """
        return _oalib.symmetry_group_walker_show(self, verbose)

    def next(self):
        r"""
        next(symmetry_group_walker self) -> bool


        go to next element of the symmetry group

        """
        return _oalib.symmetry_group_walker_next(self)

    def fullperm(self):
        r"""
        fullperm(symmetry_group_walker self) -> intVector


        return the full permutation corresponding to the current permutation in the
        walker

        """
        return _oalib.symmetry_group_walker_fullperm(self)
    __swig_destroy__ = _oalib.delete_symmetry_group_walker

# Register symmetry_group_walker in _oalib:
_oalib.symmetry_group_walker_swigregister(symmetry_group_walker)


def ipow(*args):
    r"""
    ipow(long x, long y) -> long
    ipow(unsigned int x, unsigned int p) -> unsigned int


    Power of two unsigned integers.

    """
    return _oalib.ipow(*args)

def power_minus_one(*args):
    r"""
    power_minus_one(int n) -> int
    power_minus_one(long n) -> long


    -1 to the power n (integer)

    """
    return _oalib.power_minus_one(*args)

def throw_runtime_exception(exception_message):
    r"""
    throw_runtime_exception(std::string const exception_message)


    Throw a runtime_error exception with specified error message

    This exception is caught in the SWIG interface.

    """
    return _oalib.throw_runtime_exception(exception_message)

def eigenInfo(*args):
    r"""eigenInfo(MatrixFloat const m, char const * str="eigen", int verbose=1)"""
    return _oalib.eigenInfo(*args)

def print_eigen_matrix(matrix):
    r"""print_eigen_matrix(MatrixFloat const matrix)"""
    return _oalib.print_eigen_matrix(matrix)

def eigen2numpyHelper(pymat1, n, m):
    r"""eigen2numpyHelper(double * pymat1, int n, MatrixFloat const & m)"""
    return _oalib.eigen2numpyHelper(pymat1, n, m)

def sizeof_array_t():
    r"""sizeof_array_t() -> int"""
    return _oalib.sizeof_array_t()

def sizeof_double():
    r"""sizeof_double() -> int"""
    return _oalib.sizeof_double()

def possible_F_values(N, strength):
    r"""possible_F_values(int N, int strength) -> intVector"""
    return _oalib.possible_F_values(N, strength)

def file_exists(*args):
    r"""
    file_exists(std::string const filename) -> bool
    file_exists(char const * filename) -> bool
    """
    return _oalib.file_exists(*args)

def oa_file_exists(*args):
    r"""
    oa_file_exists(char const * filename) -> bool
    oa_file_exists(std::string const filename) -> bool
    """
    return _oalib.oa_file_exists(*args)
ORDER_LEX = _oalib.ORDER_LEX
r""" lexicograph minimal by columns ordering"""
ORDER_J5 = _oalib.ORDER_J5
r""" J5 based ordering"""
class arraydata_t(object):
    r"""


    Specifies a class of arrays.

    The specification includes the number of rows, number of columns, factor levels
    and strength.

    C++ includes: arraytools.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    N = property(_oalib.arraydata_t_N_get, _oalib.arraydata_t_N_set, doc=r"""N : rowindex_t""")
    ncols = property(_oalib.arraydata_t_ncols_get, _oalib.arraydata_t_ncols_set, doc=r"""ncols : colindex_t""")
    strength = property(_oalib.arraydata_t_strength_get, _oalib.arraydata_t_strength_set, doc=r"""strength : colindex_t""")
    s = property(_oalib.arraydata_t_s_get, _oalib.arraydata_t_s_set, doc=r"""s : p.array_t""")
    order = property(_oalib.arraydata_t_order_get, _oalib.arraydata_t_order_set, doc=r"""order : ordering_t""")
    ncolgroups = property(_oalib.arraydata_t_ncolgroups_get, _oalib.arraydata_t_ncolgroups_set, doc=r"""ncolgroups : colindex_t""")
    colgroupindex = property(_oalib.arraydata_t_colgroupindex_get, _oalib.arraydata_t_colgroupindex_set, doc=r"""colgroupindex : p.colindex_t""")
    colgroupsize = property(_oalib.arraydata_t_colgroupsize_get, _oalib.arraydata_t_colgroupsize_set, doc=r"""colgroupsize : p.colindex_t""")
    oaindex = property(_oalib.arraydata_t_oaindex_get, _oalib.arraydata_t_oaindex_set, doc=r"""oaindex : int""")

    def __init__(self, *args):
        r"""
        __init__(arraydata_t self) -> arraydata_t
        __init__(arraydata_t self, array_t s, rowindex_t N, colindex_t strength, colindex_t ncols) -> arraydata_t
        __init__(arraydata_t self, intVector s, rowindex_t N, colindex_t strength, colindex_t ncols) -> arraydata_t
        __init__(arraydata_t self, array_t const * s_, rowindex_t N, colindex_t strength, colindex_t ncols) -> arraydata_t
        __init__(arraydata_t self, arraydata_t adp) -> arraydata_t
        __init__(arraydata_t self, arraydata_t adp, colindex_t newncols) -> arraydata_t


        Specifies a class of orthogonal arrays

        The specification includes the number of rows, number of columns, factor levels
        and strength.

        An orthogonal array of strength t, N runs, k factors (columns) and factor levels
        s[i] is an N times k array with symbols 0, 1, ..., s[i]-1 in column i such that
        for every t columns every t-tuple of elements occurs equally often.

        """
        _oalib.arraydata_t_swiginit(self, _oalib.new_arraydata_t(*args))
    __swig_destroy__ = _oalib.delete_arraydata_t

    def __eq__(self, ad2):
        r"""__eq__(arraydata_t self, arraydata_t ad2) -> int"""
        return _oalib.arraydata_t___eq__(self, ad2)

    def ismixed(self):
        r"""
        ismixed(arraydata_t self) -> bool


        return true if the class represents mixed-level arrays

        """
        return _oalib.arraydata_t_ismixed(self)

    def is2level(self):
        r"""
        is2level(arraydata_t self) -> bool


        return true if the class represents a 2-level array

        """
        return _oalib.arraydata_t_is2level(self)

    def randomarray(self, strength=0, ncols=-1):
        r"""
        randomarray(arraydata_t self, int strength=0, int ncols=-1) -> array_link


        return random array from the class. this operation is only valid for strength 0
        or 1

        """
        return _oalib.arraydata_t_randomarray(self, strength, ncols)

    def writeConfigFile(self, filename):
        r"""
        writeConfigFile(arraydata_t self, char const * filename)


        Write file with specification of orthognal array class.

        Parameters
        ----------
        * `filename` :
            Filename to write to

        """
        return _oalib.arraydata_t_writeConfigFile(self, filename)

    def idstr(self):
        r"""
        idstr(arraydata_t self) -> std::string


        """
        return _oalib.arraydata_t_idstr(self)

    def idstrseriesfull(self):
        r"""
        idstrseriesfull(arraydata_t self) -> std::string


        """
        return _oalib.arraydata_t_idstrseriesfull(self)

    def fullidstr(self, series=0):
        r"""
        fullidstr(arraydata_t self, int series=0) -> std::string


        """
        return _oalib.arraydata_t_fullidstr(self, series)

    def latexstr(self, cmd=0, series=0):
        r"""
        latexstr(arraydata_t self, int cmd=0, int series=0) -> std::string


        return latex string describing the class

        """
        return _oalib.arraydata_t_latexstr(self, cmd, series)

    def reduceColumns(self, k):
        r"""
        reduceColumns(arraydata_t self, int k) -> arraydata_t


        """
        return _oalib.arraydata_t_reduceColumns(self, k)

    def showstr(self):
        r"""
        showstr(arraydata_t self) -> std::string


        """
        return _oalib.arraydata_t_showstr(self)

    def show(self, verbose=1):
        r"""
        show(arraydata_t self, int verbose=1)


        """
        return _oalib.arraydata_t_show(self, verbose)

    def complete_arraydata(self):
        r"""
        complete_arraydata(arraydata_t self)


        Calculate derived data such as the index and column groups from a design.

        """
        return _oalib.arraydata_t_complete_arraydata(self)

    def lmc_overflow_check(self):
        r"""
        lmc_overflow_check(arraydata_t self)


        check whether the LMC calculation will overflow

        """
        return _oalib.arraydata_t_lmc_overflow_check(self)

    def complete_arraydata_fixlast(self):
        r"""
        complete_arraydata_fixlast(arraydata_t self)


        """
        return _oalib.arraydata_t_complete_arraydata_fixlast(self)

    def complete_arraydata_splitn(self, ns):
        r"""
        complete_arraydata_splitn(arraydata_t self, int ns)


        """
        return _oalib.arraydata_t_complete_arraydata_splitn(self, ns)

    def set_colgroups(self, *args):
        r"""
        set_colgroups(arraydata_t self, intVector splits)
        set_colgroups(arraydata_t self, symmetry_group sg)


        set column group equal to that of a symmetry group

        """
        return _oalib.arraydata_t_set_colgroups(self, *args)

    def get_column_groups_sizes(self):
        r"""get_column_groups_sizes(arraydata_t self) -> intVector"""
        return _oalib.arraydata_t_get_column_groups_sizes(self)

    def show_colgroups(self):
        r"""
        show_colgroups(arraydata_t self)


        show column groups in the array class

        """
        return _oalib.arraydata_t_show_colgroups(self)

    def calculate_oa_index(self, strength):
        r"""
        calculate_oa_index(arraydata_t self, colindex_t strength)


        calculate the index of the orthogonal arrays in this class

        """
        return _oalib.arraydata_t_calculate_oa_index(self, strength)

    def create_root(self, n_columns=-1, fill_value=0):
        r"""
        create_root(arraydata_t self, int n_columns=-1, int fill_value=0) -> array_link


        return the root array for the class

        """
        return _oalib.arraydata_t_create_root(self, n_columns, fill_value)

    def getfactorlevel(self, idx):
        r"""
        getfactorlevel(arraydata_t self, int idx) -> int


        return the factor level for the specified column return -1 if the column index
        is invalid

        """
        return _oalib.arraydata_t_getfactorlevel(self, idx)

    def getS(self):
        r"""
        getS(arraydata_t self) -> intVector


        return factor levels

        """
        return _oalib.arraydata_t_getS(self)

    def factor_levels(self):
        r"""
        factor_levels(arraydata_t self) -> intVector


        return factor levels

        """
        return _oalib.arraydata_t_factor_levels(self)

    def factor_levels_column_groups(self):
        r"""factor_levels_column_groups(arraydata_t self) -> intVector"""
        return _oalib.arraydata_t_factor_levels_column_groups(self)

    def reset_strength(self, strength):
        r"""
        reset_strength(arraydata_t self, colindex_t strength)


        Reset strength of arraydata.

        Parameters
        ----------
        * `strength` :
            The strength to reset the structure to

        """
        return _oalib.arraydata_t_reset_strength(self, strength)

    def get_col_group(self, col):
        r"""
        get_col_group(arraydata_t self, colindex_t const col) -> colindex_t


        Return index of the column group for a column.

        """
        return _oalib.arraydata_t_get_col_group(self, col)

    def is_factor_levels_sorted(self):
        r"""
        is_factor_levels_sorted(arraydata_t self) -> bool


        Return True if the factor levels are sorted from large to small.

        """
        return _oalib.arraydata_t_is_factor_levels_sorted(self)

    def __repr__(self):
        r"""__repr__(arraydata_t self) -> std::string"""
        return _oalib.arraydata_t___repr__(self)

# Register arraydata_t in _oalib:
_oalib.arraydata_t_swigregister(arraydata_t)


def readConfigFile(file):
    r"""readConfigFile(char const * file) -> arraydata_t"""
    return _oalib.readConfigFile(file)

def copy_array(src, dst, nrows, ncols):
    r"""copy_array(array_t const * src, array_t *const dst, int const nrows, int const ncols)"""
    return _oalib.copy_array(src, dst, nrows, ncols)

def destroy_array(array):
    r"""destroy_array(array_t * array) -> int"""
    return _oalib.destroy_array(array)

def create_array(*args):
    r"""
    create_array(int const nrows, int const ncols) -> array_t
    create_array(arraydata_t ad) -> array_t *
    """
    return _oalib.create_array(*args)

def clone_array(array, nrows, ncols):
    r"""clone_array(array_t const *const array, rowindex_t const nrows, colindex_t const ncols) -> array_t *"""
    return _oalib.clone_array(array, nrows, ncols)
class array_link(object):
    r"""


    C++ includes: arraytools.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    n_rows = property(_oalib.array_link_n_rows_get, _oalib.array_link_n_rows_set, doc=r"""n_rows : rowindex_t""")
    n_columns = property(_oalib.array_link_n_columns_get, _oalib.array_link_n_columns_set, doc=r"""n_columns : colindex_t""")
    index = property(_oalib.array_link_index_get, _oalib.array_link_index_set, doc=r"""index : int""")
    array = property(_oalib.array_link_array_get, _oalib.array_link_array_set, doc=r"""array : p.array_t""")
    INDEX_NONE = _oalib.array_link_INDEX_NONE
    
    INDEX_ERROR = _oalib.array_link_INDEX_ERROR
    
    INDEX_DEFAULT = _oalib.array_link_INDEX_DEFAULT
    
    __swig_destroy__ = _oalib.delete_array_link

    def __init__(self, *args):
        r"""
        __init__(array_link self) -> array_link
        __init__(array_link self, rowindex_t nrows, colindex_t ncols, int index) -> array_link
        __init__(array_link self, rowindex_t nrows, colindex_t ncols, int index, carray_t * data) -> array_link
        __init__(array_link self, array_link arg2) -> array_link
        __init__(array_link self, Eigen::MatrixXd & eigen_matrix) -> array_link
        __init__(array_link self, array_link array, intVector column_permutation) -> array_link
        __init__(array_link self, array_t const * array, rowindex_t nrows, colindex_t ncols, int index=0) -> array_link
        __init__(array_link self, array_t const * array, rowindex_t nrows, colindex_t ncolsorig, colindex_t ncols, int index) -> array_link
        __init__(array_link self, intVector values, rowindex_t nrows, colindex_t ncols, int index=0) -> array_link
        __init__(array_link self, long * pymatinput) -> array_link


        A class representing an integer valued array

        The array is initialized by copying the values from a vector.

        """
        _oalib.array_link_swiginit(self, _oalib.new_array_link(*args))

    def clone(self):
        r"""
        clone(array_link self) -> array_link


        """
        return _oalib.array_link_clone(self)

    def showarray(self):
        r"""
        showarray(array_link self)


        print array to stdout

        """
        return _oalib.array_link_showarray(self)

    def showarrayString(self):
        r"""
        showarrayString(array_link self) -> std::string


        print array to string

        """
        return _oalib.array_link_showarrayString(self)

    def showarraycompact(self):
        r"""
        showarraycompact(array_link self)


        print array to stdout in compact format (no whitespace between elemenents)

        """
        return _oalib.array_link_showarraycompact(self)

    def showproperties(self):
        r"""
        showproperties(array_link self)


        print array properties to stdout

        """
        return _oalib.array_link_showproperties(self)

    def is2level(self):
        r"""
        is2level(array_link self) -> bool


        return true if the array is a 2-level array (e.g. only contains values 0 and 1)

        """
        return _oalib.array_link_is2level(self)

    def is_mixed_level(self):
        r"""
        is_mixed_level(array_link self) -> bool


        return true is the array is a mixel-level array

        """
        return _oalib.array_link_is_mixed_level(self)

    def is_orthogonal_array(self):
        r"""
        is_orthogonal_array(array_link self) -> bool


        return true is the array is array with values in 0, 1, ..., for each column

        """
        return _oalib.array_link_is_orthogonal_array(self)

    def is_conference(self, *args):
        r"""
        is_conference(array_link self) -> bool
        is_conference(array_link self, int number_of_zeros) -> bool


        return true if the array is a +1, 0, -1 valued array, with specified number of
        zeros in each column

        """
        return _oalib.array_link_is_conference(self, *args)

    def isSymmetric(self):
        r"""
        isSymmetric(array_link self) -> bool


        return true if the array is symmetric

        """
        return _oalib.array_link_isSymmetric(self)

    def makeSymmetric(self):
        r"""
        makeSymmetric(array_link self)


        make the array symmetric by copying the upper-right to the lower-left

        """
        return _oalib.array_link_makeSymmetric(self)

    def deleteColumn(self, index):
        r"""
        deleteColumn(array_link self, int index) -> array_link


        return array with selected column removed

        """
        return _oalib.array_link_deleteColumn(self, index)

    def selectFirstRows(self, nrows):
        r"""
        selectFirstRows(array_link self, int nrows) -> array_link


        return array with first number_of_arrays rows

        """
        return _oalib.array_link_selectFirstRows(self, nrows)

    def selectFirstColumns(self, ncolumns):
        r"""
        selectFirstColumns(array_link self, int ncolumns) -> array_link


        return array with first number_of_arrays columns selected

        """
        return _oalib.array_link_selectFirstColumns(self, ncolumns)

    def selectLastColumns(self, ncolumns):
        r"""
        selectLastColumns(array_link self, int ncolumns) -> array_link


        return array with last number_of_arrays columns selected

        """
        return _oalib.array_link_selectLastColumns(self, ncolumns)

    def selectColumns(self, *args):
        r"""
        selectColumns(array_link self, intVector c) -> array_link
        selectColumns(array_link self, int c) -> array_link


        select single column from an array

        """
        return _oalib.array_link_selectColumns(self, *args)

    def setColumn(self, *args):
        r"""
        setColumn(array_link self, int c, intVector v)
        setColumn(array_link self, int c, charVector v)


        set a column of the array to the given vector

        """
        return _oalib.array_link_setColumn(self, *args)

    def transposed(self):
        r"""
        transposed(array_link self) -> array_link


        return transposed array

        """
        return _oalib.array_link_transposed(self)

    def Defficiency(self):
        r"""
        Defficiency(array_link self) -> double


        calculate D-efficiency

        """
        return _oalib.array_link_Defficiency(self)

    def DsEfficiency(self, verbose=0):
        r"""
        DsEfficiency(array_link self, int verbose=0) -> double


        calculate main effect robustness (or Ds-optimality)

        """
        return _oalib.array_link_DsEfficiency(self, verbose)

    def Defficiencies(self, verbose=0, addDs0=0):
        r"""
        Defficiencies(array_link self, int verbose=0, int addDs0=0) -> doubleVector


        calculate D-efficiency, calculate main effect robustness (or Ds-optimality) and
        D1-efficiency for an orthogonal array

        """
        return _oalib.array_link_Defficiencies(self, verbose, addDs0)

    def VIFefficiency(self):
        r"""
        VIFefficiency(array_link self) -> double


        """
        return _oalib.array_link_VIFefficiency(self)

    def Aefficiency(self):
        r"""
        Aefficiency(array_link self) -> double


        calculate A-efficiency

        """
        return _oalib.array_link_Aefficiency(self)

    def Eefficiency(self):
        r"""
        Eefficiency(array_link self) -> double


        calculate E-efficiency

        """
        return _oalib.array_link_Eefficiency(self)

    def Fvalues(self, number_of_columns):
        r"""
        Fvalues(array_link self, int number_of_columns) -> intVector


        Calculate F-values of a 2-level matrix.

        This assumes the strength is at least 3. Otherwise use the jstruct_t object

        """
        return _oalib.array_link_Fvalues(self, number_of_columns)

    def FvaluesConference(self, number_of_columns):
        r"""
        FvaluesConference(array_link self, int number_of_columns) -> intVector


        Calculate F-values of a conference design

        Parameters
        ----------
        * `number_of_columns` :
            Number of columns to use

        Returns
        -------
        The Fk vector with k the number of columns specified

        """
        return _oalib.array_link_FvaluesConference(self, number_of_columns)

    def Jcharacteristics(self, jj=4):
        r"""
        Jcharacteristics(array_link self, int jj=4) -> intVector


        Calculate the Jk-characteristics of the matrix (the values are signed)

        Parameters
        ----------
        * `jj` :
            Number of columns to use

        Returns
        -------
        Vector with calculated Jk values

        """
        return _oalib.array_link_Jcharacteristics(self, jj)

    def PECsequence(self, verbose=0):
        r"""
        PECsequence(array_link self, int verbose=0) -> doubleVector


        Calculate the projective estimation capacity sequence.

        """
        return _oalib.array_link_PECsequence(self, verbose)

    def PICsequence(self, verbose=0):
        r"""
        PICsequence(array_link self, int verbose=0) -> doubleVector


        Calculate the projective information capacity sequence.

        """
        return _oalib.array_link_PICsequence(self, verbose)

    def rank(self):
        r"""
        rank(array_link self) -> int


        calculate rank of array

        """
        return _oalib.array_link_rank(self)

    def GWLP(self, truncate=1, verbose=0):
        r"""
        GWLP(array_link self, int truncate=1, int verbose=0) -> doubleVector


        Calculate generalized wordlength pattern

        See also: GWLP

        """
        return _oalib.array_link_GWLP(self, truncate, verbose)

    def strength(self):
        r"""
        strength(array_link self) -> int


        calculate strength of an array

        """
        return _oalib.array_link_strength(self)

    def foldover(self):
        r"""
        foldover(array_link self) -> bool


        return true if the array is a foldover array

        """
        return _oalib.array_link_foldover(self)

    def min(self):
        r"""
        min(array_link self) -> array_t


        """
        return _oalib.array_link_min(self)

    def max(self):
        r"""
        max(array_link self) -> array_t


        """
        return _oalib.array_link_max(self)

    def CL2discrepancy(self):
        r"""
        CL2discrepancy(array_link self) -> double


        Calculate centered L2 discrepancy

        The method is from "A connection between uniformity and aberration in regular
        fractions of two-level factorials", Fang and Mukerjee, 2000

        """
        return _oalib.array_link_CL2discrepancy(self)

    def randomperm(self):
        r"""
        randomperm(array_link self) -> array_link


        apply a random permutation of rows, columns and levels of an orthogonal array

        """
        return _oalib.array_link_randomperm(self)

    def randomcolperm(self):
        r"""
        randomcolperm(array_link self) -> array_link


        apply a random permutation of columns of an orthogonal array

        """
        return _oalib.array_link_randomcolperm(self)

    def randomrowperm(self):
        r"""
        randomrowperm(array_link self) -> array_link


        apply a random permutation of rows of an orthogonal array

        """
        return _oalib.array_link_randomrowperm(self)

    def getModelMatrix(self, order, intercept=1, verbose=0):
        r"""
        getModelMatrix(array_link self, int order, int intercept=1, int verbose=0) -> MatrixFloat


        Caculate model matrix of an orthogonal array

        Parameters
        ----------
        * `order` :
            For 0 return only the intercept; for 1 return intercept and main effects;
            for 2 return intercept, main effects and interaction effects.
        * `intercept` :
            If 1, then include the intercept in the output.
        * `verbose` :
            Verbosity level

        Returns
        -------
        Calculated model matrix

        This function uses array2eigenModelMatrixMixed for the calculation.

        """
        return _oalib.array_link_getModelMatrix(self, order, intercept, verbose)

    def deepcopy(self, rhs):
        r"""
        deepcopy(array_link self, array_link rhs) -> array_link


        """
        return _oalib.array_link_deepcopy(self, rhs)

    def shallowcopy(self, rhs):
        r"""
        shallowcopy(array_link self, array_link rhs) -> array_link


        """
        return _oalib.array_link_shallowcopy(self, rhs)

    def __eq__(self, rhs):
        r"""__eq__(array_link self, array_link rhs) -> int"""
        return _oalib.array_link___eq__(self, rhs)

    def __ne__(self, rhs):
        r"""__ne__(array_link self, array_link rhs) -> int"""
        return _oalib.array_link___ne__(self, rhs)

    def __lt__(self, rhs):
        r"""__lt__(array_link self, array_link rhs) -> int"""
        return _oalib.array_link___lt__(self, rhs)

    def __gt__(self, rhs):
        r"""__gt__(array_link self, array_link rhs) -> int"""
        return _oalib.array_link___gt__(self, rhs)

    def equalsize(self, rhs):
        r"""
        equalsize(array_link self, array_link rhs) -> int


        return true of two array have the same dimensions

        """
        return _oalib.array_link_equalsize(self, rhs)

    def __add__(self, *args):
        r"""
        __add__(array_link self, array_link arg2) -> array_link
        __add__(array_link self, array_t value) -> array_link
        """
        return _oalib.array_link___add__(self, *args)

    def __sub__(self, *args):
        r"""
        __sub__(array_link self, array_link arg2) -> array_link
        __sub__(array_link self, array_t value) -> array_link
        """
        return _oalib.array_link___sub__(self, *args)

    def __mul__(self, *args):
        r"""
        __mul__(array_link self, array_link rhs) -> array_link
        __mul__(array_link self, array_t value) -> array_link
        """
        return _oalib.array_link___mul__(self, *args)

    def __imul__(self, value):
        r"""__imul__(array_link self, array_t value) -> array_link"""
        return _oalib.array_link___imul__(self, value)

    def __iadd__(self, value):
        r"""__iadd__(array_link self, array_t value) -> array_link"""
        return _oalib.array_link___iadd__(self, value)

    def __isub__(self, value):
        r"""__isub__(array_link self, array_t value) -> array_link"""
        return _oalib.array_link___isub__(self, value)

    def atfast(self, *args):
        r"""
        atfast(array_link self, rowindex_t const r, colindex_t const c) -> array_t const
        atfast(array_link self, rowindex_t const r, colindex_t const c) -> array_t &


        get element from array, no error checking, inline version

        """
        return _oalib.array_link_atfast(self, *args)

    def _at(self, *args):
        r"""
        _at(array_link self, rowindex_t const arg2, colindex_t const arg3) -> array_t
        _at(array_link self, int const index) -> array_t


        get element at specified position, no bounds checking

        """
        return _oalib.array_link__at(self, *args)

    def at(self, *args):
        r"""
        at(array_link self, rowindex_t const arg2, colindex_t const arg3) -> array_t
        at(array_link self, int const index) -> array_t
        at(array_link self, rowindex_t const arg2, colindex_t const arg3) -> array_t &


        get element at specified position

        """
        return _oalib.array_link_at(self, *args)

    def setconstant(self, value):
        r"""
        setconstant(array_link self, array_t value)


        set all elements in the array to a value

        """
        return _oalib.array_link_setconstant(self, value)

    def setvalue(self, *args):
        r"""
        setvalue(array_link self, int row, int col, int value)
        setvalue(array_link self, int row, int col, double value)


        set value of an array

        """
        return _oalib.array_link_setvalue(self, *args)

    def _setvalue(self, row, col, value):
        r"""
        _setvalue(array_link self, int row, int col, int value)


        set value of an array, no bounds checking!

        """
        return _oalib.array_link__setvalue(self, row, col, value)

    def negateRow(self, row):
        r"""
        negateRow(array_link self, rowindex_t row)


        multiply a row by -1

        """
        return _oalib.array_link_negateRow(self, row)

    def show(self):
        r"""
        show(array_link self)


        print information about array

        """
        return _oalib.array_link_show(self)

    def showstr(self):
        r"""
        showstr(array_link self) -> std::string


        return string describing the array

        """
        return _oalib.array_link_showstr(self)

    def md5(self):
        r"""
        md5(array_link self) -> std::string


        return md5 sum of array representation (as represented with 32bit int datatype
        in memory)

        """
        return _oalib.array_link_md5(self)

    def columnEqual(self, column_index, rhs, column_index_rhs):
        r"""
        columnEqual(array_link self, int column_index, array_link rhs, int column_index_rhs) -> bool


        return true if two columns are equal

        """
        return _oalib.array_link_columnEqual(self, column_index, rhs, column_index_rhs)

    def firstColumnDifference(self, A):
        r"""
        firstColumnDifference(array_link self, array_link A) -> int


        return index of first different column

        """
        return _oalib.array_link_firstColumnDifference(self, A)

    def firstDiff(self, A, r, c, verbose=1):
        r"""
        firstDiff(array_link self, array_link A, int & r, int & c, int verbose=1) -> bool


        Calculate row and column index of first difference between two arrays

        The difference is according to the column-major ordering.

        """
        return _oalib.array_link_firstDiff(self, A, r, c, verbose)

    def create_root(self, arrayclass, fill_value=0):
        r"""
        create_root(array_link self, arraydata_t arrayclass, int fill_value=0)


        create root in arraylink

        """
        return _oalib.array_link_create_root(self, arrayclass, fill_value)

    def nonzero_fraction(self):
        r"""
        nonzero_fraction(array_link self) -> double


        return fraction of nonzero elements in array

        """
        return _oalib.array_link_nonzero_fraction(self)

    def clear(self):
        r"""
        clear(array_link self)


        fill array with zeros

        """
        return _oalib.array_link_clear(self)

    def getarraydata(self, pymat1):
        r"""
        getarraydata(array_link self, int * pymat1)


        """
        return _oalib.array_link_getarraydata(self, pymat1)

    def setarraydata(self, tmp, n):
        r"""
        setarraydata(array_link self, intVector tmp, int n)


        internal function

        """
        return _oalib.array_link_setarraydata(self, tmp, n)

    def setcolumn(self, target_column, source_array, source_column=0):
        r"""
        setcolumn(array_link self, int target_column, array_link source_array, int source_column=0)


        set column to values

        """
        return _oalib.array_link_setcolumn(self, target_column, source_array, source_column)

    def init(self, r, c):
        r"""
        init(array_link self, rowindex_t r, colindex_t c)


        """
        return _oalib.array_link_init(self, r, c)

    def row_symmetry_group(self):
        r"""
        row_symmetry_group(array_link self) -> symmetry_group


        return the row_symmetry group of an array

        """
        return _oalib.array_link_row_symmetry_group(self)

    def reduceLMC(self):
        r"""
        reduceLMC(array_link self) -> array_link


        return the LMC form of the array

        """
        return _oalib.array_link_reduceLMC(self)

    def reduceDOP(self):
        r"""
        reduceDOP(array_link self) -> array_link


        return the delete-one-factor-projection form of the array

        """
        return _oalib.array_link_reduceDOP(self)

    def getEigenMatrix(self):
        r"""
        getEigenMatrix(array_link self) -> MatrixFloat


        return the array as an Eigen matrix

        """
        return _oalib.array_link_getEigenMatrix(self)

    def columnGreater(self, c1, rhs, rhs_column):
        r"""
        columnGreater(array_link self, int c1, array_link rhs, int rhs_column) -> int


        return true of specified column is smaller than column in another array

        """
        return _oalib.array_link_columnGreater(self, c1, rhs, rhs_column)

    def debug(self):
        r"""
        debug(array_link self)


        """
        return _oalib.array_link_debug(self)

    def data(self):
        r"""data(array_link self) -> void *"""
        return _oalib.array_link_data(self)


    def __getattr__(self, attr):
        if attr=='__array_interface__':
          a = dict()
          a['version']=3
          a['shape']=(self.n_rows, self.n_columns)
          sizeofdata=_oalib.sizeof_array_t()
          a['typestr']='<i%d' % sizeofdata # sizeof(array_t)
          a['data']=(self.data(), True)
    # convert from the OAP column-major style to Numpy row-major style
          a['strides']=(sizeofdata, sizeofdata*self.n_rows)
          return a
        else:
          raise AttributeError("%r object has no attribute %r" %
                             (self.__class__, attr))

    @property
    def shape(self):
        return (self.n_rows, self.n_columns)

    @property
    def size(self):
        return self.n_rows*self.n_columns

    def showarray(self):
      """ Show array """
    # overridden to fix problems with ipython
      sys.stdout.write(self.showarrayString())

    def getarray(self, verbose=0, *args):
      """ Return Numpy style array """
      if verbose:
          print('getting array: size %d %d' % (self.n_rows, self.n_columns))
      x=self.getarraydata( int(self.n_rows*self.n_columns) )
      return x.reshape((self.n_columns, self.n_rows)).transpose()

    def setarray(self, X, verbose=0):
      """ Update the array link object with a Numpy array

      Args:
         X (numpy array): array to be copied to the object
      """
      self.init(X.shape[0], X.shape[1])
      self.index=-1
      iv = intVector(X.T.astype(int).flatten().tolist())
      self.setarraydata(iv, X.size)

    def _slice2range(self, slice, max_value):
        """ Convert a python slice object to a range """
        if isinstance(slice, int):
            return [slice]
        if slice.start  is None:
            start = 0
        else:
            start = slice.start
        if slice.stop is None:
            stop = max_value
        else:
            stop = slice.stop
        if slice.step is None:
            step = 1
        else:
            step = slice.step
        return list(range(start, stop, step))

    def _ranges2subarray(self, row_range, col_range):
          """ From a list of row element and a list of column element construct a submatrix """
          al=array_link(len(row_range), len(col_range), array_link.INDEX_DEFAULT )
          for ii, row in enumerate(row_range):
              for jj, col in enumerate(col_range):
                  al[ii, jj]=self.at(row, col)
          return al

    def __getitem__(self, index):
      """ Return element of array """
      if type(index)==int:
          if index<0 or index > self.n_rows*self.n_columns:
            raise IndexError('index out of bounds')
          return self.at(index)
      elif isinstance(index, slice):
          indices=self._slice2range(index, self.n_rows*self.n_columns)
          return np.array( [self.at(a) for a in indices])
      else:
          if len(index)==2:
              index0=index[0]
              index1=index[1]
              if isinstance(index0, int) and isinstance(index1, int):
                if index0<0 or index0 >= self.n_rows:
                  raise IndexError('index out of bounds')
                if index1<0 or index1 >= self.n_columns:
                  raise IndexError('index out of bounds')
                return self.at(index0, index1)
              elif isinstance(index0, int) and isinstance(index1, slice):
                  row_range=[index0]
                  col_range=self._slice2range(index1, self.n_columns)

                  return self._ranges2subarray(row_range, col_range)
              elif isinstance(index0, slice) and isinstance(index1, int):
                  row_range=self._slice2range(index0, self.n_rows)
                  col_range=[index1]

                  return self._ranges2subarray(row_range, col_range)
              elif isinstance(index0, slice) and isinstance(index1, slice):
                  row_range=self._slice2range(index0, self.n_rows)
                  col_range=self._slice2range(index1, self.n_columns)

                  return self._ranges2subarray(row_range, col_range)
              else:
                  raise NotImplementedError('slice indexing not supported')
          else:
            raise IndexError('invalid index')

    def __setitem__(self, index, value):
      """ Set specified value at specified index in the array """
      if type(index)==int:
          if index<0 or index > self.n_rows*self.n_columns:
            raise IndexError('index out of bounds')
          self.setvalue(index, 0, value)
      else:
          if len(index)==2:
            a=index[0]
            b=index[1]
            if a<0 or a >= self.n_rows:
              raise IndexError('index out of bounds')
            if b<0 or b >= self.n_columns:
              raise IndexError('index out of bounds')
            self.setvalue(a, b, value)
          else:
            raise IndexError('invalid index')


    def __repr__(self):
        r"""__repr__(array_link self) -> std::string"""
        return _oalib.array_link___repr__(self)

# Register array_link in _oalib:
_oalib.array_link_swigregister(array_link)


def create_array_link(pymatinput):
    r"""create_array_link(long * pymatinput) -> array_link"""
    return _oalib.create_array_link(pymatinput)

def update_array_link(al, pymatinput):
    r"""update_array_link(array_link al, long * pymatinput)"""
    return _oalib.update_array_link(al, pymatinput)

def compareLMC(lhs, rhs):
    r"""compareLMC(array_link lhs, array_link rhs) -> int"""
    return _oalib.compareLMC(lhs, rhs)

def exampleArray(idx=0, verbose=0):
    r"""exampleArray(int idx=0, int verbose=0) -> array_link"""
    return _oalib.exampleArray(idx, verbose)

def Jcharacteristics_conference(array, number_of_columns, verbose=0):
    r"""Jcharacteristics_conference(array_link array, int number_of_columns, int verbose=0) -> intVector"""
    return _oalib.Jcharacteristics_conference(array, number_of_columns, verbose)

def hstack(*args):
    r"""
    hstack(array_link array1, array_link array2) -> array_link
    hstack(array_link array, charVector column) -> array_link
    """
    return _oalib.hstack(*args)

def hstacklastcol(A, B):
    r"""hstacklastcol(array_link A, array_link B) -> array_link"""
    return _oalib.hstacklastcol(A, B)

def vstack(column_top, column_bottom):
    r"""vstack(charVector column_top, charVector column_bottom) -> charVector"""
    return _oalib.vstack(column_top, column_bottom)

def perform_column_permutation(source, target, perm):
    r"""perform_column_permutation(array_link source, array_link target, intVector perm)"""
    return _oalib.perform_column_permutation(source, target, perm)

def perform_row_permutation(source, target, perm):
    r"""perform_row_permutation(array_link source, array_link target, intVector perm)"""
    return _oalib.perform_row_permutation(source, target, perm)

def arraylink2arraydata(array, extracols=0, strength=2):
    r"""arraylink2arraydata(array_link array, int extracols=0, int strength=2) -> arraydata_t"""
    return _oalib.arraylink2arraydata(array, extracols, strength)

def addConstant(lst, value):
    r"""addConstant(arraylist_t lst, int value) -> arraylist_t"""
    return _oalib.addConstant(lst, value)

def getJcounts(arraylist, N, k, verbose=1):
    r"""getJcounts(arraylist_t arraylist, int N, int k, int verbose=1) -> intVector"""
    return _oalib.getJcounts(arraylist, N, k, verbose)
class jstructbase_t(object):
    r"""


    struct to hold data of an array, e.g. J-characteristic. Abstract base class

    C++ includes: arraytools.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    values = property(_oalib.jstructbase_t_values_get, _oalib.jstructbase_t_values_set, doc=r"""values : std::vector<(int,std::allocator<(int)>)>""")
    jvalues = property(_oalib.jstructbase_t_jvalues_get, _oalib.jstructbase_t_jvalues_set, doc=r"""jvalues : std::vector<(int,std::allocator<(int)>)>""")
    jvalue2index = property(_oalib.jstructbase_t_jvalue2index_get, _oalib.jstructbase_t_jvalue2index_set, doc=r"""jvalue2index : std::map<(int,int,std::less<(int)>,std::allocator<(std::pair<(q(const).int,int)>)>)>""")
    jj = property(_oalib.jstructbase_t_jj_get, _oalib.jstructbase_t_jj_set, doc=r"""jj : int""")

    def maxJ(self):
        r"""
        maxJ(jstructbase_t self) -> int


        calculate maximum J value

        """
        return _oalib.jstructbase_t_maxJ(self)

    def Jvalues(self):
        r"""
        Jvalues(jstructbase_t self) -> intVector


        calculate possible values in F vector

        """
        return _oalib.jstructbase_t_Jvalues(self)

    def calculateF(self):
        r"""
        calculateF(jstructbase_t self) -> intVector


        Calculate histogram of J values

               \return Histogram of J values

               The histogram bins are given by the values of @ref Jvalues.


        """
        return _oalib.jstructbase_t_calculateF(self)

    def calc(self, array):
        r"""
        calc(jstructbase_t self, array_link array)


        Calculate the J-values for a given array.

        """
        return _oalib.jstructbase_t_calc(self, array)

    def show(self):
        r"""
        show(jstructbase_t self)


        Show contents of structure.

        """
        return _oalib.jstructbase_t_show(self)

    def showdata(self, verbose=1):
        r"""
        showdata(jstructbase_t self, int verbose=1)


        """
        return _oalib.jstructbase_t_showdata(self, verbose)

    def showstr(self):
        r"""
        showstr(jstructbase_t self) -> std::string


        """
        return _oalib.jstructbase_t_showstr(self)

    def allzero(self):
        r"""
        allzero(jstructbase_t self) -> int


        return 1 if all vals are zero

        """
        return _oalib.jstructbase_t_allzero(self)
    __swig_destroy__ = _oalib.delete_jstructbase_t

# Register jstructbase_t in _oalib:
_oalib.jstructbase_t_swigregister(jstructbase_t)

class symmdata(object):
    r"""


    structure containing data related to symmetries of arrays

    C++ includes: arraytools.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    rowvalue = property(_oalib.symmdata_rowvalue_get, _oalib.symmdata_rowvalue_set, doc=r"""rowvalue : array_link""")
    orig = property(_oalib.symmdata_orig_get, _oalib.symmdata_orig_set, doc=r"""orig : array_link""")
    ft = property(_oalib.symmdata_ft_get, _oalib.symmdata_ft_set, doc=r"""ft : array_link""")

    def __init__(self, al, minlen=1):
        r"""
        __init__(symmdata self, array_link al, int minlen=1) -> symmdata


        """
        _oalib.symmdata_swiginit(self, _oalib.new_symmdata(al, minlen))

    def show(self, verbose=1):
        r"""
        show(symmdata self, int verbose=1)


        """
        return _oalib.symmdata_show(self, verbose)

    def checkIdx(self, col=-1):
        r"""
        checkIdx(symmdata self, int col=-1) -> intVector


        list with indices set to check for symmetry reductions

        """
        return _oalib.symmdata_checkIdx(self, col)
    __swig_destroy__ = _oalib.delete_symmdata

# Register symmdata in _oalib:
_oalib.symmdata_swigregister(symmdata)

class jstruct_t(object):
    r"""


    struct to hold data of an array, e.g. J-characteristic, rank

    See papers: Minimum G2-aberration properties of two-level foldover designs,
    Butler, 2004 Design Selection and Classification for Hadamard Matrices Using
    Generalized Minimum Aberration Criteria, Deng and Tang

    C++ includes: arraytools.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    N = property(_oalib.jstruct_t_N_get, _oalib.jstruct_t_N_set, doc=r"""N : int""")
    k = property(_oalib.jstruct_t_k_get, _oalib.jstruct_t_k_set, doc=r"""k : int""")
    jj = property(_oalib.jstruct_t_jj_get, _oalib.jstruct_t_jj_set, doc=r"""jj : int""")
    nc = property(_oalib.jstruct_t_nc_get, _oalib.jstruct_t_nc_set, doc=r"""nc : int""")
    values = property(_oalib.jstruct_t_values_get, _oalib.jstruct_t_values_set, doc=r"""values : std::vector<(int,std::allocator<(int)>)>""")
    abberration = property(_oalib.jstruct_t_abberration_get, _oalib.jstruct_t_abberration_set, doc=r"""abberration : double""")

    def __init__(self, *args):
        r"""
        __init__(jstruct_t self) -> jstruct_t
        __init__(jstruct_t self, array_link al, int jj=4) -> jstruct_t
        __init__(jstruct_t self, int const N, int const K, int const jj=4) -> jstruct_t
        __init__(jstruct_t self, jstruct_t js) -> jstruct_t


        Create an object to calculate J-characteristics.

        """
        _oalib.jstruct_t_swiginit(self, _oalib.new_jstruct_t(*args))
    __swig_destroy__ = _oalib.delete_jstruct_t

    def maxJ(self):
        r"""
        maxJ(jstruct_t self) -> int


        calculate maximum J value

        """
        return _oalib.jstruct_t_maxJ(self)

    def number_J_values(self, strength):
        r"""
        number_J_values(jstruct_t self, int strength) -> int


        Calculate the number of possible J values that can occur for the given strength.

        """
        return _oalib.jstruct_t_number_J_values(self, strength)

    def Fval(self, strength=3):
        r"""
        Fval(jstruct_t self, int strength=3) -> intVector


        Calculate possible values in F vector

        Parameters
        ----------
        * `strength` :
            Strength to use

        Returns
        -------
        Vector with possible Jk values (ordered from high to low)

        """
        return _oalib.jstruct_t_Fval(self, strength)

    def calculateF(self, strength=3):
        r"""
        calculateF(jstruct_t self, int strength=3) -> intVector


        calculate histogram of J values for a 2-level array

        """
        return _oalib.jstruct_t_calculateF(self, strength)

    def calculateAberration(self):
        r"""
        calculateAberration(jstruct_t self)


        Calculate aberration value

        This is equal to the sum of the squares of all Jk values, divided by the number
        of rows squared.

        The calculated abberation is stored in the variable abberation.

        """
        return _oalib.jstruct_t_calculateAberration(self)

    def show(self):
        r"""
        show(jstruct_t self)


        Show contents of structure.

        """
        return _oalib.jstruct_t_show(self)

    def showdata(self):
        r"""
        showdata(jstruct_t self)


        """
        return _oalib.jstruct_t_showdata(self)

    def showstr(self):
        r"""
        showstr(jstruct_t self) -> std::string


        """
        return _oalib.jstruct_t_showstr(self)

    def allzero(self):
        r"""
        allzero(jstruct_t self) -> int


        return 1 if all J values are zero, otherwise return 0

        """
        return _oalib.jstruct_t_allzero(self)

    def __repr__(self):
        r"""__repr__(jstruct_t self) -> std::string"""
        return _oalib.jstruct_t___repr__(self)

# Register jstruct_t in _oalib:
_oalib.jstruct_t_swigregister(jstruct_t)

class jstructconference_t(jstructbase_t):
    r"""


    Calculate J-characteristics of conference designs

    C++ includes: arraytools.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(jstructconference_t self, int N, int jj=4) -> jstructconference_t
        __init__(jstructconference_t self, array_link array, int jj=4) -> jstructconference_t


        Calculate J-characteristics of a conference design

        Parameters
        ----------
        * `array` :
            Array to calculate the J-characteristics for
        * `jj` :
            Number of columns to use for the Jk-characteristics

        """
        _oalib.jstructconference_t_swiginit(self, _oalib.new_jstructconference_t(*args))
    __swig_destroy__ = _oalib.delete_jstructconference_t

# Register jstructconference_t in _oalib:
_oalib.jstructconference_t_swigregister(jstructconference_t)


def create_root(*args):
    r"""
    create_root(array_t * array, arraydata_t arrayclass)
    create_root(arraydata_t arrayclass, arraylist_t solutions)
    """
    return _oalib.create_root(*args)

def array_diff(A, B, r, c, rpos, cpos):
    r"""array_diff(carray_p A, carray_p B, rowindex_t const r, colindex_t const c, rowindex_t & rpos, colindex_t & cpos) -> int"""
    return _oalib.array_diff(A, B, r, c, rpos, cpos)

def fastJupdate(array, N, J, column_indices, tmp):
    r"""fastJupdate(array_t const * array, rowindex_t N, int const J, colindex_t const * column_indices, array_t * tmp)"""
    return _oalib.fastJupdate(array, N, J, column_indices, tmp)

def jvalue(array, J, column_indices):
    r"""jvalue(array_link array, int const J, int const * column_indices) -> int"""
    return _oalib.jvalue(array, J, column_indices)

def jvaluefast(array, N, J, column_indices):
    r"""jvaluefast(array_t const * array, rowindex_t N, int const J, colindex_t const * column_indices) -> int"""
    return _oalib.jvaluefast(array, N, J, column_indices)

def analyseArrays(arraylist, verbose, jj=4):
    r"""analyseArrays(arraylist_t arraylist, int const verbose, int const jj=4) -> jstructArray"""
    return _oalib.analyseArrays(arraylist, verbose, jj)
class array_transformation_t(object):
    r"""


    Contains a transformation of an array.

    Contains an array transformation. The transformation consists of column, row and
    level permutations. The level and column permutations are not commutative (since
    the level permutations are tied to a particular column). We apply the column
    permutations first.

    C++ includes: arraytools.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    rperm = property(_oalib.array_transformation_t_rperm_get, _oalib.array_transformation_t_rperm_set, doc=r"""rperm : rowperm_t""")
    cperm = property(_oalib.array_transformation_t_cperm_get, _oalib.array_transformation_t_cperm_set, doc=r"""cperm : colperm_t""")
    lperms = property(_oalib.array_transformation_t_lperms_get, _oalib.array_transformation_t_lperms_set, doc=r"""lperms : p.levelperm_t""")
    ad = property(_oalib.array_transformation_t_ad_get, _oalib.array_transformation_t_ad_set, doc=r"""ad : p.q(const).arraydata_t""")

    def __init__(self, *args):
        r"""
        __init__(array_transformation_t self, arraydata_t arrayclass) -> array_transformation_t
        __init__(array_transformation_t self, arraydata_t arrayclass) -> array_transformation_t
        __init__(array_transformation_t self) -> array_transformation_t
        __init__(array_transformation_t self, array_transformation_t transformation) -> array_transformation_t


        copy constructor

        """
        _oalib.array_transformation_t_swiginit(self, _oalib.new_array_transformation_t(*args))
    __swig_destroy__ = _oalib.delete_array_transformation_t

    def isIdentity(self):
        r"""
        isIdentity(array_transformation_t self) -> bool


        return true if the transformation is equal to the identity

        """
        return _oalib.array_transformation_t_isIdentity(self)

    def inverse(self):
        r"""
        inverse(array_transformation_t self) -> array_transformation_t


        return the inverse transformation

        """
        return _oalib.array_transformation_t_inverse(self)

    def reset(self):
        r"""
        reset(array_transformation_t self)


        return the transformation to the identity transformation

        """
        return _oalib.array_transformation_t_reset(self)

    def randomize(self):
        r"""
        randomize(array_transformation_t self)


        initialize to a random transformation

        """
        return _oalib.array_transformation_t_randomize(self)

    def randomizecolperm(self):
        r"""
        randomizecolperm(array_transformation_t self)


        initialize with a random column permutation

        """
        return _oalib.array_transformation_t_randomizecolperm(self)

    def randomizerowperm(self):
        r"""
        randomizerowperm(array_transformation_t self)


        initialize with a random row permutation

        """
        return _oalib.array_transformation_t_randomizerowperm(self)

    def __eq__(self, t2):
        r"""__eq__(array_transformation_t self, array_transformation_t t2) -> int"""
        return _oalib.array_transformation_t___eq__(self, t2)

    def __mul__(self, b):
        r"""__mul__(array_transformation_t self, array_transformation_t b) -> array_transformation_t"""
        return _oalib.array_transformation_t___mul__(self, b)

    def apply(self, *args):
        r"""
        apply(array_transformation_t self, array_link array) -> array_link
        apply(array_transformation_t self, array_t * sourcetarget)
        apply(array_transformation_t self, array_t const * source, array_t * target)


        apply transformation to an array

        """
        return _oalib.array_transformation_t_apply(self, *args)

    def print_transformed(self, source):
        r"""
        print_transformed(array_transformation_t self, carray_t * source)


        apply transformation and show resulting array

        """
        return _oalib.array_transformation_t_print_transformed(self, source)

    def show(self, *args):
        r"""
        show(array_transformation_t self)
        show(array_transformation_t self, std::ostream & out)


        """
        return _oalib.array_transformation_t_show(self, *args)

    def rowperm(self):
        r"""
        rowperm(array_transformation_t self) -> intVector


        return the row permutation of the transformation

        """
        return _oalib.array_transformation_t_rowperm(self)

    def colperm(self):
        r"""
        colperm(array_transformation_t self) -> intVector


        return the column permutation of the transformation

        """
        return _oalib.array_transformation_t_colperm(self)

    def lvlperm(self, c):
        r"""
        lvlperm(array_transformation_t self, int c) -> intVector


        return the level permutations of the transformation

        """
        return _oalib.array_transformation_t_lvlperm(self, c)

    def setrowperm(self, row_permutation):
        r"""
        setrowperm(array_transformation_t self, intVector row_permutation)


        set the row permutation of the transformation

        """
        return _oalib.array_transformation_t_setrowperm(self, row_permutation)

    def setcolperm(self, column_permutation):
        r"""
        setcolperm(array_transformation_t self, intVector column_permutation)


        set the column permutation of the transformation

        """
        return _oalib.array_transformation_t_setcolperm(self, column_permutation)

    def setlevelperm(self, column_index, lvl_permutation):
        r"""
        setlevelperm(array_transformation_t self, int column_index, intVector lvl_permutation)


        set the level permutation of the transformation

        """
        return _oalib.array_transformation_t_setlevelperm(self, column_index, lvl_permutation)

    def __repr__(self):
        r"""__repr__(array_transformation_t self) -> std::string"""
        return _oalib.array_transformation_t___repr__(self)

# Register array_transformation_t in _oalib:
_oalib.array_transformation_t_swigregister(array_transformation_t)

class conference_transformation_t(object):
    r"""


    Contains a transformation of a conference matrix.

    Contains an array transformation. The transformation consists of column
    permutations, row permutations and sign switches for both the rows and columns.

    The sign switches and the permutations are not commutative. We apply the
    permutations first and then the sign flips.

    C++ includes: arraytools.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    rperm = property(_oalib.conference_transformation_t_rperm_get, _oalib.conference_transformation_t_rperm_set, doc=r"""rperm : std::vector<(int,std::allocator<(int)>)>""")
    cperm = property(_oalib.conference_transformation_t_cperm_get, _oalib.conference_transformation_t_cperm_set, doc=r"""cperm : std::vector<(int,std::allocator<(int)>)>""")
    cswitch = property(_oalib.conference_transformation_t_cswitch_get, _oalib.conference_transformation_t_cswitch_set, doc=r"""cswitch : std::vector<(int,std::allocator<(int)>)>""")
    rswitch = property(_oalib.conference_transformation_t_rswitch_get, _oalib.conference_transformation_t_rswitch_set, doc=r"""rswitch : std::vector<(int,std::allocator<(int)>)>""")
    nrows = property(_oalib.conference_transformation_t_nrows_get, _oalib.conference_transformation_t_nrows_set, doc=r"""nrows : int""")
    ncols = property(_oalib.conference_transformation_t_ncols_get, _oalib.conference_transformation_t_ncols_set, doc=r"""ncols : int""")

    def __init__(self, *args):
        r"""
        __init__(conference_transformation_t self) -> conference_transformation_t
        __init__(conference_transformation_t self, int nrows, int ncols) -> conference_transformation_t
        __init__(conference_transformation_t self, array_link al) -> conference_transformation_t
        __init__(conference_transformation_t self, conference_transformation_t T) -> conference_transformation_t


        """
        _oalib.conference_transformation_t_swiginit(self, _oalib.new_conference_transformation_t(*args))

    def show(self, verbose=1):
        r"""
        show(conference_transformation_t self, int verbose=1)


        show the array transformation

        """
        return _oalib.conference_transformation_t_show(self, verbose)

    def isIdentity(self):
        r"""
        isIdentity(conference_transformation_t self) -> bool


        return true if the transformation is equal to the identity

        """
        return _oalib.conference_transformation_t_isIdentity(self)

    def inverse(self):
        r"""
        inverse(conference_transformation_t self) -> conference_transformation_t


        return the inverse transformation

        """
        return _oalib.conference_transformation_t_inverse(self)

    def reset(self):
        r"""
        reset(conference_transformation_t self)


        return the transformation to the identity transformation

        """
        return _oalib.conference_transformation_t_reset(self)

    def randomize(self):
        r"""
        randomize(conference_transformation_t self)


        initialize to a random transformation

        """
        return _oalib.conference_transformation_t_randomize(self)

    def randomizecolperm(self):
        r"""
        randomizecolperm(conference_transformation_t self)


        initialize with a random column permutation

        """
        return _oalib.conference_transformation_t_randomizecolperm(self)

    def randomizerowperm(self):
        r"""
        randomizerowperm(conference_transformation_t self)


        initialize with a random row permutation

        """
        return _oalib.conference_transformation_t_randomizerowperm(self)

    def randomizecolflips(self):
        r"""
        randomizecolflips(conference_transformation_t self)


        initialize with random col switches

        """
        return _oalib.conference_transformation_t_randomizecolflips(self)

    def randomizerowflips(self):
        r"""
        randomizerowflips(conference_transformation_t self)


        initialize with random row switches

        """
        return _oalib.conference_transformation_t_randomizerowflips(self)

    def apply(self, al):
        r"""
        apply(conference_transformation_t self, array_link al) -> array_link


        apply transformation to an array_link object

        """
        return _oalib.conference_transformation_t_apply(self, al)

    def __eq__(self, rhs):
        r"""__eq__(conference_transformation_t self, conference_transformation_t rhs) -> int"""
        return _oalib.conference_transformation_t___eq__(self, rhs)

    def __mul__(self, rhs):
        r"""__mul__(conference_transformation_t self, conference_transformation_t rhs) -> conference_transformation_t"""
        return _oalib.conference_transformation_t___mul__(self, rhs)

    def setrowperm(self, rp):
        r"""
        setrowperm(conference_transformation_t self, intVector rp)


        """
        return _oalib.conference_transformation_t_setrowperm(self, rp)

    def setcolperm(self, cp):
        r"""
        setcolperm(conference_transformation_t self, intVector cp)


        """
        return _oalib.conference_transformation_t_setcolperm(self, cp)
    __swig_destroy__ = _oalib.delete_conference_transformation_t

# Register conference_transformation_t in _oalib:
_oalib.conference_transformation_t_swigregister(conference_transformation_t)


def showArrayList(lst):
    r"""showArrayList(arraylist_t lst)"""
    return _oalib.showArrayList(lst)
ATEXT = _oalib.ATEXT
r""" text based format"""
ALATEX = _oalib.ALATEX
r""" write arrays to a text file in a format that can be parsed by LaTeX"""
ABINARY = _oalib.ABINARY
r""" binary format"""
ABINARY_DIFF = _oalib.ABINARY_DIFF
r""" binary format storing differences of arrays"""
ABINARY_DIFFZERO = _oalib.ABINARY_DIFFZERO
r""" binary format storing differences of arrays and zero offsets"""
AERROR = _oalib.AERROR

A_AUTOMATIC = _oalib.A_AUTOMATIC
r""" automatically determine the format"""
A_AUTOMATIC_BINARY = _oalib.A_AUTOMATIC_BINARY
r""" automatically determine the format (but binary)"""
READ = _oalib.READ

WRITE = _oalib.WRITE

READWRITE = _oalib.READWRITE

class arrayfile_t(object):
    r"""


    Structure for reading or writing a file with arrays.

    The format of the file is determined by the `arrayfilemode_t` The format
    described in detail in the documentation of the OApackage
    https://oapackage.readthedocs.io/en/latest/.

    C++ includes: arraytools.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    filename = property(_oalib.arrayfile_t_filename_get, _oalib.arrayfile_t_filename_set, doc=r"""filename : std::string""")
    iscompressed = property(_oalib.arrayfile_t_iscompressed_get, _oalib.arrayfile_t_iscompressed_set, doc=r"""iscompressed : int""")
    nrows = property(_oalib.arrayfile_t_nrows_get, _oalib.arrayfile_t_nrows_set, doc=r"""nrows : int""")
    ncols = property(_oalib.arrayfile_t_ncols_get, _oalib.arrayfile_t_ncols_set, doc=r"""ncols : int""")
    nbits = property(_oalib.arrayfile_t_nbits_get, _oalib.arrayfile_t_nbits_set, doc=r"""nbits : int""")
    mode = property(_oalib.arrayfile_t_mode_get, _oalib.arrayfile_t_mode_set, doc=r"""mode : arrayfile::arrayfilemode_t""")
    rwmode = property(_oalib.arrayfile_t_rwmode_get, _oalib.arrayfile_t_rwmode_set, doc=r"""rwmode : arrayfile::afilerw_t""")
    narrays = property(_oalib.arrayfile_t_narrays_get, _oalib.arrayfile_t_narrays_set, doc=r"""narrays : int""")
    narraycounter = property(_oalib.arrayfile_t_narraycounter_get, _oalib.arrayfile_t_narraycounter_set, doc=r"""narraycounter : int""")
    NARRAYS_MAX = _oalib.arrayfile_t_NARRAYS_MAX
    r""" maximum number of arrays in structure"""

    def __init__(self, *args):
        r"""
        __init__(arrayfile_t self) -> arrayfile_t
        __init__(arrayfile_t self, std::string const filename, int verbose=1) -> arrayfile_t
        __init__(arrayfile_t self, std::string const filename, int nrows, int ncols, int narrays=-1, arrayfile::arrayfilemode_t mode=ATEXT, int number_of_bits=8) -> arrayfile_t


        Structure for reading or writing a file with arrays

        Open new array file for writing

        Parameters
        ----------
        * `filename` :
            File to open
        * `nrows` :
            Number of rows
        * `ncols` :
            Number of columns
        * `narrays` :
            Specify a number of arrays, or -1 to add dynamically
        * `mode` :
            File mode
        * `number_of_bits` :
            Number of bits to use for storage. For 2-level arrays only 1 bit is needed

        """
        _oalib.arrayfile_t_swiginit(self, _oalib.new_arrayfile_t(*args))
    __swig_destroy__ = _oalib.delete_arrayfile_t

    def createfile(self, *args):
        r"""
        createfile(arrayfile_t self, std::string const filename, int nrows, int ncols, int narrays=-1, arrayfile::arrayfilemode_t m=ATEXT, int number_of_bits=8)


        Open a new file for writing and (if opened) close the current file.

        """
        return _oalib.arrayfile_t_createfile(self, *args)

    def closefile(self):
        r"""
        closefile(arrayfile_t self)


        close the array file

        """
        return _oalib.arrayfile_t_closefile(self)

    def isopen(self):
        r"""
        isopen(arrayfile_t self) -> int


        return true if file is open

        """
        return _oalib.arrayfile_t_isopen(self)

    def seek(self, pos):
        r"""
        seek(arrayfile_t self, int pos) -> int


        seek to specified array position

        """
        return _oalib.arrayfile_t_seek(self, pos)

    def readnext(self):
        r"""
        readnext(arrayfile_t self) -> array_link


        read next array from the file

        """
        return _oalib.arrayfile_t_readnext(self)

    def readarrays(self, *args):
        r"""
        readarrays(arrayfile_t self, int nmax=NARRAYS_MAX, int verbose=1) -> arraylist_t


        read set of array from the file

        """
        return _oalib.arrayfile_t_readarrays(self, *args)

    def flush(self):
        r"""
        flush(arrayfile_t self)


        flush any open file pointer

        """
        return _oalib.arrayfile_t_flush(self)

    def isbinary(self):
        r"""
        isbinary(arrayfile_t self) -> bool


        return true if the file has binary format

        """
        return _oalib.arrayfile_t_isbinary(self)

    def append_arrays(self, arrays, startidx=-1):
        r"""
        append_arrays(arrayfile_t self, arraylist_t arrays, int startidx=-1) -> int


        append list of arrays to the file

        """
        return _oalib.arrayfile_t_append_arrays(self, arrays, startidx)

    def append_array(self, a, specialindex=-1):
        r"""
        append_array(arrayfile_t self, array_link a, int specialindex=-1)


        append a single array to the file

        """
        return _oalib.arrayfile_t_append_array(self, a, specialindex)

    def add_comment(self, comment):
        r"""
        add_comment(arrayfile_t self, std::string const & comment)


        Add a comment to an array file (only available in text mode)

        """
        return _oalib.arrayfile_t_add_comment(self, comment)

    def swigcheck(self):
        r"""
        swigcheck(arrayfile_t self) -> int


        return True if code is wrapped by SWIG

        """
        return _oalib.arrayfile_t_swigcheck(self)

    def showstr(self):
        r"""
        showstr(arrayfile_t self) -> std::string


        return string describing the object

        """
        return _oalib.arrayfile_t_showstr(self)

    def pos(self):
        r"""
        pos(arrayfile_t self) -> size_t


        return current position in file

        """
        return _oalib.arrayfile_t_pos(self)

    def hasrandomaccess(self):
        r"""
        hasrandomaccess(arrayfile_t self) -> bool


        return true of the file format has random access mode

        """
        return _oalib.arrayfile_t_hasrandomaccess(self)
    nfid = property(_oalib.arrayfile_t_nfid_get, _oalib.arrayfile_t_nfid_set, doc=r"""nfid : p.FILE""")
    gzfid = property(_oalib.arrayfile_t_gzfid_get, _oalib.arrayfile_t_gzfid_set, doc=r"""gzfid : int""")
    verbose = property(_oalib.arrayfile_t_verbose_get, _oalib.arrayfile_t_verbose_set, doc=r"""verbose : int""")

    def updatenumbers(self):
        r"""
        updatenumbers(arrayfile_t self)


        """
        return _oalib.arrayfile_t_updatenumbers(self)

    def read_array(self, *args):
        r"""
        read_array(arrayfile_t self, array_link a) -> int
        read_array(arrayfile_t self, array_t * array, int const nrows, int const ncols) -> int


        read array and return index

        """
        return _oalib.arrayfile_t_read_array(self, *args)

    def finisharrayfile(self):
        r"""
        finisharrayfile(arrayfile_t self)


        """
        return _oalib.arrayfile_t_finisharrayfile(self)

    def setVerbose(self, v):
        r"""
        setVerbose(arrayfile_t self, int v)


        set verbosity level

        """
        return _oalib.arrayfile_t_setVerbose(self, v)

    def getnbits(self):
        r"""
        getnbits(arrayfile_t self) -> int


        """
        return _oalib.arrayfile_t_getnbits(self)

    @staticmethod
    def parseModeString(format):
        r"""
        parseModeString(std::string const format) -> arrayfile::arrayfilemode_t


        parse string to determine the file mode

        """
        return _oalib.arrayfile_t_parseModeString(format)

    @staticmethod
    def arrayNbits(*args):
        r"""
        arrayNbits(arraydata_t ad) -> int
        arrayNbits(array_link A) -> int


        return number of bits necessary to store an array

        """
        return _oalib.arrayfile_t_arrayNbits(*args)

    def __repr__(self):
        r"""__repr__(arrayfile_t self) -> std::string"""
        return _oalib.arrayfile_t___repr__(self)

# Register arrayfile_t in _oalib:
_oalib.arrayfile_t_swigregister(arrayfile_t)

def arrayfile_t_parseModeString(format):
    r"""
    arrayfile_t_parseModeString(std::string const format) -> arrayfile::arrayfilemode_t


    parse string to determine the file mode

    """
    return _oalib.arrayfile_t_parseModeString(format)

def arrayfile_t_arrayNbits(*args):
    r"""
    arrayfile_t_arrayNbits(arraydata_t ad) -> int
    arrayfile_t_arrayNbits(array_link A) -> int


    return number of bits necessary to store an array

    """
    return _oalib.arrayfile_t_arrayNbits(*args)


def nArrays(fname):
    r"""nArrays(char const * fname) -> long"""
    return _oalib.nArrays(fname)

def arrayfileinfo(filename, number_of_arrays, number_of_rows, number_of_columns):
    r"""arrayfileinfo(char const * filename, int & number_of_arrays, int & number_of_rows, int & number_of_columns)"""
    return _oalib.arrayfileinfo(filename, number_of_arrays, number_of_rows, number_of_columns)

def readarrayfile(*args):
    r"""
    readarrayfile(char const * fname, int verbose=0, int * setcols=None) -> arraylist_t
    readarrayfile(char const * filename, arraylist_t arraylist, int verbose=1, int * setcols=None, int * setrows=None, int * setbits=None) -> int
    """
    return _oalib.readarrayfile(*args)

def writearrayfile(*args):
    r"""
    writearrayfile(char const * filename, arraylist_t arraylist, arrayfile::arrayfilemode_t mode=ATEXT, int nrows=NRAUTO, int ncols=NRAUTO) -> int
    writearrayfile(char const * filename, array_link array, arrayfile::arrayfilemode_t mode=ATEXT) -> int
    """
    return _oalib.writearrayfile(*args)

def append_arrayfile(filename, array):
    r"""append_arrayfile(char const * filename, array_link array) -> int"""
    return _oalib.append_arrayfile(filename, array)

def selectArrays(*args):
    r"""
    selectArrays(std::string const filename, intVector idx, arraylist_t fl, int verbose=0)
    selectArrays(std::string filename, int index) -> array_link
    selectArrays(arraylist_t input_list, intVector idx) -> arraylist_t
    selectArrays(arraylist_t input_list, longVector idx) -> arraylist_t
    selectArrays(arraylist_t input_list, intVector idx, arraylist_t output_list)
    selectArrays(arraylist_t input_list, longVector idx, arraylist_t output_list)
    """
    return _oalib.selectArrays(*args)

def appendArrays(arrays_to_append, dst):
    r"""appendArrays(arraylist_t arrays_to_append, arraylist_t dst)"""
    return _oalib.appendArrays(arrays_to_append, dst)

def convert_array_file(input_filename, output_filename, output_format, verbose=0):
    r"""convert_array_file(std::string input_filename, std::string output_filename, arrayfile::arrayfilemode_t output_format, int verbose=0)"""
    return _oalib.convert_array_file(input_filename, output_filename, output_format, verbose)
class arraywriter_t(object):
    r"""


    structure to write arrays to disk, thread safe

    C++ includes: arraytools.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    afiles = property(_oalib.arraywriter_t_afiles_get, _oalib.arraywriter_t_afiles_set, doc=r"""afiles : std::vector<(p.arrayfile::arrayfile_t,std::allocator<(p.arrayfile::arrayfile_t)>)>""")
    writearrays = property(_oalib.arraywriter_t_writearrays_get, _oalib.arraywriter_t_writearrays_set, doc=r"""writearrays : bool""")
    nwritten = property(_oalib.arraywriter_t_nwritten_get, _oalib.arraywriter_t_nwritten_set, doc=r"""nwritten : int""")
    verbose = property(_oalib.arraywriter_t_verbose_get, _oalib.arraywriter_t_verbose_set, doc=r"""verbose : int""")

    def __init__(self):
        r"""
        __init__(arraywriter_t self) -> arraywriter_t


        """
        _oalib.arraywriter_t_swiginit(self, _oalib.new_arraywriter_t())
    __swig_destroy__ = _oalib.delete_arraywriter_t

    def flush(self):
        r"""
        flush(arraywriter_t self)


        flush all output files

        """
        return _oalib.arraywriter_t_flush(self)

    def writeArray(self, *args):
        r"""
        writeArray(arraywriter_t self, array_link A)
        writeArray(arraywriter_t self, arraylist_t lst)


        write a list of arrays to disk

        """
        return _oalib.arraywriter_t_writeArray(self, *args)

    def initArrayFiles(self, *args):
        r"""
        initArrayFiles(arraywriter_t self, arraydata_t ad, int kstart, std::string const prefix, arrayfile::arrayfilemode_t mode=ABINARY_DIFF)


        initialize the result files

        """
        return _oalib.arraywriter_t_initArrayFiles(self, *args)

    def nArraysWritten(self):
        r"""
        nArraysWritten(arraywriter_t self) -> int


        return the total number arrays written to disk

        """
        return _oalib.arraywriter_t_nArraysWritten(self)

    def closeafiles(self):
        r"""
        closeafiles(arraywriter_t self)


        """
        return _oalib.arraywriter_t_closeafiles(self)

# Register arraywriter_t in _oalib:
_oalib.arraywriter_t_swigregister(arraywriter_t)
cvar = _oalib.cvar
NRAUTO = cvar.NRAUTO


def readbinheader(fid, nr, nc):
    r"""readbinheader(FILE * fid, int & nr, int & nc) -> bool"""
    return _oalib.readbinheader(fid, nr, nc)

def writebinheader(fid, number_rows, number_columns):
    r"""writebinheader(FILE * fid, int number_rows, int number_columns)"""
    return _oalib.writebinheader(fid, number_rows, number_columns)

def vectorvector2binfile(fname, vals, writeheader, na):
    r"""vectorvector2binfile(std::string const fname, vector_vector_double vals, int writeheader, int na)"""
    return _oalib.vectorvector2binfile(fname, vals, writeheader, na)

def array2eigenX1(array, intercept=1):
    r"""array2eigenX1(array_link array, int intercept=1) -> MatrixFloat"""
    return _oalib.array2eigenX1(array, intercept)

def array2eigenX2(array):
    r"""array2eigenX2(array_link array) -> MatrixFloat"""
    return _oalib.array2eigenX2(array)

def array2eigenModelMatrix(array):
    r"""array2eigenModelMatrix(array_link array) -> MatrixFloat"""
    return _oalib.array2eigenModelMatrix(array)

def array2eigenModelMatrixMixed(array, verbose=1):
    r"""array2eigenModelMatrixMixed(array_link array, int verbose=1) -> pairEigenMatrix"""
    return _oalib.array2eigenModelMatrixMixed(array, verbose)

def numberModelParams(array, order=-1):
    r"""numberModelParams(array_link array, int order=-1) -> intVector"""
    return _oalib.numberModelParams(array, order)

def arrayInFile(array, array_file, verbose=1):
    r"""arrayInFile(array_link array, char const * array_file, int verbose=1) -> int"""
    return _oalib.arrayInFile(array, array_file, verbose)

def arrayInList(array, arrays, verbose=1):
    r"""arrayInList(array_link array, arraylist_t arrays, int verbose=1) -> int"""
    return _oalib.arrayInList(array, arrays, verbose)

def printfd_handler(*args):
    r"""
    printfd_handler(char const * file, char const * func, int line, char const * message)


    function to print debugging messages

    """
    return _oalib.printfd_handler(*args)
LOGERROR = _oalib.LOGERROR

SYSTEM = _oalib.SYSTEM

QUIET = _oalib.QUIET

NORMAL = _oalib.NORMAL

DEBUG = _oalib.DEBUG

EXTRADEBUG = _oalib.EXTRADEBUG


def log_print(*args):
    r"""
    log_print(int const level, char const * message) -> int


    """
    return _oalib.log_print(*args)

def getloglevel():
    r"""
    getloglevel() -> int


    return current level of logging

    """
    return _oalib.getloglevel()

def setloglevel(n):
    r"""
    setloglevel(int n)


    reset the level of logging

    """
    return _oalib.setloglevel(n)

def checkloglevel(level):
    r"""
    checkloglevel(int level) -> bool


    return True if the current logging level is smaller or equal than the specified
    level

    """
    return _oalib.checkloglevel(level)

def system_uname():
    r"""
    system_uname() -> std::string


    Return string describing the system.

    """
    return _oalib.system_uname()

def path_separator():
    r"""
    path_separator() -> char


    return path separator symbol for the current platform

    """
    return _oalib.path_separator()

def mycheck_handler(*args):
    r"""
    mycheck_handler(char const * file, char const * func, int line, int condition, char const * error_message)


    handler for error messages. throws an std::runtime_error exception

    """
    return _oalib.mycheck_handler(*args)

def myassert(condition, error_message):
    r"""
    myassert(int condition, char const * error_message)


    Check whether the condition is true and throw an expception otherwise.

    """
    return _oalib.myassert(condition, error_message)

def cprintf(*args):
    r"""
    cprintf(int check, char const * message) -> int


    conditional printf

    """
    return _oalib.cprintf(*args)

def flush_stdout():
    r"""
    flush_stdout()


    flush to stdout

    """
    return _oalib.flush_stdout()

def next_comb_s(comb, k, n):
    r"""
    next_comb_s(int * comb, int k, int n) -> int


    Go to next combination in sequence

    """
    return _oalib.next_comb_s(comb, k, n)

def print_array(*args):
    r"""
    print_array(char const * str, array_t const * array, int const nrows, int const ncols)
    print_array(array_t const * array, rowindex_t const nrows, colindex_t const ncols)


    """
    return _oalib.print_array(*args)

def get_time_ms(*args):
    r"""
    get_time_ms() -> double
    get_time_ms(double t0) -> double


    return time difference with milisecond precision

    """
    return _oalib.get_time_ms(*args)

def trim(*args):
    r"""
    trim(std::string & str, std::string const & trimChars="")


    trim a string by removing the specified characters from the left and right

    """
    return _oalib.trim(*args)

def currenttime():
    r"""
    currenttime() -> std::string


    return the current time as a string

    """
    return _oalib.currenttime()

def oafilestring(arrayclass):
    r"""
    oafilestring(arraydata_t arrayclass) -> std::string


    return string describing array

    """
    return _oalib.oafilestring(arrayclass)

def replaceString(subject, search, replacement):
    r"""
    replaceString(std::string subject, std::string const & search, std::string const & replacement) -> std::string


    replace all occurces of a substring in a string

    """
    return _oalib.replaceString(subject, search, replacement)

def printdoubleasbits(double_value, add_newline=True):
    r"""
    printdoubleasbits(double double_value, bool add_newline=True)


    print a double value as bits

    """
    return _oalib.printdoubleasbits(double_value, add_newline)

def splitDir(tag_indices):
    r"""
    splitDir(intVector tag_indices) -> std::string


    calculate directory name for job splitted into parts

    """
    return _oalib.splitDir(tag_indices)

def splitFile(tag_indices):
    r"""
    splitFile(intVector tag_indices) -> std::string


    calculate file name of job splitted into parts

    """
    return _oalib.splitFile(tag_indices)

def splitTag(tag_indices):
    r"""
    splitTag(intVector tag_indices) -> std::string


    calculate tag for job splitted into parts

    """
    return _oalib.splitTag(tag_indices)

def DAEefficiencyWithSVD(secondorder_interaction_matrix, Deff, vif, Eeff, rank, verbose):
    r"""
    DAEefficiencyWithSVD(Eigen::MatrixXd const & secondorder_interaction_matrix, double & Deff, double & vif, double & Eeff, int & rank, int verbose)


    Calculate D-efficiency and VIF-efficiency and E-efficiency values using SVD.

    """
    return _oalib.DAEefficiencyWithSVD(secondorder_interaction_matrix, Deff, vif, Eeff, rank, verbose)

def array2rank_Deff_Beff(al, ret=None, verbose=0):
    r"""
    array2rank_Deff_Beff(array_link al, doubleVector ret=None, int verbose=0) -> int


    Calculate the rank of the second order interaction matrix of an orthogonal array

    The model is the intercept, main effects and interaction effects The rank,
    D-efficiency, VIF-efficiency and E-efficiency are appended to the second
    argument

    The return vector is filled with the rank, Defficiency, VIF efficiency and
    Eefficiency

    """
    return _oalib.array2rank_Deff_Beff(al, ret, verbose)

def Defficiency(orthogonal_array, verbose=0):
    r"""
    Defficiency(array_link orthogonal_array, int verbose=0) -> double


    Calculate D-efficiency for a 2-level array using symmetric eigenvalue
    decomposition.

    """
    return _oalib.Defficiency(orthogonal_array, verbose)

def Defficiencies(array, arrayclass, verbose=0, addDs0=0):
    r"""
    Defficiencies(array_link array, arraydata_t arrayclass, int verbose=0, int addDs0=0) -> doubleVector


    Calculate efficiencies for an array

    Parameters
    ----------
    * `array` :
        Array to use in calculation
    * `arrayclass` :
        Specification of the array class
    * `verbose` :
        Verbosity level
    * `addDs0` :
        If True, then add the Ds0-efficiency to the output

    Returns
    -------
    Vector with the calculate D-efficiency, the main effect robustness (or Ds-
    optimality) and D1-efficiency for an orthogonal array

    """
    return _oalib.Defficiencies(array, arrayclass, verbose, addDs0)

def VIFefficiency(orthogonal_array, verbose=0):
    r"""
    VIFefficiency(array_link orthogonal_array, int verbose=0) -> double


    Calculate VIF-efficiency of matrix.

    """
    return _oalib.VIFefficiency(orthogonal_array, verbose)

def Aefficiency(orthogonal_array, verbose=0):
    r"""
    Aefficiency(array_link orthogonal_array, int verbose=0) -> double


    Calculate A-efficiency of matrix.

    """
    return _oalib.Aefficiency(orthogonal_array, verbose)

def Eefficiency(orthogonal_array, verbose=0):
    r"""
    Eefficiency(array_link orthogonal_array, int verbose=0) -> double


    Calculate E-efficiency of matrix (1 over the VIF-efficiency)

    """
    return _oalib.Eefficiency(orthogonal_array, verbose)

def Aefficiencies(orthogonal_array, verbose=0):
    r"""
    Aefficiencies(array_link orthogonal_array, int verbose=0) -> doubleVector


    calculate various A-efficiencies

    """
    return _oalib.Aefficiencies(orthogonal_array, verbose)

def projDeff(array, number_of_factors, verbose=0):
    r"""
    projDeff(array_link array, int number_of_factors, int verbose=0) -> doubleVector


    Calculate D-efficiencies for all projection designs

    Parameters
    ----------
    * `array` :
        Design to calculate D-efficiencies for
    * `number_of_factors` :
        Number of factors into which to project
    * `verbose` :
        Verbosity level

    Returns
    -------
    Vector with calculated D-efficiencies

    """
    return _oalib.projDeff(array, number_of_factors, verbose)

def PECsequence(array, verbose=0):
    r"""
    PECsequence(array_link array, int verbose=0) -> doubleVector


    Calculate the projection estimation capacity sequence for a design

    Parameters
    ----------
    * `array` :
        Input array
    * `verbose` :
        Verbosity level

    Returns
    -------
    Vector with the caculated PEC sequence

    The PECk of a design is the fraction of estimable second-order models in k
    factors. The vector (PEC1, PEC2, ..., ) is called the projection estimation
    capacity sequence. See "Ranking Non-regular Designs", J.L. Loeppky, 2004.

    """
    return _oalib.PECsequence(array, verbose)

def PICsequence(array, verbose=0):
    r"""
    PICsequence(array_link array, int verbose=0) -> doubleVector


    Calculate the projection information capacity sequence for a design.

    Parameters
    ----------
    * `array` :
        Input array
    * `verbose` :
        Verbosity level

    Returns
    -------
    Vector with the caculated PIC sequence

    The PICk of a design is the average D-efficiency of estimable second-order
    models in k factors. The vector (PIC1, PIC2, ..., ) is called the PIC sequence.

    """
    return _oalib.PICsequence(array, verbose)

def macwilliams_transform_mixed(B, N, factor_levels_for_groups, verbose=0):
    r"""macwilliams_transform_mixed(ndarray_double B, int N, intVector factor_levels_for_groups, int verbose=0) -> ndarray_double"""
    return _oalib.macwilliams_transform_mixed(B, N, factor_levels_for_groups, verbose)

def distance_distribution(array):
    r"""
    distance_distribution(array_link array) -> doubleVector


    Return the distance distribution of a design

    The distance distribution is described in "Generalized minimum aberration for
    asymmetrical fractional factorial designs", Wu and Xu, 2001

    """
    return _oalib.distance_distribution(array)

def distance_distribution_shape(arrayclass):
    r"""distance_distribution_shape(arraydata_t arrayclass) -> intVector"""
    return _oalib.distance_distribution_shape(arrayclass)

def distance_distribution_mixed(array, verbose=0):
    r"""distance_distribution_mixed(array_link array, int verbose=0) -> ndarray_double"""
    return _oalib.distance_distribution_mixed(array, verbose)

def distance_distribution_mixed_inplace(al, B, verbose=0):
    r"""distance_distribution_mixed_inplace(array_link al, ndarray_double B, int verbose=0)"""
    return _oalib.distance_distribution_mixed_inplace(al, B, verbose)

def Jcharacteristics(array, number_of_columns=4, verbose=0):
    r"""
    Jcharacteristics(array_link array, int number_of_columns=4, int verbose=0) -> intVector


    Calculate Jk-characteristics of a matrix

    The calcualted Jk-values are signed.

    Parameters
    ----------
    * `array` :
        Array to calculate Jk-characteristics for
    * `number_of_columns` :
        Number of columns
    * `verbose` :
        Verbosity level

    Returns
    -------
    Vector with calculated Jk-characteristics

    """
    return _oalib.Jcharacteristics(array, number_of_columns, verbose)

def GWLP(array, verbose=0, truncate=1):
    r"""
    GWLP(array_link array, int verbose=0, int truncate=1) -> doubleVector


    Calculate GWLP (generalized wordlength pattern)

    The method used for calculation is from Xu and Wu (2001), "Generalized minimum
    aberration for asymmetrical
    fractional factorial desings". For non-symmetric arrays see "Algorithmic
    Construction of Efficient Fractional Factorial Designs With Large Run
    Sizes", Xu, Technometrics, 2009.

    Parameters
    ----------
    * `array` :
        Array to calculate the GWLP value for
    * `verbose` :
        Verbosity level
    * `truncate` :
        If True then round values near zero to solve double precision errors

    Returns
    -------
    Vector with calculated generalized wordlength pattern

    A more detailed description of the generalized wordlength pattern can also be
    found in the documentation at https://oapackage.readthedocs.io/.

    """
    return _oalib.GWLP(array, verbose, truncate)

def GWLPmixed(array, verbose=0, truncate=1):
    r"""
    GWLPmixed(array_link array, int verbose=0, int truncate=1) -> doubleVector


    Calculate GWLP (generalized wordlength pattern) for mixed-level arrays.

    The method used for calculation is from "Algorithmic Construction of Efficient
    Fractional Factorial Designs With Large Run
    Sizes", Xu, Technometrics, 2009.

    Parameters
    ----------
    * `array` :
        Array to calculate the GWLP value for
    * `verbose` :
        Verbosity level
    * `truncate` :
        If True then round values near zero to solve double precision errors

    Returns
    -------
    Vector with calculated generalized wordlength pattern

    """
    return _oalib.GWLPmixed(array, verbose, truncate)

def projectionGWLPs(al):
    r"""
    projectionGWLPs(array_link al) -> vector_mvalue_t_double


    calculate delete-one-factor GWLP (generalized wordlength pattern) projections

    """
    return _oalib.projectionGWLPs(al)

def sortGWLP(arg1):
    r"""
    sortGWLP(vector_mvalue_t_double arg1) -> vector_mvalue_t_double


    sort a list of GWLP values and return the sorted list

    """
    return _oalib.sortGWLP(arg1)

def CL2discrepancy(array):
    r"""
    CL2discrepancy(array_link array) -> double


    Calculate centered L2-discrepancy of a design

    The method is from "A connection between uniformity and aberration in regular
    fractions of two-level factorials", Fang and Mukerjee, 2000

    """
    return _oalib.CL2discrepancy(array)

def array2secondorder(array):
    r"""
    array2secondorder(array_link array) -> array_link


    Calculate second order interaction model for 2-level array

    Parameters
    ----------
    * `array` :
        Array to calculate second order interaction model from

    Returns
    -------
    Array interaction effects

    """
    return _oalib.array2secondorder(array)

def array2xf(array):
    r"""
    array2xf(array_link array) -> array_link


    calculate second order interaction model for 2-level array

    Parameters
    ----------
    * `array` :
        Array to calculate second order interaction model from

    Returns
    -------
    Array with intercept, main effects and interaction effects

    """
    return _oalib.array2xf(array)
MODEL_CONSTANT = _oalib.MODEL_CONSTANT
r""" only the intercept"""
MODEL_MAIN = _oalib.MODEL_MAIN
r""" intercept and main effects"""
MODEL_INTERACTION = _oalib.MODEL_INTERACTION
r""" intercept, main effects and second order interactions"""
MODEL_SECONDORDER = _oalib.MODEL_SECONDORDER
r""" intercept, main effects and second order effects(interactions and quadratic effects)"""
MODEL_INVALID = _oalib.MODEL_INVALID
r""" invalid model"""

def conference_design2modelmatrix(conference_design, mode, verbose=0):
    r"""
    conference_design2modelmatrix(array_link conference_design, char const * mode, int verbose=0) -> array_link


    Calculate model matrix for a conference design

    Parameters
    ----------
    * `conference_design` :
        Conference design
    * `mode` :
        Can be 'm' for main effects, 'i' for interaction effects or 'q' for
        quadratic effects
    * `verbose` :
        Verbosity level

    Returns
    -------
    Calculated model matrix

    """
    return _oalib.conference_design2modelmatrix(conference_design, mode, verbose)

def array2modelmatrix(array, mode, verbose=0):
    r"""
    array2modelmatrix(array_link array, char const * mode, int verbose=0) -> Eigen::MatrixXd


    Convert orthogonal array or conference design to model matrix

    The model matrix consists of the intercept, main effects and (optionally) the
    interaction effects and quadratic effects. The order in the interaction effects
    is (c1, c2)=(0,0), (1,0), (2,0), (2,1), ... with c2<c1 for columns c1, c2. The
    size of the model matrix calculated by this function is given by
    array2modelmatrix_sizes.

    Parameters
    ----------
    * `array` :
        Orthogonal array or conference design
    * `mode` :
        Type of model matrix to calculate. Can be 'm' for main effects, 'i' for
        interaction effects or 'q' for quadratic effects
    * `verbose` :
        Verbosity level

    Returns
    -------
    Calculated model matrix

    For conference designs the method conference_design2modelmatrix is used. For
    orthogonal array the calculated is performed with array2eigenModelMatrixMixed.

    """
    return _oalib.array2modelmatrix(array, mode, verbose)

def array2modelmatrix_sizes(array):
    r"""
    array2modelmatrix_sizes(array_link array) -> intVector


    Return the sizes of the model matrices calculated

    Parameters
    ----------
    * `array` :
        Orthogonal array or conference designs

    Returns
    -------
    List with the sizes of the model matrix for: only intercept; intercept, main;
    intercept, main, and iteraction terms, intercept, main and full second order

    """
    return _oalib.array2modelmatrix_sizes(array)

def array2xfeigen(array):
    r"""
    array2xfeigen(array_link array) -> Eigen::MatrixXd


    calculate second order interaction model for 2-level array

    Parameters
    ----------
    * `array` :
        Array to calculate second order interaction model from

    Returns
    -------
    Array with intercept, main effects and interaction effects

    """
    return _oalib.array2xfeigen(array)

def arrayrankFullPivQR(al, threshold=-1):
    r"""
    arrayrankFullPivQR(array_link al, double threshold=-1) -> int


    return rank of an array based on Eigen::FullPivHouseholderQR

    """
    return _oalib.arrayrankFullPivQR(al, threshold)

def arrayrankColPivQR(al, threshold=-1):
    r"""
    arrayrankColPivQR(array_link al, double threshold=-1) -> int


    return rank of an array based on Eigen::ColPivHouseholderQR

    """
    return _oalib.arrayrankColPivQR(al, threshold)

def arrayrankFullPivLU(al, threshold=-1):
    r"""
    arrayrankFullPivLU(array_link al, double threshold=-1) -> int


    return rank of an array based on Eigen::FullPivLU

    """
    return _oalib.arrayrankFullPivLU(al, threshold)

def arrayrankSVD(al, threshold=-1):
    r"""
    arrayrankSVD(array_link al, double threshold=-1) -> int


    return rank of an array based on Eigen::JacobiSVD

    """
    return _oalib.arrayrankSVD(al, threshold)

def arrayrank(array):
    r"""
    arrayrank(array_link array) -> int


    calculate the rank of an array

    """
    return _oalib.arrayrank(array)

def arrayrankInfo(*args):
    r"""
    arrayrankInfo(Eigen::MatrixXd const & arg1, int verbose=1) -> int
    arrayrankInfo(array_link array, int verbose=1) -> int


    Return rank of an array. Information about the different methods for rank
    calculation is printed to stdout.

    """
    return _oalib.arrayrankInfo(*args)

def arraylink2eigen(array):
    r"""
    arraylink2eigen(array_link array) -> Eigen::MatrixXd


    convert array_link to Eigen matrix

    """
    return _oalib.arraylink2eigen(array)
class rankStructure(object):
    r"""


    Structure to efficiently calculate the rank of the second order interaction
    matrix of many arrays

    The efficiency is obtained if the arrays share a common subarray. The theory is
    described in "Efficient rank calculation for matrices with a common
    submatrix", Eendebak, 2016

    C++ includes: arrayproperties.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    alsub = property(_oalib.rankStructure_alsub_get, _oalib.rankStructure_alsub_set, doc=r"""alsub : array_link""")
    r = property(_oalib.rankStructure_r_get, _oalib.rankStructure_r_set, doc=r"""r : int""")
    verbose = property(_oalib.rankStructure_verbose_get, _oalib.rankStructure_verbose_set, doc=r"""verbose : int""")
    ks = property(_oalib.rankStructure_ks_get, _oalib.rankStructure_ks_set, doc=r"""ks : int""")
    nsub = property(_oalib.rankStructure_nsub_get, _oalib.rankStructure_nsub_set, doc=r"""nsub : int""")
    id = property(_oalib.rankStructure_id_get, _oalib.rankStructure_id_set, doc=r"""id : int""")

    def __init__(self, *args):
        r"""
        __init__(rankStructure self, array_link al, int nsub=3, int verbose=0) -> rankStructure
        __init__(rankStructure self, int nsub=3, int id=-1) -> rankStructure


        constructor

        """
        _oalib.rankStructure_swiginit(self, _oalib.new_rankStructure(*args))

    def info(self):
        r"""
        info(rankStructure self)


        print information about the rank structure

        """
        return _oalib.rankStructure_info(self)

    def updateStructure(self, al):
        r"""
        updateStructure(rankStructure self, array_link al)


        update the structure cache with a new array

        """
        return _oalib.rankStructure_updateStructure(self, al)

    def rankdirect(self, array):
        r"""
        rankdirect(rankStructure self, Eigen::MatrixXd const & array) -> int


        calculate the rank of an array directly, uses special threshold

        """
        return _oalib.rankStructure_rankdirect(self, array)

    def rankxfdirect(self, array):
        r"""
        rankxfdirect(rankStructure self, array_link array) -> int


        calculate the rank of the second order interaction matrix of an array directly

        """
        return _oalib.rankStructure_rankxfdirect(self, array)

    def rankxf(self, array):
        r"""
        rankxf(rankStructure self, array_link array) -> int


        calculate the rank of the second order interaction matrix of an array using the
        cache system

        """
        return _oalib.rankStructure_rankxf(self, array)
    __swig_destroy__ = _oalib.delete_rankStructure

# Register rankStructure in _oalib:
_oalib.rankStructure_swigregister(rankStructure)


def conditionNumber(matrix):
    r"""
    conditionNumber(array_link matrix) -> double


    return the condition number of a matrix

    """
    return _oalib.conditionNumber(matrix)
PARETOFUNCTION_DEFAULT = _oalib.PARETOFUNCTION_DEFAULT

PARETOFUNCTION_J5 = _oalib.PARETOFUNCTION_J5


def calculateParetoEvenOdd(*args):
    r"""
    calculateParetoEvenOdd(stringVector infiles, char const * outfile, int verbose=1, arrayfile::arrayfilemode_t afmode=ABINARY, int nrows=-1, int ncols=-1, paretomethod_t paretomethod=PARETOFUNCTION_DEFAULT)


    Calculate the Pareto optimal arrays from a list of array files

    Pareto optimality is calculated according to (rank; A3,A4; F4)

    """
    return _oalib.calculateParetoEvenOdd(*args)

def parsePareto(arraylist, verbose, paretomethod=PARETOFUNCTION_DEFAULT):
    r"""
    parsePareto(arraylist_t arraylist, int verbose, paretomethod_t paretomethod=PARETOFUNCTION_DEFAULT) -> ParetoMultiLongLong


    """
    return _oalib.parsePareto(arraylist, verbose, paretomethod)

def A3A4(al):
    r"""
    A3A4(array_link al) -> mvalue_t_long


    calculate A3 and A4 value for array

    Parameters
    ----------
    * `al` :
        Array for which to calculate A3 and A4

    Returns
    -------
    Object with A3 and A4

    """
    return _oalib.A3A4(al)

def F4(al, verbose=1):
    r"""
    F4(array_link al, int verbose=1) -> mvalue_t_long


    calculate F4 value for 2-level array

    """
    return _oalib.F4(al, verbose)

def Cvalue2Dvalue(Cvalue, number_of_columns):
    r"""
    Cvalue2Dvalue(double Cvalue, int number_of_columns) -> double


    convert C value to D-efficiency value

    """
    return _oalib.Cvalue2Dvalue(Cvalue, number_of_columns)

def Dvalue2Cvalue(Defficiency, number_of_columns):
    r"""
    Dvalue2Cvalue(double Defficiency, int number_of_columns) -> double


    convert D-efficiency value to C value

    """
    return _oalib.Dvalue2Cvalue(Defficiency, number_of_columns)

def md5(*args):
    r"""
    md5(void * data, int number_of_bytes) -> std::string
    md5(std::string const & filename) -> std::string


    calculate md5 sum of a file on disk

    """
    return _oalib.md5(*args)

def scoreD(efficiencies, weights):
    r"""
    scoreD(doubleVector efficiencies, doubleVector weights) -> double


    Calculate score from a set of efficiencies

    The score is the weighted sum of the efficiencies.

    Parameters
    ----------
    * `efficiencies` :
        Vector with calculated efficiencies
    * `weights` :
        Weights for the efficiencies

    Returns
    -------
    Weighted sum of the efficiencies

    """
    return _oalib.scoreD(efficiencies, weights)
DOPTIM_UPDATE = _oalib.DOPTIM_UPDATE
r""" replace a random element with a random value"""
DOPTIM_SWAP = _oalib.DOPTIM_SWAP
r""" swap two elements at random"""
DOPTIM_FLIP = _oalib.DOPTIM_FLIP
r""" randomly flip an element between 0 and 1"""
DOPTIM_AUTOMATIC = _oalib.DOPTIM_AUTOMATIC
r""" automatically select one of the methods"""
DOPTIM_NONE = _oalib.DOPTIM_NONE
r""" perform no optimization"""
class DoptimReturn(object):
    r"""


    Structure containing results of the Doptimize function

    C++ includes: Deff.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    dds = property(_oalib.DoptimReturn_dds_get, _oalib.DoptimReturn_dds_set, doc=r"""dds : std::vector<(std::vector<(double,std::allocator<(double)>)>,std::allocator<(std::vector<(double,std::allocator<(double)>)>)>)>""")
    designs = property(_oalib.DoptimReturn_designs_get, _oalib.DoptimReturn_designs_set, doc=r"""designs : arraylist_t""")
    nrestarts = property(_oalib.DoptimReturn_nrestarts_get, _oalib.DoptimReturn_nrestarts_set, doc=r"""nrestarts : int""")
    _nimproved = property(_oalib.DoptimReturn__nimproved_get, _oalib.DoptimReturn__nimproved_set, doc=r"""_nimproved : int""")

    def __init__(self):
        r"""
        __init__(DoptimReturn self) -> DoptimReturn


        Structure containing results of the Doptimize function

        C++ includes: Deff.h

        """
        _oalib.DoptimReturn_swiginit(self, _oalib.new_DoptimReturn())
    __swig_destroy__ = _oalib.delete_DoptimReturn

# Register DoptimReturn in _oalib:
_oalib.DoptimReturn_swigregister(DoptimReturn)


def Doptimize(arrayclass, nrestarts, alpha, verbose, method=DOPTIM_AUTOMATIC, niter=300000, maxtime=100000, nabort=5000):
    r"""
    Doptimize(arraydata_t arrayclass, int nrestarts, doubleVector alpha, int verbose, coordinate_exchange_method_t method=DOPTIM_AUTOMATIC, int niter=300000, double maxtime=100000, int nabort=5000) -> DoptimReturn


    Generates optimal designs for the specified class of designs

    The method uses a coordinate-exchange algorithm to optimze a target function
    defined by the optimziation paramaters. The optimization is performed multiple
    times to prevent finding a design in a local minmum of the target function.

    The method is described in more detail in "Two-Level Designs to Estimate All
    Main Effects and Two-Factor Interactions", Eendebak et al., 2015,
    Technometrics, https://doi.org/10.1080/00401706.2016.1142903.

    Parameters
    ----------
    * `arrayclass` :
        Class of designs to optimize
    * `nrestarts` :
        Number of restarts to perform
    * `alpha` :
        Optimization parameters. The target function is alpha_1 D + alpha_2 D_s +
        alpha D_1
    * `verbose` :
        Verbosity level
    * `method` :
        Method for optimization algorithm
    * `niter` :
        Maximum number of iterations for each restart
    * `maxtime` :
        Maximum calculation time. If this time is exceeded, the function is aborted
    * `nabort` :
        Maximum number of iterations when no improvement is found

    Returns
    -------
    A structure with the generated optimal designs

    """
    return _oalib.Doptimize(arrayclass, nrestarts, alpha, verbose, method, niter, maxtime, nabort)

def DoptimizeMixed(sols, arrayclass, alpha, verbose=1, nabort=-1):
    r"""
    DoptimizeMixed(arraylist_t sols, arraydata_t arrayclass, doubleVector alpha, int verbose=1, int nabort=-1) -> DoptimReturn


    Function to generate optimal designs with mixed optimization approach

    This function is beta code. See Doptimize for detauls of the parameters.

    """
    return _oalib.DoptimizeMixed(sols, arrayclass, alpha, verbose, nabort)

def optimDeff(array, arrayclass, alpha, verbose=1, optimmethod=DOPTIM_AUTOMATIC, niter=100000, nabort=0):
    r"""
    optimDeff(array_link array, arraydata_t arrayclass, doubleVector alpha, int verbose=1, coordinate_exchange_method_t optimmethod=DOPTIM_AUTOMATIC, int niter=100000, int nabort=0) -> array_link


    Optimize a design according to the optimization function specified.

    Arguments:

    Parameters
    ----------
    * `array` :
        Array to be optimized
    * `arrayclass` :
        Structure describing the design class
    * `alpha` :
        3x1 array with optimization parameters
    * `verbose` :
        Verbosity level
    * `optimmethod` :
        Optimization method to use
    * `niter` :
        Number of iterations
    * `nabort` :
        Number of iterations after which to abort when no improvements are found

    Returns
    -------
    Optimized designs

    """
    return _oalib.optimDeff(array, arrayclass, alpha, verbose, optimmethod, niter, nabort)
class OAextend(object):
    r"""


    Options for the extend code.

    class containing parameters of the extension and LMC algorithm

    C++ includes: extend.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    singleExtendTime = property(_oalib.OAextend_singleExtendTime_get, _oalib.OAextend_singleExtendTime_set, doc=r"""singleExtendTime : double""")
    nLMC = property(_oalib.OAextend_nLMC_get, _oalib.OAextend_nLMC_set, doc=r"""nLMC : int""")
    checkarrays = property(_oalib.OAextend_checkarrays_get, _oalib.OAextend_checkarrays_set, doc=r"""checkarrays : int""")
    check_maximal = property(_oalib.OAextend_check_maximal_get, _oalib.OAextend_check_maximal_set, doc=r"""check_maximal : int""")
    use_row_symmetry = property(_oalib.OAextend_use_row_symmetry_get, _oalib.OAextend_use_row_symmetry_set, doc=r"""use_row_symmetry : int""")
    init_column_previous = property(_oalib.OAextend_init_column_previous_get, _oalib.OAextend_init_column_previous_set, doc=r"""init_column_previous : int""")
    APPENDEXTENSION = _oalib.OAextend_APPENDEXTENSION
    r""" append extension column to extension list"""
    APPENDFULL = _oalib.OAextend_APPENDFULL
    r""" append full array to extension list"""
    STOREARRAY = _oalib.OAextend_STOREARRAY
    r""" store extension to disk"""
    NONE = _oalib.OAextend_NONE
    r""" do not store generated extensions"""
    extendarraymode = property(_oalib.OAextend_extendarraymode_get, _oalib.OAextend_extendarraymode_set, doc=r"""extendarraymode : OAextend::extendarray_mode_t""")
    storefile = property(_oalib.OAextend_storefile_get, _oalib.OAextend_storefile_set, doc=r"""storefile : arrayfile::arrayfile_t""")
    j5structure = property(_oalib.OAextend_j5structure_get, _oalib.OAextend_j5structure_set, doc=r"""j5structure : j5structure_t""")

    def __init__(self, *args):
        r"""
        __init__(OAextend self) -> OAextend
        __init__(OAextend self, OAextend o) -> OAextend
        __init__(OAextend self, arraydata_t arrayclass) -> OAextend


        Options for the extension algorithm

        The algorithm is automatically determined from the specified arrayclass.

        """
        _oalib.OAextend_swiginit(self, _oalib.new_OAextend(*args))

    def setAlgorithm(self, algorithm, ad=None):
        r"""
        setAlgorithm(OAextend self, algorithm_t algorithm, arraydata_t ad=None)


        Set the algorithm to use for LMC checks.

        """
        return _oalib.OAextend_setAlgorithm(self, algorithm, ad)

    def setAlgorithmAuto(self, ad=None):
        r"""
        setAlgorithmAuto(OAextend self, arraydata_t ad=None)


        Set the algorithm automatically.

        """
        return _oalib.OAextend_setAlgorithmAuto(self, ad)

    def getAlgorithm(self):
        r"""
        getAlgorithm(OAextend self) -> algorithm_t


        Return algorithm used.

        """
        return _oalib.OAextend_getAlgorithm(self)

    def getAlgorithmName(self):
        r"""
        getAlgorithmName(OAextend self) -> std::string


        Return algorithm used (as string)

        """
        return _oalib.OAextend_getAlgorithmName(self)

    def updateArraydata(self, arrayclass=None):
        r"""
        updateArraydata(OAextend self, arraydata_t arrayclass=None)


        update the options structuer with the specified class of designs

        """
        return _oalib.OAextend_updateArraydata(self, arrayclass)

    @staticmethod
    def getPreferredAlgorithm(arrayclass, verbose=0):
        r"""
        getPreferredAlgorithm(arraydata_t arrayclass, int verbose=0) -> algorithm_t


        Return preferred extension algorithm

        Parameters
        ----------
        * `arrayclass` :
            Class of designs to extend
        * `verbose` :
            Verbosity level

        Returns
        -------
        Algorithm selected to be used for this class

        """
        return _oalib.OAextend_getPreferredAlgorithm(arrayclass, verbose)

    def info(self, verbose=1):
        r"""
        info(OAextend self, int verbose=1)


        print configuration to stdout

        """
        return _oalib.OAextend_info(self, verbose)

    def __repr__(self):
        r"""
        __repr__(OAextend self) -> std::string


        """
        return _oalib.OAextend___repr__(self)
    __swig_destroy__ = _oalib.delete_OAextend

# Register OAextend in _oalib:
_oalib.OAextend_swigregister(OAextend)

def OAextend_getPreferredAlgorithm(arrayclass, verbose=0):
    r"""
    OAextend_getPreferredAlgorithm(arraydata_t arrayclass, int verbose=0) -> algorithm_t


    Return preferred extension algorithm

    Parameters
    ----------
    * `arrayclass` :
        Class of designs to extend
    * `verbose` :
        Verbosity level

    Returns
    -------
    Algorithm selected to be used for this class

    """
    return _oalib.OAextend_getPreferredAlgorithm(arrayclass, verbose)


def extend_arraylist(*args):
    r"""
    extend_arraylist(arraylist_t array_list, arraydata_t array_class, OAextend oaextend_options) -> arraylist_t
    extend_arraylist(arraylist_t array_list, arraydata_t arrayclass) -> arraylist_t
    extend_arraylist(arraylist_t array_list, arraydata_t array_class, OAextend oaextend_options, colindex_t extensioncol, arraylist_t extensions) -> int


    Extend a list of orthogonal arrays

    Parameters
    ----------
    * `array_list` :
        The list of arrays to be extended
    * `array_class` :
        Class of arrays to generate
    * `oaextend_options` :
        Parameters for the extension algorithm

    Returns
    -------
    List of all generated arrays

    See also: extend_array(const array_link &, arraydata_t &, OAextend const &)

    Parameters
    ----------
    * `extensioncol` :
        Index of column to be added to the designs
    * `extensions` :
        List to append generated designs to

    Returns
    -------
    Number of candidate arrays generated

    """
    return _oalib.extend_arraylist(*args)

def extend_array(*args):
    r"""
    extend_array(array_link array, arraydata_t array_class, OAextend oaextend) -> arraylist_t
    extend_array(array_link array, arraydata_t arrayclass) -> arraylist_t
    extend_array(array_link array, arraydata_t arrayclass, colindex_t const extension_column, arraylist_t extensions, OAextend oaextend) -> int


    Extend an orthogonal array with a single column

    See also: extend_array(const array_link &, arraydata_t &, OAextend const &)

    Parameters
    ----------
    * `array` :
        Array to extend
    * `arrayclass` :
        Array data for the full array
    * `extension_column` :
        Column to extend
    * `extensions` :
        List to which generated valid extensions are added
    * `oaextend` :
        Structure with options

    Returns
    -------
    Number of candidate extensions generated

    """
    return _oalib.extend_array(*args)

def runExtendRoot(arrayclass, max_number_columns, verbose=0):
    r"""
    runExtendRoot(arraydata_t arrayclass, int max_number_columns, int verbose=0) -> arraylist_t


    Run the LMC extension algorithm starting with the root array

    See also: extend_array(const array_link &, arraydata_t &, OAextend const &)

    """
    return _oalib.runExtendRoot(arrayclass, max_number_columns, verbose)
DFILTER_NONE = _oalib.DFILTER_NONE
r""" no filtering on D-efficiency"""
DFILTER_BASIC = _oalib.DFILTER_BASIC
r""" filtering on D-efficiency"""
DFILTER_MULTI = _oalib.DFILTER_MULTI
r""" filtering on D-efficiency with multi column prediction"""
DCALC_ALWAYS = _oalib.DCALC_ALWAYS
r""" always calculate efficiency"""
DCALC_COND = _oalib.DCALC_COND
r""" only calculate efficiency for LMC_LESS"""
class dextend_t(object):
    r"""


    Structure for dynamic extension of arrays based on D-efficiencies.

    C++ includes: extend.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    NO_VALUE = _oalib.dextend_t_NO_VALUE
    
    lmctype = property(_oalib.dextend_t_lmctype_get, _oalib.dextend_t_lmctype_set, doc=r"""lmctype : std::vector<(lmc_t,std::allocator<(lmc_t)>)>""")
    lastcol = property(_oalib.dextend_t_lastcol_get, _oalib.dextend_t_lastcol_set, doc=r"""lastcol : std::vector<(int,std::allocator<(int)>)>""")
    Deff = property(_oalib.dextend_t_Deff_get, _oalib.dextend_t_Deff_set, doc=r"""Deff : std::vector<(double,std::allocator<(double)>)>""")
    filter = property(_oalib.dextend_t_filter_get, _oalib.dextend_t_filter_set, doc=r"""filter : std::vector<(int,std::allocator<(int)>)>""")
    filtermode = property(_oalib.dextend_t_filtermode_get, _oalib.dextend_t_filtermode_set, doc=r"""filtermode : dfilter_t""")
    Dcheck = property(_oalib.dextend_t_Dcheck_get, _oalib.dextend_t_Dcheck_set, doc=r"""Dcheck : dcalc_mode""")
    directcheck = property(_oalib.dextend_t_directcheck_get, _oalib.dextend_t_directcheck_set, doc=r"""directcheck : int""")

    def __init__(self):
        r"""
        __init__(dextend_t self) -> dextend_t


        """
        _oalib.dextend_t_swiginit(self, _oalib.new_dextend_t())

    def resize(self, nn):
        r"""
        resize(dextend_t self, int nn)


        """
        return _oalib.dextend_t_resize(self, nn)

    def DefficiencyFilter(self, Dfinal, k, kfinal, Lmax, verbose=1):
        r"""
        DefficiencyFilter(dextend_t self, double Dfinal, int k, int kfinal, double Lmax, int verbose=1)


        perform filtering using D-efficiency

        """
        return _oalib.dextend_t_DefficiencyFilter(self, Dfinal, k, kfinal, Lmax, verbose)

    def filterArrays(self, al, earrays, earraysout, edata, verbose=1):
        r"""
        filterArrays(dextend_t self, array_link al, arraylist_t earrays, arraylist_t earraysout, vector_vector_double edata, int verbose=1) -> intVector


        filter the arrays based on values in filter

        """
        return _oalib.dextend_t_filterArrays(self, al, earrays, earraysout, edata, verbose)
    ntotal = property(_oalib.dextend_t_ntotal_get, _oalib.dextend_t_ntotal_set, doc=r"""ntotal : long""")
    nlmc = property(_oalib.dextend_t_nlmc_get, _oalib.dextend_t_nlmc_set, doc=r"""nlmc : long""")
    n = property(_oalib.dextend_t_n_get, _oalib.dextend_t_n_set, doc=r"""n : long""")
    DmaxDiscard = property(_oalib.dextend_t_DmaxDiscard_get, _oalib.dextend_t_DmaxDiscard_set, doc=r"""DmaxDiscard : double""")
    nmaxrnktotal = property(_oalib.dextend_t_nmaxrnktotal_get, _oalib.dextend_t_nmaxrnktotal_set, doc=r"""nmaxrnktotal : long""")
    __swig_destroy__ = _oalib.delete_dextend_t

# Register dextend_t in _oalib:
_oalib.dextend_t_swigregister(dextend_t)

LMC_LESS = _oalib.LMC_LESS
r""" Found a permutation which leads to a lexicographically smaller array"""
LMC_EQUAL = _oalib.LMC_EQUAL
r""" Found a permutation which leads to a lexicographically equal array"""
LMC_MORE = _oalib.LMC_MORE
r""" Found a permutation which leads to a lexicographically larger array"""
LMC_NONSENSE = _oalib.LMC_NONSENSE
r""" No valid result"""
MODE_LMC = _oalib.MODE_LMC
r""" LMC minimal form"""
MODE_J4 = _oalib.MODE_J4
r""" LMC minimal form with J4 method"""
MODE_J5ORDER = _oalib.MODE_J5ORDER
r""" J5 minimal form"""
MODE_J5ORDERX = _oalib.MODE_J5ORDERX
r""" J5 minimal form"""
MODE_INVALID = _oalib.MODE_INVALID

MODE_AUTOSELECT = _oalib.MODE_AUTOSELECT
r""" Automatically select the algorithm"""
MODE_LMC_SYMMETRY = _oalib.MODE_LMC_SYMMETRY
r""" debugging method"""
MODE_LMC_2LEVEL = _oalib.MODE_LMC_2LEVEL
r""" LMC minimal form, specialized for 2-level arrays"""
MODE_LMC_DEBUG = _oalib.MODE_LMC_DEBUG
r""" debugging method"""
MODE_J5ORDER_2LEVEL = _oalib.MODE_J5ORDER_2LEVEL
r""" J5 minimal form for 2-level arrays"""

def algorithm_t_list():
    r"""
    algorithm_t_list() -> std::string


    Return string representation of available algorithm modes.

    """
    return _oalib.algorithm_t_list()
INITCOLUMN_ZERO = _oalib.INITCOLUMN_ZERO
r""" Initialize column with zeros"""
INITCOLUMN_PREVIOUS = _oalib.INITCOLUMN_PREVIOUS
r""" Initialize column with values of previous column"""
INITCOLUMN_J5 = _oalib.INITCOLUMN_J5
r""" Initialize column with values based on J5 value"""
J5_ORIGINAL = _oalib.J5_ORIGINAL
r""" Ordering based in J5 in succesive columns"""
J5_45 = _oalib.J5_45
r""" Ordering based on J5 and the 5-tuple of J4 values"""

def algnames(m):
    r"""
    algnames(algorithm_t m) -> std::string


    return name of the algorithm

    """
    return _oalib.algnames(m)
class rowsort_t(object):
    r"""Proxy of C++ rowsort_t class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    r = property(_oalib.rowsort_t_r_get, _oalib.rowsort_t_r_set, doc=r"""r : rowindex_t""")
    val = property(_oalib.rowsort_t_val_get, _oalib.rowsort_t_val_set, doc=r"""val : rowsort_value_t""")

    def __init__(self):
        r"""__init__(rowsort_t self) -> rowsort_t"""
        _oalib.rowsort_t_swiginit(self, _oalib.new_rowsort_t())
    __swig_destroy__ = _oalib.delete_rowsort_t

# Register rowsort_t in _oalib:
_oalib.rowsort_t_swigregister(rowsort_t)
MODE_ORIGINAL = cvar.MODE_ORIGINAL


def __lt__(a, b):
    r"""__lt__(rowsort_t a, rowsort_t b) -> bool"""
    return _oalib.__lt__(a, b)

def __gt__(a, b):
    r"""__gt__(rowsort_t a, rowsort_t b) -> bool"""
    return _oalib.__gt__(a, b)

def apply_hadamard(al, hcolumn):
    r"""
    apply_hadamard(array_link al, colindex_t hcolumn)


    Apply Hadamard transformation to orthogonal array.

    """
    return _oalib.apply_hadamard(al, hcolumn)
class LMCreduction_helper_t(object):
    r"""


    Contains structures used by the LMC reduction or LMC check.

    Part of the allocations is for structures that are constant and are re-used each
    time an LMC calculation is performed. Some other structures are temporary
    buffers that are written to all the time.

    C++ includes: lmc.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    LMC_non_root_init = property(_oalib.LMCreduction_helper_t_LMC_non_root_init_get, _oalib.LMCreduction_helper_t_LMC_non_root_init_set, doc=r"""LMC_non_root_init : int""")
    LMC_root_init = property(_oalib.LMCreduction_helper_t_LMC_root_init_get, _oalib.LMCreduction_helper_t_LMC_root_init_set, doc=r"""LMC_root_init : int""")
    LMC_reduce_root_rowperms_init = property(_oalib.LMCreduction_helper_t_LMC_reduce_root_rowperms_init_get, _oalib.LMCreduction_helper_t_LMC_reduce_root_rowperms_init_set, doc=r"""LMC_reduce_root_rowperms_init : int""")
    ad = property(_oalib.LMCreduction_helper_t_ad_get, _oalib.LMCreduction_helper_t_ad_set, doc=r"""ad : p.arraydata_t""")
    LMC_root_rowperms_init = property(_oalib.LMCreduction_helper_t_LMC_root_rowperms_init_get, _oalib.LMCreduction_helper_t_LMC_root_rowperms_init_set, doc=r"""LMC_root_rowperms_init : int""")
    nrootrowperms = property(_oalib.LMCreduction_helper_t_nrootrowperms_get, _oalib.LMCreduction_helper_t_nrootrowperms_set, doc=r"""nrootrowperms : int""")
    rootrowperms = property(_oalib.LMCreduction_helper_t_rootrowperms_get, _oalib.LMCreduction_helper_t_rootrowperms_set, doc=r"""rootrowperms : p.rowperm_t""")
    LMC_root_rowperms_init_full = property(_oalib.LMCreduction_helper_t_LMC_root_rowperms_init_full_get, _oalib.LMCreduction_helper_t_LMC_root_rowperms_init_full_set, doc=r"""LMC_root_rowperms_init_full : int""")
    nrootrowperms_full = property(_oalib.LMCreduction_helper_t_nrootrowperms_full_get, _oalib.LMCreduction_helper_t_nrootrowperms_full_set, doc=r"""nrootrowperms_full : int""")
    rootrowperms_full = property(_oalib.LMCreduction_helper_t_rootrowperms_full_get, _oalib.LMCreduction_helper_t_rootrowperms_full_set, doc=r"""rootrowperms_full : p.rowperm_t""")
    colbuffer = property(_oalib.LMCreduction_helper_t_colbuffer_get, _oalib.LMCreduction_helper_t_colbuffer_set, doc=r"""colbuffer : p.array_t""")
    dyndata_p = property(_oalib.LMCreduction_helper_t_dyndata_p_get, _oalib.LMCreduction_helper_t_dyndata_p_set, doc=r"""dyndata_p : p.p.dyndata_t""")
    colperm_p = property(_oalib.LMCreduction_helper_t_colperm_p_get, _oalib.LMCreduction_helper_t_colperm_p_set, doc=r"""colperm_p : p.p.colindex_t""")
    localcolperm_p = property(_oalib.LMCreduction_helper_t_localcolperm_p_get, _oalib.LMCreduction_helper_t_localcolperm_p_set, doc=r"""localcolperm_p : p.p.colindex_t""")
    current_trans = property(_oalib.LMCreduction_helper_t_current_trans_get, _oalib.LMCreduction_helper_t_current_trans_set, doc=r"""current_trans : p.array_transformation_t""")

    def __init__(self):
        r"""
        __init__(LMCreduction_helper_t self) -> LMCreduction_helper_t


        """
        _oalib.LMCreduction_helper_t_swiginit(self, _oalib.new_LMCreduction_helper_t())
    __swig_destroy__ = _oalib.delete_LMCreduction_helper_t

    def show(self, verbose=1):
        r"""
        show(LMCreduction_helper_t self, int verbose=1)


        """
        return _oalib.LMCreduction_helper_t_show(self, verbose)

    def init(self, adp):
        r"""
        init(LMCreduction_helper_t self, arraydata_t adp)


        """
        return _oalib.LMCreduction_helper_t_init(self, adp)

    def freeall(self):
        r"""
        freeall(LMCreduction_helper_t self)


        """
        return _oalib.LMCreduction_helper_t_freeall(self)

    def update(self, adp):
        r"""
        update(LMCreduction_helper_t self, arraydata_t adp) -> int


        update structure with new design specification

        """
        return _oalib.LMCreduction_helper_t_update(self, adp)

    def needUpdate(self, adp):
        r"""
        needUpdate(LMCreduction_helper_t self, arraydata_t adp) -> int


        """
        return _oalib.LMCreduction_helper_t_needUpdate(self, adp)

    def init_root_stage(self, lperm_p, colperm_p, adp):
        r"""
        init_root_stage(LMCreduction_helper_t self, levelperm_t *& lperm_p, colperm_t *& colperm_p, arraydata_t adp)


        """
        return _oalib.LMCreduction_helper_t_init_root_stage(self, lperm_p, colperm_p, adp)

    def init_nonroot_stage(self, lperm_p, colperm_p, localcolperm_p, dynd_p, dynd_p_nelem, colbuffer, adp):
        r"""
        init_nonroot_stage(LMCreduction_helper_t self, levelperm_t *& lperm_p, colperm_t *& colperm_p, colperm_t *& localcolperm_p, dyndata_t **& dynd_p, int & dynd_p_nelem, array_t *& colbuffer, arraydata_t adp)


        """
        return _oalib.LMCreduction_helper_t_init_nonroot_stage(self, lperm_p, colperm_p, localcolperm_p, dynd_p, dynd_p_nelem, colbuffer, adp)

    def init_rootrowperms(self, totalperms, rootrowperms, lperm_p):
        r"""
        init_rootrowperms(LMCreduction_helper_t self, int & totalperms, rowperm_t *& rootrowperms, levelperm_t *& lperm_p)


        Static initialization of root row permutations.

        """
        return _oalib.LMCreduction_helper_t_init_rootrowperms(self, totalperms, rootrowperms, lperm_p)

    def init_rootrowperms_full(self, totalperms, rootrowperms, lperm_p):
        r"""
        init_rootrowperms_full(LMCreduction_helper_t self, int & totalperms, rowperm_t *& rootrowperms, levelperm_t *& lperm_p)


        Static initialization of root row permutations (full group)

        """
        return _oalib.LMCreduction_helper_t_init_rootrowperms_full(self, totalperms, rootrowperms, lperm_p)

# Register LMCreduction_helper_t in _oalib:
_oalib.LMCreduction_helper_t_swigregister(LMCreduction_helper_t)


def acquire_LMCreduction_object():
    r"""
    acquire_LMCreduction_object() -> LMCreduction_helper_t


    return static structure from dynamic global pool, return with
    releaseGlobalStatic

    """
    return _oalib.acquire_LMCreduction_object()

def release_LMCreduction_object(p):
    r"""
    release_LMCreduction_object(LMCreduction_helper_t p)


    """
    return _oalib.release_LMCreduction_object(p)

def clear_LMCreduction_pool():
    r"""
    clear_LMCreduction_pool()


    release all objects in the pool

    """
    return _oalib.clear_LMCreduction_pool()
REDUCTION_INITIAL = _oalib.REDUCTION_INITIAL
r""" the reduction is equal to the initial"""
REDUCTION_CHANGED = _oalib.REDUCTION_CHANGED
r""" the reduction was changed"""
OA_TEST = _oalib.OA_TEST
r""" test for minimal form"""
OA_REDUCE = _oalib.OA_REDUCE
r""" reduce to minimal form"""
OA_REDUCE_PARTIAL = _oalib.OA_REDUCE_PARTIAL
r""" reduce to partial minimal form"""
INIT_STATE_INVALID = _oalib.INIT_STATE_INVALID

COPY = _oalib.COPY
r""" copy from array argument"""
INIT = _oalib.INIT
r"""  initialized by user"""
SETROOT = _oalib.SETROOT
r""" set initial state to root array"""
class LMCreduction_t(object):
    r"""


    Class to describe an LMC reduction.

    The most important variable is the transformation itself, contained in
    transformation. The state contains information about how the reduction was
    performed.

    C++ includes: lmc.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    array = property(_oalib.LMCreduction_t_array_get, _oalib.LMCreduction_t_array_set, doc=r"""array : p.array_t""")
    transformation = property(_oalib.LMCreduction_t_transformation_get, _oalib.LMCreduction_t_transformation_set, doc=r"""transformation : p.array_transformation_t""")
    mode = property(_oalib.LMCreduction_t_mode_get, _oalib.LMCreduction_t_mode_set, doc=r"""mode : OA_MODE""")
    state = property(_oalib.LMCreduction_t_state_get, _oalib.LMCreduction_t_state_set, doc=r"""state : REDUCTION_STATE""")
    init_state = property(_oalib.LMCreduction_t_init_state_get, _oalib.LMCreduction_t_init_state_set, doc=r"""init_state : INIT_STATE""")
    maxdepth = property(_oalib.LMCreduction_t_maxdepth_get, _oalib.LMCreduction_t_maxdepth_set, doc=r"""maxdepth : int""")
    lastcol = property(_oalib.LMCreduction_t_lastcol_get, _oalib.LMCreduction_t_lastcol_set, doc=r"""lastcol : int""")
    nred = property(_oalib.LMCreduction_t_nred_get, _oalib.LMCreduction_t_nred_set, doc=r"""nred : long""")
    targetcol = property(_oalib.LMCreduction_t_targetcol_get, _oalib.LMCreduction_t_targetcol_set, doc=r"""targetcol : int""")
    mincol = property(_oalib.LMCreduction_t_mincol_get, _oalib.LMCreduction_t_mincol_set, doc=r"""mincol : int""")
    nrows = property(_oalib.LMCreduction_t_nrows_get, _oalib.LMCreduction_t_nrows_set, doc=r"""nrows : int""")
    ncols = property(_oalib.LMCreduction_t_ncols_get, _oalib.LMCreduction_t_ncols_set, doc=r"""ncols : int""")
    staticdata = property(_oalib.LMCreduction_t_staticdata_get, _oalib.LMCreduction_t_staticdata_set, doc=r"""staticdata : p.LMCreduction_helper_t""")
    sd = property(_oalib.LMCreduction_t_sd_get, _oalib.LMCreduction_t_sd_set, doc=r"""sd : symmdataPointer""")

    def __init__(self, *args):
        r"""
        __init__(LMCreduction_t self, LMCreduction_t at) -> LMCreduction_t
        __init__(LMCreduction_t self, arraydata_t arrayclass) -> LMCreduction_t


        copy constructor

        """
        _oalib.LMCreduction_t_swiginit(self, _oalib.new_LMCreduction_t(*args))
    __swig_destroy__ = _oalib.delete_LMCreduction_t

    def getArray(self):
        r"""
        getArray(LMCreduction_t self) -> array_link


        Assignment operator.

        """
        return _oalib.LMCreduction_t_getArray(self)

    def setArray(self, *args):
        r"""
        setArray(LMCreduction_t self, array_link al)
        setArray(LMCreduction_t self, array_t const * array, int nrows, int ncols)


        """
        return _oalib.LMCreduction_t_setArray(self, *args)

    def updateSDpointer(self, al, cache=False):
        r"""
        updateSDpointer(LMCreduction_t self, array_link al, bool cache=False)


        update the pointer to the symmetry data based on the specified array

        """
        return _oalib.LMCreduction_t_updateSDpointer(self, al, cache)

    def releaseStatic(self):
        r"""
        releaseStatic(LMCreduction_t self)


        release internal LMCreduction_helper_t object

        """
        return _oalib.LMCreduction_t_releaseStatic(self)

    def initStatic(self):
        r"""
        initStatic(LMCreduction_t self)


        acquire a reference to a LMCreduction_helper_t object

        """
        return _oalib.LMCreduction_t_initStatic(self)

    def getReferenceReductionHelper(self):
        r"""
        getReferenceReductionHelper(LMCreduction_t self) -> LMCreduction_helper_t


        return a reference to a object with LMC reduction data

        """
        return _oalib.LMCreduction_t_getReferenceReductionHelper(self)

    def reset(self):
        r"""
        reset(LMCreduction_t self)


        reset the reduction: clears the symmetries and sets the transformation to zero

        """
        return _oalib.LMCreduction_t_reset(self)

    def show(self, verbose=2):
        r"""
        show(LMCreduction_t self, int verbose=2)


        """
        return _oalib.LMCreduction_t_show(self, verbose)

    def __repr__(self):
        r"""
        __repr__(LMCreduction_t self) -> std::string


        """
        return _oalib.LMCreduction_t___repr__(self)

    def updateFromLoop(self, ad, dynd, lperms, original):
        r"""
        updateFromLoop(LMCreduction_t self, arraydata_t ad, dyndata_t dynd, levelperm_t * lperms, array_t const * original)


        called whenever we find a reduction

        """
        return _oalib.LMCreduction_t_updateFromLoop(self, ad, dynd, lperms, original)

    def updateTransformation(self, ad, dynd, lperms, original):
        r"""
        updateTransformation(LMCreduction_t self, arraydata_t ad, dyndata_t dynd, levelperm_t * lperms, array_t const * original)


        """
        return _oalib.LMCreduction_t_updateTransformation(self, ad, dynd, lperms, original)

    def updateLastCol(self, col):
        r"""
        updateLastCol(LMCreduction_t self, int col)


        """
        return _oalib.LMCreduction_t_updateLastCol(self, col)

# Register LMCreduction_t in _oalib:
_oalib.LMCreduction_t_swigregister(LMCreduction_t)

class rowsorter_t(object):
    r"""


    Structure to sort rows of arrays.

    C++ includes: lmc.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    number_of_rows = property(_oalib.rowsorter_t_number_of_rows_get, _oalib.rowsorter_t_number_of_rows_set, doc=r"""number_of_rows : int""")
    rowsort = property(_oalib.rowsorter_t_rowsort_get, _oalib.rowsorter_t_rowsort_set, doc=r"""rowsort : p.rowsort_t""")

    def __init__(self, number_of_rows):
        r"""
        __init__(rowsorter_t self, int number_of_rows) -> rowsorter_t


        """
        _oalib.rowsorter_t_swiginit(self, _oalib.new_rowsorter_t(number_of_rows))
    __swig_destroy__ = _oalib.delete_rowsorter_t

# Register rowsorter_t in _oalib:
_oalib.rowsorter_t_swigregister(rowsorter_t)

class dyndata_t(object):
    r"""


    Contains dynamic data of an array.

    The dynamic data are used in the inner loops of the LMC algorithm. In particular
    they keep track of the current row ordering and column permutation. By not
    applying these transformations to the array we can save calculation time.

    We try to prevent copying the object, so it is re-used at different levels in
    the algorithm.

    *   N: static
        -   col: changes at each column level
    *   rowsort: changes at each column level, used mainly in non-root stage
    *   colperm: changes at all levels

        See also: arraydata_t

    C++ includes: lmc.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    col = property(_oalib.dyndata_t_col_get, _oalib.dyndata_t_col_set, doc=r"""col : colindex_t""")
    N = property(_oalib.dyndata_t_N_get, _oalib.dyndata_t_N_set, doc=r"""N : rowindex_t""")
    rowsort = property(_oalib.dyndata_t_rowsort_get, _oalib.dyndata_t_rowsort_set, doc=r"""rowsort : p.rowsort_t""")
    rowsortl = property(_oalib.dyndata_t_rowsortl_get, _oalib.dyndata_t_rowsortl_set, doc=r"""rowsortl : p.rowsortlight_t""")
    colperm = property(_oalib.dyndata_t_colperm_get, _oalib.dyndata_t_colperm_set, doc=r"""colperm : colperm_t""")

    def __init__(self, *args):
        r"""
        __init__(dyndata_t self, int N, int col=0) -> dyndata_t
        __init__(dyndata_t self, dyndata_t dd) -> dyndata_t


        """
        _oalib.dyndata_t_swiginit(self, _oalib.new_dyndata_t(*args))
    __swig_destroy__ = _oalib.delete_dyndata_t

    def show(self):
        r"""
        show(dyndata_t self)


        """
        return _oalib.dyndata_t_show(self)

    def reset(self):
        r"""
        reset(dyndata_t self)


        """
        return _oalib.dyndata_t_reset(self)

    def setColperm(self, *args):
        r"""
        setColperm(dyndata_t self, colperm_t const perm, int n)
        setColperm(dyndata_t self, larray< colindex_t > const & perm)
        setColperm(dyndata_t self, intVector perm)


        """
        return _oalib.dyndata_t_setColperm(self, *args)

    def getRowperm(self, *args):
        r"""
        getRowperm(dyndata_t self, rowpermtypelight & rp)
        getRowperm(dyndata_t self, rowperm_t & rperm)
        getRowperm(dyndata_t self) -> rowpermtypelight


        return lightweight row permutation

        """
        return _oalib.dyndata_t_getRowperm(self, *args)

    def getColperm(self, *args):
        r"""
        getColperm(dyndata_t self) -> colpermtypelight
        getColperm(dyndata_t self, colpermtypelight & cp)


        set column permutation

        """
        return _oalib.dyndata_t_getColperm(self, *args)

    def allocate_rowsortl(self):
        r"""
        allocate_rowsortl(dyndata_t self)


        allocate lightweight rowsort structure

        """
        return _oalib.dyndata_t_allocate_rowsortl(self)

    def deleterowsortl(self):
        r"""
        deleterowsortl(dyndata_t self)


        """
        return _oalib.dyndata_t_deleterowsortl(self)

    def initrowsortl(self):
        r"""
        initrowsortl(dyndata_t self)


        initialize rowsortl from rowsort

        """
        return _oalib.dyndata_t_initrowsortl(self)

    def rowsortl2rowsort(self):
        r"""
        rowsortl2rowsort(dyndata_t self)


        copy rowsortl variable to rowsrt

        """
        return _oalib.dyndata_t_rowsortl2rowsort(self)

    def copydata(self, dd):
        r"""
        copydata(dyndata_t self, dyndata_t dd)


        """
        return _oalib.dyndata_t_copydata(self, dd)

# Register dyndata_t in _oalib:
_oalib.dyndata_t_swigregister(dyndata_t)


def is_root_form(array, strength):
    r"""
    is_root_form(array_link array, int strength) -> bool


    Return True if the array is in root form

    Parameters
    ----------
    * `array` :
        Array to check
    * `strength` :
        Strength to use

    Returns
    -------
    True if the array is in root form for the specified strength

    """
    return _oalib.is_root_form(array, strength)

def LMCreduction_train(al, ad, reduction, oaextend):
    r"""
    LMCreduction_train(array_link al, arraydata_t ad, LMCreduction_t reduction, OAextend oaextend) -> lmc_t


    helper function for LMC reduction

    """
    return _oalib.LMCreduction_train(al, ad, reduction, oaextend)

def LMCcheck(*args):
    r"""
    LMCcheck(array_t const * array, arraydata_t ad, OAextend oaextend, LMCreduction_t reduction) -> lmc_t
    LMCcheck(array_link array, arraydata_t ad, OAextend oaextend, LMCreduction_t reduction) -> lmc_t
    LMCcheck(array_link array) -> lmc_t


    Perform LMC check on an orthogonal array

    Parameters
    ----------
    * `array` :
        Array to be checked for LMC minimal form

    Returns
    -------
    Result of the LMC check

    """
    return _oalib.LMCcheck(*args)

def LMCcheckOriginal(array):
    r"""
    LMCcheckOriginal(array_link array) -> lmc_t


    Perform LMC check on a 2-level orthogonal array

    The algorithm used is the original algorithm from "Complete enumeration of
    pure-level and mixed-level orthogonal arrays", Schoen et al, 2009

    Parameters
    ----------
    * `array` :
        Array to be checked for LMC minimal form

    Returns
    -------
    Result of the LMC check

    """
    return _oalib.LMCcheckOriginal(array)

def reduceArraysGWLP(input_arrays, reduced_arrays, verbose, dopruning=1, strength=2, dolmc=1):
    r"""
    reduceArraysGWLP(arraylist_t input_arrays, arraylist_t reduced_arrays, int verbose, int dopruning=1, int strength=2, int dolmc=1)


    reduce arrays to canonical form using delete-1-factor ordering

    """
    return _oalib.reduceArraysGWLP(input_arrays, reduced_arrays, verbose, dopruning, strength, dolmc)

def reductionDOP(array, verbose=0):
    r"""
    reductionDOP(array_link array, int verbose=0) -> array_transformation_t


    Caculate the transformation reducing an array to delete-on-factor normal

    The normal form is described in "A canonical form for non-regular arrays based
    on generalized wordlength pattern values of delete-one-factor projections",
    Eendebak, 2014

    Parameters
    ----------
    * `array` :
        Orthogonal array
    * `verbose` :
        Verbosity level

    Returns
    -------
    The transformation that reduces the array to normal form

    """
    return _oalib.reductionDOP(array, verbose)

def reduceDOPform(array, verbose=0):
    r"""
    reduceDOPform(array_link array, int verbose=0) -> array_link


    Reduce an array to canonical form using delete-1-factor ordering

    The normal form is described in "A canonical form for non-regular arrays based
    on generalized wordlength pattern values of delete-one-factor projections",
    Eendebak, 2014

    Parameters
    ----------
    * `array` :
        Orthogonal array
    * `verbose` :
        Verbosity level

    Returns
    -------
    The array transformed to normal form

    """
    return _oalib.reduceDOPform(array, verbose)

def selectUniqueArrays(input_arrays, output_arrays, verbose=1):
    r"""
    selectUniqueArrays(arraylist_t input_arrays, arraylist_t output_arrays, int verbose=1)


    select the unique arrays in a list, the original list is sorted in place. the
    unique arrays are append to the output list

    """
    return _oalib.selectUniqueArrays(input_arrays, output_arrays, verbose)

def projectionDOFvalues(array, verbose=0):
    r"""
    projectionDOFvalues(array_link array, int verbose=0) -> vector_mvalue_t_double


    Calculate projection values for delete-of-factor algorithm

    """
    return _oalib.projectionDOFvalues(array, verbose)

def reduceLMCform(array):
    r"""
    reduceLMCform(array_link array) -> array_link


    reduce an array to canonical form using LMC ordering

    """
    return _oalib.reduceLMCform(array)

def LMCcheckLex(*args):
    r"""
    LMCcheckLex(arraylist_t list, arraydata_t ad, int verbose=0) -> intVector
    LMCcheckLex(array_link array, arraydata_t arrayclass) -> lmc_t


    Perform minimal form check with LMC ordering.

    """
    return _oalib.LMCcheckLex(*args)

def LMCcheckj4(array, arrayclass, reduction, oaextend, jj=4):
    r"""
    LMCcheckj4(array_link array, arraydata_t arrayclass, LMCreduction_t reduction, OAextend oaextend, int jj=4) -> lmc_t


    Perform minimal form check with J4 ordering.

    """
    return _oalib.LMCcheckj4(array, arrayclass, reduction, oaextend, jj)

def LMCcheckj5(array, arrayclass, reduction, oaextend):
    r"""
    LMCcheckj5(array_link array, arraydata_t arrayclass, LMCreduction_t reduction, OAextend oaextend) -> lmc_t


    Perform minimal form check for J5 ordering.

    """
    return _oalib.LMCcheckj5(array, arrayclass, reduction, oaextend)

def print_rowsort(rowsort, N):
    r"""
    print_rowsort(rowsort_t rowsort, int N)


    Print the contents of a rowsort structure.

    Parameters
    ----------
    * `rowsort` :
        Pointer to rowsort structure
    * `N` :
        Number of elements

    """
    return _oalib.print_rowsort(rowsort, N)

def print_column_rowsort(arraycol, rowsort, N):
    r"""
    print_column_rowsort(array_t const * arraycol, rowsort_t rowsort, int N)


    """
    return _oalib.print_column_rowsort(arraycol, rowsort, N)
ISOTOPY = _oalib.ISOTOPY
r""" isotopy: permute rows, columns and symbols"""
MATRIX_ISOMORPHISM = _oalib.MATRIX_ISOMORPHISM
r""" permute rows and columns"""
CONFERENCE_ISOMORPHISM = _oalib.CONFERENCE_ISOMORPHISM
r""" permute rows, columns and to row and column negations (values in 0, +1, -1)"""
OA_ISOMORPHISM = _oalib.OA_ISOMORPHISM
r""" permutations of rows, columns and column symbol permutations"""

def reduceNauty(graph, colors, verbose=0):
    r"""
    reduceNauty(array_link graph, intVector colors, int verbose=0) -> intVector


    Reduce a colored graph to Nauty minimal form

    The transformation returned is from the normal form to the specified graph.

    Parameters
    ----------
    * `graph` :
        Graph in incidence matrix form
    * `colors` :
        Colors of the graph nodes
    * `verbose` :
        Verbosity level

    Returns
    -------
    Relabelling of the graph vertices

    """
    return _oalib.reduceNauty(graph, colors, verbose)

def transformGraph(graph, vertex_permutation, verbose=1):
    r"""transformGraph(array_link graph, intVector vertex_permutation, int verbose=1) -> array_link"""
    return _oalib.transformGraph(graph, vertex_permutation, verbose)

def reduceOAnauty(*args):
    r"""
    reduceOAnauty(array_link array, int verbose=0) -> array_transformation_t
    reduceOAnauty(array_link array, int verbose, arraydata_t arrayclass) -> array_transformation_t
    """
    return _oalib.reduceOAnauty(*args)

def array2graph(*args):
    r"""
    array2graph(array_link array, int verbose=1) -> pairGraphColors
    array2graph(array_link array, int verbose, arraydata_t arrayclass) -> pairGraphColors
    """
    return _oalib.array2graph(*args)

def oagraph2transformation(pp, arrayclass, verbose=1):
    r"""oagraph2transformation(intVector pp, arraydata_t arrayclass, int verbose=1) -> array_transformation_t"""
    return _oalib.oagraph2transformation(pp, arrayclass, verbose)
class depth_path_t(object):
    r"""


    structure containing current position in search tree

    C++ includes: evenodd.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    ncurr = property(_oalib.depth_path_t_ncurr_get, _oalib.depth_path_t_ncurr_set, doc=r"""ncurr : std::vector<(int,std::allocator<(int)>)>""")
    nmax = property(_oalib.depth_path_t_nmax_get, _oalib.depth_path_t_nmax_set, doc=r"""nmax : std::vector<(int,std::allocator<(int)>)>""")
    necols = property(_oalib.depth_path_t_necols_get, _oalib.depth_path_t_necols_set, doc=r"""necols : std::vector<(int,std::allocator<(int)>)>""")
    ngecols = property(_oalib.depth_path_t_ngecols_get, _oalib.depth_path_t_ngecols_set, doc=r"""ngecols : std::vector<(int,std::allocator<(int)>)>""")
    depthstart = property(_oalib.depth_path_t_depthstart_get, _oalib.depth_path_t_depthstart_set, doc=r"""depthstart : int""")

    def __init__(self):
        r"""
        __init__(depth_path_t self) -> depth_path_t


        """
        _oalib.depth_path_t_swiginit(self, _oalib.new_depth_path_t())

    def updatePositionGEC(self, k, goodextensioncols):
        r"""
        updatePositionGEC(depth_path_t self, int k, int goodextensioncols)


        """
        return _oalib.depth_path_t_updatePositionGEC(self, k, goodextensioncols)

    def updatePosition(self, k, c, m, extensioncols, goodextensioncols):
        r"""
        updatePosition(depth_path_t self, int k, int c, int m, int extensioncols, int goodextensioncols)


        """
        return _oalib.depth_path_t_updatePosition(self, k, c, m, extensioncols, goodextensioncols)

    def show(self, depth, maxentries=8):
        r"""
        show(depth_path_t self, int depth, int maxentries=8)


        """
        return _oalib.depth_path_t_show(self, depth, maxentries)

    def init(self, ncols, _depthstart=9):
        r"""
        init(depth_path_t self, int ncols, int _depthstart=9)


        """
        return _oalib.depth_path_t_init(self, ncols, _depthstart)
    __swig_destroy__ = _oalib.delete_depth_path_t

# Register depth_path_t in _oalib:
_oalib.depth_path_t_swigregister(depth_path_t)
CONFERENCE_RESTRICTED_ISOMORPHISM = cvar.CONFERENCE_RESTRICTED_ISOMORPHISM

class counter_t(object):
    r"""


    structure to count and show number of arrays generated, the structure is thread
    safe

    C++ includes: evenodd.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    nfound = property(_oalib.counter_t_nfound_get, _oalib.counter_t_nfound_set, doc=r"""nfound : std::vector<(int,std::allocator<(int)>)>""")

    def __init__(self, n):
        r"""
        __init__(counter_t self, int n) -> counter_t


        """
        _oalib.counter_t_swiginit(self, _oalib.new_counter_t(n))

    def addNfound(self, col, num):
        r"""
        addNfound(counter_t self, int col, int num)


        """
        return _oalib.counter_t_addNfound(self, col, num)

    def nArrays(self):
        r"""
        nArrays(counter_t self) -> long


        """
        return _oalib.counter_t_nArrays(self)

    def clearNumberFound(self):
        r"""
        clearNumberFound(counter_t self)


        """
        return _oalib.counter_t_clearNumberFound(self)

    def addNumberFound(self, *args):
        r"""
        addNumberFound(counter_t self, int n, int k)
        addNumberFound(counter_t self, counter_t de)


        """
        return _oalib.counter_t_addNumberFound(self, *args)

    def showcountscompact(self):
        r"""
        showcountscompact(counter_t self)


        show information about the number of arrays found

        """
        return _oalib.counter_t_showcountscompact(self)

    def showcounts(self, *args):
        r"""
        showcounts(counter_t self, arraydata_t ad)
        showcounts(counter_t self, char const * str, int first, int last)


        show information about the number of arrays found

        """
        return _oalib.counter_t_showcounts(self, *args)
    __swig_destroy__ = _oalib.delete_counter_t

# Register counter_t in _oalib:
_oalib.counter_t_swigregister(counter_t)

class depth_extend_sub_t(object):
    r"""


    Helper structure for dynamic extension

    In this structure we keep track of pointers to valid column extensions

    C++ includes: evenodd.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    lmctype = property(_oalib.depth_extend_sub_t_lmctype_get, _oalib.depth_extend_sub_t_lmctype_set, doc=r"""lmctype : std::vector<(int,std::allocator<(int)>)>""")
    lastcol = property(_oalib.depth_extend_sub_t_lastcol_get, _oalib.depth_extend_sub_t_lastcol_set, doc=r"""lastcol : std::vector<(int,std::allocator<(int)>)>""")
    strengthcheck = property(_oalib.depth_extend_sub_t_strengthcheck_get, _oalib.depth_extend_sub_t_strengthcheck_set, doc=r"""strengthcheck : std::vector<(double,std::allocator<(double)>)>""")
    valididx = property(_oalib.depth_extend_sub_t_valididx_get, _oalib.depth_extend_sub_t_valididx_set, doc=r"""valididx : std::vector<(int,std::allocator<(int)>)>""")
    verbose = property(_oalib.depth_extend_sub_t_verbose_get, _oalib.depth_extend_sub_t_verbose_set, doc=r"""verbose : int""")

    def __init__(self, nn=0):
        r"""
        __init__(depth_extend_sub_t self, int nn=0) -> depth_extend_sub_t


        """
        _oalib.depth_extend_sub_t_swiginit(self, _oalib.new_depth_extend_sub_t(nn))

    def resize(self, nn):
        r"""
        resize(depth_extend_sub_t self, int nn)


        """
        return _oalib.depth_extend_sub_t_resize(self, nn)

    def n(self):
        r"""
        n(depth_extend_sub_t self) -> size_t


        """
        return _oalib.depth_extend_sub_t_n(self)

    def updateExtensionPointers(self, extcol):
        r"""
        updateExtensionPointers(depth_extend_sub_t self, int extcol) -> intVector


        """
        return _oalib.depth_extend_sub_t_updateExtensionPointers(self, extcol)

    def initialize(self, alist, adf, oaextend):
        r"""
        initialize(depth_extend_sub_t self, arraylist_t alist, arraydata_t adf, OAextend oaextend) -> arraylist_t


        initialize the new list of extension columns

        """
        return _oalib.depth_extend_sub_t_initialize(self, alist, adf, oaextend)

    def selectArraysZ(self, alist):
        r"""
        selectArraysZ(depth_extend_sub_t self, arraylist_t alist) -> arraylist_t


        select the arrays with are LMC and hence need to be written to disk

        """
        return _oalib.depth_extend_sub_t_selectArraysZ(self, alist)

    def selectArraysXX(self, al, elist):
        r"""
        selectArraysXX(depth_extend_sub_t self, array_link al, arraylist_t elist) -> arraylist_t


        """
        return _oalib.depth_extend_sub_t_selectArraysXX(self, al, elist)

    def info(self):
        r"""
        info(depth_extend_sub_t self)


        """
        return _oalib.depth_extend_sub_t_info(self)
    __swig_destroy__ = _oalib.delete_depth_extend_sub_t

# Register depth_extend_sub_t in _oalib:
_oalib.depth_extend_sub_t_swigregister(depth_extend_sub_t)

class depth_extend_t(object):
    r"""


    Helper structure for dynamic extension.

    This structure allows for writing the generated arrays to disk. It also contains
    functions to print progress of the extension.

    Multiple copies of this class are made, but they all share the same counter_t
    and arraywriter_t object. Also t0 and tp are shared

    C++ includes: evenodd.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    verbose = property(_oalib.depth_extend_t_verbose_get, _oalib.depth_extend_t_verbose_set, doc=r"""verbose : int""")
    oaextend = property(_oalib.depth_extend_t_oaextend_get, _oalib.depth_extend_t_oaextend_set, doc=r"""oaextend : OAextend""")
    ad = property(_oalib.depth_extend_t_ad_get, _oalib.depth_extend_t_ad_set, doc=r"""ad : p.q(const).arraydata_t""")
    loglevelcol = property(_oalib.depth_extend_t_loglevelcol_get, _oalib.depth_extend_t_loglevelcol_set, doc=r"""loglevelcol : int""")
    logtime = property(_oalib.depth_extend_t_logtime_get, _oalib.depth_extend_t_logtime_set, doc=r"""logtime : double""")
    extension_column_list = property(_oalib.depth_extend_t_extension_column_list_get, _oalib.depth_extend_t_extension_column_list_set, doc=r"""extension_column_list : arraylist_t""")
    writearrays = property(_oalib.depth_extend_t_writearrays_get, _oalib.depth_extend_t_writearrays_set, doc=r"""writearrays : int""")
    discardJ5 = property(_oalib.depth_extend_t_discardJ5_get, _oalib.depth_extend_t_discardJ5_set, doc=r"""discardJ5 : int""")
    discardJ5number = property(_oalib.depth_extend_t_discardJ5number_get, _oalib.depth_extend_t_discardJ5number_set, doc=r"""discardJ5number : long""")
    arraywriter = property(_oalib.depth_extend_t_arraywriter_get, _oalib.depth_extend_t_arraywriter_set, doc=r"""arraywriter : p.arraywriter_t""")
    counter = property(_oalib.depth_extend_t_counter_get, _oalib.depth_extend_t_counter_set, doc=r"""counter : p.counter_t""")
    t0 = property(_oalib.depth_extend_t_t0_get, _oalib.depth_extend_t_t0_set, doc=r"""t0 : double""")
    tp = property(_oalib.depth_extend_t_tp_get, _oalib.depth_extend_t_tp_set, doc=r"""tp : double""")

    def __init__(self, *args):
        r"""
        __init__(depth_extend_t self, arraydata_t ad_, double _logtime=10000000, int _discardJ5=-1) -> depth_extend_t
        __init__(depth_extend_t self, depth_extend_t de) -> depth_extend_t


        """
        _oalib.depth_extend_t_swiginit(self, _oalib.new_depth_extend_t(*args))
    __swig_destroy__ = _oalib.delete_depth_extend_t

    def show(self):
        r"""
        show(depth_extend_t self)


        """
        return _oalib.depth_extend_t_show(self)

    def setNarraysMax(self, n):
        r"""
        setNarraysMax(depth_extend_t self, long n)


        """
        return _oalib.depth_extend_t_setNarraysMax(self, n)

    def maxArrayCheck(self):
        r"""
        maxArrayCheck(depth_extend_t self)


        """
        return _oalib.depth_extend_t_maxArrayCheck(self)

    def showsearchpath(self, depth):
        r"""
        showsearchpath(depth_extend_t self, int depth)


        """
        return _oalib.depth_extend_t_showsearchpath(self, depth)

    def showprogress(self, showtime=1, depth=0, forcelog=0):
        r"""
        showprogress(depth_extend_t self, int showtime=1, int depth=0, int forcelog=0) -> bool


        show information about the progress of the loop

        """
        return _oalib.depth_extend_t_showprogress(self, showtime, depth, forcelog)

    def info(self):
        r"""
        info(depth_extend_t self)


        """
        return _oalib.depth_extend_t_info(self)

    def setposition(self, k, c, m, extensioncols=-1, goodextensioncols=-1):
        r"""
        setposition(depth_extend_t self, int k, int c, int m, int extensioncols=-1, int goodextensioncols=-1)


        set the position in the dextend structure

        """
        return _oalib.depth_extend_t_setposition(self, k, c, m, extensioncols, goodextensioncols)

    def setpositionGEC(self, k, goodextensioncols):
        r"""
        setpositionGEC(depth_extend_t self, int k, int goodextensioncols)


        set the position in the dextend structure

        """
        return _oalib.depth_extend_t_setpositionGEC(self, k, goodextensioncols)

# Register depth_extend_t in _oalib:
_oalib.depth_extend_t_swigregister(depth_extend_t)

DEPTH_DIRECT = _oalib.DEPTH_DIRECT

DEPTH_EXTENSIONS = _oalib.DEPTH_EXTENSIONS

class depth_extensions_storage_t(object):
    r"""


    Helper structure for the even-odd depth extension.

    C++ includes: evenodd.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def resize(self, s):
        r"""
        resize(depth_extensions_storage_t self, size_t s)


        """
        return _oalib.depth_extensions_storage_t_resize(self, s)

    def set(self, ai, goodarrays, extension_column_list, depthalg, dextendsub):
        r"""
        set(depth_extensions_storage_t self, int ai, arraylist_t goodarrays, arraylist_t extension_column_list, depth_alg_t depthalg, depth_extend_sub_t dextendsub)


        """
        return _oalib.depth_extensions_storage_t_set(self, ai, goodarrays, extension_column_list, depthalg, dextendsub)
    columnextensionsList = property(_oalib.depth_extensions_storage_t_columnextensionsList_get, _oalib.depth_extensions_storage_t_columnextensionsList_set, doc=r"""columnextensionsList : std::vector<(arraylist_t,std::allocator<(arraylist_t)>)>""")
    goodarrayslist = property(_oalib.depth_extensions_storage_t_goodarrayslist_get, _oalib.depth_extensions_storage_t_goodarrayslist_set, doc=r"""goodarrayslist : std::vector<(arraylist_t,std::allocator<(arraylist_t)>)>""")
    depthalglist = property(_oalib.depth_extensions_storage_t_depthalglist_get, _oalib.depth_extensions_storage_t_depthalglist_set, doc=r"""depthalglist : std::vector<(depth_alg_t,std::allocator<(depth_alg_t)>)>""")
    dextendsubList = property(_oalib.depth_extensions_storage_t_dextendsubList_get, _oalib.depth_extensions_storage_t_dextendsubList_set, doc=r"""dextendsubList : std::vector<(depth_extend_sub_t,std::allocator<(depth_extend_sub_t)>)>""")

    def __init__(self):
        r"""
        __init__(depth_extensions_storage_t self) -> depth_extensions_storage_t


        Helper structure for the even-odd depth extension.

        C++ includes: evenodd.h

        """
        _oalib.depth_extensions_storage_t_swiginit(self, _oalib.new_depth_extensions_storage_t())
    __swig_destroy__ = _oalib.delete_depth_extensions_storage_t

# Register depth_extensions_storage_t in _oalib:
_oalib.depth_extensions_storage_t_swigregister(depth_extensions_storage_t)


def processDepth(goodarrays, depthalg, dextend, dextendsublight, extensioncol, verbose=0):
    r"""
    processDepth(arraylist_t goodarrays, depth_alg_t depthalg, depth_extend_t dextend, depth_extend_sub_t dextendsublight, int extensioncol, int verbose=0)


    Extend arrays using a depth-first or breadth-first approach

    Parameters
    ----------
    * `goodarrays` :
        List of arrays to extend
    * `depthalg` :
        Extend using depth-first or breadth-first
    * `dextend` :
        Option structure for the extension
    * `dextendsublight` :
        Data structure for the extensions
    * `extensioncol` :
        Column to extend
    * `verbose` :
        Verbosity level

    """
    return _oalib.processDepth(goodarrays, depthalg, dextend, dextendsublight, extensioncol, verbose)

def depth_extend_hybrid(alist, dextend, extcol, oaextendx, verbose):
    r"""
    depth_extend_hybrid(arraylist_t alist, depth_extend_t dextend, int extcol, OAextend oaextendx, int verbose)


    depth-first extension of arrays. depending on the symmetry group of the array to
    be extended a direct method is used or a method with caching of candidate
    columns

    """
    return _oalib.depth_extend_hybrid(alist, dextend, extcol, oaextendx, verbose)

def depth_extend_direct(alist, dextend, extcol, oaextendx, verbose):
    r"""
    depth_extend_direct(arraylist_t alist, depth_extend_t dextend, int extcol, OAextend oaextendx, int verbose)


    variation of depth_extend for arrays with large symmetry groups

    """
    return _oalib.depth_extend_direct(alist, dextend, extcol, oaextendx, verbose)

def depth_extend_array(al, dextend, adfull, verbose, ds=None, arg6=0):
    r"""
    depth_extend_array(array_link al, depth_extend_t dextend, arraydata_t adfull, int verbose, depth_extensions_storage_t ds=None, int arg6=0)


    depth extend a single array

    """
    return _oalib.depth_extend_array(al, dextend, adfull, verbose, ds, arg6)

def addArraysToPareto(*args):
    r"""
    addArraysToPareto(Pareto< mvalue_t< long >,array_link > & pset, pareto_cb paretofunction, arraylist_t arraylist, int jj, int verbose)
    addArraysToPareto(Pareto< mvalue_t< long >,array_link > & pset, pareto_cb_cache paretofunction, arraylist_t arraylist, int jj, int verbose)


    add arrays to set of Pareto results

    """
    return _oalib.addArraysToPareto(*args)
class jindex_t(object):
    r"""


    helper class for indexing statistics of designs

    The index consists of the number of columns and the value for the
    J-characteristic

    C++ includes: evenodd.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    k = property(_oalib.jindex_t_k_get, _oalib.jindex_t_k_set, doc=r"""k : int""")
    j = property(_oalib.jindex_t_j_get, _oalib.jindex_t_j_set, doc=r"""j : int""")

    def __init__(self, colindex, jvalue):
        r"""
        __init__(jindex_t self, int colindex, int jvalue) -> jindex_t


        """
        _oalib.jindex_t_swiginit(self, _oalib.new_jindex_t(colindex, jvalue))

    def __lt__(self, rhs):
        r"""__lt__(jindex_t self, jindex_t rhs) -> bool"""
        return _oalib.jindex_t___lt__(self, rhs)

    def toString(self):
        r"""
        toString(jindex_t self) -> std::string


        """
        return _oalib.jindex_t_toString(self)
    __swig_destroy__ = _oalib.delete_jindex_t

# Register jindex_t in _oalib:
_oalib.jindex_t_swigregister(jindex_t)

class Jcounter(object):
    r"""


    object to hold counts of maximum J_k-values

    C++ includes: evenodd.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    N = property(_oalib.Jcounter_N_get, _oalib.Jcounter_N_set, doc=r"""N : int""")
    jj = property(_oalib.Jcounter_jj_get, _oalib.Jcounter_jj_set, doc=r"""jj : int""")
    fvals = property(_oalib.Jcounter_fvals_get, _oalib.Jcounter_fvals_set, doc=r"""fvals : std::vector<(int,std::allocator<(int)>)>""")
    maxJcounts = property(_oalib.Jcounter_maxJcounts_get, _oalib.Jcounter_maxJcounts_set, doc=r"""maxJcounts : std::map<(jindex_t,long,std::less<(jindex_t)>,std::allocator<(std::pair<(q(const).jindex_t,long)>)>)>""")
    dt = property(_oalib.Jcounter_dt_get, _oalib.Jcounter_dt_set, doc=r"""dt : double""")

    def __init__(self, *args):
        r"""
        __init__(Jcounter self) -> Jcounter
        __init__(Jcounter self, int N, int jj=5, int k=-1) -> Jcounter


        """
        _oalib.Jcounter_swiginit(self, _oalib.new_Jcounter(*args))

    def validData(self):
        r"""
        validData(Jcounter self) -> bool


        """
        return _oalib.Jcounter_validData(self)

    def hasColumn(self, col):
        r"""
        hasColumn(Jcounter self, int col) -> bool


        return true if specified column is in the data

        """
        return _oalib.Jcounter_hasColumn(self, col)

    def isOpen(self):
        r"""
        isOpen(Jcounter self) -> bool


        """
        return _oalib.Jcounter_isOpen(self)

    def showPerformance(self):
        r"""
        showPerformance(Jcounter self)


        """
        return _oalib.Jcounter_showPerformance(self)

    def narrays(self):
        r"""
        narrays(Jcounter self) -> long


        """
        return _oalib.Jcounter_narrays(self)

    def show(self):
        r"""
        show(Jcounter self)


        show statistics of the object

        """
        return _oalib.Jcounter_show(self)

    def maxCols(self):
        r"""
        maxCols(Jcounter self) -> int


        """
        return _oalib.Jcounter_maxCols(self)

    def getCount(self, k, j):
        r"""
        getCount(Jcounter self, int k, int j) -> long


        """
        return _oalib.Jcounter_getCount(self, k, j)

    def getTotalsJvalue(self, jval):
        r"""
        getTotalsJvalue(Jcounter self, int jval) -> longVector


        """
        return _oalib.Jcounter_getTotalsJvalue(self, jval)

    def getTotals(self):
        r"""
        getTotals(Jcounter self) -> longVector


        """
        return _oalib.Jcounter_getTotals(self)

    def showcompact(self):
        r"""
        showcompact(Jcounter self)


        show statistics of the object

        """
        return _oalib.Jcounter_showcompact(self)

    def __iadd__(self, jc):
        r"""__iadd__(Jcounter self, Jcounter jc) -> Jcounter"""
        return _oalib.Jcounter___iadd__(self, jc)

    def addArrays(self, arraylist, verbose=0):
        r"""
        addArrays(Jcounter self, arraylist_t arraylist, int verbose=0)


        add list of arrays to object

        """
        return _oalib.Jcounter_addArrays(self, arraylist, verbose)

    def addArray(self, al, verbose=0):
        r"""
        addArray(Jcounter self, array_link al, int verbose=0)


        add single array to statistics object

        """
        return _oalib.Jcounter_addArray(self, al, verbose)
    __swig_destroy__ = _oalib.delete_Jcounter

# Register Jcounter in _oalib:
_oalib.Jcounter_swigregister(Jcounter)


def readStatisticsFile(numbersfile, verbose):
    r"""
    readStatisticsFile(char const * numbersfile, int verbose) -> Jcounter


    read statistics object from disk

    """
    return _oalib.readStatisticsFile(numbersfile, verbose)

def writeStatisticsFile(numbersfile, jc, verbose):
    r"""
    writeStatisticsFile(char const * numbersfile, Jcounter jc, int verbose)


    write statistics object to disk

    """
    return _oalib.writeStatisticsFile(numbersfile, jc, verbose)

def calculateJstatistics(afile, jj=5, verbose=1):
    r"""
    calculateJstatistics(char const * afile, int jj=5, int verbose=1) -> Jcounter


    calculate J-value statistics

    """
    return _oalib.calculateJstatistics(afile, jj, verbose)

def compareJ54(lhs, rhs):
    r"""
    compareJ54(array_link lhs, array_link rhs) -> int


    Return -1 if the first array is smaller in J54 ordering than the second array, 0
    if equal and 1 otherwise

    """
    return _oalib.compareJ54(lhs, rhs)

def print_column(column, msg=None):
    r"""
    print_column(charVector column, char const * msg=None)


    print a candidate extension

    """
    return _oalib.print_column(column, msg)

def showCandidates(column_candidates):
    r"""
    showCandidates(conference_columnVector column_candidates)


    Show a list of candidate extensions

    Parameters
    ----------
    * `column_candidates` :
        List of candidates to show

    """
    return _oalib.showCandidates(column_candidates)

def conference2DSD(conference_design, add_zeros=True):
    r"""
    conference2DSD(array_link conference_design, bool add_zeros=True) -> array_link


    Convert conference design to definitive screening design

    The DSD is created by appending the negated design to the conference design and
    then appending a row of zeros.

    Parameters
    ----------
    * `conference_design` :
        Array with the conference design
    * `add_zeros` :
        If True, then append a row of zeros

    Returns
    -------
    The DSD generated from the conference design

    """
    return _oalib.conference2DSD(conference_design, add_zeros)
class conference_t(object):
    r"""


    Structure representing the type of conference designs.

    C++ includes: conference.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    N = property(_oalib.conference_t_N_get, _oalib.conference_t_N_set, doc=r"""N : rowindex_t""")
    ncols = property(_oalib.conference_t_ncols_get, _oalib.conference_t_ncols_set, doc=r"""ncols : colindex_t""")
    CONFERENCE_NORMAL = _oalib.conference_t_CONFERENCE_NORMAL
    r""" normal conference design"""
    CONFERENCE_DIAGONAL = _oalib.conference_t_CONFERENCE_DIAGONAL
    r""" conference design with zeros only on diagonal"""
    DCONFERENCE = _oalib.conference_t_DCONFERENCE
    r""" double conference design"""
    ctype = property(_oalib.conference_t_ctype_get, _oalib.conference_t_ctype_set, doc=r"""ctype : conference_t::conference_type""")
    itype = property(_oalib.conference_t_itype_get, _oalib.conference_t_itype_set, doc=r"""itype : matrix_isomorphism_t""")
    j1zero = property(_oalib.conference_t_j1zero_get, _oalib.conference_t_j1zero_set, doc=r"""j1zero : bool""")
    j3zero = property(_oalib.conference_t_j3zero_get, _oalib.conference_t_j3zero_set, doc=r"""j3zero : bool""")

    def __init__(self, *args):
        r"""
        __init__(conference_t self) -> conference_t
        __init__(conference_t self, int N, int k, int j1zero) -> conference_t
        __init__(conference_t self, conference_t rhs) -> conference_t


        Structure representing the type of conference designs

        """
        _oalib.conference_t_swiginit(self, _oalib.new_conference_t(*args))

    def idstr(self):
        r"""
        idstr(conference_t self) -> std::string


        """
        return _oalib.conference_t_idstr(self)

    def create_root(self):
        r"""
        create_root(conference_t self) -> array_link


        create the unique representative of the 2 column conference design in LMC0 form

        """
        return _oalib.conference_t_create_root(self)

    def create_root_three_columns(self):
        r"""
        create_root_three_columns(conference_t self) -> array_link


        create the unique representative of the 3 column conference design in LMC0 form

        """
        return _oalib.conference_t_create_root_three_columns(self)

    def createDoubleConferenceRootArrays(self):
        r"""
        createDoubleConferenceRootArrays(conference_t self) -> arraylist_t


        create the root arrays with 1 column for the double conference matrices

        """
        return _oalib.conference_t_createDoubleConferenceRootArrays(self)

    def createRootArrays(self):
        r"""
        createRootArrays(conference_t self) -> arraylist_t


        return the list of root arrays for the class of conference designs

        """
        return _oalib.conference_t_createRootArrays(self)

    def __repr__(self):
        r"""
        __repr__(conference_t self) -> std::string


        return string representation of the object

        """
        return _oalib.conference_t___repr__(self)
    __swig_destroy__ = _oalib.delete_conference_t

# Register conference_t in _oalib:
_oalib.conference_t_swigregister(conference_t)


def reduceConference(arg1, verbose=0):
    r"""
    reduceConference(array_link arg1, int verbose=0) -> array_link


    Reduce conference matrix to normal form using Nauty

    See also: reduceConferenceTransformation

    """
    return _oalib.reduceConference(arg1, verbose)

def reduceConferenceTransformation(conference_design, verbose):
    r"""
    reduceConferenceTransformation(array_link conference_design, int verbose) -> conference_transformation_t


    Reduce conference matrix to normal form using Nauty

    The design is converted to a graph representation. The graph is then reduced
    using Nauty to normal form and the resulting graph translated back to a
    conference design.

    Parameters
    ----------
    * `conference_design` :
        Design to be reduced to normal form
    * `verbose` :
        Verbosity level

    Returns
    -------
    A transformation that converts the input design to normal form

    """
    return _oalib.reduceConferenceTransformation(conference_design, verbose)
class CandidateGeneratorBase(object):
    r"""


    Class to generate candidate extensions with caching

    We assume that the designs to be extended are run ordered, so that the caching
    has maximal effect.

    The key idea used is that any valid extension of a design A with k columns is a
    permutation of a valid extension of the design B obtained by taking the first l
    < k columns of A. The permutations that are allowed are called the symmetry
    inflations. All the j2 checks performed for the extension of B do not have to be
    repeated for the permutations of this extension.

    C++ includes: conference.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    ct = property(_oalib.CandidateGeneratorBase_ct_get, _oalib.CandidateGeneratorBase_ct_set, doc=r"""ct : conference_t""")
    verbose = property(_oalib.CandidateGeneratorBase_verbose_get, _oalib.CandidateGeneratorBase_verbose_set, doc=r"""verbose : int""")
    al = property(_oalib.CandidateGeneratorBase_al_get, _oalib.CandidateGeneratorBase_al_set, doc=r"""al : array_link""")
    last_valid = property(_oalib.CandidateGeneratorBase_last_valid_get, _oalib.CandidateGeneratorBase_last_valid_set, doc=r"""last_valid : int""")

    def __init__(self, al, ct):
        r"""
        __init__(CandidateGeneratorBase self, array_link al, conference_t ct) -> CandidateGeneratorBase


        """
        _oalib.CandidateGeneratorBase_swiginit(self, _oalib.new_CandidateGeneratorBase(al, ct))

    def showCandidates(self, verbose=1):
        r"""
        showCandidates(CandidateGeneratorBase self, int verbose=1)


        Show the candidate extensions for each column

        """
        return _oalib.CandidateGeneratorBase_showCandidates(self, verbose)

    def candidates(self, k):
        r"""
        candidates(CandidateGeneratorBase self, int k) -> conference_columnVector


        return all candidates for the kth column

        """
        return _oalib.CandidateGeneratorBase_candidates(self, k)
    __swig_destroy__ = _oalib.delete_CandidateGeneratorBase

# Register CandidateGeneratorBase in _oalib:
_oalib.CandidateGeneratorBase_swigregister(CandidateGeneratorBase)

class CandidateGeneratorConference(CandidateGeneratorBase):
    r"""


    Class to generate conference candidate extensions.

    C++ includes: conference.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, al, ct):
        r"""
        __init__(CandidateGeneratorConference self, array_link al, conference_t ct) -> CandidateGeneratorConference


        """
        _oalib.CandidateGeneratorConference_swiginit(self, _oalib.new_CandidateGeneratorConference(al, ct))

    def generateCandidates(self, al):
        r"""
        generateCandidates(CandidateGeneratorConference self, array_link al) -> conference_columnVector


        Generate a list of candidate extensions for the specified design.

        """
        return _oalib.CandidateGeneratorConference_generateCandidates(self, al)

    def generateCandidatesZero(self, al, kz):
        r"""
        generateCandidatesZero(CandidateGeneratorConference self, array_link al, int kz) -> conference_columnVector


        generate all candidate extensions with a zero at the specified position

        """
        return _oalib.CandidateGeneratorConference_generateCandidatesZero(self, al, kz)
    __swig_destroy__ = _oalib.delete_CandidateGeneratorConference

# Register CandidateGeneratorConference in _oalib:
_oalib.CandidateGeneratorConference_swigregister(CandidateGeneratorConference)

class CandidateGeneratorDouble(CandidateGeneratorBase):
    r"""


    Class to generate double conference candidate extensions with caching.

    C++ includes: conference.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, al, ct):
        r"""
        __init__(CandidateGeneratorDouble self, array_link al, conference_t ct) -> CandidateGeneratorDouble


        """
        _oalib.CandidateGeneratorDouble_swiginit(self, _oalib.new_CandidateGeneratorDouble(al, ct))

    def generateCandidates(self, al):
        r"""
        generateCandidates(CandidateGeneratorDouble self, array_link al) -> conference_columnVector


        Generate a list of candidate extensions for the specified design

        This method uses symmetry inflation, assumes j1=0 and j2=0. Optimal performance
        is achieved when the arrays to be extended have identical first columns.

        """
        return _oalib.CandidateGeneratorDouble_generateCandidates(self, al)
    __swig_destroy__ = _oalib.delete_CandidateGeneratorDouble

# Register CandidateGeneratorDouble in _oalib:
_oalib.CandidateGeneratorDouble_swigregister(CandidateGeneratorDouble)

class conference_extend_t(object):
    r"""


    Helper structure containing extensions of conference designs

    C++ includes: conference.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    first = property(_oalib.conference_extend_t_first_get, _oalib.conference_extend_t_first_set, doc=r"""first : std::vector<(conference_column,std::allocator<(conference_column)>)>""")
    second = property(_oalib.conference_extend_t_second_get, _oalib.conference_extend_t_second_set, doc=r"""second : std::vector<(conference_column,std::allocator<(conference_column)>)>""")
    extensions = property(_oalib.conference_extend_t_extensions_get, _oalib.conference_extend_t_extensions_set, doc=r"""extensions : std::vector<(conference_column,std::allocator<(conference_column)>)>""")

    def combine(self, i, j):
        r"""
        combine(conference_extend_t self, int i, int j) -> charVector


        list of candidate extensions

        """
        return _oalib.conference_extend_t_combine(self, i, j)

    def nExtensions(self):
        r"""
        nExtensions(conference_extend_t self) -> size_t


        """
        return _oalib.conference_extend_t_nExtensions(self)

    def getarrays(self, al):
        r"""
        getarrays(conference_extend_t self, array_link al) -> arraylist_t


        return the set of extension arrays

        """
        return _oalib.conference_extend_t_getarrays(self, al)

    def __init__(self):
        r"""
        __init__(conference_extend_t self) -> conference_extend_t


        Helper structure containing extensions of conference designs

        C++ includes: conference.h

        """
        _oalib.conference_extend_t_swiginit(self, _oalib.new_conference_extend_t())
    __swig_destroy__ = _oalib.delete_conference_extend_t

# Register conference_extend_t in _oalib:
_oalib.conference_extend_t_swigregister(conference_extend_t)


def extend_conference_matrix(design, conference_type, extcol, verbose=1, maxzpos=-1):
    r"""
    extend_conference_matrix(array_link design, conference_t conference_type, int extcol, int verbose=1, int maxzpos=-1) -> conference_extend_t


    Extend a single conference design with candidate columns

    Parameters
    ----------
    * `design` :
        Conference design
    * `conference_type` :
        Type specification for the conference designs
    * `extcol` :
        Index of column to generate extensions for
    * `verbose` :
        Verbosity level
    * `maxzpos` :
        Maximum position of zero in specified design

    Returns
    -------
    Structure with information about the possible extensions

    """
    return _oalib.extend_conference_matrix(design, conference_type, extcol, verbose, maxzpos)

def extend_conference(lst, conference_type, verbose, select_isomorphism_classes=0):
    r"""
    extend_conference(arraylist_t lst, conference_t conference_type, int verbose, int select_isomorphism_classes=0) -> arraylist_t


    Extend a list of conference designs with a single column.

    The list of conference designs is extended by adding to each design the
    candidate extentions generated by CandidateGenerator.

    Parameters
    ----------
    * `lst` :
        List of conference designs
    * `conference_type` :
        Type specification for the conference designs
    * `verbose` :
        Verbosity level
    * `select_isomorphism_classes` :
        If True then select only a single design for each isomorphism class
        specified by the conference type.

    Returns
    -------
    List of generated conference designs

    The extension algorithm tries to generate designs in LMC0 normal form and prunes
    any designs that are not in LMC0 form.

    """
    return _oalib.extend_conference(lst, conference_type, verbose, select_isomorphism_classes)

def extend_conference_plain(lst, conference_type, verbose, select_isomorphism_classes=0):
    r"""
    extend_conference_plain(arraylist_t lst, conference_t conference_type, int verbose, int select_isomorphism_classes=0) -> arraylist_t


    Extend a list of conference designs with a single column, plain version without
    caching

    Research function.

    """
    return _oalib.extend_conference_plain(lst, conference_type, verbose, select_isomorphism_classes)

def extend_conference_restricted(lst, conference_type, verbose):
    r"""
    extend_conference_restricted(arraylist_t lst, conference_t conference_type, int verbose) -> arraylist_t


    Extend a list of conference designs with a single column

    Research function.

    """
    return _oalib.extend_conference_restricted(lst, conference_type, verbose)

def extend_double_conference(lst, conference_type, verbose):
    r"""
    extend_double_conference(arraylist_t lst, conference_t conference_type, int verbose) -> arraylist_t


    Extend a list of double conference matrices with an additional column

    The list of designs is extended by adding each design with the candidate
    extentions generated by CandidateGeneratorDouble.

    Parameters
    ----------
    * `lst` :
        List of double conference designs
    * `conference_type` :
        Type specification for the double conference designs
    * `verbose` :
        Verbosity level

    Returns
    -------
    List of generated double conference designs

    """
    return _oalib.extend_double_conference(lst, conference_type, verbose)

def selectConferenceIsomorpismClasses(list, verbose, itype=CONFERENCE_ISOMORPHISM):
    r"""
    selectConferenceIsomorpismClasses(arraylist_t list, int verbose, matrix_isomorphism_t itype=CONFERENCE_ISOMORPHISM) -> arraylist_t


    Select representatives for the isomorphism classes of a list of conference
    arrays

    The method uses Nauty for reduction to normal form and selection of isomorphism
    classes.

    Parameters
    ----------
    * `list` :
        List of designs
    * `verbose` :
        Verbosity level
    * `itype` :
        Specification of the type of isomorphism to use

    Returns
    -------
    Selected isomorphism classes

    """
    return _oalib.selectConferenceIsomorpismClasses(list, verbose, itype)

def selectConferenceIsomorpismIndices(lst, verbose, itype=CONFERENCE_ISOMORPHISM):
    r"""
    selectConferenceIsomorpismIndices(arraylist_t lst, int verbose, matrix_isomorphism_t itype=CONFERENCE_ISOMORPHISM) -> intVector


    select representatives for the isomorphism classes of a list of conference
    arrays, return indices of classes

    """
    return _oalib.selectConferenceIsomorpismIndices(lst, verbose, itype)

def selectLMC0doubleconference(list, verbose, ctype):
    r"""
    selectLMC0doubleconference(arraylist_t list, int verbose, conference_t ctype) -> arraylist_t


    Select double conference designs in LMC0 form

    Parameters
    ----------
    * `list` :
        List of double conference designs
    * `verbose` :
        Verbosity level
    * `ctype` :
        Specifiation of the class of designs

    Returns
    -------
    List with only the designs in the input list that are in LMC0 normal form.

    """
    return _oalib.selectLMC0doubleconference(list, verbose, ctype)

def selectLMC0(list, verbose, ctype):
    r"""
    selectLMC0(arraylist_t list, int verbose, conference_t ctype) -> arraylist_t


    Select conference designs in LMC0 form

    Parameters
    ----------
    * `list` :
        List of conference designs
    * `verbose` :
        Verbosity level
    * `ctype` :
        Specification of the class of designs

    Returns
    -------
    List with only the designs in the input list that are in LMC0 normal form.

    """
    return _oalib.selectLMC0(list, verbose, ctype)

def generateConferenceExtensions(array, conference_type, zero_index, verbose=1, filter_symmetry=1, filterj2=1):
    r"""
    generateConferenceExtensions(array_link array, conference_t conference_type, int zero_index, int verbose=1, int filter_symmetry=1, int filterj2=1) -> conference_columnVector


    Generate candidate extensions for a conference design

    Parameters
    ----------
    * `array` :
        Design to be extended
    * `conference_type` :
        Class of conference designs
    * `zero_index` :
        Index of zero in candidate column
    * `verbose` :
        Verbosity level
    * `filter_symmetry` :
        If True, filter based on symmetry
    * `filterj2` :
        If True, filter based on J2 values

    Returns
    -------
    List of generated extensions

    """
    return _oalib.generateConferenceExtensions(array, conference_type, zero_index, verbose, filter_symmetry, filterj2)

def generateConferenceRestrictedExtensions(array, conference_type, zero_index, verbose=1, filter_symmetry=1, filterip=1):
    r"""
    generateConferenceRestrictedExtensions(array_link array, conference_t conference_type, int zero_index, int verbose=1, int filter_symmetry=1, int filterip=1) -> conference_columnVector


    Generate candidate extensions for restricted isomorphism classes

    """
    return _oalib.generateConferenceRestrictedExtensions(array, conference_type, zero_index, verbose, filter_symmetry, filterip)

def generateDoubleConferenceExtensions(array, conference_type, verbose=1, filter_symmetry=1, filterip=1, filterJ3=0, filter_symmetry_inline=1):
    r"""
    generateDoubleConferenceExtensions(array_link array, conference_t conference_type, int verbose=1, int filter_symmetry=1, int filterip=1, int filterJ3=0, int filter_symmetry_inline=1) -> conference_columnVector


    generate extensions for double conference matrices in LMC0 form

    """
    return _oalib.generateDoubleConferenceExtensions(array, conference_type, verbose, filter_symmetry, filterip, filterJ3, filter_symmetry_inline)

def generateSingleConferenceExtensions(array, conference_type, zero_index, verbose, filter_symmetry, filterj2, filterj3, filter_symmetry_inline=0):
    r"""
    generateSingleConferenceExtensions(array_link array, conference_t conference_type, int zero_index, int verbose, int filter_symmetry, int filterj2, int filterj3, int filter_symmetry_inline=0) -> conference_columnVector


    generate extensions for conference matrices in LMC0 form

    The the method assumes that the input array is in LMC0 format. In particular,
    the element at row 0 and column 0 of the design should be a zero.

    Parameters
    ----------
    * `array` :
        Design to generate extensions for
    * `conference_type` :
        Specification of the type of designs
    * `zero_index` :
        Passed to checkZeroPosition to determine whether a zero in the extension
        column is in a valid position
    * `verbose` :
        Verbosity level
    * `filter_symmetry` :
        If True than reject extensions which are not minimal according to the row
        symmetry group of the specified design
    * `filterj2` :
        If True than reject extensions which do not satisfy the J2 criterea
    * `filterj3` :
        If True than reject extensions which do not satisfy the J3 criterea
    * `filter_symmetry_inline` :
        Quick rejection of extensions which do not satisfy the symmetry criterion.

    Returns
    -------
    List of extensions of the design

    """
    return _oalib.generateSingleConferenceExtensions(array, conference_type, zero_index, verbose, filter_symmetry, filterj2, filterj3, filter_symmetry_inline)

def maxz(al, column_index=-1):
    r"""
    maxz(array_link al, int column_index=-1) -> int


    return max position of zero in array, returns -1 if no zero is found

    The parameter k specifies the column to search in. For k=-1 all columns are
    searched.

    """
    return _oalib.maxz(al, column_index)

def compareLMC0(array_first, array_second):
    r"""
    compareLMC0(array_link array_first, array_link array_second) -> bool


    Return true if the first array is smaller in LMC-0 ordering than the second
    array

    """
    return _oalib.compareLMC0(array_first, array_second)

def sortLMC0(arrays):
    r"""
    sortLMC0(arraylist_t arrays) -> arraylist_t


    sort list of conference designs according to LMC0 ordering

    """
    return _oalib.sortLMC0(arrays)

def LMC0checkDC(al, verbose=0):
    r"""
    LMC0checkDC(array_link al, int verbose=0) -> lmc_t


    """
    return _oalib.LMC0checkDC(al, verbose)

def LMC0check(array, verbose=0):
    r"""
    LMC0check(array_link array, int verbose=0) -> lmc_t


    """
    return _oalib.LMC0check(array, verbose)

def isConferenceFoldover(array, verbose=0):
    r"""
    isConferenceFoldover(array_link array, int verbose=0) -> bool


    return true if the design is a foldover array

    """
    return _oalib.isConferenceFoldover(array, verbose)

def double_conference_foldover_permutation(double_conference):
    r"""
    double_conference_foldover_permutation(array_link double_conference) -> intVector


    For a double conference design return a row permutation to a single conference
    design

    If the design is not a foldover design then the first element of the returned
    permutation is -1.

    Parameters
    ----------
    * `double_conference` :
        A double conference design

    Returns
    -------
    Permutation such that the top block of the resulting design forms a single
    conference design

    """
    return _oalib.double_conference_foldover_permutation(double_conference)

def minz(al, column_index):
    r"""
    minz(array_link al, int column_index) -> int


    return minimal position of zero in specified column of a design

    """
    return _oalib.minz(al, column_index)
class DconferenceFilter(object):
    r"""


    class to filter single or double conference designs

    C++ includes: conference.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    als = property(_oalib.DconferenceFilter_als_get, _oalib.DconferenceFilter_als_set, doc=r"""als : array_link""")
    filtersymm = property(_oalib.DconferenceFilter_filtersymm_get, _oalib.DconferenceFilter_filtersymm_set, doc=r"""filtersymm : int""")
    filterj2 = property(_oalib.DconferenceFilter_filterj2_get, _oalib.DconferenceFilter_filterj2_set, doc=r"""filterj2 : int""")
    filterj3 = property(_oalib.DconferenceFilter_filterj3_get, _oalib.DconferenceFilter_filterj3_set, doc=r"""filterj3 : int""")
    filterfirst = property(_oalib.DconferenceFilter_filterfirst_get, _oalib.DconferenceFilter_filterfirst_set, doc=r"""filterfirst : int""")
    filterzero = property(_oalib.DconferenceFilter_filterzero_get, _oalib.DconferenceFilter_filterzero_set, doc=r"""filterzero : int""")
    ngood = property(_oalib.DconferenceFilter_ngood_get, _oalib.DconferenceFilter_ngood_set, doc=r"""ngood : long""")
    inline_row = property(_oalib.DconferenceFilter_inline_row_get, _oalib.DconferenceFilter_inline_row_set, doc=r"""inline_row : int""")
    sd = property(_oalib.DconferenceFilter_sd_get, _oalib.DconferenceFilter_sd_set, doc=r"""sd : symmdata""")

    def __init__(self, _als, filter_symmetry, filterj2_, filterj3_=1):
        r"""
        __init__(DconferenceFilter self, array_link _als, int filter_symmetry, int filterj2_, int filterj3_=1) -> DconferenceFilter


        """
        _oalib.DconferenceFilter_swiginit(self, _oalib.new_DconferenceFilter(_als, filter_symmetry, filterj2_, filterj3_))

    def show(self):
        r"""
        show(DconferenceFilter self)


        print object to stdout

        """
        return _oalib.DconferenceFilter_show(self)

    def filterList(self, lst, verbose=0):
        r"""
        filterList(DconferenceFilter self, conference_columnVector lst, int verbose=0) -> conference_columnVector


        filter a list of columns using the filter method

        """
        return _oalib.DconferenceFilter_filterList(self, lst, verbose)

    def filterListJ2last(self, column_list):
        r"""
        filterListJ2last(DconferenceFilter self, conference_columnVector column_list) -> conference_columnVector


        """
        return _oalib.DconferenceFilter_filterListJ2last(self, column_list)

    def filterListZero(self, lst):
        r"""
        filterListZero(DconferenceFilter self, conference_columnVector lst) -> conference_columnVector


        filter a list of cperms using the filterZero method

        """
        return _oalib.DconferenceFilter_filterListZero(self, lst)

    def filter(self, c):
        r"""
        filter(DconferenceFilter self, charVector c) -> bool


        return True if the extension satisfies all checks

        """
        return _oalib.DconferenceFilter_filter(self, c)

    def filterJpartial(self, column, maxrow):
        r"""
        filterJpartial(DconferenceFilter self, charVector column, int maxrow) -> bool


        Filter on partial column (only last col)

        Parameters
        ----------
        * `column` :
            Extension column
        * `maxrow` :
            the number of rows that are valid

        """
        return _oalib.DconferenceFilter_filterJpartial(self, column, maxrow)

    def filterJ(self, column, j2start=0):
        r"""
        filterJ(DconferenceFilter self, charVector column, int j2start=0) -> bool


        return True if the extension satisfies all J-characteristic checks

        """
        return _oalib.DconferenceFilter_filterJ(self, column, j2start)

    def filterJlast(self, c, j2start=0):
        r"""
        filterJlast(DconferenceFilter self, charVector c, int j2start=0) -> bool


        return True if the extension satisfies all J-characteristic checks for the last
        columns

        """
        return _oalib.DconferenceFilter_filterJlast(self, c, j2start)

    def filterReason(self, column):
        r"""
        filterReason(DconferenceFilter self, charVector column) -> bool


        return True if the extension satisfies all checks. prints the reason for
        returning True or False to stdout

        """
        return _oalib.DconferenceFilter_filterReason(self, column)

    def filterJ3(self, column):
        r"""
        filterJ3(DconferenceFilter self, charVector column) -> bool


        return True if the candidate satisfies the J3 check

        """
        return _oalib.DconferenceFilter_filterJ3(self, column)

    def filterJ3s(self, column, idxstart):
        r"""
        filterJ3s(DconferenceFilter self, charVector column, int idxstart) -> bool


        return True if the candidate satisfies the J3 check for specified pairs

        """
        return _oalib.DconferenceFilter_filterJ3s(self, column, idxstart)

    def filterJ3inline(self, column):
        r"""
        filterJ3inline(DconferenceFilter self, charVector column) -> bool


        return True if the candidate satisfies the J3 check

        """
        return _oalib.DconferenceFilter_filterJ3inline(self, column)

    def filterSymmetry(self, column):
        r"""
        filterSymmetry(DconferenceFilter self, charVector column) -> bool


        return True of the candidate satisfies the symmetry check

        """
        return _oalib.DconferenceFilter_filterSymmetry(self, column)

    def filterJ2(self, c):
        r"""
        filterJ2(DconferenceFilter self, charVector c) -> bool


        return True of the candidate extension satisfies the J2 check

        """
        return _oalib.DconferenceFilter_filterJ2(self, c)

    def filterJ2last(self, c):
        r"""
        filterJ2last(DconferenceFilter self, charVector c) -> bool


        return True of the candidate extension satisfies the J2 check for the last
        column of the array checked against

        """
        return _oalib.DconferenceFilter_filterJ2last(self, c)

    def filterZero(self, c):
        r"""
        filterZero(DconferenceFilter self, charVector c) -> bool


        return True of the candidate extension satisfies the zero check

        This means that the first entries of the extension do not contain a zero.

        """
        return _oalib.DconferenceFilter_filterZero(self, c)
    __swig_destroy__ = _oalib.delete_DconferenceFilter

# Register DconferenceFilter in _oalib:
_oalib.DconferenceFilter_swigregister(DconferenceFilter)


def unittest_reduceConferenceTransformation():
    r"""
    unittest_reduceConferenceTransformation() -> int


    """
    return _oalib.unittest_reduceConferenceTransformation()

def unittest_nautynormalform(al, verbose):
    r"""
    unittest_nautynormalform(array_link al, int verbose) -> int


    """
    return _oalib.unittest_nautynormalform(al, verbose)

def checkTransformationComposition(al, verbose=0):
    r"""
    checkTransformationComposition(array_link al, int verbose=0) -> int


    """
    return _oalib.checkTransformationComposition(al, verbose)

def test_array_manipulation(verbose=1):
    r"""
    test_array_manipulation(int verbose=1)


    """
    return _oalib.test_array_manipulation(verbose)

def checkConferenceComposition(al, verbose=0):
    r"""
    checkConferenceComposition(array_link al, int verbose=0) -> int


    """
    return _oalib.checkConferenceComposition(al, verbose)

def test_conference_candidate_generators(verbose=1):
    r"""
    test_conference_candidate_generators(int verbose=1)


    """
    return _oalib.test_conference_candidate_generators(verbose)

def checkTransformationInverse(al):
    r"""
    checkTransformationInverse(array_link al) -> int


    """
    return _oalib.checkTransformationInverse(al)

def checkConferenceInverse(array):
    r"""
    checkConferenceInverse(array_link array) -> int


    """
    return _oalib.checkConferenceInverse(array)

def testLMC0checkDC(al, verbose=1):
    r"""
    testLMC0checkDC(array_link al, int verbose=1) -> bool


    """
    return _oalib.testLMC0checkDC(al, verbose)
class pairDoptimize(object):
    r"""Proxy of C++ std::pair< std::vector< std::vector< double > >,arraylist_t > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(pairDoptimize self) -> pairDoptimize
        __init__(pairDoptimize self, vector_vector_double first, arraylist_t second) -> pairDoptimize
        __init__(pairDoptimize self, pairDoptimize other) -> pairDoptimize
        """
        _oalib.pairDoptimize_swiginit(self, _oalib.new_pairDoptimize(*args))
    first = property(_oalib.pairDoptimize_first_get, _oalib.pairDoptimize_first_set, doc=r"""first : std::vector<(std::vector<(double,std::allocator<(double)>)>,std::allocator<(std::vector<(double,std::allocator<(double)>)>)>)>""")
    second = property(_oalib.pairDoptimize_second_get, _oalib.pairDoptimize_second_set, doc=r"""second : std::deque<(array_link,std::allocator<(array_link)>)>""")
    def __len__(self):
        return 2
    def __repr__(self):
        return str((self.first, self.second))
    def __getitem__(self, index): 
        if not (index % 2):
            return self.first
        else:
            return self.second
    def __setitem__(self, index, val):
        if not (index % 2):
            self.first = val
        else:
            self.second = val
    __swig_destroy__ = _oalib.delete_pairDoptimize

# Register pairDoptimize in _oalib:
_oalib.pairDoptimize_swigregister(pairDoptimize)

class pairGraphColors(object):
    r"""Proxy of C++ std::pair< array_link,std::vector< int > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(pairGraphColors self) -> pairGraphColors
        __init__(pairGraphColors self, array_link first, intVector second) -> pairGraphColors
        __init__(pairGraphColors self, pairGraphColors other) -> pairGraphColors
        """
        _oalib.pairGraphColors_swiginit(self, _oalib.new_pairGraphColors(*args))
    first = property(_oalib.pairGraphColors_first_get, _oalib.pairGraphColors_first_set, doc=r"""first : array_link""")
    second = property(_oalib.pairGraphColors_second_get, _oalib.pairGraphColors_second_set, doc=r"""second : std::vector<(int,std::allocator<(int)>)>""")
    def __len__(self):
        return 2
    def __repr__(self):
        return str((self.first, self.second))
    def __getitem__(self, index): 
        if not (index % 2):
            return self.first
        else:
            return self.second
    def __setitem__(self, index, val):
        if not (index % 2):
            self.first = val
        else:
            self.second = val
    __swig_destroy__ = _oalib.delete_pairGraphColors

# Register pairGraphColors in _oalib:
_oalib.pairGraphColors_swigregister(pairGraphColors)

class pairEigenMatrix(object):
    r"""Proxy of C++ std::pair< MatrixFloat,MatrixFloat > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(pairEigenMatrix self) -> pairEigenMatrix
        __init__(pairEigenMatrix self, Eigen::MatrixXd first, Eigen::MatrixXd second) -> pairEigenMatrix
        __init__(pairEigenMatrix self, pairEigenMatrix other) -> pairEigenMatrix
        """
        _oalib.pairEigenMatrix_swiginit(self, _oalib.new_pairEigenMatrix(*args))
    first = property(_oalib.pairEigenMatrix_first_get, _oalib.pairEigenMatrix_first_set, doc=r"""first : Eigen::MatrixXd""")
    second = property(_oalib.pairEigenMatrix_second_get, _oalib.pairEigenMatrix_second_set, doc=r"""second : Eigen::MatrixXd""")
    def __len__(self):
        return 2
    def __repr__(self):
        return str((self.first, self.second))
    def __getitem__(self, index): 
        if not (index % 2):
            return self.first
        else:
            return self.second
    def __setitem__(self, index, val):
        if not (index % 2):
            self.first = val
        else:
            self.second = val
    __swig_destroy__ = _oalib.delete_pairEigenMatrix

# Register pairEigenMatrix in _oalib:
_oalib.pairEigenMatrix_swigregister(pairEigenMatrix)

class mvalue_t_long(object):
    r"""


    Multi-value type.

    This object represents a multi-valued object. The objects are ordered using
    lexicographic ordering.

    C++ includes: mathtools.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    values = property(_oalib.mvalue_t_long_values_get, _oalib.mvalue_t_long_values_set, doc=r"""values : std::vector<(long,std::allocator<(long)>)>""")
    HIGH = _oalib.mvalue_t_long_HIGH
    r""" Order from high to low values"""
    LOW = _oalib.mvalue_t_long_LOW
    r""" Order from low to high values"""
    ordering = property(_oalib.mvalue_t_long_ordering_get, _oalib.mvalue_t_long_ordering_set, doc=r"""ordering : mvalue_t<(long)>::direction_t""")
    __swig_destroy__ = _oalib.delete_mvalue_t_long

    def __init__(self, *args):
        r"""
        __init__(mvalue_t_long self) -> mvalue_t_long
        __init__(mvalue_t_long self, long element, mvalue_t< long >::direction_t dd=mvalue_t< long >::HIGH) -> mvalue_t_long
        __init__(mvalue_t_long self, longVector elements, mvalue_t< long >::direction_t dd=mvalue_t< long >::HIGH) -> mvalue_t_long


        Create multi-valued object

        The object consists of a vector of elements.

        Parameters
        ----------
        * `elements` :
            Vector to use for initalization of the object
        * `dd` :
            Ordering to use

        """
        _oalib.mvalue_t_long_swiginit(self, _oalib.new_mvalue_t_long(*args))

    def raw_values(self):
        r"""
        raw_values(mvalue_t_long self) -> longVector


        Return vector with the raw values in this object.

        """
        return _oalib.mvalue_t_long_raw_values(self)

    def size(self):
        r"""
        size(mvalue_t_long self) -> size_t


        """
        return _oalib.mvalue_t_long_size(self)

    def __eq__(self, rhs):
        r"""__eq__(mvalue_t_long self, mvalue_t_long rhs) -> bool"""
        return _oalib.mvalue_t_long___eq__(self, rhs)

    def __ne__(self, rhs):
        r"""__ne__(mvalue_t_long self, mvalue_t_long rhs) -> bool"""
        return _oalib.mvalue_t_long___ne__(self, rhs)

    def __le__(self, rhs):
        r"""__le__(mvalue_t_long self, mvalue_t_long rhs) -> bool"""
        return _oalib.mvalue_t_long___le__(self, rhs)

    def __lt__(self, rhs):
        r"""__lt__(mvalue_t_long self, mvalue_t_long rhs) -> bool"""
        return _oalib.mvalue_t_long___lt__(self, rhs)

    def __gt__(self, rhs):
        r"""__gt__(mvalue_t_long self, mvalue_t_long rhs) -> bool"""
        return _oalib.mvalue_t_long___gt__(self, rhs)

    def __ge__(self, rhs):
        r"""__ge__(mvalue_t_long self, mvalue_t_long rhs) -> bool"""
        return _oalib.mvalue_t_long___ge__(self, rhs)

    def show_integer(self):
        r"""
        show_integer(mvalue_t_long self)


        Show the object on stdout by casting to integer type objects.

        """
        return _oalib.mvalue_t_long_show_integer(self)

    def string_representation(self, *args):
        r"""
        string_representation(mvalue_t_long self, char const * separator=";") -> std::string


        return a string representation of the object

        """
        return _oalib.mvalue_t_long_string_representation(self, *args)

# Register mvalue_t_long in _oalib:
_oalib.mvalue_t_long_swigregister(mvalue_t_long)

class mvalue_t_double(object):
    r"""


    Multi-value type.

    This object represents a multi-valued object. The objects are ordered using
    lexicographic ordering.

    C++ includes: mathtools.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    values = property(_oalib.mvalue_t_double_values_get, _oalib.mvalue_t_double_values_set, doc=r"""values : std::vector<(double,std::allocator<(double)>)>""")
    HIGH = _oalib.mvalue_t_double_HIGH
    r""" Order from high to low values"""
    LOW = _oalib.mvalue_t_double_LOW
    r""" Order from low to high values"""
    ordering = property(_oalib.mvalue_t_double_ordering_get, _oalib.mvalue_t_double_ordering_set, doc=r"""ordering : mvalue_t<(double)>::direction_t""")
    __swig_destroy__ = _oalib.delete_mvalue_t_double

    def __init__(self, *args):
        r"""
        __init__(mvalue_t_double self) -> mvalue_t_double
        __init__(mvalue_t_double self, double element, mvalue_t< double >::direction_t dd=mvalue_t< double >::HIGH) -> mvalue_t_double
        __init__(mvalue_t_double self, doubleVector elements, mvalue_t< double >::direction_t dd=mvalue_t< double >::HIGH) -> mvalue_t_double


        Create multi-valued object

        The object consists of a vector of elements.

        Parameters
        ----------
        * `elements` :
            Vector to use for initalization of the object
        * `dd` :
            Ordering to use

        """
        _oalib.mvalue_t_double_swiginit(self, _oalib.new_mvalue_t_double(*args))

    def raw_values(self):
        r"""
        raw_values(mvalue_t_double self) -> doubleVector


        Return vector with the raw values in this object.

        """
        return _oalib.mvalue_t_double_raw_values(self)

    def size(self):
        r"""
        size(mvalue_t_double self) -> size_t


        """
        return _oalib.mvalue_t_double_size(self)

    def __eq__(self, rhs):
        r"""__eq__(mvalue_t_double self, mvalue_t_double rhs) -> bool"""
        return _oalib.mvalue_t_double___eq__(self, rhs)

    def __ne__(self, rhs):
        r"""__ne__(mvalue_t_double self, mvalue_t_double rhs) -> bool"""
        return _oalib.mvalue_t_double___ne__(self, rhs)

    def __le__(self, rhs):
        r"""__le__(mvalue_t_double self, mvalue_t_double rhs) -> bool"""
        return _oalib.mvalue_t_double___le__(self, rhs)

    def __lt__(self, rhs):
        r"""__lt__(mvalue_t_double self, mvalue_t_double rhs) -> bool"""
        return _oalib.mvalue_t_double___lt__(self, rhs)

    def __gt__(self, rhs):
        r"""__gt__(mvalue_t_double self, mvalue_t_double rhs) -> bool"""
        return _oalib.mvalue_t_double___gt__(self, rhs)

    def __ge__(self, rhs):
        r"""__ge__(mvalue_t_double self, mvalue_t_double rhs) -> bool"""
        return _oalib.mvalue_t_double___ge__(self, rhs)

    def show_integer(self):
        r"""
        show_integer(mvalue_t_double self)


        Show the object on stdout by casting to integer type objects.

        """
        return _oalib.mvalue_t_double_show_integer(self)

    def string_representation(self, *args):
        r"""
        string_representation(mvalue_t_double self, char const * separator=";") -> std::string


        return a string representation of the object

        """
        return _oalib.mvalue_t_double_string_representation(self, *args)


    def __getattr__(self, attr):
        if attr=='__array_interface__':
          a = dict()
          a['version']=3
          a['shape']=(self.size(), )
          sizeofdata=_oalib.sizeof_double()
          a['typestr']='<f%d' % sizeofdata
          a['data']=(np.array(self.values), True)
          return a
        else:
          raise AttributeError("%r object has no attribute %r" %
                             (self.__class__, attr))



# Register mvalue_t_double in _oalib:
_oalib.mvalue_t_double_swigregister(mvalue_t_double)

class ParetoLongLong(object):
    r"""


    Class to the calculate Pareto optimal elements.

    The class is templated by the type of values to be compared and an index type.
    The index type is used to index the elements.

    For elements added to the Pareto structure larger is better.

    C++ includes: pareto.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    verbose = property(_oalib.ParetoLongLong_verbose_get, _oalib.ParetoLongLong_verbose_set, doc=r"""verbose : int""")
    elements = property(_oalib.ParetoLongLong_elements_get, _oalib.ParetoLongLong_elements_set, doc=r"""elements : std::deque<(pareto_element<(long,long)>,std::allocator<(pareto_element<(long,long)>)>)>""")

    def __init__(self):
        r"""
        __init__(ParetoLongLong self) -> ParetoLongLong


        Create an empty Pareto class.

        """
        _oalib.ParetoLongLong_swiginit(self, _oalib.new_ParetoLongLong())
    __swig_destroy__ = _oalib.delete_ParetoLongLong

    def number(self):
        r"""
        number(ParetoLongLong self) -> int


        return the total number of Pareto optimal values

        """
        return _oalib.ParetoLongLong_number(self)

    def numberindices(self):
        r"""
        numberindices(ParetoLongLong self) -> int


        return the total number Pareto optimal objects

        """
        return _oalib.ParetoLongLong_numberindices(self)

    def __repr__(self):
        r"""
        __repr__(ParetoLongLong self) -> std::string


        """
        return _oalib.ParetoLongLong___repr__(self)

    @staticmethod
    def showvalue(p):
        r"""
        showvalue(longVector p)


        show a Pareto element

        """
        return _oalib.ParetoLongLong_showvalue(p)

    def show(self, verbose=1):
        r"""
        show(ParetoLongLong self, int verbose=1)


        show the current set of Pareto optimal elements

        """
        return _oalib.ParetoLongLong_show(self, verbose)

    def allindicesdeque(self):
        r"""
        allindicesdeque(ParetoLongLong self) -> longDeque


        return all indices of the Pareto optimal elements as a std::deque

        """
        return _oalib.ParetoLongLong_allindicesdeque(self)

    def allindices(self):
        r"""
        allindices(ParetoLongLong self) -> longVector


        return all indices of the Pareto optimal elements

        """
        return _oalib.ParetoLongLong_allindices(self)

    def allvalues(self):
        r"""
        allvalues(ParetoLongLong self) -> std::vector< Pareto< long,long >::pValue,std::allocator< Pareto< long,long >::pValue > >


        return the values of all Pareto optimal elements

        """
        return _oalib.ParetoLongLong_allvalues(self)

    def addvalue(self, value, idx):
        r"""
        addvalue(ParetoLongLong self, longVector value, long const idx) -> bool


        add a new element

        """
        return _oalib.ParetoLongLong_addvalue(self, value, idx)

# Register ParetoLongLong in _oalib:
_oalib.ParetoLongLong_swigregister(ParetoLongLong)

def ParetoLongLong_showvalue(p):
    r"""
    ParetoLongLong_showvalue(longVector p)


    show a Pareto element

    """
    return _oalib.ParetoLongLong_showvalue(p)

class ParetoMultiLongLong(object):
    r"""


    Class to the calculate Pareto optimal elements.

    The class is templated by the type of values to be compared and an index type.
    The index type is used to index the elements.

    For elements added to the Pareto structure larger is better.

    C++ includes: pareto.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    verbose = property(_oalib.ParetoMultiLongLong_verbose_get, _oalib.ParetoMultiLongLong_verbose_set, doc=r"""verbose : int""")
    elements = property(_oalib.ParetoMultiLongLong_elements_get, _oalib.ParetoMultiLongLong_elements_set, doc=r"""elements : std::deque<(pareto_element<(mvalue_t<(long)>,long)>,std::allocator<(pareto_element<(mvalue_t<(long)>,long)>)>)>""")

    def __init__(self):
        r"""
        __init__(ParetoMultiLongLong self) -> ParetoMultiLongLong


        Create an empty Pareto class.

        """
        _oalib.ParetoMultiLongLong_swiginit(self, _oalib.new_ParetoMultiLongLong())
    __swig_destroy__ = _oalib.delete_ParetoMultiLongLong

    def number(self):
        r"""
        number(ParetoMultiLongLong self) -> int


        return the total number of Pareto optimal values

        """
        return _oalib.ParetoMultiLongLong_number(self)

    def numberindices(self):
        r"""
        numberindices(ParetoMultiLongLong self) -> int


        return the total number Pareto optimal objects

        """
        return _oalib.ParetoMultiLongLong_numberindices(self)

    def __repr__(self):
        r"""
        __repr__(ParetoMultiLongLong self) -> std::string


        """
        return _oalib.ParetoMultiLongLong___repr__(self)

    @staticmethod
    def showvalue(p):
        r"""
        showvalue(vector_mvalue_t_long p)


        show a Pareto element

        """
        return _oalib.ParetoMultiLongLong_showvalue(p)

    def show(self, verbose=1):
        r"""
        show(ParetoMultiLongLong self, int verbose=1)


        show the current set of Pareto optimal elements

        """
        return _oalib.ParetoMultiLongLong_show(self, verbose)

    def allindicesdeque(self):
        r"""
        allindicesdeque(ParetoMultiLongLong self) -> longDeque


        return all indices of the Pareto optimal elements as a std::deque

        """
        return _oalib.ParetoMultiLongLong_allindicesdeque(self)

    def allindices(self):
        r"""
        allindices(ParetoMultiLongLong self) -> longVector


        return all indices of the Pareto optimal elements

        """
        return _oalib.ParetoMultiLongLong_allindices(self)

    def allvalues(self):
        r"""
        allvalues(ParetoMultiLongLong self) -> std::vector< Pareto< mvalue_t< long >,long >::pValue,std::allocator< Pareto< mvalue_t< long >,long >::pValue > >


        return the values of all Pareto optimal elements

        """
        return _oalib.ParetoMultiLongLong_allvalues(self)

    def addvalue(self, value, idx):
        r"""
        addvalue(ParetoMultiLongLong self, vector_mvalue_t_long value, long const idx) -> bool


        add a new element

        """
        return _oalib.ParetoMultiLongLong_addvalue(self, value, idx)

# Register ParetoMultiLongLong in _oalib:
_oalib.ParetoMultiLongLong_swigregister(ParetoMultiLongLong)

def ParetoMultiLongLong_showvalue(p):
    r"""
    ParetoMultiLongLong_showvalue(vector_mvalue_t_long p)


    show a Pareto element

    """
    return _oalib.ParetoMultiLongLong_showvalue(p)

class ParetoMultiDoubleLong(object):
    r"""


    Class to the calculate Pareto optimal elements.

    The class is templated by the type of values to be compared and an index type.
    The index type is used to index the elements.

    For elements added to the Pareto structure larger is better.

    C++ includes: pareto.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    verbose = property(_oalib.ParetoMultiDoubleLong_verbose_get, _oalib.ParetoMultiDoubleLong_verbose_set, doc=r"""verbose : int""")
    elements = property(_oalib.ParetoMultiDoubleLong_elements_get, _oalib.ParetoMultiDoubleLong_elements_set, doc=r"""elements : std::deque<(pareto_element<(mvalue_t<(double)>,long)>,std::allocator<(pareto_element<(mvalue_t<(double)>,long)>)>)>""")

    def __init__(self):
        r"""
        __init__(ParetoMultiDoubleLong self) -> ParetoMultiDoubleLong


        Create an empty Pareto class.

        """
        _oalib.ParetoMultiDoubleLong_swiginit(self, _oalib.new_ParetoMultiDoubleLong())
    __swig_destroy__ = _oalib.delete_ParetoMultiDoubleLong

    def number(self):
        r"""
        number(ParetoMultiDoubleLong self) -> int


        return the total number of Pareto optimal values

        """
        return _oalib.ParetoMultiDoubleLong_number(self)

    def numberindices(self):
        r"""
        numberindices(ParetoMultiDoubleLong self) -> int


        return the total number Pareto optimal objects

        """
        return _oalib.ParetoMultiDoubleLong_numberindices(self)

    def __repr__(self):
        r"""
        __repr__(ParetoMultiDoubleLong self) -> std::string


        """
        return _oalib.ParetoMultiDoubleLong___repr__(self)

    @staticmethod
    def showvalue(p):
        r"""
        showvalue(vector_mvalue_t_double p)


        show a Pareto element

        """
        return _oalib.ParetoMultiDoubleLong_showvalue(p)

    def show(self, verbose=1):
        r"""
        show(ParetoMultiDoubleLong self, int verbose=1)


        show the current set of Pareto optimal elements

        """
        return _oalib.ParetoMultiDoubleLong_show(self, verbose)

    def allindicesdeque(self):
        r"""
        allindicesdeque(ParetoMultiDoubleLong self) -> longDeque


        return all indices of the Pareto optimal elements as a std::deque

        """
        return _oalib.ParetoMultiDoubleLong_allindicesdeque(self)

    def allindices(self):
        r"""
        allindices(ParetoMultiDoubleLong self) -> longVector


        return all indices of the Pareto optimal elements

        """
        return _oalib.ParetoMultiDoubleLong_allindices(self)

    def allvalues(self):
        r"""
        allvalues(ParetoMultiDoubleLong self) -> std::vector< Pareto< mvalue_t< double >,long >::pValue,std::allocator< Pareto< mvalue_t< double >,long >::pValue > >


        return the values of all Pareto optimal elements

        """
        return _oalib.ParetoMultiDoubleLong_allvalues(self)

    def addvalue(self, value, idx):
        r"""
        addvalue(ParetoMultiDoubleLong self, vector_mvalue_t_double value, long const idx) -> bool


        add a new element

        """
        return _oalib.ParetoMultiDoubleLong_addvalue(self, value, idx)

# Register ParetoMultiDoubleLong in _oalib:
_oalib.ParetoMultiDoubleLong_swigregister(ParetoMultiDoubleLong)

def ParetoMultiDoubleLong_showvalue(p):
    r"""
    ParetoMultiDoubleLong_showvalue(vector_mvalue_t_double p)


    show a Pareto element

    """
    return _oalib.ParetoMultiDoubleLong_showvalue(p)

class ParetoDoubleLong(object):
    r"""


    Class to the calculate Pareto optimal elements.

    The class is templated by the type of values to be compared and an index type.
    The index type is used to index the elements.

    For elements added to the Pareto structure larger is better.

    C++ includes: pareto.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    verbose = property(_oalib.ParetoDoubleLong_verbose_get, _oalib.ParetoDoubleLong_verbose_set, doc=r"""verbose : int""")
    elements = property(_oalib.ParetoDoubleLong_elements_get, _oalib.ParetoDoubleLong_elements_set, doc=r"""elements : std::deque<(pareto_element<(double,long)>,std::allocator<(pareto_element<(double,long)>)>)>""")

    def __init__(self):
        r"""
        __init__(ParetoDoubleLong self) -> ParetoDoubleLong


        Create an empty Pareto class.

        """
        _oalib.ParetoDoubleLong_swiginit(self, _oalib.new_ParetoDoubleLong())
    __swig_destroy__ = _oalib.delete_ParetoDoubleLong

    def number(self):
        r"""
        number(ParetoDoubleLong self) -> int


        return the total number of Pareto optimal values

        """
        return _oalib.ParetoDoubleLong_number(self)

    def numberindices(self):
        r"""
        numberindices(ParetoDoubleLong self) -> int


        return the total number Pareto optimal objects

        """
        return _oalib.ParetoDoubleLong_numberindices(self)

    def __repr__(self):
        r"""
        __repr__(ParetoDoubleLong self) -> std::string


        """
        return _oalib.ParetoDoubleLong___repr__(self)

    @staticmethod
    def showvalue(p):
        r"""
        showvalue(doubleVector p)


        show a Pareto element

        """
        return _oalib.ParetoDoubleLong_showvalue(p)

    def show(self, verbose=1):
        r"""
        show(ParetoDoubleLong self, int verbose=1)


        show the current set of Pareto optimal elements

        """
        return _oalib.ParetoDoubleLong_show(self, verbose)

    def allindicesdeque(self):
        r"""
        allindicesdeque(ParetoDoubleLong self) -> longDeque


        return all indices of the Pareto optimal elements as a std::deque

        """
        return _oalib.ParetoDoubleLong_allindicesdeque(self)

    def allindices(self):
        r"""
        allindices(ParetoDoubleLong self) -> longVector


        return all indices of the Pareto optimal elements

        """
        return _oalib.ParetoDoubleLong_allindices(self)

    def allvalues(self):
        r"""
        allvalues(ParetoDoubleLong self) -> vector_vector_double


        return the values of all Pareto optimal elements

        """
        return _oalib.ParetoDoubleLong_allvalues(self)

    def addvalue(self, value, idx):
        r"""
        addvalue(ParetoDoubleLong self, doubleVector value, long const idx) -> bool


        add a new element

        """
        return _oalib.ParetoDoubleLong_addvalue(self, value, idx)

# Register ParetoDoubleLong in _oalib:
_oalib.ParetoDoubleLong_swigregister(ParetoDoubleLong)

def ParetoDoubleLong_showvalue(p):
    r"""
    ParetoDoubleLong_showvalue(doubleVector p)


    show a Pareto element

    """
    return _oalib.ParetoDoubleLong_showvalue(p)

class ParetoElementLong(object):
    r"""


    helper class for the Pareto class to hold elements

    C++ includes: pareto.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    value = property(_oalib.ParetoElementLong_value_get, _oalib.ParetoElementLong_value_set, doc=r"""value : pareto_element<(mvalue_t<(long)>,long)>::pValue""")
    indices = property(_oalib.ParetoElementLong_indices_get, _oalib.ParetoElementLong_indices_set, doc=r"""indices : std::vector<(long,std::allocator<(long)>)>""")

    def dominates(self, v):
        r"""
        dominates(ParetoElementLong self, vector_mvalue_t_long v) -> bool


        return true of the argument element dominates this value

        """
        return _oalib.ParetoElementLong_dominates(self, v)

    def isdominated(self, v):
        r"""
        isdominated(ParetoElementLong self, vector_mvalue_t_long v) -> bool


        return true of the argument element is dominated by this value

        """
        return _oalib.ParetoElementLong_isdominated(self, v)

    def equal(self, v):
        r"""
        equal(ParetoElementLong self, vector_mvalue_t_long v) -> bool


        return true of the argument element is equal to this element

        """
        return _oalib.ParetoElementLong_equal(self, v)

    def __init__(self):
        r"""
        __init__(ParetoElementLong self) -> ParetoElementLong


        helper class for the Pareto class to hold elements

        C++ includes: pareto.h

        """
        _oalib.ParetoElementLong_swiginit(self, _oalib.new_ParetoElementLong())
    __swig_destroy__ = _oalib.delete_ParetoElementLong

# Register ParetoElementLong in _oalib:
_oalib.ParetoElementLong_swigregister(ParetoElementLong)

class ParetoMElementLong(object):
    r"""


    helper class for the Pareto class to hold elements

    C++ includes: pareto.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    value = property(_oalib.ParetoMElementLong_value_get, _oalib.ParetoMElementLong_value_set, doc=r"""value : pareto_element<(mvalue_t<(long)>,long)>::pValue""")
    indices = property(_oalib.ParetoMElementLong_indices_get, _oalib.ParetoMElementLong_indices_set, doc=r"""indices : std::vector<(long,std::allocator<(long)>)>""")

    def dominates(self, v):
        r"""
        dominates(ParetoMElementLong self, vector_mvalue_t_long v) -> bool


        return true of the argument element dominates this value

        """
        return _oalib.ParetoMElementLong_dominates(self, v)

    def isdominated(self, v):
        r"""
        isdominated(ParetoMElementLong self, vector_mvalue_t_long v) -> bool


        return true of the argument element is dominated by this value

        """
        return _oalib.ParetoMElementLong_isdominated(self, v)

    def equal(self, v):
        r"""
        equal(ParetoMElementLong self, vector_mvalue_t_long v) -> bool


        return true of the argument element is equal to this element

        """
        return _oalib.ParetoMElementLong_equal(self, v)

    def __init__(self):
        r"""
        __init__(ParetoMElementLong self) -> ParetoMElementLong


        helper class for the Pareto class to hold elements

        C++ includes: pareto.h

        """
        _oalib.ParetoMElementLong_swiginit(self, _oalib.new_ParetoMElementLong())
    __swig_destroy__ = _oalib.delete_ParetoMElementLong

# Register ParetoMElementLong in _oalib:
_oalib.ParetoMElementLong_swigregister(ParetoMElementLong)

class vector_mvalue_t_double(object):
    r"""Proxy of C++ std::vector< mvalue_t< double > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(vector_mvalue_t_double self) -> SwigPyIterator"""
        return _oalib.vector_mvalue_t_double_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(vector_mvalue_t_double self) -> bool"""
        return _oalib.vector_mvalue_t_double___nonzero__(self)

    def __bool__(self):
        r"""__bool__(vector_mvalue_t_double self) -> bool"""
        return _oalib.vector_mvalue_t_double___bool__(self)

    def __len__(self):
        r"""__len__(vector_mvalue_t_double self) -> std::vector< mvalue_t< double > >::size_type"""
        return _oalib.vector_mvalue_t_double___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(vector_mvalue_t_double self, std::vector< mvalue_t< double > >::difference_type i, std::vector< mvalue_t< double > >::difference_type j) -> vector_mvalue_t_double"""
        return _oalib.vector_mvalue_t_double___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(vector_mvalue_t_double self, std::vector< mvalue_t< double > >::difference_type i, std::vector< mvalue_t< double > >::difference_type j)
        __setslice__(vector_mvalue_t_double self, std::vector< mvalue_t< double > >::difference_type i, std::vector< mvalue_t< double > >::difference_type j, vector_mvalue_t_double v)
        """
        return _oalib.vector_mvalue_t_double___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(vector_mvalue_t_double self, std::vector< mvalue_t< double > >::difference_type i, std::vector< mvalue_t< double > >::difference_type j)"""
        return _oalib.vector_mvalue_t_double___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(vector_mvalue_t_double self, std::vector< mvalue_t< double > >::difference_type i)
        __delitem__(vector_mvalue_t_double self, PySliceObject * slice)
        """
        return _oalib.vector_mvalue_t_double___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(vector_mvalue_t_double self, PySliceObject * slice) -> vector_mvalue_t_double
        __getitem__(vector_mvalue_t_double self, std::vector< mvalue_t< double > >::difference_type i) -> mvalue_t_double
        """
        return _oalib.vector_mvalue_t_double___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(vector_mvalue_t_double self, PySliceObject * slice, vector_mvalue_t_double v)
        __setitem__(vector_mvalue_t_double self, PySliceObject * slice)
        __setitem__(vector_mvalue_t_double self, std::vector< mvalue_t< double > >::difference_type i, mvalue_t_double x)
        """
        return _oalib.vector_mvalue_t_double___setitem__(self, *args)

    def pop(self):
        r"""pop(vector_mvalue_t_double self) -> mvalue_t_double"""
        return _oalib.vector_mvalue_t_double_pop(self)

    def append(self, x):
        r"""append(vector_mvalue_t_double self, mvalue_t_double x)"""
        return _oalib.vector_mvalue_t_double_append(self, x)

    def empty(self):
        r"""empty(vector_mvalue_t_double self) -> bool"""
        return _oalib.vector_mvalue_t_double_empty(self)

    def size(self):
        r"""size(vector_mvalue_t_double self) -> std::vector< mvalue_t< double > >::size_type"""
        return _oalib.vector_mvalue_t_double_size(self)

    def swap(self, v):
        r"""swap(vector_mvalue_t_double self, vector_mvalue_t_double v)"""
        return _oalib.vector_mvalue_t_double_swap(self, v)

    def begin(self):
        r"""begin(vector_mvalue_t_double self) -> std::vector< mvalue_t< double > >::iterator"""
        return _oalib.vector_mvalue_t_double_begin(self)

    def end(self):
        r"""end(vector_mvalue_t_double self) -> std::vector< mvalue_t< double > >::iterator"""
        return _oalib.vector_mvalue_t_double_end(self)

    def rbegin(self):
        r"""rbegin(vector_mvalue_t_double self) -> std::vector< mvalue_t< double > >::reverse_iterator"""
        return _oalib.vector_mvalue_t_double_rbegin(self)

    def rend(self):
        r"""rend(vector_mvalue_t_double self) -> std::vector< mvalue_t< double > >::reverse_iterator"""
        return _oalib.vector_mvalue_t_double_rend(self)

    def clear(self):
        r"""clear(vector_mvalue_t_double self)"""
        return _oalib.vector_mvalue_t_double_clear(self)

    def get_allocator(self):
        r"""get_allocator(vector_mvalue_t_double self) -> std::vector< mvalue_t< double > >::allocator_type"""
        return _oalib.vector_mvalue_t_double_get_allocator(self)

    def pop_back(self):
        r"""pop_back(vector_mvalue_t_double self)"""
        return _oalib.vector_mvalue_t_double_pop_back(self)

    def erase(self, *args):
        r"""
        erase(vector_mvalue_t_double self, std::vector< mvalue_t< double > >::iterator pos) -> std::vector< mvalue_t< double > >::iterator
        erase(vector_mvalue_t_double self, std::vector< mvalue_t< double > >::iterator first, std::vector< mvalue_t< double > >::iterator last) -> std::vector< mvalue_t< double > >::iterator
        """
        return _oalib.vector_mvalue_t_double_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(vector_mvalue_t_double self) -> vector_mvalue_t_double
        __init__(vector_mvalue_t_double self, vector_mvalue_t_double other) -> vector_mvalue_t_double
        __init__(vector_mvalue_t_double self, std::vector< mvalue_t< double > >::size_type size) -> vector_mvalue_t_double
        __init__(vector_mvalue_t_double self, std::vector< mvalue_t< double > >::size_type size, mvalue_t_double value) -> vector_mvalue_t_double
        """
        _oalib.vector_mvalue_t_double_swiginit(self, _oalib.new_vector_mvalue_t_double(*args))

    def push_back(self, x):
        r"""push_back(vector_mvalue_t_double self, mvalue_t_double x)"""
        return _oalib.vector_mvalue_t_double_push_back(self, x)

    def front(self):
        r"""front(vector_mvalue_t_double self) -> mvalue_t_double"""
        return _oalib.vector_mvalue_t_double_front(self)

    def back(self):
        r"""back(vector_mvalue_t_double self) -> mvalue_t_double"""
        return _oalib.vector_mvalue_t_double_back(self)

    def assign(self, n, x):
        r"""assign(vector_mvalue_t_double self, std::vector< mvalue_t< double > >::size_type n, mvalue_t_double x)"""
        return _oalib.vector_mvalue_t_double_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(vector_mvalue_t_double self, std::vector< mvalue_t< double > >::size_type new_size)
        resize(vector_mvalue_t_double self, std::vector< mvalue_t< double > >::size_type new_size, mvalue_t_double x)
        """
        return _oalib.vector_mvalue_t_double_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(vector_mvalue_t_double self, std::vector< mvalue_t< double > >::iterator pos, mvalue_t_double x) -> std::vector< mvalue_t< double > >::iterator
        insert(vector_mvalue_t_double self, std::vector< mvalue_t< double > >::iterator pos, std::vector< mvalue_t< double > >::size_type n, mvalue_t_double x)
        """
        return _oalib.vector_mvalue_t_double_insert(self, *args)

    def reserve(self, n):
        r"""reserve(vector_mvalue_t_double self, std::vector< mvalue_t< double > >::size_type n)"""
        return _oalib.vector_mvalue_t_double_reserve(self, n)

    def capacity(self):
        r"""capacity(vector_mvalue_t_double self) -> std::vector< mvalue_t< double > >::size_type"""
        return _oalib.vector_mvalue_t_double_capacity(self)
    __swig_destroy__ = _oalib.delete_vector_mvalue_t_double

# Register vector_mvalue_t_double in _oalib:
_oalib.vector_mvalue_t_double_swigregister(vector_mvalue_t_double)

class vector_mvalue_t_int(object):
    r"""Proxy of C++ std::vector< mvalue_t< int > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(vector_mvalue_t_int self) -> SwigPyIterator"""
        return _oalib.vector_mvalue_t_int_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(vector_mvalue_t_int self) -> bool"""
        return _oalib.vector_mvalue_t_int___nonzero__(self)

    def __bool__(self):
        r"""__bool__(vector_mvalue_t_int self) -> bool"""
        return _oalib.vector_mvalue_t_int___bool__(self)

    def __len__(self):
        r"""__len__(vector_mvalue_t_int self) -> std::vector< mvalue_t< int > >::size_type"""
        return _oalib.vector_mvalue_t_int___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(vector_mvalue_t_int self, std::vector< mvalue_t< int > >::difference_type i, std::vector< mvalue_t< int > >::difference_type j) -> vector_mvalue_t_int"""
        return _oalib.vector_mvalue_t_int___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(vector_mvalue_t_int self, std::vector< mvalue_t< int > >::difference_type i, std::vector< mvalue_t< int > >::difference_type j)
        __setslice__(vector_mvalue_t_int self, std::vector< mvalue_t< int > >::difference_type i, std::vector< mvalue_t< int > >::difference_type j, vector_mvalue_t_int v)
        """
        return _oalib.vector_mvalue_t_int___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(vector_mvalue_t_int self, std::vector< mvalue_t< int > >::difference_type i, std::vector< mvalue_t< int > >::difference_type j)"""
        return _oalib.vector_mvalue_t_int___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(vector_mvalue_t_int self, std::vector< mvalue_t< int > >::difference_type i)
        __delitem__(vector_mvalue_t_int self, PySliceObject * slice)
        """
        return _oalib.vector_mvalue_t_int___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(vector_mvalue_t_int self, PySliceObject * slice) -> vector_mvalue_t_int
        __getitem__(vector_mvalue_t_int self, std::vector< mvalue_t< int > >::difference_type i) -> std::vector< mvalue_t< int > >::value_type const &
        """
        return _oalib.vector_mvalue_t_int___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(vector_mvalue_t_int self, PySliceObject * slice, vector_mvalue_t_int v)
        __setitem__(vector_mvalue_t_int self, PySliceObject * slice)
        __setitem__(vector_mvalue_t_int self, std::vector< mvalue_t< int > >::difference_type i, std::vector< mvalue_t< int > >::value_type const & x)
        """
        return _oalib.vector_mvalue_t_int___setitem__(self, *args)

    def pop(self):
        r"""pop(vector_mvalue_t_int self) -> std::vector< mvalue_t< int > >::value_type"""
        return _oalib.vector_mvalue_t_int_pop(self)

    def append(self, x):
        r"""append(vector_mvalue_t_int self, std::vector< mvalue_t< int > >::value_type const & x)"""
        return _oalib.vector_mvalue_t_int_append(self, x)

    def empty(self):
        r"""empty(vector_mvalue_t_int self) -> bool"""
        return _oalib.vector_mvalue_t_int_empty(self)

    def size(self):
        r"""size(vector_mvalue_t_int self) -> std::vector< mvalue_t< int > >::size_type"""
        return _oalib.vector_mvalue_t_int_size(self)

    def swap(self, v):
        r"""swap(vector_mvalue_t_int self, vector_mvalue_t_int v)"""
        return _oalib.vector_mvalue_t_int_swap(self, v)

    def begin(self):
        r"""begin(vector_mvalue_t_int self) -> std::vector< mvalue_t< int > >::iterator"""
        return _oalib.vector_mvalue_t_int_begin(self)

    def end(self):
        r"""end(vector_mvalue_t_int self) -> std::vector< mvalue_t< int > >::iterator"""
        return _oalib.vector_mvalue_t_int_end(self)

    def rbegin(self):
        r"""rbegin(vector_mvalue_t_int self) -> std::vector< mvalue_t< int > >::reverse_iterator"""
        return _oalib.vector_mvalue_t_int_rbegin(self)

    def rend(self):
        r"""rend(vector_mvalue_t_int self) -> std::vector< mvalue_t< int > >::reverse_iterator"""
        return _oalib.vector_mvalue_t_int_rend(self)

    def clear(self):
        r"""clear(vector_mvalue_t_int self)"""
        return _oalib.vector_mvalue_t_int_clear(self)

    def get_allocator(self):
        r"""get_allocator(vector_mvalue_t_int self) -> std::vector< mvalue_t< int > >::allocator_type"""
        return _oalib.vector_mvalue_t_int_get_allocator(self)

    def pop_back(self):
        r"""pop_back(vector_mvalue_t_int self)"""
        return _oalib.vector_mvalue_t_int_pop_back(self)

    def erase(self, *args):
        r"""
        erase(vector_mvalue_t_int self, std::vector< mvalue_t< int > >::iterator pos) -> std::vector< mvalue_t< int > >::iterator
        erase(vector_mvalue_t_int self, std::vector< mvalue_t< int > >::iterator first, std::vector< mvalue_t< int > >::iterator last) -> std::vector< mvalue_t< int > >::iterator
        """
        return _oalib.vector_mvalue_t_int_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(vector_mvalue_t_int self) -> vector_mvalue_t_int
        __init__(vector_mvalue_t_int self, vector_mvalue_t_int other) -> vector_mvalue_t_int
        __init__(vector_mvalue_t_int self, std::vector< mvalue_t< int > >::size_type size) -> vector_mvalue_t_int
        __init__(vector_mvalue_t_int self, std::vector< mvalue_t< int > >::size_type size, std::vector< mvalue_t< int > >::value_type const & value) -> vector_mvalue_t_int
        """
        _oalib.vector_mvalue_t_int_swiginit(self, _oalib.new_vector_mvalue_t_int(*args))

    def push_back(self, x):
        r"""push_back(vector_mvalue_t_int self, std::vector< mvalue_t< int > >::value_type const & x)"""
        return _oalib.vector_mvalue_t_int_push_back(self, x)

    def front(self):
        r"""front(vector_mvalue_t_int self) -> std::vector< mvalue_t< int > >::value_type const &"""
        return _oalib.vector_mvalue_t_int_front(self)

    def back(self):
        r"""back(vector_mvalue_t_int self) -> std::vector< mvalue_t< int > >::value_type const &"""
        return _oalib.vector_mvalue_t_int_back(self)

    def assign(self, n, x):
        r"""assign(vector_mvalue_t_int self, std::vector< mvalue_t< int > >::size_type n, std::vector< mvalue_t< int > >::value_type const & x)"""
        return _oalib.vector_mvalue_t_int_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(vector_mvalue_t_int self, std::vector< mvalue_t< int > >::size_type new_size)
        resize(vector_mvalue_t_int self, std::vector< mvalue_t< int > >::size_type new_size, std::vector< mvalue_t< int > >::value_type const & x)
        """
        return _oalib.vector_mvalue_t_int_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(vector_mvalue_t_int self, std::vector< mvalue_t< int > >::iterator pos, std::vector< mvalue_t< int > >::value_type const & x) -> std::vector< mvalue_t< int > >::iterator
        insert(vector_mvalue_t_int self, std::vector< mvalue_t< int > >::iterator pos, std::vector< mvalue_t< int > >::size_type n, std::vector< mvalue_t< int > >::value_type const & x)
        """
        return _oalib.vector_mvalue_t_int_insert(self, *args)

    def reserve(self, n):
        r"""reserve(vector_mvalue_t_int self, std::vector< mvalue_t< int > >::size_type n)"""
        return _oalib.vector_mvalue_t_int_reserve(self, n)

    def capacity(self):
        r"""capacity(vector_mvalue_t_int self) -> std::vector< mvalue_t< int > >::size_type"""
        return _oalib.vector_mvalue_t_int_capacity(self)
    __swig_destroy__ = _oalib.delete_vector_mvalue_t_int

# Register vector_mvalue_t_int in _oalib:
_oalib.vector_mvalue_t_int_swigregister(vector_mvalue_t_int)

class vector_mvalue_t_long(object):
    r"""Proxy of C++ std::vector< mvalue_t< long > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(vector_mvalue_t_long self) -> SwigPyIterator"""
        return _oalib.vector_mvalue_t_long_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(vector_mvalue_t_long self) -> bool"""
        return _oalib.vector_mvalue_t_long___nonzero__(self)

    def __bool__(self):
        r"""__bool__(vector_mvalue_t_long self) -> bool"""
        return _oalib.vector_mvalue_t_long___bool__(self)

    def __len__(self):
        r"""__len__(vector_mvalue_t_long self) -> std::vector< mvalue_t< long > >::size_type"""
        return _oalib.vector_mvalue_t_long___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(vector_mvalue_t_long self, std::vector< mvalue_t< long > >::difference_type i, std::vector< mvalue_t< long > >::difference_type j) -> vector_mvalue_t_long"""
        return _oalib.vector_mvalue_t_long___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(vector_mvalue_t_long self, std::vector< mvalue_t< long > >::difference_type i, std::vector< mvalue_t< long > >::difference_type j)
        __setslice__(vector_mvalue_t_long self, std::vector< mvalue_t< long > >::difference_type i, std::vector< mvalue_t< long > >::difference_type j, vector_mvalue_t_long v)
        """
        return _oalib.vector_mvalue_t_long___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(vector_mvalue_t_long self, std::vector< mvalue_t< long > >::difference_type i, std::vector< mvalue_t< long > >::difference_type j)"""
        return _oalib.vector_mvalue_t_long___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(vector_mvalue_t_long self, std::vector< mvalue_t< long > >::difference_type i)
        __delitem__(vector_mvalue_t_long self, PySliceObject * slice)
        """
        return _oalib.vector_mvalue_t_long___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(vector_mvalue_t_long self, PySliceObject * slice) -> vector_mvalue_t_long
        __getitem__(vector_mvalue_t_long self, std::vector< mvalue_t< long > >::difference_type i) -> mvalue_t_long
        """
        return _oalib.vector_mvalue_t_long___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(vector_mvalue_t_long self, PySliceObject * slice, vector_mvalue_t_long v)
        __setitem__(vector_mvalue_t_long self, PySliceObject * slice)
        __setitem__(vector_mvalue_t_long self, std::vector< mvalue_t< long > >::difference_type i, mvalue_t_long x)
        """
        return _oalib.vector_mvalue_t_long___setitem__(self, *args)

    def pop(self):
        r"""pop(vector_mvalue_t_long self) -> mvalue_t_long"""
        return _oalib.vector_mvalue_t_long_pop(self)

    def append(self, x):
        r"""append(vector_mvalue_t_long self, mvalue_t_long x)"""
        return _oalib.vector_mvalue_t_long_append(self, x)

    def empty(self):
        r"""empty(vector_mvalue_t_long self) -> bool"""
        return _oalib.vector_mvalue_t_long_empty(self)

    def size(self):
        r"""size(vector_mvalue_t_long self) -> std::vector< mvalue_t< long > >::size_type"""
        return _oalib.vector_mvalue_t_long_size(self)

    def swap(self, v):
        r"""swap(vector_mvalue_t_long self, vector_mvalue_t_long v)"""
        return _oalib.vector_mvalue_t_long_swap(self, v)

    def begin(self):
        r"""begin(vector_mvalue_t_long self) -> std::vector< mvalue_t< long > >::iterator"""
        return _oalib.vector_mvalue_t_long_begin(self)

    def end(self):
        r"""end(vector_mvalue_t_long self) -> std::vector< mvalue_t< long > >::iterator"""
        return _oalib.vector_mvalue_t_long_end(self)

    def rbegin(self):
        r"""rbegin(vector_mvalue_t_long self) -> std::vector< mvalue_t< long > >::reverse_iterator"""
        return _oalib.vector_mvalue_t_long_rbegin(self)

    def rend(self):
        r"""rend(vector_mvalue_t_long self) -> std::vector< mvalue_t< long > >::reverse_iterator"""
        return _oalib.vector_mvalue_t_long_rend(self)

    def clear(self):
        r"""clear(vector_mvalue_t_long self)"""
        return _oalib.vector_mvalue_t_long_clear(self)

    def get_allocator(self):
        r"""get_allocator(vector_mvalue_t_long self) -> std::vector< mvalue_t< long > >::allocator_type"""
        return _oalib.vector_mvalue_t_long_get_allocator(self)

    def pop_back(self):
        r"""pop_back(vector_mvalue_t_long self)"""
        return _oalib.vector_mvalue_t_long_pop_back(self)

    def erase(self, *args):
        r"""
        erase(vector_mvalue_t_long self, std::vector< mvalue_t< long > >::iterator pos) -> std::vector< mvalue_t< long > >::iterator
        erase(vector_mvalue_t_long self, std::vector< mvalue_t< long > >::iterator first, std::vector< mvalue_t< long > >::iterator last) -> std::vector< mvalue_t< long > >::iterator
        """
        return _oalib.vector_mvalue_t_long_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(vector_mvalue_t_long self) -> vector_mvalue_t_long
        __init__(vector_mvalue_t_long self, vector_mvalue_t_long other) -> vector_mvalue_t_long
        __init__(vector_mvalue_t_long self, std::vector< mvalue_t< long > >::size_type size) -> vector_mvalue_t_long
        __init__(vector_mvalue_t_long self, std::vector< mvalue_t< long > >::size_type size, mvalue_t_long value) -> vector_mvalue_t_long
        """
        _oalib.vector_mvalue_t_long_swiginit(self, _oalib.new_vector_mvalue_t_long(*args))

    def push_back(self, x):
        r"""push_back(vector_mvalue_t_long self, mvalue_t_long x)"""
        return _oalib.vector_mvalue_t_long_push_back(self, x)

    def front(self):
        r"""front(vector_mvalue_t_long self) -> mvalue_t_long"""
        return _oalib.vector_mvalue_t_long_front(self)

    def back(self):
        r"""back(vector_mvalue_t_long self) -> mvalue_t_long"""
        return _oalib.vector_mvalue_t_long_back(self)

    def assign(self, n, x):
        r"""assign(vector_mvalue_t_long self, std::vector< mvalue_t< long > >::size_type n, mvalue_t_long x)"""
        return _oalib.vector_mvalue_t_long_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(vector_mvalue_t_long self, std::vector< mvalue_t< long > >::size_type new_size)
        resize(vector_mvalue_t_long self, std::vector< mvalue_t< long > >::size_type new_size, mvalue_t_long x)
        """
        return _oalib.vector_mvalue_t_long_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(vector_mvalue_t_long self, std::vector< mvalue_t< long > >::iterator pos, mvalue_t_long x) -> std::vector< mvalue_t< long > >::iterator
        insert(vector_mvalue_t_long self, std::vector< mvalue_t< long > >::iterator pos, std::vector< mvalue_t< long > >::size_type n, mvalue_t_long x)
        """
        return _oalib.vector_mvalue_t_long_insert(self, *args)

    def reserve(self, n):
        r"""reserve(vector_mvalue_t_long self, std::vector< mvalue_t< long > >::size_type n)"""
        return _oalib.vector_mvalue_t_long_reserve(self, n)

    def capacity(self):
        r"""capacity(vector_mvalue_t_long self) -> std::vector< mvalue_t< long > >::size_type"""
        return _oalib.vector_mvalue_t_long_capacity(self)
    __swig_destroy__ = _oalib.delete_vector_mvalue_t_long

# Register vector_mvalue_t_long in _oalib:
_oalib.vector_mvalue_t_long_swigregister(vector_mvalue_t_long)

class DequeParetoElementLong(object):
    r"""Proxy of C++ std::deque< pareto_element< mvalue_t< long >,long > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(DequeParetoElementLong self) -> SwigPyIterator"""
        return _oalib.DequeParetoElementLong_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(DequeParetoElementLong self) -> bool"""
        return _oalib.DequeParetoElementLong___nonzero__(self)

    def __bool__(self):
        r"""__bool__(DequeParetoElementLong self) -> bool"""
        return _oalib.DequeParetoElementLong___bool__(self)

    def __len__(self):
        r"""__len__(DequeParetoElementLong self) -> std::deque< pareto_element< mvalue_t< long >,long > >::size_type"""
        return _oalib.DequeParetoElementLong___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(DequeParetoElementLong self, std::deque< pareto_element< mvalue_t< long >,long > >::difference_type i, std::deque< pareto_element< mvalue_t< long >,long > >::difference_type j) -> DequeParetoElementLong"""
        return _oalib.DequeParetoElementLong___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(DequeParetoElementLong self, std::deque< pareto_element< mvalue_t< long >,long > >::difference_type i, std::deque< pareto_element< mvalue_t< long >,long > >::difference_type j)
        __setslice__(DequeParetoElementLong self, std::deque< pareto_element< mvalue_t< long >,long > >::difference_type i, std::deque< pareto_element< mvalue_t< long >,long > >::difference_type j, DequeParetoElementLong v)
        """
        return _oalib.DequeParetoElementLong___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(DequeParetoElementLong self, std::deque< pareto_element< mvalue_t< long >,long > >::difference_type i, std::deque< pareto_element< mvalue_t< long >,long > >::difference_type j)"""
        return _oalib.DequeParetoElementLong___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(DequeParetoElementLong self, std::deque< pareto_element< mvalue_t< long >,long > >::difference_type i)
        __delitem__(DequeParetoElementLong self, PySliceObject * slice)
        """
        return _oalib.DequeParetoElementLong___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(DequeParetoElementLong self, PySliceObject * slice) -> DequeParetoElementLong
        __getitem__(DequeParetoElementLong self, std::deque< pareto_element< mvalue_t< long >,long > >::difference_type i) -> ParetoElementLong
        """
        return _oalib.DequeParetoElementLong___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(DequeParetoElementLong self, PySliceObject * slice, DequeParetoElementLong v)
        __setitem__(DequeParetoElementLong self, PySliceObject * slice)
        __setitem__(DequeParetoElementLong self, std::deque< pareto_element< mvalue_t< long >,long > >::difference_type i, ParetoElementLong x)
        """
        return _oalib.DequeParetoElementLong___setitem__(self, *args)

    def pop(self):
        r"""pop(DequeParetoElementLong self) -> ParetoElementLong"""
        return _oalib.DequeParetoElementLong_pop(self)

    def append(self, x):
        r"""append(DequeParetoElementLong self, ParetoElementLong x)"""
        return _oalib.DequeParetoElementLong_append(self, x)

    def empty(self):
        r"""empty(DequeParetoElementLong self) -> bool"""
        return _oalib.DequeParetoElementLong_empty(self)

    def size(self):
        r"""size(DequeParetoElementLong self) -> std::deque< pareto_element< mvalue_t< long >,long > >::size_type"""
        return _oalib.DequeParetoElementLong_size(self)

    def swap(self, v):
        r"""swap(DequeParetoElementLong self, DequeParetoElementLong v)"""
        return _oalib.DequeParetoElementLong_swap(self, v)

    def begin(self):
        r"""begin(DequeParetoElementLong self) -> std::deque< pareto_element< mvalue_t< long >,long > >::iterator"""
        return _oalib.DequeParetoElementLong_begin(self)

    def end(self):
        r"""end(DequeParetoElementLong self) -> std::deque< pareto_element< mvalue_t< long >,long > >::iterator"""
        return _oalib.DequeParetoElementLong_end(self)

    def rbegin(self):
        r"""rbegin(DequeParetoElementLong self) -> std::deque< pareto_element< mvalue_t< long >,long > >::reverse_iterator"""
        return _oalib.DequeParetoElementLong_rbegin(self)

    def rend(self):
        r"""rend(DequeParetoElementLong self) -> std::deque< pareto_element< mvalue_t< long >,long > >::reverse_iterator"""
        return _oalib.DequeParetoElementLong_rend(self)

    def clear(self):
        r"""clear(DequeParetoElementLong self)"""
        return _oalib.DequeParetoElementLong_clear(self)

    def get_allocator(self):
        r"""get_allocator(DequeParetoElementLong self) -> std::deque< pareto_element< mvalue_t< long >,long > >::allocator_type"""
        return _oalib.DequeParetoElementLong_get_allocator(self)

    def pop_back(self):
        r"""pop_back(DequeParetoElementLong self)"""
        return _oalib.DequeParetoElementLong_pop_back(self)

    def erase(self, *args):
        r"""
        erase(DequeParetoElementLong self, std::deque< pareto_element< mvalue_t< long >,long > >::iterator pos) -> std::deque< pareto_element< mvalue_t< long >,long > >::iterator
        erase(DequeParetoElementLong self, std::deque< pareto_element< mvalue_t< long >,long > >::iterator first, std::deque< pareto_element< mvalue_t< long >,long > >::iterator last) -> std::deque< pareto_element< mvalue_t< long >,long > >::iterator
        """
        return _oalib.DequeParetoElementLong_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(DequeParetoElementLong self) -> DequeParetoElementLong
        __init__(DequeParetoElementLong self, DequeParetoElementLong other) -> DequeParetoElementLong
        __init__(DequeParetoElementLong self, std::deque< pareto_element< mvalue_t< long >,long > >::size_type size) -> DequeParetoElementLong
        __init__(DequeParetoElementLong self, std::deque< pareto_element< mvalue_t< long >,long > >::size_type size, ParetoElementLong value) -> DequeParetoElementLong
        """
        _oalib.DequeParetoElementLong_swiginit(self, _oalib.new_DequeParetoElementLong(*args))

    def push_back(self, x):
        r"""push_back(DequeParetoElementLong self, ParetoElementLong x)"""
        return _oalib.DequeParetoElementLong_push_back(self, x)

    def front(self):
        r"""front(DequeParetoElementLong self) -> ParetoElementLong"""
        return _oalib.DequeParetoElementLong_front(self)

    def back(self):
        r"""back(DequeParetoElementLong self) -> ParetoElementLong"""
        return _oalib.DequeParetoElementLong_back(self)

    def assign(self, n, x):
        r"""assign(DequeParetoElementLong self, std::deque< pareto_element< mvalue_t< long >,long > >::size_type n, ParetoElementLong x)"""
        return _oalib.DequeParetoElementLong_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(DequeParetoElementLong self, std::deque< pareto_element< mvalue_t< long >,long > >::size_type new_size)
        resize(DequeParetoElementLong self, std::deque< pareto_element< mvalue_t< long >,long > >::size_type new_size, ParetoElementLong x)
        """
        return _oalib.DequeParetoElementLong_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(DequeParetoElementLong self, std::deque< pareto_element< mvalue_t< long >,long > >::iterator pos, ParetoElementLong x) -> std::deque< pareto_element< mvalue_t< long >,long > >::iterator
        insert(DequeParetoElementLong self, std::deque< pareto_element< mvalue_t< long >,long > >::iterator pos, std::deque< pareto_element< mvalue_t< long >,long > >::size_type n, ParetoElementLong x)
        """
        return _oalib.DequeParetoElementLong_insert(self, *args)

    def pop_front(self):
        r"""pop_front(DequeParetoElementLong self)"""
        return _oalib.DequeParetoElementLong_pop_front(self)

    def push_front(self, x):
        r"""push_front(DequeParetoElementLong self, ParetoElementLong x)"""
        return _oalib.DequeParetoElementLong_push_front(self, x)
    __swig_destroy__ = _oalib.delete_DequeParetoElementLong

# Register DequeParetoElementLong in _oalib:
_oalib.DequeParetoElementLong_swigregister(DequeParetoElementLong)

class conference_columnVector(object):
    r"""Proxy of C++ std::vector< conference_column > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(conference_columnVector self) -> SwigPyIterator"""
        return _oalib.conference_columnVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(conference_columnVector self) -> bool"""
        return _oalib.conference_columnVector___nonzero__(self)

    def __bool__(self):
        r"""__bool__(conference_columnVector self) -> bool"""
        return _oalib.conference_columnVector___bool__(self)

    def __len__(self):
        r"""__len__(conference_columnVector self) -> std::vector< std::vector< signed char,std::allocator< signed char > > >::size_type"""
        return _oalib.conference_columnVector___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(conference_columnVector self, std::vector< std::vector< signed char,std::allocator< signed char > > >::difference_type i, std::vector< std::vector< signed char,std::allocator< signed char > > >::difference_type j) -> conference_columnVector"""
        return _oalib.conference_columnVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(conference_columnVector self, std::vector< std::vector< signed char,std::allocator< signed char > > >::difference_type i, std::vector< std::vector< signed char,std::allocator< signed char > > >::difference_type j)
        __setslice__(conference_columnVector self, std::vector< std::vector< signed char,std::allocator< signed char > > >::difference_type i, std::vector< std::vector< signed char,std::allocator< signed char > > >::difference_type j, conference_columnVector v)
        """
        return _oalib.conference_columnVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(conference_columnVector self, std::vector< std::vector< signed char,std::allocator< signed char > > >::difference_type i, std::vector< std::vector< signed char,std::allocator< signed char > > >::difference_type j)"""
        return _oalib.conference_columnVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(conference_columnVector self, std::vector< std::vector< signed char,std::allocator< signed char > > >::difference_type i)
        __delitem__(conference_columnVector self, PySliceObject * slice)
        """
        return _oalib.conference_columnVector___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(conference_columnVector self, PySliceObject * slice) -> conference_columnVector
        __getitem__(conference_columnVector self, std::vector< std::vector< signed char,std::allocator< signed char > > >::difference_type i) -> charVector
        """
        return _oalib.conference_columnVector___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(conference_columnVector self, PySliceObject * slice, conference_columnVector v)
        __setitem__(conference_columnVector self, PySliceObject * slice)
        __setitem__(conference_columnVector self, std::vector< std::vector< signed char,std::allocator< signed char > > >::difference_type i, charVector x)
        """
        return _oalib.conference_columnVector___setitem__(self, *args)

    def pop(self):
        r"""pop(conference_columnVector self) -> charVector"""
        return _oalib.conference_columnVector_pop(self)

    def append(self, x):
        r"""append(conference_columnVector self, charVector x)"""
        return _oalib.conference_columnVector_append(self, x)

    def empty(self):
        r"""empty(conference_columnVector self) -> bool"""
        return _oalib.conference_columnVector_empty(self)

    def size(self):
        r"""size(conference_columnVector self) -> std::vector< std::vector< signed char,std::allocator< signed char > > >::size_type"""
        return _oalib.conference_columnVector_size(self)

    def swap(self, v):
        r"""swap(conference_columnVector self, conference_columnVector v)"""
        return _oalib.conference_columnVector_swap(self, v)

    def begin(self):
        r"""begin(conference_columnVector self) -> std::vector< std::vector< signed char,std::allocator< signed char > > >::iterator"""
        return _oalib.conference_columnVector_begin(self)

    def end(self):
        r"""end(conference_columnVector self) -> std::vector< std::vector< signed char,std::allocator< signed char > > >::iterator"""
        return _oalib.conference_columnVector_end(self)

    def rbegin(self):
        r"""rbegin(conference_columnVector self) -> std::vector< std::vector< signed char,std::allocator< signed char > > >::reverse_iterator"""
        return _oalib.conference_columnVector_rbegin(self)

    def rend(self):
        r"""rend(conference_columnVector self) -> std::vector< std::vector< signed char,std::allocator< signed char > > >::reverse_iterator"""
        return _oalib.conference_columnVector_rend(self)

    def clear(self):
        r"""clear(conference_columnVector self)"""
        return _oalib.conference_columnVector_clear(self)

    def get_allocator(self):
        r"""get_allocator(conference_columnVector self) -> std::vector< std::vector< signed char,std::allocator< signed char > > >::allocator_type"""
        return _oalib.conference_columnVector_get_allocator(self)

    def pop_back(self):
        r"""pop_back(conference_columnVector self)"""
        return _oalib.conference_columnVector_pop_back(self)

    def erase(self, *args):
        r"""
        erase(conference_columnVector self, std::vector< std::vector< signed char,std::allocator< signed char > > >::iterator pos) -> std::vector< std::vector< signed char,std::allocator< signed char > > >::iterator
        erase(conference_columnVector self, std::vector< std::vector< signed char,std::allocator< signed char > > >::iterator first, std::vector< std::vector< signed char,std::allocator< signed char > > >::iterator last) -> std::vector< std::vector< signed char,std::allocator< signed char > > >::iterator
        """
        return _oalib.conference_columnVector_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(conference_columnVector self) -> conference_columnVector
        __init__(conference_columnVector self, conference_columnVector other) -> conference_columnVector
        __init__(conference_columnVector self, std::vector< std::vector< signed char,std::allocator< signed char > > >::size_type size) -> conference_columnVector
        __init__(conference_columnVector self, std::vector< std::vector< signed char,std::allocator< signed char > > >::size_type size, charVector value) -> conference_columnVector
        """
        _oalib.conference_columnVector_swiginit(self, _oalib.new_conference_columnVector(*args))

    def push_back(self, x):
        r"""push_back(conference_columnVector self, charVector x)"""
        return _oalib.conference_columnVector_push_back(self, x)

    def front(self):
        r"""front(conference_columnVector self) -> charVector"""
        return _oalib.conference_columnVector_front(self)

    def back(self):
        r"""back(conference_columnVector self) -> charVector"""
        return _oalib.conference_columnVector_back(self)

    def assign(self, n, x):
        r"""assign(conference_columnVector self, std::vector< std::vector< signed char,std::allocator< signed char > > >::size_type n, charVector x)"""
        return _oalib.conference_columnVector_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(conference_columnVector self, std::vector< std::vector< signed char,std::allocator< signed char > > >::size_type new_size)
        resize(conference_columnVector self, std::vector< std::vector< signed char,std::allocator< signed char > > >::size_type new_size, charVector x)
        """
        return _oalib.conference_columnVector_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(conference_columnVector self, std::vector< std::vector< signed char,std::allocator< signed char > > >::iterator pos, charVector x) -> std::vector< std::vector< signed char,std::allocator< signed char > > >::iterator
        insert(conference_columnVector self, std::vector< std::vector< signed char,std::allocator< signed char > > >::iterator pos, std::vector< std::vector< signed char,std::allocator< signed char > > >::size_type n, charVector x)
        """
        return _oalib.conference_columnVector_insert(self, *args)

    def reserve(self, n):
        r"""reserve(conference_columnVector self, std::vector< std::vector< signed char,std::allocator< signed char > > >::size_type n)"""
        return _oalib.conference_columnVector_reserve(self, n)

    def capacity(self):
        r"""capacity(conference_columnVector self) -> std::vector< std::vector< signed char,std::allocator< signed char > > >::size_type"""
        return _oalib.conference_columnVector_capacity(self)
    __swig_destroy__ = _oalib.delete_conference_columnVector

# Register conference_columnVector in _oalib:
_oalib.conference_columnVector_swigregister(conference_columnVector)


def calculateArrayParetoJ5(al, verbose):
    r"""
    calculateArrayParetoJ5(array_link al, int verbose) -> Pareto< mvalue_t< long >,array_link >::pValue


    Calculate Pareto element with J5 criterium.

    """
    return _oalib.calculateArrayParetoJ5(al, verbose)

def calculateArrayParetoJ5int(al, verbose):
    r"""
    calculateArrayParetoJ5int(array_link al, int verbose) -> Pareto< mvalue_t< long >,int >::pValue


    Calculate Pareto element with J5 criterium.

    """
    return _oalib.calculateArrayParetoJ5int(al, verbose)

def calculateArrayParetoJ5long(al, verbose):
    r"""
    calculateArrayParetoJ5long(array_link al, int verbose) -> vector_mvalue_t_long


    Calculate Pareto element with J5 criterium.

    """
    return _oalib.calculateArrayParetoJ5long(al, verbose)
class vector_vector_double(object):
    r"""Proxy of C++ std::vector< std::vector< double > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(vector_vector_double self) -> SwigPyIterator"""
        return _oalib.vector_vector_double_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(vector_vector_double self) -> bool"""
        return _oalib.vector_vector_double___nonzero__(self)

    def __bool__(self):
        r"""__bool__(vector_vector_double self) -> bool"""
        return _oalib.vector_vector_double___bool__(self)

    def __len__(self):
        r"""__len__(vector_vector_double self) -> std::vector< std::vector< double > >::size_type"""
        return _oalib.vector_vector_double___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(vector_vector_double self, std::vector< std::vector< double > >::difference_type i, std::vector< std::vector< double > >::difference_type j) -> vector_vector_double"""
        return _oalib.vector_vector_double___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(vector_vector_double self, std::vector< std::vector< double > >::difference_type i, std::vector< std::vector< double > >::difference_type j)
        __setslice__(vector_vector_double self, std::vector< std::vector< double > >::difference_type i, std::vector< std::vector< double > >::difference_type j, vector_vector_double v)
        """
        return _oalib.vector_vector_double___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(vector_vector_double self, std::vector< std::vector< double > >::difference_type i, std::vector< std::vector< double > >::difference_type j)"""
        return _oalib.vector_vector_double___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(vector_vector_double self, std::vector< std::vector< double > >::difference_type i)
        __delitem__(vector_vector_double self, PySliceObject * slice)
        """
        return _oalib.vector_vector_double___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(vector_vector_double self, PySliceObject * slice) -> vector_vector_double
        __getitem__(vector_vector_double self, std::vector< std::vector< double > >::difference_type i) -> doubleVector
        """
        return _oalib.vector_vector_double___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(vector_vector_double self, PySliceObject * slice, vector_vector_double v)
        __setitem__(vector_vector_double self, PySliceObject * slice)
        __setitem__(vector_vector_double self, std::vector< std::vector< double > >::difference_type i, doubleVector x)
        """
        return _oalib.vector_vector_double___setitem__(self, *args)

    def pop(self):
        r"""pop(vector_vector_double self) -> doubleVector"""
        return _oalib.vector_vector_double_pop(self)

    def append(self, x):
        r"""append(vector_vector_double self, doubleVector x)"""
        return _oalib.vector_vector_double_append(self, x)

    def empty(self):
        r"""empty(vector_vector_double self) -> bool"""
        return _oalib.vector_vector_double_empty(self)

    def size(self):
        r"""size(vector_vector_double self) -> std::vector< std::vector< double > >::size_type"""
        return _oalib.vector_vector_double_size(self)

    def swap(self, v):
        r"""swap(vector_vector_double self, vector_vector_double v)"""
        return _oalib.vector_vector_double_swap(self, v)

    def begin(self):
        r"""begin(vector_vector_double self) -> std::vector< std::vector< double > >::iterator"""
        return _oalib.vector_vector_double_begin(self)

    def end(self):
        r"""end(vector_vector_double self) -> std::vector< std::vector< double > >::iterator"""
        return _oalib.vector_vector_double_end(self)

    def rbegin(self):
        r"""rbegin(vector_vector_double self) -> std::vector< std::vector< double > >::reverse_iterator"""
        return _oalib.vector_vector_double_rbegin(self)

    def rend(self):
        r"""rend(vector_vector_double self) -> std::vector< std::vector< double > >::reverse_iterator"""
        return _oalib.vector_vector_double_rend(self)

    def clear(self):
        r"""clear(vector_vector_double self)"""
        return _oalib.vector_vector_double_clear(self)

    def get_allocator(self):
        r"""get_allocator(vector_vector_double self) -> std::vector< std::vector< double > >::allocator_type"""
        return _oalib.vector_vector_double_get_allocator(self)

    def pop_back(self):
        r"""pop_back(vector_vector_double self)"""
        return _oalib.vector_vector_double_pop_back(self)

    def erase(self, *args):
        r"""
        erase(vector_vector_double self, std::vector< std::vector< double > >::iterator pos) -> std::vector< std::vector< double > >::iterator
        erase(vector_vector_double self, std::vector< std::vector< double > >::iterator first, std::vector< std::vector< double > >::iterator last) -> std::vector< std::vector< double > >::iterator
        """
        return _oalib.vector_vector_double_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(vector_vector_double self) -> vector_vector_double
        __init__(vector_vector_double self, vector_vector_double other) -> vector_vector_double
        __init__(vector_vector_double self, std::vector< std::vector< double > >::size_type size) -> vector_vector_double
        __init__(vector_vector_double self, std::vector< std::vector< double > >::size_type size, doubleVector value) -> vector_vector_double
        """
        _oalib.vector_vector_double_swiginit(self, _oalib.new_vector_vector_double(*args))

    def push_back(self, x):
        r"""push_back(vector_vector_double self, doubleVector x)"""
        return _oalib.vector_vector_double_push_back(self, x)

    def front(self):
        r"""front(vector_vector_double self) -> doubleVector"""
        return _oalib.vector_vector_double_front(self)

    def back(self):
        r"""back(vector_vector_double self) -> doubleVector"""
        return _oalib.vector_vector_double_back(self)

    def assign(self, n, x):
        r"""assign(vector_vector_double self, std::vector< std::vector< double > >::size_type n, doubleVector x)"""
        return _oalib.vector_vector_double_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(vector_vector_double self, std::vector< std::vector< double > >::size_type new_size)
        resize(vector_vector_double self, std::vector< std::vector< double > >::size_type new_size, doubleVector x)
        """
        return _oalib.vector_vector_double_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(vector_vector_double self, std::vector< std::vector< double > >::iterator pos, doubleVector x) -> std::vector< std::vector< double > >::iterator
        insert(vector_vector_double self, std::vector< std::vector< double > >::iterator pos, std::vector< std::vector< double > >::size_type n, doubleVector x)
        """
        return _oalib.vector_vector_double_insert(self, *args)

    def reserve(self, n):
        r"""reserve(vector_vector_double self, std::vector< std::vector< double > >::size_type n)"""
        return _oalib.vector_vector_double_reserve(self, n)

    def capacity(self):
        r"""capacity(vector_vector_double self) -> std::vector< std::vector< double > >::size_type"""
        return _oalib.vector_vector_double_capacity(self)
    __swig_destroy__ = _oalib.delete_vector_vector_double

# Register vector_vector_double in _oalib:
_oalib.vector_vector_double_swigregister(vector_vector_double)


def krawtchouk(j, x, n, s, verbose=0):
    r"""
    krawtchouk(long j, long x, long n, long s, int verbose=0) -> long


    calculate value of Krawtchouk polynomial

    """
    return _oalib.krawtchouk(j, x, n, s, verbose)

def choose_long(n, k):
    r"""choose_long(long const n, long const k) -> long"""
    return _oalib.choose_long(n, k)

def macwilliams_transform(B, N, s):
    r"""macwilliams_transform(doubleVector B, int N, int s) -> doubleVector"""
    return _oalib.macwilliams_transform(B, N, s)

# for legacy reasons and for name consistency
GWLPvalueVector = vector_mvalue_t_double
mvalueVector = vector_mvalue_t_long


__doc__ = """
Python Orthogonal Array Interface
"""

class ndarray_double(object):
    r"""Proxy of C++ ndarray< double > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    data = property(_oalib.ndarray_double_data_get, _oalib.ndarray_double_data_set, doc=r"""data : p.double""")
    dims = property(_oalib.ndarray_double_dims_get, _oalib.ndarray_double_dims_set, doc=r"""dims : std::vector<(int,std::allocator<(int)>)>""")
    k = property(_oalib.ndarray_double_k_get, _oalib.ndarray_double_k_set, doc=r"""k : int""")
    n = property(_oalib.ndarray_double_n_get, _oalib.ndarray_double_n_set, doc=r"""n : int""")
    cumdims = property(_oalib.ndarray_double_cumdims_get, _oalib.ndarray_double_cumdims_set, doc=r"""cumdims : std::vector<(int,std::allocator<(int)>)>""")
    cumprod = property(_oalib.ndarray_double_cumprod_get, _oalib.ndarray_double_cumprod_set, doc=r"""cumprod : std::vector<(int,std::allocator<(int)>)>""")

    def __init__(self, *args):
        r"""
        __init__(ndarray_double self, intVector dims) -> ndarray_double
        __init__(ndarray_double self, ndarray_double rhs) -> ndarray_double
        """
        _oalib.ndarray_double_swiginit(self, _oalib.new_ndarray_double(*args))
    __swig_destroy__ = _oalib.delete_ndarray_double

    def initialize(self, value):
        r"""initialize(ndarray_double self, double const value)"""
        return _oalib.ndarray_double_initialize(self, value)

    def sizeof_type(self):
        r"""sizeof_type(ndarray_double self) -> int"""
        return _oalib.ndarray_double_sizeof_type(self)

    def type_is_floating_point(self):
        r"""type_is_floating_point(ndarray_double self) -> bool"""
        return _oalib.ndarray_double_type_is_floating_point(self)

    def info(self):
        r"""info(ndarray_double self)"""
        return _oalib.ndarray_double_info(self)

    def idxstring(self, linear_idx):
        r"""idxstring(ndarray_double self, int linear_idx) -> std::string"""
        return _oalib.ndarray_double_idxstring(self, linear_idx)

    def totalsize(self):
        r"""totalsize(ndarray_double self) -> long"""
        return _oalib.ndarray_double_totalsize(self)

    def show(self):
        r"""show(ndarray_double self)"""
        return _oalib.ndarray_double_show(self)

    def linear2idx(self, *args):
        r"""
        linear2idx(ndarray_double self, int ndx, int * nidx=None)
        linear2idx(ndarray_double self, int ndx, intVector nidx)
        """
        return _oalib.ndarray_double_linear2idx(self, *args)

    def getlinearidx(self, idx):
        r"""getlinearidx(ndarray_double self, int * idx) -> int"""
        return _oalib.ndarray_double_getlinearidx(self, idx)

    def data_pointer(self):
        r"""data_pointer(ndarray_double self) -> void *"""
        return _oalib.ndarray_double_data_pointer(self)

    def setconstant(self, val):
        r"""setconstant(ndarray_double self, double val)"""
        return _oalib.ndarray_double_setconstant(self, val)

    def set(self, idx, val):
        r"""set(ndarray_double self, int * idx, double val)"""
        return _oalib.ndarray_double_set(self, idx, val)

    def setlinear(self, idx, val):
        r"""setlinear(ndarray_double self, int idx, double val)"""
        return _oalib.ndarray_double_setlinear(self, idx, val)

    def getlinear(self, idx):
        r"""getlinear(ndarray_double self, int idx) -> double"""
        return _oalib.ndarray_double_getlinear(self, idx)

    def get(self, idx):
        r"""get(ndarray_double self, int * idx) -> double"""
        return _oalib.ndarray_double_get(self, idx)


    @property
    def shape(self):
        return tuple(self.dims)

    def __getattr__(self, attr):
        if attr=='__array_interface__':
          a = dict()
          a['version']=3
          a['shape']=tuple(self.dims)
          sizeofdata=self.sizeof_type()
          is_floating_point = self.type_is_floating_point()

          if is_floating_point:
              a['typestr']='<f%d' % sizeofdata
          else:
    # assume signed integer type
              a['typestr']='<i%d' % sizeofdata
          a['data']=(self.data_pointer(), True)
    # convert from the OAP column-major style to Numpy row-major style
          a['strides'] = tuple(sizeofdata*p for p in list(self.cumprod)[:-1] )
          return a
        else:
          raise AttributeError("%r object has no attribute %r" %
                             (self.__class__, attr))



# Register ndarray_double in _oalib:
_oalib.ndarray_double_swigregister(ndarray_double)

class ndarray_long(object):
    r"""Proxy of C++ ndarray< long > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    data = property(_oalib.ndarray_long_data_get, _oalib.ndarray_long_data_set, doc=r"""data : p.long""")
    dims = property(_oalib.ndarray_long_dims_get, _oalib.ndarray_long_dims_set, doc=r"""dims : std::vector<(int,std::allocator<(int)>)>""")
    k = property(_oalib.ndarray_long_k_get, _oalib.ndarray_long_k_set, doc=r"""k : int""")
    n = property(_oalib.ndarray_long_n_get, _oalib.ndarray_long_n_set, doc=r"""n : int""")
    cumdims = property(_oalib.ndarray_long_cumdims_get, _oalib.ndarray_long_cumdims_set, doc=r"""cumdims : std::vector<(int,std::allocator<(int)>)>""")
    cumprod = property(_oalib.ndarray_long_cumprod_get, _oalib.ndarray_long_cumprod_set, doc=r"""cumprod : std::vector<(int,std::allocator<(int)>)>""")

    def __init__(self, *args):
        r"""
        __init__(ndarray_long self, intVector dims) -> ndarray_long
        __init__(ndarray_long self, ndarray_long rhs) -> ndarray_long
        """
        _oalib.ndarray_long_swiginit(self, _oalib.new_ndarray_long(*args))
    __swig_destroy__ = _oalib.delete_ndarray_long

    def initialize(self, value):
        r"""initialize(ndarray_long self, long const value)"""
        return _oalib.ndarray_long_initialize(self, value)

    def sizeof_type(self):
        r"""sizeof_type(ndarray_long self) -> int"""
        return _oalib.ndarray_long_sizeof_type(self)

    def type_is_floating_point(self):
        r"""type_is_floating_point(ndarray_long self) -> bool"""
        return _oalib.ndarray_long_type_is_floating_point(self)

    def info(self):
        r"""info(ndarray_long self)"""
        return _oalib.ndarray_long_info(self)

    def idxstring(self, linear_idx):
        r"""idxstring(ndarray_long self, int linear_idx) -> std::string"""
        return _oalib.ndarray_long_idxstring(self, linear_idx)

    def totalsize(self):
        r"""totalsize(ndarray_long self) -> long"""
        return _oalib.ndarray_long_totalsize(self)

    def show(self):
        r"""show(ndarray_long self)"""
        return _oalib.ndarray_long_show(self)

    def linear2idx(self, *args):
        r"""
        linear2idx(ndarray_long self, int ndx, int * nidx=None)
        linear2idx(ndarray_long self, int ndx, intVector nidx)
        """
        return _oalib.ndarray_long_linear2idx(self, *args)

    def getlinearidx(self, idx):
        r"""getlinearidx(ndarray_long self, int * idx) -> int"""
        return _oalib.ndarray_long_getlinearidx(self, idx)

    def data_pointer(self):
        r"""data_pointer(ndarray_long self) -> void *"""
        return _oalib.ndarray_long_data_pointer(self)

    def setconstant(self, val):
        r"""setconstant(ndarray_long self, long val)"""
        return _oalib.ndarray_long_setconstant(self, val)

    def set(self, idx, val):
        r"""set(ndarray_long self, int * idx, long val)"""
        return _oalib.ndarray_long_set(self, idx, val)

    def setlinear(self, idx, val):
        r"""setlinear(ndarray_long self, int idx, long val)"""
        return _oalib.ndarray_long_setlinear(self, idx, val)

    def getlinear(self, idx):
        r"""getlinear(ndarray_long self, int idx) -> long"""
        return _oalib.ndarray_long_getlinear(self, idx)

    def get(self, idx):
        r"""get(ndarray_long self, int * idx) -> long"""
        return _oalib.ndarray_long_get(self, idx)


    @property
    def shape(self):
        return tuple(self.dims)

    def __getattr__(self, attr):
        if attr=='__array_interface__':
          a = dict()
          a['version']=3
          a['shape']=tuple(self.dims)
          sizeofdata=self.sizeof_type()
          is_floating_point = self.type_is_floating_point()

          if is_floating_point:
              a['typestr']='<f%d' % sizeofdata
          else:
    # assume signed integer type
              a['typestr']='<i%d' % sizeofdata
          a['data']=(self.data_pointer(), True)
    # convert from the OAP column-major style to Numpy row-major style
          a['strides'] = tuple(sizeofdata*p for p in list(self.cumprod)[:-1] )
          return a
        else:
          raise AttributeError("%r object has no attribute %r" %
                             (self.__class__, attr))



# Register ndarray_long in _oalib:
_oalib.ndarray_long_swigregister(ndarray_long)



