# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import serialize
from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class RecordingRulesList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, room_sid):
        """
        Initialize the RecordingRulesList

        :param Version version: Version that contains the resource
        :param room_sid: The SID of the Room resource for the Recording Rules

        :returns: twilio.rest.video.v1.room.room_recording_rule.RecordingRulesList
        :rtype: twilio.rest.video.v1.room.room_recording_rule.RecordingRulesList
        """
        super(RecordingRulesList, self).__init__(version)

        # Path Solution
        self._solution = {'room_sid': room_sid, }
        self._uri = '/Rooms/{room_sid}/RecordingRules'.format(**self._solution)

    def fetch(self):
        """
        Fetch the RecordingRulesInstance

        :returns: The fetched RecordingRulesInstance
        :rtype: twilio.rest.video.v1.room.room_recording_rule.RecordingRulesInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return RecordingRulesInstance(self._version, payload, room_sid=self._solution['room_sid'], )

    def update(self, rules=values.unset):
        """
        Update the RecordingRulesInstance

        :param dict rules: A JSON-encoded array of recording rules

        :returns: The updated RecordingRulesInstance
        :rtype: twilio.rest.video.v1.room.room_recording_rule.RecordingRulesInstance
        """
        data = values.of({'Rules': serialize.object(rules), })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return RecordingRulesInstance(self._version, payload, room_sid=self._solution['room_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Video.V1.RecordingRulesList>'


class RecordingRulesPage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the RecordingRulesPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param room_sid: The SID of the Room resource for the Recording Rules

        :returns: twilio.rest.video.v1.room.room_recording_rule.RecordingRulesPage
        :rtype: twilio.rest.video.v1.room.room_recording_rule.RecordingRulesPage
        """
        super(RecordingRulesPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of RecordingRulesInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.video.v1.room.room_recording_rule.RecordingRulesInstance
        :rtype: twilio.rest.video.v1.room.room_recording_rule.RecordingRulesInstance
        """
        return RecordingRulesInstance(self._version, payload, room_sid=self._solution['room_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Video.V1.RecordingRulesPage>'


class RecordingRulesInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, payload, room_sid):
        """
        Initialize the RecordingRulesInstance

        :returns: twilio.rest.video.v1.room.room_recording_rule.RecordingRulesInstance
        :rtype: twilio.rest.video.v1.room.room_recording_rule.RecordingRulesInstance
        """
        super(RecordingRulesInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'room_sid': payload.get('room_sid'),
            'rules': payload.get('rules'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
        }

        # Context
        self._context = None
        self._solution = {'room_sid': room_sid, }

    @property
    def room_sid(self):
        """
        :returns: The SID of the Room resource for the Recording Rules
        :rtype: unicode
        """
        return self._properties['room_sid']

    @property
    def rules(self):
        """
        :returns: A collection of recording Rules that describe how to include or exclude matching tracks for recording
        :rtype: unicode
        """
        return self._properties['rules']

    @property
    def date_created(self):
        """
        :returns: The ISO 8601 date and time in GMT when the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The ISO 8601 date and time in GMT when the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Video.V1.RecordingRulesInstance>'
