import * as cloudwatch from '@aws-cdk/aws-cloudwatch';
declare module "./cluster-ref" {
    /**
     * Create a clustered database with a given number of instances.
     *
     * @stability stable
     */
    interface IDatabaseCluster {
        /**
         * Return the given named metric for this DBCluster.
         *
         * @stability stable
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The percentage of CPU utilization.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricCPUUtilization(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of database connections in use.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricDatabaseConnections(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The average number of deadlocks in the database per second.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricDeadlocks(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The amount of time that the instance has been running, in seconds.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricEngineUptime(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The amount of available random access memory, in bytes.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricFreeableMemory(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The amount of local storage available, in bytes.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricFreeLocalStorage(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The amount of network throughput received from clients by each instance, in bytes per second.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricNetworkReceiveThroughput(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The amount of network throughput both received from and transmitted to clients by each instance, in bytes per second.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricNetworkThroughput(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The amount of network throughput sent to clients by each instance, in bytes per second.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricNetworkTransmitThroughput(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The total amount of backup storage in bytes consumed by all Aurora snapshots outside its backup retention window.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricSnapshotStorageUsed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The total amount of backup storage in bytes for which you are billed.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricTotalBackupStorageBilled(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The amount of storage used by your Aurora DB instance, in bytes.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricVolumeBytesUsed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of billed read I/O operations from a cluster volume, reported at 5-minute intervals.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricVolumeReadIOPs(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of write disk I/O operations to the cluster volume, reported at 5-minute intervals.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricVolumeWriteIOPs(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
}
declare module "./cluster" {
    /**
     * A new or imported clustered database.
     *
     * @stability stable
     */
    interface DatabaseClusterBase {
        /**
         * Return the given named metric for this DBCluster.
         *
         * @stability stable
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The percentage of CPU utilization.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricCPUUtilization(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of database connections in use.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricDatabaseConnections(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The average number of deadlocks in the database per second.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricDeadlocks(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The amount of time that the instance has been running, in seconds.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricEngineUptime(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The amount of available random access memory, in bytes.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricFreeableMemory(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The amount of local storage available, in bytes.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricFreeLocalStorage(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The amount of network throughput received from clients by each instance, in bytes per second.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricNetworkReceiveThroughput(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The amount of network throughput both received from and transmitted to clients by each instance, in bytes per second.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricNetworkThroughput(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The amount of network throughput sent to clients by each instance, in bytes per second.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricNetworkTransmitThroughput(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The total amount of backup storage in bytes consumed by all Aurora snapshots outside its backup retention window.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricSnapshotStorageUsed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The total amount of backup storage in bytes for which you are billed.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricTotalBackupStorageBilled(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The amount of storage used by your Aurora DB instance, in bytes.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricVolumeBytesUsed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of billed read I/O operations from a cluster volume, reported at 5-minute intervals.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricVolumeReadIOPs(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of write disk I/O operations to the cluster volume, reported at 5-minute intervals.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricVolumeWriteIOPs(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
}
declare module "./instance" {
    /**
     * A database instance.
     *
     * @stability stable
     */
    interface IDatabaseInstance {
        /**
         * Return the given named metric for this DBInstance.
         *
         * @stability stable
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The percentage of CPU utilization.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricCPUUtilization(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of database connections in use.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricDatabaseConnections(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The amount of available storage space.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricFreeStorageSpace(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The amount of available random access memory.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricFreeableMemory(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The average number of disk read I/O operations per second.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricWriteIOPS(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The average number of disk write I/O operations per second.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricReadIOPS(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
    /**
     * A new or imported database instance.
     *
     * @stability stable
     */
    interface DatabaseInstanceBase {
        /**
         * Return the given named metric for this DBInstance.
         *
         * @stability stable
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The percentage of CPU utilization.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricCPUUtilization(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of database connections in use.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricDatabaseConnections(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The amount of available storage space.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricFreeStorageSpace(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The amount of available random access memory.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricFreeableMemory(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The average number of disk read I/O operations per second.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricWriteIOPS(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The average number of disk write I/O operations per second.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricReadIOPS(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
}
