import { IResource, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IEngine } from './engine';
/**
 * Options for {@link IParameterGroup.bindToCluster}. Empty for now, but can be extended later.
 *
 * @stability stable
 */
export interface ParameterGroupClusterBindOptions {
}
/**
 * The type returned from {@link IParameterGroup.bindToCluster}.
 *
 * @stability stable
 */
export interface ParameterGroupClusterConfig {
    /**
     * The name of this parameter group.
     *
     * @stability stable
     */
    readonly parameterGroupName: string;
}
/**
 * Options for {@link IParameterGroup.bindToInstance}. Empty for now, but can be extended later.
 *
 * @stability stable
 */
export interface ParameterGroupInstanceBindOptions {
}
/**
 * The type returned from {@link IParameterGroup.bindToInstance}.
 *
 * @stability stable
 */
export interface ParameterGroupInstanceConfig {
    /**
     * The name of this parameter group.
     *
     * @stability stable
     */
    readonly parameterGroupName: string;
}
/**
 * A parameter group.
 *
 * Represents both a cluster parameter group,
 * and an instance parameter group.
 *
 * @stability stable
 */
export interface IParameterGroup extends IResource {
    /**
     * Method called when this Parameter Group is used when defining a database cluster.
     *
     * @stability stable
     */
    bindToCluster(options: ParameterGroupClusterBindOptions): ParameterGroupClusterConfig;
    /**
     * Method called when this Parameter Group is used when defining a database instance.
     *
     * @stability stable
     */
    bindToInstance(options: ParameterGroupInstanceBindOptions): ParameterGroupInstanceConfig;
    /**
     * Adds a parameter to this group.
     *
     * If this is an imported parameter group,
     * this method does nothing.
     *
     * @returns true if the parameter was actually added
     * (i.e., this ParameterGroup is not imported),
     * false otherwise
     * @stability stable
     */
    addParameter(key: string, value: string): boolean;
}
/**
 * Properties for a parameter group.
 *
 * @stability stable
 */
export interface ParameterGroupProps {
    /**
     * The database engine for this parameter group.
     *
     * @stability stable
     */
    readonly engine: IEngine;
    /**
     * Description for this parameter group.
     *
     * @default a CDK generated description
     * @stability stable
     */
    readonly description?: string;
    /**
     * The parameters in this parameter group.
     *
     * @default - None
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    };
}
/**
 * A parameter group.
 *
 * Represents both a cluster parameter group,
 * and an instance parameter group.
 *
 * @stability stable
 * @resource AWS::RDS::DBParameterGroup
 */
export declare class ParameterGroup extends Resource implements IParameterGroup {
    /**
     * Imports a parameter group.
     *
     * @stability stable
     */
    static fromParameterGroupName(scope: Construct, id: string, parameterGroupName: string): IParameterGroup;
    private readonly parameters;
    private readonly family;
    private readonly description?;
    private clusterCfnGroup?;
    private instanceCfnGroup?;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: ParameterGroupProps);
    /**
     * Method called when this Parameter Group is used when defining a database cluster.
     *
     * @stability stable
     */
    bindToCluster(_options: ParameterGroupClusterBindOptions): ParameterGroupClusterConfig;
    /**
     * Method called when this Parameter Group is used when defining a database instance.
     *
     * @stability stable
     */
    bindToInstance(_options: ParameterGroupInstanceBindOptions): ParameterGroupInstanceConfig;
    /**
     * Add a parameter to this parameter group.
     *
     * @param key The key of the parameter to be added.
     * @param value The value of the parameter to be added.
     * @stability stable
     */
    addParameter(key: string, value: string): boolean;
}
