# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://docs.mailslurp.com/) - [Examples](https://github.com/mailslurp/examples) repository  # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Contact: contact@mailslurp.dev
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailslurp_client.configuration import Configuration


class WaitForSingleSmsOptions(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'phone_number_id': 'str',
        'timeout': 'int',
        'unread_only': 'bool',
        'before': 'datetime',
        'since': 'datetime',
        'sort_direction': 'str',
        'delay': 'int'
    }

    attribute_map = {
        'phone_number_id': 'phoneNumberId',
        'timeout': 'timeout',
        'unread_only': 'unreadOnly',
        'before': 'before',
        'since': 'since',
        'sort_direction': 'sortDirection',
        'delay': 'delay'
    }

    def __init__(self, phone_number_id=None, timeout=None, unread_only=None, before=None, since=None, sort_direction=None, delay=None, local_vars_configuration=None):  # noqa: E501
        """WaitForSingleSmsOptions - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._phone_number_id = None
        self._timeout = None
        self._unread_only = None
        self._before = None
        self._since = None
        self._sort_direction = None
        self._delay = None
        self.discriminator = None

        self.phone_number_id = phone_number_id
        self.timeout = timeout
        if unread_only is not None:
            self.unread_only = unread_only
        if before is not None:
            self.before = before
        if since is not None:
            self.since = since
        if sort_direction is not None:
            self.sort_direction = sort_direction
        if delay is not None:
            self.delay = delay

    @property
    def phone_number_id(self):
        """Gets the phone_number_id of this WaitForSingleSmsOptions.  # noqa: E501


        :return: The phone_number_id of this WaitForSingleSmsOptions.  # noqa: E501
        :rtype: str
        """
        return self._phone_number_id

    @phone_number_id.setter
    def phone_number_id(self, phone_number_id):
        """Sets the phone_number_id of this WaitForSingleSmsOptions.


        :param phone_number_id: The phone_number_id of this WaitForSingleSmsOptions.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and phone_number_id is None:  # noqa: E501
            raise ValueError("Invalid value for `phone_number_id`, must not be `None`")  # noqa: E501

        self._phone_number_id = phone_number_id

    @property
    def timeout(self):
        """Gets the timeout of this WaitForSingleSmsOptions.  # noqa: E501


        :return: The timeout of this WaitForSingleSmsOptions.  # noqa: E501
        :rtype: int
        """
        return self._timeout

    @timeout.setter
    def timeout(self, timeout):
        """Sets the timeout of this WaitForSingleSmsOptions.


        :param timeout: The timeout of this WaitForSingleSmsOptions.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and timeout is None:  # noqa: E501
            raise ValueError("Invalid value for `timeout`, must not be `None`")  # noqa: E501

        self._timeout = timeout

    @property
    def unread_only(self):
        """Gets the unread_only of this WaitForSingleSmsOptions.  # noqa: E501


        :return: The unread_only of this WaitForSingleSmsOptions.  # noqa: E501
        :rtype: bool
        """
        return self._unread_only

    @unread_only.setter
    def unread_only(self, unread_only):
        """Sets the unread_only of this WaitForSingleSmsOptions.


        :param unread_only: The unread_only of this WaitForSingleSmsOptions.  # noqa: E501
        :type: bool
        """

        self._unread_only = unread_only

    @property
    def before(self):
        """Gets the before of this WaitForSingleSmsOptions.  # noqa: E501


        :return: The before of this WaitForSingleSmsOptions.  # noqa: E501
        :rtype: datetime
        """
        return self._before

    @before.setter
    def before(self, before):
        """Sets the before of this WaitForSingleSmsOptions.


        :param before: The before of this WaitForSingleSmsOptions.  # noqa: E501
        :type: datetime
        """

        self._before = before

    @property
    def since(self):
        """Gets the since of this WaitForSingleSmsOptions.  # noqa: E501


        :return: The since of this WaitForSingleSmsOptions.  # noqa: E501
        :rtype: datetime
        """
        return self._since

    @since.setter
    def since(self, since):
        """Sets the since of this WaitForSingleSmsOptions.


        :param since: The since of this WaitForSingleSmsOptions.  # noqa: E501
        :type: datetime
        """

        self._since = since

    @property
    def sort_direction(self):
        """Gets the sort_direction of this WaitForSingleSmsOptions.  # noqa: E501


        :return: The sort_direction of this WaitForSingleSmsOptions.  # noqa: E501
        :rtype: str
        """
        return self._sort_direction

    @sort_direction.setter
    def sort_direction(self, sort_direction):
        """Sets the sort_direction of this WaitForSingleSmsOptions.


        :param sort_direction: The sort_direction of this WaitForSingleSmsOptions.  # noqa: E501
        :type: str
        """
        allowed_values = ["ASC", "DESC"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and sort_direction not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `sort_direction` ({0}), must be one of {1}"  # noqa: E501
                .format(sort_direction, allowed_values)
            )

        self._sort_direction = sort_direction

    @property
    def delay(self):
        """Gets the delay of this WaitForSingleSmsOptions.  # noqa: E501


        :return: The delay of this WaitForSingleSmsOptions.  # noqa: E501
        :rtype: int
        """
        return self._delay

    @delay.setter
    def delay(self, delay):
        """Sets the delay of this WaitForSingleSmsOptions.


        :param delay: The delay of this WaitForSingleSmsOptions.  # noqa: E501
        :type: int
        """

        self._delay = delay

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WaitForSingleSmsOptions):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, WaitForSingleSmsOptions):
            return True

        return self.to_dict() != other.to_dict()
