"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UrlSubscription = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const sns = require("@aws-cdk/aws-sns");
const core_1 = require("@aws-cdk/core");
/**
 * Use a URL as a subscription target
 *
 * The message will be POSTed to the given URL.
 *
 * @see https://docs.aws.amazon.com/sns/latest/dg/sns-http-https-endpoint-as-subscriber.html
 */
class UrlSubscription {
    constructor(url, props = {}) {
        this.url = url;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_sns_subscriptions_UrlSubscriptionProps(props);
        this.unresolvedUrl = core_1.Token.isUnresolved(url);
        if (!this.unresolvedUrl && !url.startsWith('http://') && !url.startsWith('https://')) {
            throw new Error('URL must start with either http:// or https://');
        }
        if (this.unresolvedUrl && props.protocol === undefined) {
            throw new Error('Must provide protocol if url is unresolved');
        }
        if (this.unresolvedUrl) {
            this.protocol = props.protocol;
        }
        else {
            this.protocol = this.url.startsWith('https:') ? sns.SubscriptionProtocol.HTTPS : sns.SubscriptionProtocol.HTTP;
        }
    }
    /**
     * Returns a configuration for a URL to subscribe to an SNS topic
     */
    bind(_topic) {
        return {
            subscriberId: this.url,
            endpoint: this.url,
            protocol: this.protocol,
            rawMessageDelivery: this.props.rawMessageDelivery,
            filterPolicy: this.props.filterPolicy,
            deadLetterQueue: this.props.deadLetterQueue,
        };
    }
}
exports.UrlSubscription = UrlSubscription;
_a = JSII_RTTI_SYMBOL_1;
UrlSubscription[_a] = { fqn: "@aws-cdk/aws-sns-subscriptions.UrlSubscription", version: "1.146.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXJsLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidXJsLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLHdDQUF3QztBQUN4Qyx3Q0FBc0M7QUF3QnRDOzs7Ozs7R0FNRztBQUNILE1BQWEsZUFBZTtJQUkxQixZQUE2QixHQUFXLEVBQW1CLFFBQThCLEVBQUU7UUFBOUQsUUFBRyxHQUFILEdBQUcsQ0FBUTtRQUFtQixVQUFLLEdBQUwsS0FBSyxDQUEyQjs7UUFDekYsSUFBSSxDQUFDLGFBQWEsR0FBRyxZQUFLLENBQUMsWUFBWSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQzdDLElBQUksQ0FBQyxJQUFJLENBQUMsYUFBYSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7WUFDcEYsTUFBTSxJQUFJLEtBQUssQ0FBQyxnREFBZ0QsQ0FBQyxDQUFDO1NBQ25FO1FBRUQsSUFBSSxJQUFJLENBQUMsYUFBYSxJQUFJLEtBQUssQ0FBQyxRQUFRLEtBQUssU0FBUyxFQUFFO1lBQ3RELE1BQU0sSUFBSSxLQUFLLENBQUMsNENBQTRDLENBQUMsQ0FBQztTQUMvRDtRQUVELElBQUksSUFBSSxDQUFDLGFBQWEsRUFBRTtZQUN0QixJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFTLENBQUM7U0FDakM7YUFBTTtZQUNMLElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxvQkFBb0IsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUM7U0FDaEg7S0FDRjtJQUVEOztPQUVHO0lBQ0ksSUFBSSxDQUFDLE1BQWtCO1FBQzVCLE9BQU87WUFDTCxZQUFZLEVBQUUsSUFBSSxDQUFDLEdBQUc7WUFDdEIsUUFBUSxFQUFFLElBQUksQ0FBQyxHQUFHO1lBQ2xCLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixrQkFBa0IsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLGtCQUFrQjtZQUNqRCxZQUFZLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZO1lBQ3JDLGVBQWUsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLGVBQWU7U0FDNUMsQ0FBQztLQUNIOztBQWpDSCwwQ0FrQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBzbnMgZnJvbSAnQGF3cy1jZGsvYXdzLXNucyc7XG5pbXBvcnQgeyBUb2tlbiB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgU3Vic2NyaXB0aW9uUHJvcHMgfSBmcm9tICcuL3N1YnNjcmlwdGlvbic7XG5cbi8qKlxuICogT3B0aW9ucyBmb3IgVVJMIHN1YnNjcmlwdGlvbnMuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgVXJsU3Vic2NyaXB0aW9uUHJvcHMgZXh0ZW5kcyBTdWJzY3JpcHRpb25Qcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgbWVzc2FnZSB0byB0aGUgcXVldWUgaXMgdGhlIHNhbWUgYXMgaXQgd2FzIHNlbnQgdG8gdGhlIHRvcGljXG4gICAqXG4gICAqIElmIGZhbHNlLCB0aGUgbWVzc2FnZSB3aWxsIGJlIHdyYXBwZWQgaW4gYW4gU05TIGVudmVsb3BlLlxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgcmF3TWVzc2FnZURlbGl2ZXJ5PzogYm9vbGVhbjtcblxuICAvKipcbiAgICogVGhlIHN1YnNjcmlwdGlvbidzIHByb3RvY29sLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIFByb3RvY29sIGlzIGRlcml2ZWQgZnJvbSB1cmxcbiAgICovXG4gIHJlYWRvbmx5IHByb3RvY29sPzogc25zLlN1YnNjcmlwdGlvblByb3RvY29sO1xufVxuXG4vKipcbiAqIFVzZSBhIFVSTCBhcyBhIHN1YnNjcmlwdGlvbiB0YXJnZXRcbiAqXG4gKiBUaGUgbWVzc2FnZSB3aWxsIGJlIFBPU1RlZCB0byB0aGUgZ2l2ZW4gVVJMLlxuICpcbiAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Nucy9sYXRlc3QvZGcvc25zLWh0dHAtaHR0cHMtZW5kcG9pbnQtYXMtc3Vic2NyaWJlci5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBVcmxTdWJzY3JpcHRpb24gaW1wbGVtZW50cyBzbnMuSVRvcGljU3Vic2NyaXB0aW9uIHtcbiAgcHJpdmF0ZSByZWFkb25seSBwcm90b2NvbDogc25zLlN1YnNjcmlwdGlvblByb3RvY29sO1xuICBwcml2YXRlIHJlYWRvbmx5IHVucmVzb2x2ZWRVcmw6IGJvb2xlYW47XG5cbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSB1cmw6IHN0cmluZywgcHJpdmF0ZSByZWFkb25seSBwcm9wczogVXJsU3Vic2NyaXB0aW9uUHJvcHMgPSB7fSkge1xuICAgIHRoaXMudW5yZXNvbHZlZFVybCA9IFRva2VuLmlzVW5yZXNvbHZlZCh1cmwpO1xuICAgIGlmICghdGhpcy51bnJlc29sdmVkVXJsICYmICF1cmwuc3RhcnRzV2l0aCgnaHR0cDovLycpICYmICF1cmwuc3RhcnRzV2l0aCgnaHR0cHM6Ly8nKSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdVUkwgbXVzdCBzdGFydCB3aXRoIGVpdGhlciBodHRwOi8vIG9yIGh0dHBzOi8vJyk7XG4gICAgfVxuXG4gICAgaWYgKHRoaXMudW5yZXNvbHZlZFVybCAmJiBwcm9wcy5wcm90b2NvbCA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ011c3QgcHJvdmlkZSBwcm90b2NvbCBpZiB1cmwgaXMgdW5yZXNvbHZlZCcpO1xuICAgIH1cblxuICAgIGlmICh0aGlzLnVucmVzb2x2ZWRVcmwpIHtcbiAgICAgIHRoaXMucHJvdG9jb2wgPSBwcm9wcy5wcm90b2NvbCE7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMucHJvdG9jb2wgPSB0aGlzLnVybC5zdGFydHNXaXRoKCdodHRwczonKSA/IHNucy5TdWJzY3JpcHRpb25Qcm90b2NvbC5IVFRQUyA6IHNucy5TdWJzY3JpcHRpb25Qcm90b2NvbC5IVFRQO1xuICAgIH1cbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIGEgY29uZmlndXJhdGlvbiBmb3IgYSBVUkwgdG8gc3Vic2NyaWJlIHRvIGFuIFNOUyB0b3BpY1xuICAgKi9cbiAgcHVibGljIGJpbmQoX3RvcGljOiBzbnMuSVRvcGljKTogc25zLlRvcGljU3Vic2NyaXB0aW9uQ29uZmlnIHtcbiAgICByZXR1cm4ge1xuICAgICAgc3Vic2NyaWJlcklkOiB0aGlzLnVybCxcbiAgICAgIGVuZHBvaW50OiB0aGlzLnVybCxcbiAgICAgIHByb3RvY29sOiB0aGlzLnByb3RvY29sLFxuICAgICAgcmF3TWVzc2FnZURlbGl2ZXJ5OiB0aGlzLnByb3BzLnJhd01lc3NhZ2VEZWxpdmVyeSxcbiAgICAgIGZpbHRlclBvbGljeTogdGhpcy5wcm9wcy5maWx0ZXJQb2xpY3ksXG4gICAgICBkZWFkTGV0dGVyUXVldWU6IHRoaXMucHJvcHMuZGVhZExldHRlclF1ZXVlLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==