import pytest
from io import StringIO
from ansiblemetrics.playbook.num_name_with_vars import NumNameWithVars

#script_plays
script_0_1 = '---\n- name: play with a name\n\thosts: localhost\n\tvars:\n\t\t- var_name: not-mastery\n\n\ttasks:\n\t- name: set a variable\n\t\tset_fact:\n\t\ttask_var_name: "defined variable"\n\n\t- name: task with a name\n\t\tdebug:\n\t\t\tmsg: "I am mastery task"\n\n- name: second play with a name\n\thosts: localhost\n\n\ttasks:\n\t- name: task with a name\n\t\tdebug:\n\t\t\tmsg: "I am another mastery task"'
script_0_2 = 'tasks:\n- name: set a variable name\n\tset_fact:\n\ttask_var_name: "defined variable"\n\n- name: task with a name\n\tdebug:\n\t\tmsg: "I am mastery task"\n\n- name: task with a name\n\tdebug:\n\t\tmsg: "I am another mastery task"'
script_1 = 'tasks:\n- name: set a variable\n\tset_fact:\n\ttask_var_name: "defined variable"\n\n- name: task with a {{ simplevar }}\n\tdebug:\n\t\tmsg: "I am mastery task"'
script_4_1 = '---\n- name: play with a {{ var_name }}\n\thosts: localhost\n\tvars:\n\t\t- var_name: not-mastery\n\n\ttasks:\n\t- name: set a variable\n\t\tset_fact:\n\t\ttask_var_name: "defined variable"\n\n\t- name: task with a {{ task_var_name }}\n\t\tdebug:\n\t\t\tmsg: "I am mastery task"\n\n- name: second play with a {{ task_var_name }}\n\thosts: localhost\n\n\ttasks:\n\t- name: task with a {{ runtime_var_name }}\n\t\tdebug:\n\t\t\tmsg: "I am another mastery task"'
script_4_2 = '- hosts: all\n\ttasks:\n\t- delegate_to: localhost\n\t\tname: Update Server Profile {{ profile_name1 }} removing volume attachment DATA1\n\t\toneview_server_profile:\n\t\t\tconfig: \'{{ config }}\'\n\t\t\tdata:\n\t\t\t\taffinity: Bay\n\t\t\t\tbios:\n\t\t\t\t\tmanageBios: false\n\t\t\t\t\toverriddenSettings: []\n\t\t\t\tboot:\n\t\t\t\t\tmanageBoot: true\n\t\t\t\t\torder:\n\t\t\t\t\t- CD\n\t\t\t\t\t- USB\n\t\t\t\t\t- HardDisk\n\t\t\t\t\t- PXE\n\t\t\t\tbootMode:\n\t\t\t\t\tmanageMode: true\n\t\t\t\t\tmode: BIOS\n\t\t\t\tconnections:\n\t\t\t\t- boot:\n\t\t\t\t\t\tpriority: NotBootable\n\t\t\t\t\tfunctionType: Ethernet\n\t\t\t\t\tid: 1\n\t\t\t\t\tname: LAB\n\t\t\t\t\tnetworkName: \'{{ management_network }}\'\n\t\t\t\t\tportId: Mezz 3:2-a\n\t\t\t\t\trequestedMbps: \'2500\'\n\t\t\t\t\trequestedVFs: \'0\'\n\t\t\t\t- boot:\n\t\t\t\t\t\tbootVolumeSource: ManagedVolume\n\t\t\t\t\t\tpriority: Primary\n\t\t\t\t\tfunctionType: FibreChannel\n\t\t\t\t\tid: 2\n\t\t\t\t\tname: SAN-A\n\t\t\t\t\tnetworkName: \'{{ SAN_A_network }}\'\n\t\t\t\t\tportId: Mezz 2:1\n\t\t\t\t\trequestedMbps: Auto\n\t\t\t\t- boot:\n\t\t\t\t\t\tpriority: NotBootable\n\t\t\t\t\tfunctionType: FibreChannel\n\t\t\t\t\tid: 3\n\t\t\t\t\tname: SAN-B\n\t\t\t\t\tnetworkName: \'{{ SAN_B_network }}\'\n\t\t\t\t\tportId: Mezz 2:2\n\t\t\t\t\trequestedMbps: Auto\n\t\t\t\tdescription: \'use case 1: boot from SAN\'\n\t\t\t\tenclosureGroupName: \'{{ enclosure_group_name }}\'\n\t\t\t\thideUnusedFlexNics: true\n\t\t\t\tiscsiInitiatorName: \'\'\n\t\t\t\tiscsiInitiatorNameType: AutoGenerated\n\t\t\t\tlocalStorage:\n\t\t\t\t\tcontrollers: []\n\t\t\t\t\tsasLogicalJBODs: []\n\t\t\t\tmacType: Virtual\n\t\t\t\tname: \'{{ profile_name1 }}\'\n\t\t\t\tsanStorage:\n\t\t\t\t\thostOSType: Windows Server 2016\n\t\t\t\t\tmanageSanStorage: true\n\t\t\t\t\tvolumeAttachments:\n\t\t\t\t\t- id: 1\n\t\t\t\t\t\tisBootVolume: true\n\t\t\t\t\t\tlunType: Auto\n\t\t\t\t\t\tstoragePaths:\n\t\t\t\t\t\t- connectionId: 2\n\t\t\t\t\t\t\tisEnabled: true\n\t\t\t\t\t\t- connectionId:\t\t 3\n\t\t\t\t\t\t\tisEnabled: true\n\t\t\t\t\t\tvolumeName: win_boot\n\t\t\t\t\t\tvolumeStoragePoolName: \'{{ storage_pool_name_A }}\'\n\t\t\t\tserialNumberType: Virtual\n\t\t\t\tserverHardwareName: \'{{ server_hardware_name1 }}\'\n\t\t\t\tserverHardwareTypeName: \'{{ server_hardware_type_name }}\'\n\t\t\t\twwnType: Virtual\n\t- delegate_to:\t\tlocalhost\n\t\tname: Update Server Profile {{ profile_name2 }} adding volume attachment DATA1\n\t\t\tremoved from\t\t\tprevious server profile\n\t\toneview_server_profile:\n\t\t\tconfig: \'{{ config }}\'\n\t\t\tdata:\n\t\t\t\tname: \'{{ profile_name2 }}\'\n\t\t\t\tsanStorage:\n\t\t\t\t\thostOSType: Windows Server 2016\n\t\t\t\t\tmanageSanStorage: true\n\t\t\t\t\tvolumeAttachments:\n\t\t\t\t\t- id: 1\n\t\t\t\t\t\tlunType: Auto\n\t\t\t\t\t\tstoragePaths:\n\t\t\t\t\t\t- connectionId: 4\n\t\t\t\t\t\t\tisEnabled: true\n\t\t\t\t\t\t- connectionId: 5\n\t\t\t\t\t\t\tisEnabled: true\n\t\t\t\t\t\tvolumeName: DATA1\n\t\t\t\t\t\tvolumeStoragePoolName: \'{{ storage_pool_name_B }}\'\n\t\t\t\tserverHardwareName: \'{{ server_hardware_name2 }}\'\n\t\t\t\tserverProfileTemplateName: \'{{ server_profile_template }}\'\n\tvars:\n\t\tSAN_A_network: SAN-A\n\t\tSAN_B_network: SAN-B\n\t\tconfig: \'{{ playbook_dir }}/oneview_config.json\'\n\t\tenclosure_group_name: SYN107_EG\n\t\tmanagement_network: Management\n\t\tprofile_name1: profile_san\n\t\tprofile_name2: profile_i3s\n\t\tserver_hardware_name1: 2-USE722C99W-M, bay 1\n\t\tserver_hardware_name2: 2-USE722C99W-M, bay 12\n\t\tserver_hardware_type_name: SY 480 Gen9 3\n\t\tserver_profile_template: Windows2016_i3s\n\t\tstorage_pool_name_A: Pool name A\n\t\tstorage_pool_name_B: Pool name B'

TEST_DATA = [
    (script_0_1, 0),
    (script_0_2, 0),
    (script_1, 1),
    (script_4_1, 4),
    (script_4_2, 4)
]

@pytest.mark.parametrize('script, expected', TEST_DATA)
def test(script, expected):
    script = StringIO(script.expandtabs(2))
    count = NumNameWithVars(script).count()
    script.close()
    assert count == expected