"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const aws_elasticsearch_1 = require("monocdk/aws-elasticsearch");
const aws_opensearchservice_1 = require("monocdk/aws-opensearchservice");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../../nag-pack");
/**
 * OpenSearch Service domains have encryption at rest enabled - (Control IDs: 3.4, 8.2.1)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticsearch_1.CfnDomain || node instanceof aws_opensearchservice_1.CfnDomain) {
        const encryptionAtRestOptions = monocdk_1.Stack.of(node).resolve(node.encryptionAtRestOptions);
        if (encryptionAtRestOptions != undefined) {
            const enabled = nag_pack_1.resolveIfPrimitive(node, encryptionAtRestOptions.enabled);
            if (enabled !== true) {
                return false;
            }
        }
        else {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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