"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_kms_1 = require("monocdk/aws-kms");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../../nag-pack");
/**
 * KMS Symmetric keys have automatic key rotation enabled - (Control IDs: 2.2, 3.5, 3.6, 3.6.4)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_kms_1.CfnKey) {
        const keySpec = monocdk_1.Stack.of(node).resolve(node.keySpec);
        if (keySpec == undefined || keySpec == aws_kms_1.KeySpec.SYMMETRIC_DEFAULT) {
            const enableKeyRotation = nag_pack_1.resolveIfPrimitive(node, node.enableKeyRotation);
            if (enableKeyRotation !== true) {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGNpRHNzMzIxS01TQmFja2luZ0tleVJvdGF0aW9uRW5hYmxlZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9QQ0ktRFNTLTMuMi4xL3J1bGVzL2ttcy9wY2lEc3MzMjFLTVNCYWNraW5nS2V5Um90YXRpb25FbmFibGVkLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUE7OztFQUdFO0FBQ0YsNkNBQWtEO0FBQ2xELHFDQUE2QztBQUM3QyxnREFBdUQ7QUFFdkQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLGdCQUFNLEVBQUU7UUFDMUIsTUFBTSxPQUFPLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQ3JELElBQUksT0FBTyxJQUFJLFNBQVMsSUFBSSxPQUFPLElBQUksaUJBQU8sQ0FBQyxpQkFBaUIsRUFBRTtZQUNoRSxNQUFNLGlCQUFpQixHQUFHLDZCQUFrQixDQUMxQyxJQUFJLEVBQ0osSUFBSSxDQUFDLGlCQUFpQixDQUN2QixDQUFDO1lBQ0YsSUFBSSxpQkFBaUIsS0FBSyxJQUFJLEVBQUU7Z0JBQzlCLE9BQU8sS0FBSyxDQUFDO2FBQ2Q7U0FDRjtLQUNGO0lBQ0QsT0FBTyxJQUFJLENBQUM7QUFDZCxDQUFDO0FBZEQsNEJBY0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IENmbktleSwgS2V5U3BlYyB9IGZyb20gJ21vbm9jZGsvYXdzLWttcyc7XG5pbXBvcnQgeyBDZm5SZXNvdXJjZSwgU3RhY2sgfSBmcm9tICdtb25vY2RrJztcbmltcG9ydCB7IHJlc29sdmVJZlByaW1pdGl2ZSB9IGZyb20gJy4uLy4uLy4uL25hZy1wYWNrJztcblxuLyoqXG4gKiBLTVMgU3ltbWV0cmljIGtleXMgaGF2ZSBhdXRvbWF0aWMga2V5IHJvdGF0aW9uIGVuYWJsZWQgLSAoQ29udHJvbCBJRHM6IDIuMizCoDMuNSzCoDMuNizCoDMuNi40KVxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmbktleSkge1xuICAgIGNvbnN0IGtleVNwZWMgPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKG5vZGUua2V5U3BlYyk7XG4gICAgaWYgKGtleVNwZWMgPT0gdW5kZWZpbmVkIHx8IGtleVNwZWMgPT0gS2V5U3BlYy5TWU1NRVRSSUNfREVGQVVMVCkge1xuICAgICAgY29uc3QgZW5hYmxlS2V5Um90YXRpb24gPSByZXNvbHZlSWZQcmltaXRpdmUoXG4gICAgICAgIG5vZGUsXG4gICAgICAgIG5vZGUuZW5hYmxlS2V5Um90YXRpb25cbiAgICAgICk7XG4gICAgICBpZiAoZW5hYmxlS2V5Um90YXRpb24gIT09IHRydWUpIHtcbiAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgfVxuICAgIH1cbiAgfVxuICByZXR1cm4gdHJ1ZTtcbn1cbiJdfQ==