"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_iam_1 = require("monocdk/aws-iam");
const monocdk_1 = require("monocdk");
/**
 * IAM policies do not grant full access - (Control IDs: 7.1.2, 7.1.3, 7.2.1, 7.2.2)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_iam_1.CfnPolicy || node instanceof aws_iam_1.CfnManagedPolicy) {
        if (checkDocument(node, node.policyDocument)) {
            return false;
        }
    }
    else if (node instanceof aws_iam_1.CfnGroup || node instanceof aws_iam_1.CfnRole) {
        if (node.policies != undefined && checkDocument(node, node.policies)) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
/**
 * Helper function for parsing through the policy document
 * @param node the CfnResource to Check
 * @param policyDoc the JSON policy document
 * @returns boolean
 */
function checkDocument(node, policyDoc) {
    const resolvedDoc = monocdk_1.Stack.of(node).resolve(policyDoc);
    const reg = /"Action":\[?(.*,)?"(?:\w+:)?\*"(,.*)?\]?,"Effect":"Allow"/gm;
    if (JSON.stringify(resolvedDoc).search(reg) != -1) {
        return true;
    }
    return false;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGNpRHNzMzIxSUFNUG9saWN5Tm9TdGF0ZW1lbnRzV2l0aEZ1bGxBY2Nlc3MuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvUENJLURTUy0zLjIuMS9ydWxlcy9pYW0vcGNpRHNzMzIxSUFNUG9saWN5Tm9TdGF0ZW1lbnRzV2l0aEZ1bGxBY2Nlc3MudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7O0VBR0U7QUFDRiw2Q0FNeUI7QUFDekIscUNBQTZDO0FBRTdDOzs7R0FHRztBQUNILG1CQUF5QixJQUFpQjtJQUN4QyxJQUFJLElBQUksWUFBWSxtQkFBUyxJQUFJLElBQUksWUFBWSwwQkFBZ0IsRUFBRTtRQUNqRSxJQUFJLGFBQWEsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLGNBQWMsQ0FBQyxFQUFFO1lBQzVDLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7S0FDRjtTQUFNLElBQUksSUFBSSxZQUFZLGtCQUFRLElBQUksSUFBSSxZQUFZLGlCQUFPLEVBQUU7UUFDOUQsSUFBSSxJQUFJLENBQUMsUUFBUSxJQUFJLFNBQVMsSUFBSSxhQUFhLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsRUFBRTtZQUNwRSxPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFYRCw0QkFXQztBQUVEOzs7OztHQUtHO0FBQ0gsU0FBUyxhQUFhLENBQUMsSUFBaUIsRUFBRSxTQUFjO0lBQ3RELE1BQU0sV0FBVyxHQUFHLGVBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBbUIsQ0FBQztJQUN4RSxNQUFNLEdBQUcsR0FBRyw2REFBNkQsQ0FBQztJQUMxRSxJQUFJLElBQUksQ0FBQyxTQUFTLENBQUMsV0FBVyxDQUFDLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsQ0FBQyxFQUFFO1FBQ2pELE9BQU8sSUFBSSxDQUFDO0tBQ2I7SUFDRCxPQUFPLEtBQUssQ0FBQztBQUNmLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7XG4gIENmblBvbGljeSxcbiAgQ2ZuTWFuYWdlZFBvbGljeSxcbiAgUG9saWN5RG9jdW1lbnQsXG4gIENmbkdyb3VwLFxuICBDZm5Sb2xlLFxufSBmcm9tICdtb25vY2RrL2F3cy1pYW0nO1xuaW1wb3J0IHsgQ2ZuUmVzb3VyY2UsIFN0YWNrIH0gZnJvbSAnbW9ub2Nkayc7XG5cbi8qKlxuICogSUFNIHBvbGljaWVzIGRvIG5vdCBncmFudCBmdWxsIGFjY2VzcyAtIChDb250cm9sIElEczogNy4xLjIsIDcuMS4zLCA3LjIuMSwgNy4yLjIpXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuUG9saWN5IHx8IG5vZGUgaW5zdGFuY2VvZiBDZm5NYW5hZ2VkUG9saWN5KSB7XG4gICAgaWYgKGNoZWNrRG9jdW1lbnQobm9kZSwgbm9kZS5wb2xpY3lEb2N1bWVudCkpIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gIH0gZWxzZSBpZiAobm9kZSBpbnN0YW5jZW9mIENmbkdyb3VwIHx8IG5vZGUgaW5zdGFuY2VvZiBDZm5Sb2xlKSB7XG4gICAgaWYgKG5vZGUucG9saWNpZXMgIT0gdW5kZWZpbmVkICYmIGNoZWNrRG9jdW1lbnQobm9kZSwgbm9kZS5wb2xpY2llcykpIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG5cbi8qKlxuICogSGVscGVyIGZ1bmN0aW9uIGZvciBwYXJzaW5nIHRocm91Z2ggdGhlIHBvbGljeSBkb2N1bWVudFxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIENoZWNrXG4gKiBAcGFyYW0gcG9saWN5RG9jIHRoZSBKU09OIHBvbGljeSBkb2N1bWVudFxuICogQHJldHVybnMgYm9vbGVhblxuICovXG5mdW5jdGlvbiBjaGVja0RvY3VtZW50KG5vZGU6IENmblJlc291cmNlLCBwb2xpY3lEb2M6IGFueSk6IGJvb2xlYW4ge1xuICBjb25zdCByZXNvbHZlZERvYyA9IFN0YWNrLm9mKG5vZGUpLnJlc29sdmUocG9saWN5RG9jKSBhcyBQb2xpY3lEb2N1bWVudDtcbiAgY29uc3QgcmVnID0gL1wiQWN0aW9uXCI6XFxbPyguKiwpP1wiKD86XFx3KzopP1xcKlwiKCwuKik/XFxdPyxcIkVmZmVjdFwiOlwiQWxsb3dcIi9nbTtcbiAgaWYgKEpTT04uc3RyaW5naWZ5KHJlc29sdmVkRG9jKS5zZWFyY2gocmVnKSAhPSAtMSkge1xuICAgIHJldHVybiB0cnVlO1xuICB9XG4gIHJldHVybiBmYWxzZTtcbn1cbiJdfQ==