"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const aws_elasticloadbalancing_1 = require("monocdk/aws-elasticloadbalancing");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../../nag-pack");
/**
 * CLB listeners are configured for secure (HTTPs or SSL) protocols for client communication - (Control IDs: 2.3, 4.1, 8.2.1)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticloadbalancing_1.CfnLoadBalancer) {
        const listeners = monocdk_1.Stack.of(node).resolve(node.listeners);
        for (const listener of listeners) {
            const resolvedListener = monocdk_1.Stack.of(node).resolve(listener);
            const protocol = nag_pack_1.resolveIfPrimitive(node, resolvedListener.protocol);
            const instanceProtocol = nag_pack_1.resolveIfPrimitive(node, resolvedListener.instanceProtocol);
            if (protocol.toLowerCase() == 'ssl') {
                if (!(instanceProtocol == undefined ||
                    instanceProtocol.toLowerCase() == 'ssl')) {
                    return false;
                }
            }
            else if (protocol.toLowerCase() == 'https') {
                if (!(instanceProtocol == undefined ||
                    instanceProtocol.toLowerCase() == 'https')) {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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