"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const aws_codebuild_1 = require("monocdk/aws-codebuild");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../../nag-pack");
/**
 * CodeBuild projects do not store AWS credentials as plaintext environment variables - (Control ID: 8.2.1)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_codebuild_1.CfnProject) {
        //Check for the presence of OAUTH
        const environment = monocdk_1.Stack.of(node).resolve(node.environment);
        const environmentVars = monocdk_1.Stack.of(node).resolve(environment.environmentVariables);
        if (environmentVars != undefined) {
            //For each envvar, check if its a sensitive credential being stored
            for (const envVar of environmentVars) {
                const resolvedEnvVar = monocdk_1.Stack.of(node).resolve(envVar);
                const name = nag_pack_1.resolveIfPrimitive(node, resolvedEnvVar.name);
                const type = nag_pack_1.resolveIfPrimitive(node, resolvedEnvVar.type);
                if (name == 'AWS_ACCESS_KEY_ID' || name == 'AWS_SECRET_ACCESS_KEY') {
                    //is this credential being stored as plaintext?
                    if (type == undefined || type == 'PLAINTEXT') {
                        return false;
                    }
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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