"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_ecs_1 = require("monocdk/aws-ecs");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../../nag-pack");
/**
 * Containers in ECS task definitions configured for host networking have 'privileged' set to true and a non-empty non-root 'user' - (Control IDs: AC-3, AC-5b, CM-5(1)(a))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ecs_1.CfnTaskDefinition) {
        if (node.networkMode === aws_ecs_1.NetworkMode.HOST) {
            const containerDefinitions = monocdk_1.Stack.of(node).resolve(node.containerDefinitions);
            if (containerDefinitions !== undefined) {
                for (const containerDefinition of containerDefinitions) {
                    const resolvedDefinition = monocdk_1.Stack.of(node).resolve(containerDefinition);
                    const privileged = nag_pack_1.resolveIfPrimitive(node, resolvedDefinition.privileged);
                    const user = nag_pack_1.resolveIfPrimitive(node, resolvedDefinition.user);
                    if (privileged !== true || user === undefined) {
                        return false;
                    }
                    const rootIdentifiers = ['root', '0'];
                    const userParts = user.split(':');
                    for (const userPart of userParts) {
                        if (rootIdentifiers.includes(userPart.toLowerCase())) {
                            return false;
                        }
                    }
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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