"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const aws_autoscaling_1 = require("monocdk/aws-autoscaling");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../../nag-pack");
/**
 * Auto Scaling groups which are associated with load balancers utilize ELB health checks - (Control IDs: AU-12(3), AU-14a, AU-14b, CA-2(2), CA-7, CA-7b, CM-6a, CM-9b, PM-14a.1, PM-14b, PM-31, SC-6, SC-36(1)(a), SI-2a)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_autoscaling_1.CfnAutoScalingGroup) {
        const classicLBs = monocdk_1.Stack.of(node).resolve(node.loadBalancerNames);
        const otherLBs = monocdk_1.Stack.of(node).resolve(node.targetGroupArns);
        if ((otherLBs != undefined && otherLBs.length > 0) ||
            (classicLBs != undefined && classicLBs.length > 0)) {
            const healthCheckType = nag_pack_1.resolveIfPrimitive(node, node.healthCheckType);
            if (healthCheckType != undefined) {
                if (healthCheckType != 'ELB') {
                    return false;
                }
            }
            else {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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