"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_iam_1 = require("monocdk/aws-iam");
const monocdk_1 = require("monocdk");
/**
 * IAM Groups, Users, and Roles do not contain inline policies - (Control ID: AC-6)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_iam_1.CfnGroup ||
        node instanceof aws_iam_1.CfnUser ||
        node instanceof aws_iam_1.CfnRole) {
        const inlinePolicies = monocdk_1.Stack.of(node).resolve(node.policies);
        if (inlinePolicies != undefined) {
            return false;
        }
    }
    if (node instanceof aws_iam_1.CfnPolicy) {
        return false;
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmlzdDgwMDUzcjRJQU1Ob0lubGluZVBvbGljeS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9OSVNULTgwMC01My1SNC9ydWxlcy9pYW0vbmlzdDgwMDUzcjRJQU1Ob0lubGluZVBvbGljeS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBOzs7RUFHRTtBQUNGLDZDQUF3RTtBQUN4RSxxQ0FBNkM7QUFFN0M7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQ0UsSUFBSSxZQUFZLGtCQUFRO1FBQ3hCLElBQUksWUFBWSxpQkFBTztRQUN2QixJQUFJLFlBQVksaUJBQU8sRUFDdkI7UUFDQSxNQUFNLGNBQWMsR0FBRyxlQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUM7UUFDN0QsSUFBSSxjQUFjLElBQUksU0FBUyxFQUFFO1lBQy9CLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7S0FDRjtJQUNELElBQUksSUFBSSxZQUFZLG1CQUFTLEVBQUU7UUFDN0IsT0FBTyxLQUFLLENBQUM7S0FDZDtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQWZELDRCQWVDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDZm5Sb2xlLCBDZm5Vc2VyLCBDZm5Hcm91cCwgQ2ZuUG9saWN5IH0gZnJvbSAnbW9ub2Nkay9hd3MtaWFtJztcbmltcG9ydCB7IENmblJlc291cmNlLCBTdGFjayB9IGZyb20gJ21vbm9jZGsnO1xuXG4vKipcbiAqIElBTSBHcm91cHMsIFVzZXJzLCBhbmQgUm9sZXMgZG8gbm90IGNvbnRhaW4gaW5saW5lIHBvbGljaWVzIC0gKENvbnRyb2wgSUQ6IEFDLTYpXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiB7XG4gIGlmIChcbiAgICBub2RlIGluc3RhbmNlb2YgQ2ZuR3JvdXAgfHxcbiAgICBub2RlIGluc3RhbmNlb2YgQ2ZuVXNlciB8fFxuICAgIG5vZGUgaW5zdGFuY2VvZiBDZm5Sb2xlXG4gICkge1xuICAgIGNvbnN0IGlubGluZVBvbGljaWVzID0gU3RhY2sub2Yobm9kZSkucmVzb2x2ZShub2RlLnBvbGljaWVzKTtcbiAgICBpZiAoaW5saW5lUG9saWNpZXMgIT0gdW5kZWZpbmVkKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuUG9saWN5KSB7XG4gICAgcmV0dXJuIGZhbHNlO1xuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19