"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const aws_elasticloadbalancingv2_1 = require("monocdk/aws-elasticloadbalancingv2");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../../nag-pack");
/**
 * Application Load Balancers are enabled to drop invalid headers - (Control IDs: AC-17(2), SC-7, SC-8, SC-8(1), SC-23)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticloadbalancingv2_1.CfnLoadBalancer) {
        const type = nag_pack_1.resolveIfPrimitive(node, node.type);
        if (type == undefined || type == 'application') {
            const attributes = monocdk_1.Stack.of(node).resolve(node.loadBalancerAttributes);
            if (attributes != undefined) {
                const reg = /"routing\.http\.drop_invalid_header_fields\.enabled","value":"true"/gm;
                if (JSON.stringify(attributes).search(reg) == -1) {
                    return false;
                }
            }
            else {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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