"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const aws_ec2_1 = require("monocdk/aws-ec2");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../../nag-pack");
/**
 * Security Groups do not allow for unrestricted SSH traffic - (Control IDs: AC-4, SC-7, SC-7(3))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ec2_1.CfnSecurityGroup) {
        const ingressRules = monocdk_1.Stack.of(node).resolve(node.securityGroupIngress);
        if (ingressRules != undefined) {
            //For each ingress rule, ensure that it does not allow unrestricted SSH traffic.
            for (const rule of ingressRules) {
                const resolvedRule = monocdk_1.Stack.of(node).resolve(rule);
                const ipProtocol = nag_pack_1.resolveIfPrimitive(node, resolvedRule.ipProtocol);
                const cidrIp = nag_pack_1.resolveIfPrimitive(node, resolvedRule.cidrIp);
                const cidrIpv6 = nag_pack_1.resolveIfPrimitive(node, resolvedRule.cidrIpv6);
                const fromPort = nag_pack_1.resolveIfPrimitive(node, resolvedRule.fromPort);
                const toPort = nag_pack_1.resolveIfPrimitive(node, resolvedRule.toPort);
                if ((cidrIp != undefined && cidrIp.includes('/0')) ||
                    (cidrIpv6 != undefined && cidrIpv6.includes('/0'))) {
                    if (fromPort != undefined && toPort != undefined) {
                        if ((fromPort <= 22 && toPort >= 22) ||
                            fromPort == -1 ||
                            toPort == -1 ||
                            ipProtocol == '-1') {
                            return false;
                        }
                    }
                    else {
                        if (fromPort == 22 || ipProtocol == '-1') {
                            return false;
                        }
                    }
                }
            }
        }
    }
    else if (node instanceof aws_ec2_1.CfnSecurityGroupIngress) {
        const ipProtocol = nag_pack_1.resolveIfPrimitive(node, node.ipProtocol);
        const cidrIp = nag_pack_1.resolveIfPrimitive(node, node.cidrIp);
        const cidrIpv6 = nag_pack_1.resolveIfPrimitive(node, node.cidrIpv6);
        const fromPort = nag_pack_1.resolveIfPrimitive(node, node.fromPort);
        const toPort = nag_pack_1.resolveIfPrimitive(node, node.toPort);
        if ((cidrIp != undefined && cidrIp.includes('/0')) ||
            (cidrIpv6 != undefined && cidrIpv6.includes('/0'))) {
            //Is a port range specified?
            if (fromPort != undefined && toPort != undefined) {
                if ((fromPort <= 22 && toPort >= 22) ||
                    fromPort == -1 ||
                    toPort == -1 ||
                    ipProtocol == '-1') {
                    return false;
                }
            }
            else {
                if (fromPort == 22 || ipProtocol == '-1') {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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