"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_dms_1 = require("monocdk/aws-dms");
const nag_pack_1 = require("../../../nag-pack");
/**
 * DMS replication instances are not public - (Control ID: AC-4)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_dms_1.CfnReplicationInstance) {
        const publicAccess = nag_pack_1.resolveIfPrimitive(node, node.publiclyAccessible);
        if (publicAccess !== false) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmlzdDgwMDUzcjRETVNSZXBsaWNhdGlvbk5vdFB1YmxpYy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9OSVNULTgwMC01My1SNC9ydWxlcy9kbXMvbmlzdDgwMDUzcjRETVNSZXBsaWNhdGlvbk5vdFB1YmxpYy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBOzs7RUFHRTtBQUNGLDZDQUF5RDtBQUV6RCxnREFBdUQ7QUFFdkQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLGdDQUFzQixFQUFFO1FBQzFDLE1BQU0sWUFBWSxHQUFHLDZCQUFrQixDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsa0JBQWtCLENBQUMsQ0FBQztRQUN2RSxJQUFJLFlBQVksS0FBSyxLQUFLLEVBQUU7WUFDMUIsT0FBTyxLQUFLLENBQUM7U0FDZDtLQUNGO0lBQ0QsT0FBTyxJQUFJLENBQUM7QUFDZCxDQUFDO0FBUkQsNEJBUUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IENmblJlcGxpY2F0aW9uSW5zdGFuY2UgfSBmcm9tICdtb25vY2RrL2F3cy1kbXMnO1xuaW1wb3J0IHsgQ2ZuUmVzb3VyY2UgfSBmcm9tICdtb25vY2RrJztcbmltcG9ydCB7IHJlc29sdmVJZlByaW1pdGl2ZSB9IGZyb20gJy4uLy4uLy4uL25hZy1wYWNrJztcblxuLyoqXG4gKiBETVMgcmVwbGljYXRpb24gaW5zdGFuY2VzIGFyZSBub3QgcHVibGljIC0gKENvbnRyb2wgSUQ6IEFDLTQpXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuUmVwbGljYXRpb25JbnN0YW5jZSkge1xuICAgIGNvbnN0IHB1YmxpY0FjY2VzcyA9IHJlc29sdmVJZlByaW1pdGl2ZShub2RlLCBub2RlLnB1YmxpY2x5QWNjZXNzaWJsZSk7XG4gICAgaWYgKHB1YmxpY0FjY2VzcyAhPT0gZmFsc2UpIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=