"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cloudwatch_1 = require("monocdk/aws-cloudwatch");
const monocdk_1 = require("monocdk");
/**
 * CloudWatch alarms have at least one alarm action, one INSUFFICIENT_DATA action, or one OK action enabled - (Control IDs: AC-2(4), AU-6(1)(3), AU-7(1), CA-7(a)(b), IR-4(1), SI-4(2), SI-4(4), SI-4(5), SI-4(a)(b)(c))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_cloudwatch_1.CfnAlarm) {
        const actionsEnabled = monocdk_1.Stack.of(node).resolve(node.actionsEnabled);
        if (actionsEnabled === false) {
            return false;
        }
        // Actions can be an array with a token that then resolves to an empty array or undefined
        const alarmActions = monocdk_1.Stack.of(node).resolve(node.alarmActions);
        const insufficientDataActions = monocdk_1.Stack.of(node).resolve(node.insufficientDataActions);
        const okActions = monocdk_1.Stack.of(node).resolve(node.okActions);
        const totalAlarmActions = alarmActions ? alarmActions.length : 0;
        const totalInsufficientDataActions = insufficientDataActions
            ? insufficientDataActions.length
            : 0;
        const totalOkActions = okActions ? okActions.length : 0;
        const totalActions = totalAlarmActions + totalInsufficientDataActions + totalOkActions;
        if (totalActions == 0) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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