"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_ecs_1 = require("monocdk/aws-ecs");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../../nag-pack");
/**
 * Containers in ECS task definitions configured for host networking have 'privileged' set to true and a non-empty non-root 'user' - (Control IDs: 164.308(a)(3)(i), 164.308(a)(3)(ii)(A), 164.308(a)(4)(ii)(A), 164.308(a)(4)(ii)(C), 164.312(a)(1))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ecs_1.CfnTaskDefinition) {
        if (node.networkMode === aws_ecs_1.NetworkMode.HOST) {
            const containerDefinitions = monocdk_1.Stack.of(node).resolve(node.containerDefinitions);
            if (containerDefinitions !== undefined) {
                for (const containerDefinition of containerDefinitions) {
                    const resolvedDefinition = monocdk_1.Stack.of(node).resolve(containerDefinition);
                    const privileged = nag_pack_1.resolveIfPrimitive(node, resolvedDefinition.privileged);
                    const user = nag_pack_1.resolveIfPrimitive(node, resolvedDefinition.user);
                    if (privileged !== true || user === undefined) {
                        return false;
                    }
                    const rootIdentifiers = ['root', '0'];
                    const userParts = user.split(':');
                    for (const userPart of userParts) {
                        if (rootIdentifiers.includes(userPart.toLowerCase())) {
                            return false;
                        }
                    }
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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