"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_s3_1 = require("monocdk/aws-s3");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../../nag-pack");
/**
 * S3 Buckets should have public access restricted and blocked.
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_s3_1.CfnBucket) {
        if (node.publicAccessBlockConfiguration == undefined) {
            return false;
        }
        const publicAccess = monocdk_1.Stack.of(node).resolve(node.publicAccessBlockConfiguration);
        const blockPublicAcls = nag_pack_1.resolveIfPrimitive(node, publicAccess.blockPublicAcls);
        const blockPublicPolicy = nag_pack_1.resolveIfPrimitive(node, publicAccess.blockPublicPolicy);
        const ignorePublicAcls = nag_pack_1.resolveIfPrimitive(node, publicAccess.ignorePublicAcls);
        const restrictPublicBuckets = nag_pack_1.resolveIfPrimitive(node, publicAccess.restrictPublicBuckets);
        if (blockPublicAcls !== true ||
            blockPublicPolicy !== true ||
            ignorePublicAcls !== true ||
            restrictPublicBuckets !== true) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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