"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_kms_1 = require("monocdk/aws-kms");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../../nag-pack");
/**
 * KMS Symmetric keys have automatic key rotation enabled
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_kms_1.CfnKey) {
        const keySpec = monocdk_1.Stack.of(node).resolve(node.keySpec);
        if (keySpec == undefined || keySpec == aws_kms_1.KeySpec.SYMMETRIC_DEFAULT) {
            const enableKeyRotation = nag_pack_1.resolveIfPrimitive(node, node.enableKeyRotation);
            if (enableKeyRotation !== true) {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiS01TNS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9Bd3NTb2x1dGlvbnMvcnVsZXMvc2VjdXJpdHlfYW5kX2NvbXBsaWFuY2UvS01TNS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBOzs7RUFHRTtBQUNGLDZDQUFrRDtBQUNsRCxxQ0FBNkM7QUFDN0MsZ0RBQXVEO0FBRXZEOzs7R0FHRztBQUNILG1CQUF5QixJQUFpQjtJQUN4QyxJQUFJLElBQUksWUFBWSxnQkFBTSxFQUFFO1FBQzFCLE1BQU0sT0FBTyxHQUFHLGVBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUNyRCxJQUFJLE9BQU8sSUFBSSxTQUFTLElBQUksT0FBTyxJQUFJLGlCQUFPLENBQUMsaUJBQWlCLEVBQUU7WUFDaEUsTUFBTSxpQkFBaUIsR0FBRyw2QkFBa0IsQ0FDMUMsSUFBSSxFQUNKLElBQUksQ0FBQyxpQkFBaUIsQ0FDdkIsQ0FBQztZQUNGLElBQUksaUJBQWlCLEtBQUssSUFBSSxFQUFFO2dCQUM5QixPQUFPLEtBQUssQ0FBQzthQUNkO1NBQ0Y7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQWRELDRCQWNDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDZm5LZXksIEtleVNwZWMgfSBmcm9tICdtb25vY2RrL2F3cy1rbXMnO1xuaW1wb3J0IHsgQ2ZuUmVzb3VyY2UsIFN0YWNrIH0gZnJvbSAnbW9ub2Nkayc7XG5pbXBvcnQgeyByZXNvbHZlSWZQcmltaXRpdmUgfSBmcm9tICcuLi8uLi8uLi9uYWctcGFjayc7XG5cbi8qKlxuICogS01TIFN5bW1ldHJpYyBrZXlzIGhhdmUgYXV0b21hdGljIGtleSByb3RhdGlvbiBlbmFibGVkXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuS2V5KSB7XG4gICAgY29uc3Qga2V5U3BlYyA9IFN0YWNrLm9mKG5vZGUpLnJlc29sdmUobm9kZS5rZXlTcGVjKTtcbiAgICBpZiAoa2V5U3BlYyA9PSB1bmRlZmluZWQgfHwga2V5U3BlYyA9PSBLZXlTcGVjLlNZTU1FVFJJQ19ERUZBVUxUKSB7XG4gICAgICBjb25zdCBlbmFibGVLZXlSb3RhdGlvbiA9IHJlc29sdmVJZlByaW1pdGl2ZShcbiAgICAgICAgbm9kZSxcbiAgICAgICAgbm9kZS5lbmFibGVLZXlSb3RhdGlvblxuICAgICAgKTtcbiAgICAgIGlmIChlbmFibGVLZXlSb3RhdGlvbiAhPT0gdHJ1ZSkge1xuICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICB9XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19