"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_autoscaling_1 = require("monocdk/aws-autoscaling");
const monocdk_1 = require("monocdk");
/**
 * Auto Scaling Groups have notifications for all scaling events configured
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_autoscaling_1.CfnAutoScalingGroup) {
        if (node.notificationConfigurations == undefined) {
            return false;
        }
        const notificationConfigurations = monocdk_1.Stack.of(node).resolve(node.notificationConfigurations);
        const requiredEvents = [
            aws_autoscaling_1.ScalingEvent.INSTANCE_LAUNCH,
            aws_autoscaling_1.ScalingEvent.INSTANCE_LAUNCH_ERROR,
            aws_autoscaling_1.ScalingEvent.INSTANCE_TERMINATE,
            aws_autoscaling_1.ScalingEvent.INSTANCE_TERMINATE_ERROR,
        ];
        return requiredEvents.every((req) => {
            return notificationConfigurations.some((config) => {
                var _a;
                return (_a = config.notificationTypes) === null || _a === void 0 ? void 0 : _a.includes(req);
            });
        });
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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