"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_sagemaker_1 = require("monocdk/aws-sagemaker");
const nag_pack_1 = require("../../../nag-pack");
/**
 * SageMaker notebook instances have direct internet access disabled
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_sagemaker_1.CfnNotebookInstance) {
        const directInternetAccess = nag_pack_1.resolveIfPrimitive(node, node.directInternetAccess);
        if (directInternetAccess == undefined ||
            directInternetAccess != 'Disabled') {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU00zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL0F3c1NvbHV0aW9ucy9ydWxlcy9tYWNoaW5lX2xlYXJuaW5nL1NNMy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBOzs7RUFHRTtBQUNGLHlEQUE0RDtBQUU1RCxnREFBdUQ7QUFFdkQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLG1DQUFtQixFQUFFO1FBQ3ZDLE1BQU0sb0JBQW9CLEdBQUcsNkJBQWtCLENBQzdDLElBQUksRUFDSixJQUFJLENBQUMsb0JBQW9CLENBQzFCLENBQUM7UUFDRixJQUNFLG9CQUFvQixJQUFJLFNBQVM7WUFDakMsb0JBQW9CLElBQUksVUFBVSxFQUNsQztZQUNBLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQWRELDRCQWNDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDZm5Ob3RlYm9va0luc3RhbmNlIH0gZnJvbSAnbW9ub2Nkay9hd3Mtc2FnZW1ha2VyJztcbmltcG9ydCB7IENmblJlc291cmNlIH0gZnJvbSAnbW9ub2Nkayc7XG5pbXBvcnQgeyByZXNvbHZlSWZQcmltaXRpdmUgfSBmcm9tICcuLi8uLi8uLi9uYWctcGFjayc7XG5cbi8qKlxuICogU2FnZU1ha2VyIG5vdGVib29rIGluc3RhbmNlcyBoYXZlIGRpcmVjdCBpbnRlcm5ldCBhY2Nlc3MgZGlzYWJsZWRcbiAqIEBwYXJhbSBub2RlIHRoZSBDZm5SZXNvdXJjZSB0byBjaGVja1xuICovXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiAobm9kZTogQ2ZuUmVzb3VyY2UpOiBib29sZWFuIHtcbiAgaWYgKG5vZGUgaW5zdGFuY2VvZiBDZm5Ob3RlYm9va0luc3RhbmNlKSB7XG4gICAgY29uc3QgZGlyZWN0SW50ZXJuZXRBY2Nlc3MgPSByZXNvbHZlSWZQcmltaXRpdmUoXG4gICAgICBub2RlLFxuICAgICAgbm9kZS5kaXJlY3RJbnRlcm5ldEFjY2Vzc1xuICAgICk7XG4gICAgaWYgKFxuICAgICAgZGlyZWN0SW50ZXJuZXRBY2Nlc3MgPT0gdW5kZWZpbmVkIHx8XG4gICAgICBkaXJlY3RJbnRlcm5ldEFjY2VzcyAhPSAnRGlzYWJsZWQnXG4gICAgKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19