"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_cloud9_1 = require("monocdk/aws-cloud9");
const nag_pack_1 = require("../../../nag-pack");
/**
 * Cloud9 instances use no-ingress EC2 instances with AWS Systems Manager
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_cloud9_1.CfnEnvironmentEC2) {
        const connectionType = nag_pack_1.resolveIfPrimitive(node, node.connectionType);
        if (connectionType == undefined || connectionType != 'CONNECT_SSM') {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQzkxLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL0F3c1NvbHV0aW9ucy9ydWxlcy9kZXZlbG9wZXJfdG9vbHMvQzkxLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUE7OztFQUdFO0FBQ0YsbURBQXVEO0FBRXZELGdEQUF1RDtBQUV2RDs7O0dBR0c7QUFDSCxtQkFBeUIsSUFBaUI7SUFDeEMsSUFBSSxJQUFJLFlBQVksOEJBQWlCLEVBQUU7UUFDckMsTUFBTSxjQUFjLEdBQUcsNkJBQWtCLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxjQUFjLENBQUMsQ0FBQztRQUNyRSxJQUFJLGNBQWMsSUFBSSxTQUFTLElBQUksY0FBYyxJQUFJLGFBQWEsRUFBRTtZQUNsRSxPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFSRCw0QkFRQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuaW1wb3J0IHsgQ2ZuRW52aXJvbm1lbnRFQzIgfSBmcm9tICdtb25vY2RrL2F3cy1jbG91ZDknO1xuaW1wb3J0IHsgQ2ZuUmVzb3VyY2UgfSBmcm9tICdtb25vY2RrJztcbmltcG9ydCB7IHJlc29sdmVJZlByaW1pdGl2ZSB9IGZyb20gJy4uLy4uLy4uL25hZy1wYWNrJztcblxuLyoqXG4gKiBDbG91ZDkgaW5zdGFuY2VzIHVzZSBuby1pbmdyZXNzIEVDMiBpbnN0YW5jZXMgd2l0aCBBV1MgU3lzdGVtcyBNYW5hZ2VyXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuRW52aXJvbm1lbnRFQzIpIHtcbiAgICBjb25zdCBjb25uZWN0aW9uVHlwZSA9IHJlc29sdmVJZlByaW1pdGl2ZShub2RlLCBub2RlLmNvbm5lY3Rpb25UeXBlKTtcbiAgICBpZiAoY29ubmVjdGlvblR5cGUgPT0gdW5kZWZpbmVkIHx8IGNvbm5lY3Rpb25UeXBlICE9ICdDT05ORUNUX1NTTScpIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=