"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_rds_1 = require("monocdk/aws-rds");
const nag_pack_1 = require("../../../nag-pack");
/**
 *  RDS Aurora DB clusters have Deletion Protection enabled
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_rds_1.CfnDBCluster) {
        if (node.deletionProtection == undefined) {
            return false;
        }
        const deletionProtection = nag_pack_1.resolveIfPrimitive(node, node.deletionProtection);
        if (deletionProtection == false) {
            return false;
        }
        return true;
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiUkRTMTUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvQXdzU29sdXRpb25zL3J1bGVzL2RhdGFiYXNlcy9SRFMxNS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBOzs7RUFHRTtBQUNGLDZDQUErQztBQUUvQyxnREFBdUQ7QUFFdkQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLHNCQUFZLEVBQUU7UUFDaEMsSUFBSSxJQUFJLENBQUMsa0JBQWtCLElBQUksU0FBUyxFQUFFO1lBQ3hDLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7UUFDRCxNQUFNLGtCQUFrQixHQUFHLDZCQUFrQixDQUMzQyxJQUFJLEVBQ0osSUFBSSxDQUFDLGtCQUFrQixDQUN4QixDQUFDO1FBQ0YsSUFBSSxrQkFBa0IsSUFBSSxLQUFLLEVBQUU7WUFDL0IsT0FBTyxLQUFLLENBQUM7U0FDZDtRQUNELE9BQU8sSUFBSSxDQUFDO0tBQ2I7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFmRCw0QkFlQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuaW1wb3J0IHsgQ2ZuREJDbHVzdGVyIH0gZnJvbSAnbW9ub2Nkay9hd3MtcmRzJztcbmltcG9ydCB7IENmblJlc291cmNlIH0gZnJvbSAnbW9ub2Nkayc7XG5pbXBvcnQgeyByZXNvbHZlSWZQcmltaXRpdmUgfSBmcm9tICcuLi8uLi8uLi9uYWctcGFjayc7XG5cbi8qKlxuICogIFJEUyBBdXJvcmEgREIgY2x1c3RlcnMgaGF2ZSBEZWxldGlvbiBQcm90ZWN0aW9uIGVuYWJsZWRcbiAqIEBwYXJhbSBub2RlIHRoZSBDZm5SZXNvdXJjZSB0byBjaGVja1xuICovXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiAobm9kZTogQ2ZuUmVzb3VyY2UpOiBib29sZWFuIHtcbiAgaWYgKG5vZGUgaW5zdGFuY2VvZiBDZm5EQkNsdXN0ZXIpIHtcbiAgICBpZiAobm9kZS5kZWxldGlvblByb3RlY3Rpb24gPT0gdW5kZWZpbmVkKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICAgIGNvbnN0IGRlbGV0aW9uUHJvdGVjdGlvbiA9IHJlc29sdmVJZlByaW1pdGl2ZShcbiAgICAgIG5vZGUsXG4gICAgICBub2RlLmRlbGV0aW9uUHJvdGVjdGlvblxuICAgICk7XG4gICAgaWYgKGRlbGV0aW9uUHJvdGVjdGlvbiA9PSBmYWxzZSkge1xuICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cbiAgICByZXR1cm4gdHJ1ZTtcbiAgfVxuICByZXR1cm4gdHJ1ZTtcbn1cbiJdfQ==