"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_msk_1 = require("monocdk/aws-msk");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../../nag-pack");
/**
 * MSK clusters only uses TLS communication between clients and brokers
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_msk_1.CfnCluster) {
        const encryptionInfo = monocdk_1.Stack.of(node).resolve(node.encryptionInfo);
        if (encryptionInfo != undefined) {
            const encryptionInTransit = monocdk_1.Stack.of(node).resolve(encryptionInfo.encryptionInTransit);
            if (encryptionInTransit != undefined) {
                const clientBroker = nag_pack_1.resolveIfPrimitive(node, encryptionInTransit.clientBroker);
                if (clientBroker != undefined &&
                    clientBroker != aws_msk_1.ClientBrokerEncryption.TLS) {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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