# ------------------------------------------------------------------
# EPC set
# ---------------------------------------------------------------- */
EPC_CODE = {
	0x00: { # Sensor-related device class group
		0x01: { # Gas leak sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Gas leak occurrence status',
			0xBF: 'Gas leak occurrence status resetting'
		},
		0x02: { # Crime prevention sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Invasion occurrence status',
			0xBF: 'Invasion occurrence status resetting'
		},
		0x03: { # Emergency button class
			0x80: 'Operation status',
			0xB1: 'Emergency occurrence status',
			0xBF: 'Emergency occurrence status resetting'
		},
		0x04: { # First-aid sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'First-aid occurrence status',
			0xBF: 'First-aid occurrence status resetting'
		},
		0x05: { # Earthquake sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Earthquake occurrence status',
			0xBF: 'Earthquake occurrence status resetting'
		},
		0x06: { # Electric leak sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Electric leak occurrence status',
			0xBF: 'Electric leak occurrence status resetting'
		},
		0x07: { # Human detection sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Human detection status'
		},
		0x08: { # Visitor sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Visitor detection status',
			0xBE: 'Visitor detection holding time'
		},
		0x09: { # Call sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Call status',
			0xBE: 'Call holding time'
		},
		0x0A: { # Condensation sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Condensation detection status'
		},
		0x0B: { # Air pollution sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Air pollution detection status'
		},
		0x0C: { # Oxygen sensor class
			0x80: 'Operation status',
			0xE0: 'Measured value of oxygen concentration'
		},
		0x0D: { # Illuminance sensor class
			0x80: 'Operation status',
			0xE0: 'Measured illuminance value 1',
			0xE1: 'Measured illuminance value 2'
		},
		0x0E: { # Sound sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Sound detection status',
			0xBE: 'Sound detection holding time'
		},
		0x0F: { # Mailing sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Mailing detection status'
		},
		0x10: { # Weight sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Weight detection status'
		},
		0x11: { # Temperature sensor class
			0x80: 'Operation status',
			0xE0: 'Measured temperature value'
		},
		0x12: { # Humidity sensor class
			0x80: 'Operation status',
			0xE0: 'Measured value of relative humidity'
		},
		0x13: { # Rain sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Rain detection status'
		},
		0x14: { # Water level sensor class
			0x80: 'Operation status',
			0xB0: 'Water level over detection threshold level',
			0xB1: 'Water level over detection status',
			0xE0: 'Measured value of water level'
		},
		0x15: { # Bath water level sensor class
			0x80: 'Operation status',
			0xB0: 'Bath water level over detection threshold level',
			0xB1: 'Bath water level over detection status',
			0xE0: 'Measured value of bath water level'
		},
		0x16: { # Bath heating status sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Bath heating detection status'
		},
		0x17: { # Water leak sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Water leak detection status'
		},
		0x18: { # Water overflow sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Water overflow detection status'
		},
		0x19: { # Fire sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Fire occurrence detection status',
			0xBF: 'Fire occurrence detection status resetting'
		},
		0x1A: { # Cigarette smoke sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Smoke (cigarette) detection status'
		},
		0x1B: { # CO2 sensor class
			0x80: 'Operation status',
			0xE0: 'Measured value of CO2 concentration'
		},
		0x1C: { # Gas sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Gas detection status',
			0xE0: 'Measured value of gas concentration'
		},
		0x1D: { # VOC sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'VOC detection status',
			0xE0: 'Measured value of VOC concentration'
		},
		0x1E: { # Differential pressure sensor class
			0x80: 'Operation status',
			0xE0: 'Measured value of differential pressure'
		},
		0x1F: { # Air speed sensor class
			0x80: 'Operation status',
			0xE0: 'Measured value of air speed',
			0xE1: 'Air flow direction'
		},
		0x20: { # Odor sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Odor detection status',
			0xE0: 'Measured odor value'
		},
		0x21: { # Flame sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Flame detection status',
			0xBF: 'Flame detection status resetting'
		},
		0x22: { # Electric energy sensor class
			0x80: 'Operation status',
			0xE0: 'Cumulative amounts of electric energy',
			0xE1: 'Medium-capacity sensor instantaneous electric energy',
			0xE2: 'Small-capacity sensor instantaneous electric energy',
			0xE3: 'Large-capacity sensor instantaneous electric energy',
			0xE4: 'Cumulative amounts of electric energy measurement log',
			0xE5: 'Effective voltage value'
		},
		0x23: { # Current value sensor class
			0x80: 'Operation status',
			0xE0: 'Measured current value 1',
			0xE1: 'Rated voltage to be measured',
			0xE2: 'Measured current  value 2'
		},
		0x25: { # Water flow rate sensor class
			0x80: 'Operation status',
			0xE0: 'Cumulative flow rate',
			0xE2: 'Flow rate'
		},
		0x26: { # Micromotion sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Micromotion detection status',
			0xB2: 'Detection counter',
			0xBC: 'Sampling count',
			0xBD: 'Sampling cycle'
		},
		0x27: { # Passage sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xBE: 'Passage detection hold time',
			0xE0: 'Passage detection direction'
		},
		0x28: { # Bed presence sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Bed presence detection status'
		},
		0x29: { # Open/close sensor class
			0x80: 'Operation status',
			0xE0: 'Degree-of-opening detection status 1',
			0xB0: 'Detection threshold level',
			0xB1: 'Degree-of-opening detection status 2'
		},
		0x2A: { # Activity amount sensor class
			0x80: 'Operation status',
			0xE0: 'Activity amount level 1',
			0xE1: 'Maximum number of human body ID’s',
			0xE2: 'Activity amount level 2',
			0xE3: 'Human body existence information'
		},
		0x2B: { # Human body location sensor
			0x80: 'Operation status',
			0xE0: 'Human body detection location 1',
			0xE1: 'Maximum number of human body ID’s',
			0xE2: 'Human body detection location 2',
			0xE3: 'Human body existence information'
		},
		0x2C: { # Snow sensor class
			0x80: 'Operation status',
			0xB0: 'Detection threshold level',
			0xB1: 'Snow detection status'
		},
		0x2D: { # Air pressure sensor class
			0x80: 'Operation status',
			0xE0: 'Air pressure measurement'
		}
	},
	0x01: { # Air conditioner-related device class group
		0x30: { # Home air conditioner class
			0x80: 'Operation status', #done
			0x8F: 'Operation power-saving',
			0xB0: 'Operation mode setting',  #done
			0xB1: 'Automatic temperature control setting',
			0xB2: 'Normal/high-speed/silent operation setting',
			0xB3: 'Set temperature value',  #done
			0xB4: 'Set value of relative humidity in dehumidifying mode',
			0xB5: 'Set temperature value in cooling mode',
			0xB6: 'Set temperature value in heating mode',
			0xB7: 'Set temperature value in dehumidifying mode',
			0xB8: 'Rated power consumption',
			0xB9: 'Measured value of current consumption',
			0xBA: 'Measured value of room relative humidity',
			0xBB: 'Measured value of room temperature',  #done
			0xBC: 'Set temperature value of user remote control',
			0xBD: 'Measured cooled air temperature',
			0xBE: 'Measured outdoor air temperature',  #done
			0xBF: 'Relative temperature setting',
			0xA0: 'Air flow rate setting',  #done
			0xA1: 'Automatic control of air flow direction setting',  #done
			0xA3: 'Automatic swing of air flow setting',  #done
			0xA4: 'Air flow direction (vertical) setting',  #done
			0xA5: 'Air flow direction (horizontal) setting',  #done
			0xAA: 'Special state',
			0xAB: 'Non-priority state',
			0xC0: 'Ventilation function setting',
			0xC1: 'Humidifier function setting',
			0xC2: 'Ventilation air flow rate setting',
			0xC4: 'Degree of humidification setting',
			0xC6: 'Mounted air cleaning method',
			0xC7: 'Air purifier function setting',
			0xC8: 'Mounted air refresh method',
			0xC9: 'Air refresher function setting',
			0xCA: 'Mounted self-cleaning method',
			0xCB: 'Self-cleaning function setting',
			0xCC: 'Special function setting',
			0xCD: 'Operation status of components',
			0xCE: 'Thermostat setting override function',
			0xCF: 'Air purification mode setting',
			0x90: 'ON timer-based reservation setting',
			0x91: 'ON timer setting (time)',
			0x92: 'ON timer setting (relative time)',
			0x94: 'OFF timer-based reservation setting',
			0x95: 'OFF timer setting (time)',
			0x96: 'OFF timer setting (relative time)',
		},
		0x33: { # Ventilation fan class
			0x80: 'Operation status',
			0xBF: 'Ventilation auto setting',
			0xA0: 'Set value of ventilation air flow rate'
		},
		0x34: { # Air conditioner ventilation fan class
			0x80: 'Operation status',
			0xB4: 'Set value of room relative humidity',
			0xBF: 'Ventilation auto setting',
			0xBA: 'Measured value of room relative humidity',
			0xA0: 'Set value of ventilation air flow rate',
			0xE0: 'Heat exchanger operation setting',
			0xC0: 'Measured value of CO2 concentration',
			0xC1: 'Smoke (cigarette) detection status',
			0xC2: 'Pollution detection status'
		},
		0x35: { # Air cleaner class
			0x80: 'Operation status',
			0xE1: 'Filter change notice',
			0xA0: 'Air flow rate setting',
			0xC1: 'Smoke (cigarette) detection status',
			0xC2: 'Optical catalyst operation setting',
			0xC0: 'Air pollution detection status'
		},
		0x39: { # Humidifier class
			0x80: 'Operation status',
			0xC0: 'Humidifying setting 1',
			0xC1: 'Humidifying setting 2',
			0xB4: 'Measured value of relative humidity',
			0x94: 'Reservation set of OFF timer',
			0x96: 'Relative time value set of OFF timer',
			0xC2: 'Ion emission setting',
			0xC3: 'Implemented ion emission method',
			0xC4: 'Special operation mode setting',
			0xC5: 'Water amount level'
		},
		0x42: { # Electric heater class
			0x80: 'Operation status',
			0xB1: 'Automatic temperature control setting',
			0xB3: 'Temperature setting',
			0xBB: 'Measured room temperature',
			0xBC: 'Remotely set temperature',
			0xA0: 'Air flow rate setting',
			0x90: 'ON timer-based reservation setting',
			0x91: 'ON timer setting (time)',
			0x92: 'ON timer setting (relative time)',
			0x94: 'OFF timer-based reservation setting',
			0x95: 'OFF timer setting (time)',
			0x96: 'Set value of OFF timer relative time'
		},
		0x43: { # Fan heater class
			0x80: 'Operation status',
			0xB3: 'Temperature setting value',
			0xBB: 'Measured temperature',
			0xB1: 'Automatic temperature control setting',
			0x90: 'ON timer reservation setting',
			0x91: 'ON timer setting value (time)',
			0x92: 'ON timer setting value (relative time)',
			0x94: 'OFF timer reservation setting',
			0x95: 'OFF timer setting value (time)',
			0x96: 'OFF timer value ( relative time)',
			0xC0: 'Extensional operation setting',
			0xC1: 'Extensional operation timer time setting value',
			0xC2: 'Ion emission setting',
			0xC3: 'Implemented ion emission method',
			0xC4: 'Oil amount level'
		},
		0x45: { # Package-type commercial air conditioner (indoor unit) class
			0x80: 'Operation status',
			0xB0: 'Operation mode setting',
			0xB3: 'Temperature setting 1',
			0xB4: '“Relative humidity setting for ‘dehumidifica-tion’ mode” 1',
			0xB5: '“Temperature setting for ‘cooling’ mode” 1',
			0xB6: '“Temperature setting for ‘heating’ mode” 1',
			0xB7: '“Temperature setting for ‘dehumidifica-tion’ mode” 1',
			0xB8: 'Rated power consumption of indoor unit',
			0xB9: 'Measured electric current consumption of indoor unit',
			0xBA: 'Measured indoor relative humidity 1',
			0xBB: 'Measured indoor temperature 1',
			0xBF: 'Relative temperature setting',
			0xA0: 'Air flow rate setting',
			0xA4: '“Air flow direction (vertical)” setting',
			0xA5: '“Air flow direction (horizontal)” setting',
			0xAA: '“Special” state',
			0xAC: 'Thermostat state',
			0xAE: 'Current function (“automatic” operation mode)',
			0xC0: 'Ventilation mode setting',
			0xC1: 'Combined operation of indoor unit and total heat exchanger',
			0xC2: 'Ventilation air flow rate setting',
			0xCD: '“Disabling of air conditioner” setting',
			0xCA: 'Group information',
			0xCE: 'Thermostat setting override function',
			0xCF: 'Filter cleaning reminder lamp setting',
			0xDB: 'Measured power consumption of indoor unit',
			0xDC: 'Aperture of expansion valve',
			0xE3: 'Temperature setting 2',
			0xE4: '“Relative humidity setting for ‘dehumidification’ mode” 2',
			0xE5: '“Temperature setting for ‘cooling’ mode” 2',
			0xE6: '“Temperature setting for ‘heating’ mode” 2',
			0xE7: '“Temperature setting for ‘dehumidification’ mode” 2',
			0xEA: 'Measured indoor relative humidity 2',
			0xEB: 'Measured indoor temperature 2',
			0x90: '“ON timer-based reservation” setting',
			0x91: 'ON timer setting (time)',
			0x92: 'ON timer setting (relative time)',
			0x94: '“OFF timer-based reservation” setting',
			0x95: 'OFF timer setting (time)',
			0x96: 'OFF timer setting (relative time)'
		},
		0x46: { # Package-type commercial air conditioner (outdoor unit) class
			0x80: 'Operation status',
			0xB0: 'Operation mode setting',
			0xB8: 'Rated power consumption of outdoor unit',
			0xB9: 'Measured electric current consumption of outdoor unit',
			0xBE: 'Measured outdoor air temperature 1',
			0xAA: '“Special” state',
			0xCA: 'Group information',
			0xD0: 'Operation status of compressor',
			0xD1: 'Operation mode information',
			0xD2: 'Fan rotation speed',
			0xDB: 'Measured power consumption of outdoor unit',
			0xEE: 'Measured outdoor air temperature 2'
		},
		0x55: { # Electric storage heater class
			0x80: 'Operation status',
			0xB3: 'Temperature setting',
			0xB8: 'Rated power consumption',
			0xBB: 'Measured indoor temperature',
			0xBE: 'Measured outdoor temperature',
			0xA0: 'Air flow rate setting',
			0xA1: 'Fan operation status',
			0xC0: 'Heat storage operation status',
			0xC1: 'Heat storage temperature setting',
			0xC2: 'Measured stored heat temperature',
			0xC3: 'Daytime heat storage setting',
			0xC4: 'Daytime heat storage ability',
			0xC5: 'Midnight power duration setting',
			0xC6: 'Midnight power start time setting',
			0xC7: 'Radiation method',
			0xC8: 'Child lock setting',
			0xD0: 'Fan timer 1 setting',
			0xD1: 'Fan timer 1 ON time setting',
			0xD2: 'Fan timer 1 OFF time setting',
			0xD3: 'Fan timer 2 setting',
			0xD4: 'Fan timer 2 ON time setting',
			0xD5: 'Fan timer 2 OFF time setting'
		}
	},
	0x02: { # Housing/facility-related device class group
		0x60: { # Electrically operated blind/shade class
			0x80: 'Operation status',
			0x89: 'Fault description (Recoverable faults)',
			0x90: 'Timer operation setting',
			0xC2: 'Wind detection status',
			0xC3: 'Sunlight detection status',
			0xD0: 'Opening (extension) speed setting',
			0xD1: 'Closing (retraction) speed setting',
			0xD2: 'Operation time',
			0xD4: 'Automatic operation setting',
			0xE0: 'Open/close (extension/retraction) setting',
			0xE1: 'Degree-of-opening level',
			0xE2: 'Shade angle setting ',
			0xE3: 'Open/close (extension/retraction) speed',
			0xE5: 'Electric lock setting',
			0xE8: 'Remote operation setting status',
			0xE9: 'Selective opening (extension) operation setting',
			0xEA: 'Open/closed (extended/retracted) status',
			0xEE: 'One-time opening (extension) speed setting',
			0xEF: 'One-time closing (retraction) speed setting'
		},
		0x61: { # Electrically operated shutter class
			0x80: 'Operation status',
			0x89: 'Fault description (Recoverable faults)',
			0x90: 'Timer operation setting',
			0xD0: 'Opening speed setting',
			0xD1: 'Closing speed setting',
			0xD2: 'Operation time',
			0xE0: 'Open/close operation setting',
			0xE1: 'Degree-of-opening setting',
			0xE2: 'Blind angle setting',
			0xE3: 'Open/close speed setting',
			0xE5: 'Electric lock setting',
			0xE8: 'Remote operation setting status',
			0xE9: 'Selective degree-of-opening setting',
			0xEA: 'Open/closed status',
			0xED: 'Slit degree-of-opening setting',
			0xEE: 'One-time opening speed setting',
			0xEF: 'One-time closing speed setting'
		},
		0x63: { # Electrically operated rain sliding door/shutter class
			0x80: 'Operation status',
			0x89: 'Fault description (Recoverable faults)',
			0x90: 'Timer operation setting',
			0xD0: 'Opening speed setting',
			0xD1: 'Closing speed setting',
			0xD2: 'Operation time',
			0xE0: 'Open/close operation setting',
			0xE1: 'Degree-of-opening setting',
			0xE2: 'Blind angle setting',
			0xE3: 'Opening/closing',
			0xE5: 'Electric lock setting',
			0xE8: 'Remote operation setting status',
			0xE9: 'Selective degree-of-opening setting',
			0xEA: 'Open/closed status',
			0xED: 'Slit degree-of-opening',
			0xEE: 'One-time opening speed setting',
			0xEF: 'One-time closing speed setting'
		},
		0x64: { # Electrically operated gate class
			0x80: 'Operation status',
			0x89: 'Fault description (Recoverable faults)',
			0xD0: 'Opening speed setting',
			0xD1: 'Closing speed setting',
			0xD2: 'Operation time setting value',
			0xE0: 'Opening/closing operation setting',
			0xE1: 'Degree-of-opening setting',
			0xE3: 'Opening/closing speed setting',
			0xE5: 'Electric lock setting',
			0xE8: 'Remote operation',
			0xE9: 'Selective degree-of-opening setting',
			0xEA: 'Open/closed status',
			0xEE: 'One-time opening speed setting',
			0xEF: 'One-time closing speed setting'
		},
		0x65: { # Electrically operated window class
			0x80: 'Operation status',
			0x89: 'Fault description (Recoverable faults)',
			0x90: 'Timer operation setting',
			0xC0: 'Registered temperature detection status',
			0xC1: 'Rain detection status',
			0xD0: 'Opening speed setting',
			0xD1: 'Closing speed setting',
			0xD2: 'Operation time setting value',
			0xD4: 'Automatic operation setting',
			0xE0: 'Opening/closing operation setting',
			0xE1: 'Degree-of-opening setting',
			0xE3: 'Opening/closing speed setting',
			0xE5: 'Electric lock setting',
			0xE8: 'Remote operation setting status',
			0xE9: 'Selective degree-of-opening setting',
			0xEA: 'Open/closed status',
			0xEE: 'One-time opening speed setting',
			0xEF: 'One-time closing speed setting'
		},
		0x66: { # Automatically operated entrance door/sliding door class
			0x80: 'Operation status',
			0x89: 'Fault description (Recoverable faults)',
			0xD0: 'Opening speed setting',
			0xD1: 'Closing speed setting',
			0xD2: 'Operation time setting value',
			0xD5: 'Opening time setting',
			0xE0: 'Opening/closing operation setting',
			0xE1: 'Degree-of-opening setting',
			0xE3: 'Opening/closing speed setting',
			0xE8: 'Remote operation setting status',
			0xE9: 'Selective degree-of-opening setting',
			0xEA: 'Open/closed status',
			0xEE: 'One-time opening speed setting',
			0xEF: 'One-time closing speed setting'
		},
		0x67: {  # Garden sprinkler class
			0x80: 'Operation status',
			0xE0: 'Sprinkle valve open/close setting',
			0xE1: 'Sprinkle interval setting',
			0xE2: 'Number of sprinkles setting',
			0xE3: 'Sprinkle time setting 1',
			0xE4: 'Sprinkle time setting 2',
			0xE5: 'Sprinkle duration setting'
		},
		0x6B: { # Electric water heater class
			0x80: 'Operation status',
			0xB0: 'Automatic water heating setting',
			0xB1: 'Automatic water temperature control setting',
			0xB2: 'Water heater status',
			0xB3: 'Water heating temperature setting',
			0xB4: 'Manual water heating stop days setting',
			0xB5: 'Relative time setting value for manual water heating OFF',
			0xB6: 'Tank operation mode setting',
			0xC0: 'Daytime reheating permission setting',
			0xC1: 'Measured temperature of water in water heater',
			0xC2: 'Alarm status',
			0xC3: 'Hot water supply status',
			0xC4: 'Relative time setting for keeping bath temperature',
			0xD1: 'Temperature of supplied water setting',
			0xD3: 'Bath water temperature setting',
			0xE0: 'Bath water volume setting',
			0xE1: 'Measured amount of water remaining in tank',
			0xE2: 'Tank capacity',
			0xE3: 'Automatic bath water heating mode setting',
			0xE9: 'Bathroom priority setting',
			0xEA: 'Bath operation status monitor',
			0xE4: 'Manual bath reheating operation setting',
			0xE5: 'Manual bath hot water addition function setting',
			0xE6: 'Manual slight bath water temperature lowering function setting',
			0xE7: 'Bath water volume setting 1',
			0xE8: 'Bath water volume setting 2',
			0xEE: 'Bath water volume setting 3',
			0xD4: 'Bath water volume setting 4',
			0xD5: 'Bath water volume setting 4-Maximum settable level',
			0x90: 'ON timer reservation setting',
			0x91: 'ON timer setting',
			0xD6: 'Volume setting',
			0xD7: 'Mute setting',
			0xD8: 'Remaining hot water volume',
			0xDB: 'Rated power consumption of H/P unit in wintertime',
			0xDC: 'Rated power consumption of H/P unit in in-between seasons',
			0xDD: 'Rated power consumption of H/P unit in summertime'
		},
		0x6E: { # Bidet-equipped toilet (with electrically warmed seat) class
			0x80: 'Operation status',
			0xE0: 'Temperature level of toilet seat',
			0xE1: 'Heater setting of toilet seat',
			0xE2: 'Temporal halt setting of toilet seat',
			0xE3: 'Temporal halt start time of toilet seat',
			0xE4: 'Temporal halt time duration of toilet seat',
			0xE5: 'Temperature level setting of room heating',
			0xE6: 'Room heating setting',
			0xE7: 'Room heating status',
			0xE8: 'Start time of room heating',
			0xE9: 'Duration time of room heating',
			0xEA: 'Special operation mode setting',
			0xEB: 'Human detection status',
			0xEC: 'Seating detection status'
		},
		0x6F: { # Electric lock class
			0x80: 'Operation status',
			0xE0: 'Lock setting 1',
			0xE1: 'Lock setting 2',
			0xE2: 'Lock status of door guard',
			0xE3: 'Door open/close status',
			0xE4: 'Occupant/non-occupant status',
			0xE5: 'Alarm status',
			0xE6: 'Auto lock mode setting',
			0xE7: 'Battery level'
		},
		0x72: { # Hot water generator class
			0x80: 'Operation status',
			0xD0: 'Hot water heating status',
			0xD1: 'Set value of hot water temperature',
			0xD2: 'Hot water warmer setting',
			0xDA: '“Duration of automatic operation” setting',
			0xDB: 'Remaining automatic operation time',
			0xE1: 'Set value of bath temperature',
			0xE2: 'Bath water heater status',
			0xE3: 'Bath auto mode setting',
			0xE4: 'Bath additional boil-up operation setting',
			0xE5: 'Bath hot water adding operation setting',
			0xE6: 'Bath water temperature lowering operation setting',
			0xE7: 'Bath hot water volume setting 1',
			0xE8: 'Bath hot water volume setting 2',
			0xEE: 'Bath hot water volume setting 3',
			0xD4: 'Bath hot water volume setting 4',
			0xD5: 'Bath hot water volume setting 4 - Maximum settable level',
			0xE9: 'Bathroom priority setting',
			0xEA: 'Shower hot water supply status',
			0xEB: 'Kitchen hot water supply status',
			0xEC: 'Hot water warmer ON timer reservation setting',
			0xED: 'Set value of hot water warmer ON timer time',
			0xEF: 'Bath operation status monitor',
			0x90: 'ON timer reservation setting',
			0x91: 'Set value of ON timer time',
			0x92: 'Set value of ON timer relative time',
			0xD6: 'Volume setting',
			0xD7: 'Mute setting'
		},
		0x73: { # Bathroom dryer class
			0x80: 'Operation status',
			0xB0: 'Operation setting',
			0xB1: 'Ventilation operation setting',
			0xB2: 'Bathroom pre-warmer operation setting',
			0xB3: 'Bathroom heater operation setting',
			0xB4: 'Bathroom dryer operation setting',
			0xB5: 'Cool air circulator operation setting',
			0xBA: 'Measured relative bathroom humidity',
			0xBB: 'Measured bathroom temperature',
			0xC2: 'Ventilation air flow rate setting',
			0xCF: 'Filter cleaning reminder sign setting',
			0xE0: 'Human body detection status',
			0x90: '“ON timer-based reservation” setting 1',
			0xE1: '“ON timer-based reservation” setting 2',
			0x91: 'ON timer setting (time)',
			0x92: 'ON timer setting (relative time)',
			0x94: '“OFF timer-based reservation” setting',
			0x95: 'OFF timer setting (time)',
			0x96: 'OFF timer setting (relative time)'
		},
		0x79: { # Home solar power generation class
			0x80: 'Operation status',
			0xD0: 'System-interconnected type',
			0xE0: 'Measured instantaneous amount of electricity generated',
			0xE1: 'Measured cumulative amount of electric energy generated',
			0xE2: 'Resetting cumulative amount of electric energy generated',
			0xE3: 'Measured cumulative amount of electric energy sold',
			0xE4: 'Resetting cumulative amount of electric energy sold',
			0xE5: 'Power generation output limit setting 1',
			0xE6: 'Power generation output limit setting 2',
			0xE7: 'Limit setting for the amount of electricity sold',
			0xE8: 'Rated power generation output (System-interconnected)',
			0xE9: 'Rated power generation output (Independent)'
		},
		0x7A: { # Cold/hot water heat source equipment class
			0x80: 'Operation status',
			0xE0: 'Operation mode setting',
			0xE1: 'Water temperature setting 1',
			0xE2: 'Water temperature setting 2',
			0xE3: 'Measured temperature of outward water (Exit water Temperature)',
			0xE4: 'Measured temperature of inward water (Entrance water temperature)',
			0xE5: 'Special operation setting',
			0xE6: 'Daily timer setting',
			0xE7: 'Daily timer setting 1',
			0xE8: 'Daily timer setting 2',
			0xE9: 'ON timer reservation setting',
			0x91: 'ON timer setting',
			0x92: 'Relative ON timer setting',
			0x94: 'OFF timer reservation setting',
			0x95: 'Time set by OFF timer',
			0x96: 'Relative OFF timer setting'
		},
		0x7B: { # Floor heater class
			0x80: 'Operation status',
			0xE0: 'Temperature setting 1',
			0xE1: 'Temperature setting 2',
			0xE2: 'Measured room temperature',
			0xE3: 'Measured floor temperature',
			0xE4: 'Zone change setting',
			0xE5: 'Special operation setting',
			0xE6: 'Daily timer setting',
			0xE7: 'Daily timer setting 1',
			0xE8: 'Daily timer setting 2',
			0x90: 'ON timer reservation setting',
			0x91: 'Time set by ON timer',
			0x92: 'Relative ON timer setting',
			0x94: 'OFF timer reservation setting',
			0x95: 'Time set by OFF timer',
			0x96: 'Relative OFF timer setting'
		},
		0x7C: { # Fuel cell class
			0x80: 'Operation status',
			0xC1: 'Measured temperature of water in water heater',
			0xC2: 'Rated power generation output',
			0xC3: 'Heating value of hot water storage tank',
			0xC4: 'Measured instantaneous power generation output',
			0xC5: 'Measured cumulative power generation output',
			0xC6: 'Cumulative power generation output reset setting',
			0xC7: 'Measured instantaneous gas consumption',
			0xC8: 'Measured cumulative gas consumption',
			0xC9: 'Cumulative gas consumption reset setting',
			0xCA: 'Power generation setting',
			0xCB: 'Power generation status',
			0xCC: 'Measured in-house instantaneous power consumption',
			0xCD: 'Measured in-house cumulative power consumption',
			0xCE: 'In-house cumulative power consumption reset',
			0xD0: 'System interconnected type',
			0xE1: 'Measured remaining hot water amount',
			0xE2: 'Tank capacity'
		},
		0x7D: { # Storage battery class
			0x80: 'Operation status',
			0xC8: 'Minimum/maxim um charging electric energy',
			0xC9: 'Minimum/maxim um discharging electric energy',
			0xCA: 'Minimum/maxim um charging current',
			0xCB: 'Minimum/maxim um discharging current',
			0xCF: 'Working operation status',
			0xD0: 'Rated electric energy',
			0xD1: 'Rated capacity',
			0xD2: 'Rated voltage',
			0xD3: 'Measured instantaneous charging/discharging electric energy',
			0xD4: 'Measured instantaneous charging/discharging current',
			0xD5: 'Measured instantaneous charging/discharging voltage',
			0xD6: 'Measured cumulative discharging electric energy',
			0xD7: '“Measured cumulative discharging electric energy” reset setting',
			0xD8: 'Measured cumulative charging electric energy',
			0xD9: '“Measured cumulative charging electric energy” reset setting',
			0xDA: 'Operation mode setting',
			0xDB: 'System-interconne cted type',
			0xDC: 'Minimum/maxim um charging power (Independent)',
			0xDD: 'Minimum/maxim um discharging power (Independent)',
			0xDE: 'Minimum/maxim um charging current (Independent)',
			0xDF: 'Minimum/maxim um discharging current (Independent)',
			0xE0: 'Charging/discharging amount setting 1',
			0xE1: 'Charging/discharging amount setting 2',
			0xE2: 'Remaining stored electricity 1',
			0xE3: 'Remaining stored electricity 2',
			0xE4: 'Remaining stored electricity 3',
			0xE5: 'Battery state of health',
			0xE6: 'Battery type',
			0xE7: 'Charging amount setting 1',
			0xE8: 'Discharging amount setting 1',
			0xE9: 'Charging amount setting 2',
			0xEA: 'Discharging amount setting 2',
			0xEB: 'Charging electric energy setting',
			0xEC: 'Discharging electric energy setting',
			0xED: 'Charging current setting',
			0xEE: 'Discharging current setting',
			0xEF: 'Rated voltage (Independent)'
		},
		0x7E: { # Electric vehicle charger/discharger class
			0x80: 'Operation status',
			0xC0: 'Dischargeable capacity of vehicle mounted battery 1',
			0xC1: 'Dischargeable capacity of vehicle mounted battery 2',
			0xC2: 'Remaining dischargeable capacity of vehicle mounted battery 1',
			0xC3: 'Remaining dischargeable capacity of vehicle mounted battery 2',
			0xC4: 'Remaining dischargeable capacity of vehicle mounted battery 3',
			0xC5: 'Rated charge capacity',
			0xC6: 'Rated discharge capacity',
			0xC7: 'Vehicle connection and chargeable/dischargeable status',
			0xC8: 'Minimum/maximum charging electric energy',
			0xC9: 'Minimum/maximum discharging electric energy',
			0xCA: 'Minimum/maximum charging current',
			0xCB: 'Minimum/maximum discharging current',
			0xD0: 'Used capacity of vehicle mounted battery 1',
			0xD1: 'Used capacity of vehicle mounted battery 2',
			0xD2: 'Rated voltage',
			0xD3: 'Measured instantaneous charging/discharging electric energy',
			0xD4: 'Measured instantaneous charging/discharging current',
			0xD5: 'Measured instantaneous charging/discharging voltage',
			0xD6: 'Measured cumulative amount of discharging electric energy',
			0xD7: 'Cumulative amount of discharging electric energy reset setting',
			0xD8: 'Measured cumulative amount of charging electric energy',
			0xD9: 'Cumulative amount of charging electric energy reset setting',
			0xDA: 'Operation mode setting',
			0xDB: 'System-interconnecte d type',
			0xE2: 'Remaining stored electricity of vehicle mounted battery 1',
			0xE3: 'Remaining stored electricity of vehicle mounted battery 2',
			0xE4: 'Remaining stored electricity of vehicle mounted battery 3',
			0xE7: 'Charging amount setting 1',
			0xE9: 'Charging amount setting 2',
			0xEB: 'Charging electric energy setting',
			0xEC: 'Discharging electric energy setting',
			0xED: 'Charging current setting',
			0xEE: 'Discharging current setting',
			0xEF: 'Rated voltage (Independent)',
		},
		0x7F: { # Engine cogeneration class
			0x80: 'Operation status',
			0xC1: 'Measured temperature of water in water heater',
			0xC2: 'Rated power generation output',
			0xC3: 'Heating value of hot water storage tank',
			0xC4: 'Measured instantaneous power generation output',
			0xC5: 'Measured cumulative power generation output',
			0xC6: 'Cumulative power generation output reset setting',
			0xC7: 'Measured instantaneous gas consumption',
			0xC8: 'Measured cumulative gas consumption',
			0xC9: 'Cumulative gas consumption reset setting',
			0xCA: 'Power generation setting',
			0xCB: 'Power generation status',
			0xCC: 'Measured in-house instantaneous power consumption',
			0xCD: 'Measured in-house cumulative power consumption',
			0xCE: 'In-house cumulative power consumption reset',
			0xD0: 'System interconnected type',
			0xE1: 'Measured remaining hot water amount',
			0xE2: 'Tank capacity'
		},
		0x80: { # Electric energy meter class
			0x80: 'Operation status',
			0xE0: 'Cumulative amounts of electric energy measurement value',
			0xE2: 'Cumulative amounts of electric energy unit',
			0xE3: 'Cumulative amounts of electric energy measurement log 1',
			0xE4: 'Cumulative amounts of electric energy measurement log 2'
		},
		0x81: { # Water flow meter class
			0x80: 'Operation status',
			0xD0: 'Flowing water classification',
			0xD1: 'Owner classification',
			0xE0: 'Measured cumulative amount of flowing water',
			0xE1: 'Unit for measured cumulative amounts of flowing water',
			0xE2: 'Historical data of measured cumulative amounts of flowing water',
			0xE3: 'Detection of abnormal value in metering data',
			0xE4: 'Security data information',
			0xE5: 'ID number setting',
			0xE6: 'Verification expiration information'
		},
		0x82: { # Gas meter class
			0x80: 'Operation status',
			0xE0: 'Cumulative amount of gas consumption measurement value',
			0xE2: 'Cumulative amount of gas consumption measurement log'
		},
		0x83: { # LP gas meter class
			0x80: 'Operation status',
			0xE0: 'Cumulative amount of gas consumption of metering data 1',
			0xE1: 'Cumulative amount of gas consumption of metering data 2',
			0xE2: 'Error detection status of metering data',
			0xE3: 'Security data 1',
			0xE4: 'Security data 2',
			0xE5: 'Center valve shut-off status',
			0xE6: 'Center valve shut-off recovery permission setting status',
			0xE7: 'Emergency valve shut-off status',
			0xE8: 'Shut-off valve open/close status',
			0xE9: 'Residual volume control warning',
			0xEA: 'Set value of residual volume control warning level 1',
			0xEB: 'Set value of residual volume control warning level 2',
			0xEC: 'Set value of residual volume control warning level 3',
			0xED: 'Slight leak timer value (gas flow rate continuation)',
			0xEE: 'Slight leak timer value (without pressure increase)',
			0xEF: 'Shut-off reason log',
			0xD0: 'Maximum value of supply pressure data',
			0xD1: 'Minimum value of supply pressure data',
			0xD2: 'Current value of supply pressure data',
			0xD3: 'Maximum value of block pressure data',
			0xD4: 'Minimum value of block pressure data',
			0xD5: 'Current value of block pressure data',
			0xD6: 'Number of block pressure/supply pressure error days: times',
			0xD7: 'Test call setting'
		},
		0x87: { # Distribution panel metering class
			0x80: 'Operation status',
			0xC0: 'Measured cumulative amount of electric energy (normal direction)',
			0xC1: 'Measured cumulative amount of electric energy (reverse direction)',
			0xC2: 'Unit for cumulative amounts of electric energy',
			0xC3: 'Historical data of measured cumulative amounts of electric energy (normal direction)',
			0xC4: 'Historical data of measured cumulative amounts of electric energy (reverse direction)',
			0xC5: 'Day for which the historical data of measured cumulative amounts of electric energy is to be retrieved',
			0xC6: 'Measured instantaneous amount of electric energy',
			0xC7: 'Measured instantaneous currents',
			0xC8: 'Measured instantaneous voltages',
			0xD0: 'Measurement channel 1',
			0xD1: 'Measurement channel 2',
			0xD2: 'Measurement channel 3',
			0xD3: 'Measurement channel 4',
			0xD4: 'Measurement channel 5',
			0xD5: 'Measurement channel 6',
			0xD6: 'Measurement channel 7',
			0xD7: 'Measurement channel 8',
			0xD8: 'Measurement channel 9',
			0xD9: 'Measurement channel 10',
			0xDA: 'Measurement channel 11',
			0xDB: 'Measurement channel 12',
			0xDC: 'Measurement channel 13',
			0xDD: 'Measurement channel 14',
			0xDE: 'Measurement channel 15',
			0xDF: 'Measurement channel 16',
			0xE0: 'Measurement channel 17',
			0xE1: 'Measurement channel 18',
			0xE2: 'Measurement channel 19',
			0xE3: 'Measurement channel 20',
			0xE4: 'Measurement channel 21',
			0xE5: 'Measurement channel 22',
			0xE6: 'Measurement channel 23',
			0xE7: 'Measurement channel 24',
			0xE8: 'Measurement channel 25',
			0xE9: 'Measurement channel 26',
			0xEA: 'Measurement channel 27',
			0xEB: 'Measurement channel 28',
			0xEC: 'Measurement channel 29',
			0xED: 'Measurement channel 30',
			0xEE: 'Measurement channel 31',
			0xEF: 'Measurement channel 32',
			0xB0: 'Master rated capacity',
			0xB1: 'Number of measurement channels (simplex)',
			0xB2: 'Channel range specification for cumulative amount of electric power consumption measurement (simplex)',
			0xB3: 'Measured cumulative amount of electric power consumption list (simplex)',
			0xB4: 'Channel range specification for instantaneous current measurement (simplex)',
			0xB5: 'Measured instantaneous current list (simplex)',
			0xB6: 'Channel range specification for instantaneous power consumption measurement (simplex)',
			0xB7: 'Measured instantaneous power consumption list (simplex)',
			0xB8: 'Number of measurement channels (duplex)',
			0xB9: 'Channel range specification for cumulative amount of electric power consumption measurement (duplex)',
			0xBA: 'Measured cumulative amount of electric power consumption list (duplex)',
			0xBB: 'Channel range specification for instantaneous current measurement (duplex)',
			0xBC: 'Measured instantaneous current list (duplex)',
			0xBD: 'Channel range specification for instantaneous power consumption measurement (duplex)',
			0xBE: 'Measured instantaneous power consumption list (duplex)'
		},
		0x88: { # Low voltage smart electric energy meter class
			0x80: 'Operation status',
			0xD3: 'Coefficient',
			0xD7: 'Number of effective digits for cumulative amounts of electric energy',
			0xE0: 'Measured cumulative amount of electric energy (normal direction)',
			0xE1: 'Unit for cumulative amounts of electric energy (normal and reverse directions)',
			0xE2: 'Historical data of measured cumulative amounts of electric energy 1 (normal direction)',
			0xE3: 'Measured cumulative amounts of electric energy (reverse direction)',
			0xE4: 'Historical data of measured cumulative amounts of electric energy 1 (reverse direction)',
			0xE5: 'Day for which the historical data of measured cumulative amounts of electric energy is to be retrieved 1',
			0xE7: 'Measured instantaneous electric energy',
			0xE8: 'Measured instantaneous currents',
			0xEA: 'Cumulative amounts of electric energy measured at fixed time (normal direction)',
			0xEB: 'Cumulative amounts of electric energy measured at fixed time (reverse direction)',
			0xEC: 'Historical data of measured cumulative amounts of electric energy 2 (normal and reverse directions)',
			0xED: 'Day for which the historical data of measured cumulative amounts of electric energy is to be retrieved 2'
		},
		0x89: { # Smart gas meter class
			0x80: 'Operation status',
			0xE0: 'Gas meter classification setting',
			0xE1: 'Owner classification setting',
			0xE2: 'Measured cumulative gas consumption',
			0xE3: 'Unit for measured cumulative gas consumption',
			0xE4: 'Historical data of measured cumulative gas consumption',
			0xE5: 'Day setting for which the historical data of measured cumulative gas consumption is to be retrieved',
			0xE6: 'Detection of abnormal value in metering data',
			0xE7: 'Security data information',
			0xE8: 'Valve closure by the Center',
			0xE9: 'Permission from the Center to reopen the valve closed by the Center',
			0xEA: 'Emergency closure of shutoff valve',
			0xEB: 'Shutoff valve status',
			0xEC: 'Historical data of shutoff reasons',
			0xED: 'ID number setting',
			0xEE: 'Verification expiration setting',
			0xD0: 'Measured cumulative gas consumption information with date and time',
			0xD1: 'Historical information of cumulative gas consumption'
		},
		0x8A: { # High voltage smart electric energy meter class
			0x80: 'Operation status',
			0xD3: 'Coefficient',
			0xD4: 'Multiplying factor for coefficient',
			0xE0: 'Fixed date',
			0xE1: 'Day for which the historical data of measured cumulative amounts of electric energy is to be retrieved',
			0xE2: 'Measured cumulative amount of active electric energy',
			0xE3: 'Cumulative amounts of active electric energy at fixed time',
			0xE4: 'Measurement data of cumulative amount of active electric energy for power factor measurement',
			0xE5: 'Number of effective digits for cumulative amount of active electric energy',
			0xE6: 'Unit for cumulative amounts of active electric energy',
			0xE7: 'Historical data of measured cumulative amount of active electric energy',
			0xC1: 'Monthly maximum electric power demand',
			0xC2: 'Cumulative maximum electric power demand',
			0xC3: 'Electric power demand at fixed time (30-minute average electric power)',
			0xC4: 'Number of effective digits of electric power demand',
			0xC5: 'Unit of electric power demand',
			0xC6: 'Historical data of measured electric power demand',
			0xC7: 'Unit of cumulative maximum electric power demand',
			0xCA: 'Measurement data of reactive electric power consumption (lag) for power factor measurement',
			0xCB: 'Measurement data of cumulative amount of reactive electric power consumption (lag) at fixed time for power factor measurement',
			0xCC: 'Number of effective digits for measurement data of cumulative amount of reactive electric power consumption (lag) for power factor measurement',
			0xCD: 'Unit of measurement data of cumulative amount of reactive electric power consumption (lag)',
			0xCE: 'Historical data of measurement data of cumulative amount of reactive electric power consumption(lag) for power factor measurement'
		},
		0x90: { # General lighting class class
			0x80: 'Operation status',
			0xB0: 'Illuminance level',
			0xB1: 'Light color setting',
			0xB2: 'Illuminance level step setting',
			0xB3: 'Light color step setting',
			0xB4: 'Maximum specifiable values',
			0xB5: 'Maximum value of settable level for night lighting',
			0xB6: 'Lighting mode setting',
			0xB7: 'Illuminance level setting for main lighting',
			0xB8: 'Illuminance level step setting for main lighting',
			0xB9: 'Illuminance level setting for night lighting',
			0xBA: 'Illuminance level step setting for night lighting',
			0xBB: 'Light color setting for main lighting',
			0xBC: 'Light color level step setting for main lighting',
			0xBD: 'Light color setting for night lighting',
			0xBE: 'Light color level step setting for night lighting',
			0xBF: 'Lighting mode status in auto mode',
			0xC0: 'RGB setting for color lighting',
			0x90: 'ON timer reservation setting',
			0x91: 'ON timer setting',
			0x94: 'OFF timer reservation setting',
			0x95: 'OFF timer setting'
		},
		0x91: { # Single function lighting class
			0x80: 'Operation status',
			0xB0: 'Illuminance level setting'
		},
		0xA0: { # Buzzer class
			0x80: 'Operation status',
			0xB1: 'Sound generation setting',
			0xE0: 'Buzzer sound type'
		}
	},
	0x03: { # Cooking/housework-related device class group
		0xB2: { # Electric hot water pot (Electric thermos) class
			0x80: 'Operation status',
			0xB0: 'Cover open/close status',
			0xB1: 'No-water warning',
			0xB2: 'Boil-up setting',
			0xE0: 'Boil-up/warmer mode setting',
			0xE1: 'Set value of warmer temperature',
			0xE2: 'Hot water discharge status',
			0xE3: 'Lock status'
		},
		0xB7: { # Refrigerator class
			0x80: 'Operation status',
			0xB0: 'Door open/close status',
			0xB1: 'Door open warning',
			0xB2: 'Refrigerator compartment door status',
			0xB3: 'Freezer compartment door status',
			0xB4: 'Ice compartment door status',
			0xB5: 'Vegetable compartment door status',
			0xB6: 'Multi-refrigera-ting mode compartment door',
			0xE0: 'Maximum allowable temperature setting level',
			0xE2: 'Refrigerator compartment temperature setting',
			0xE3: 'Freezer compartment temperature setting',
			0xE4: 'Ice temperature setting',
			0xE5: 'Vegetable compartment temperature setting',
			0xE6: 'Multi-refrigera-ting mode compartment temperature setting',
			0xE9: 'Refrigerator compartment temperature level setting',
			0xEA: 'Freezer compartment temperature level setting',
			0xEB: 'ice compartment temperature level setting',
			0xEC: 'Vegetable compartment temperature level setting',
			0xED: 'Multi-refrigera-ting mode compartment temperature level setting',
			0xD1: 'Measured refrigerator compartment temperature',
			0xD2: 'Measured freezer compartment temperature',
			0xD3: 'Measured subzero-fresh compartment temperature',
			0xD4: 'Measured vegetable compartment temperature',
			0xD5: 'Measured multi-refrigeratin g mode compartment temperature',
			0xD8: 'Compressor rotation speed',
			0xDA: 'Measured electric current consumption',
			0xDC: 'Rated power consumption',
			0xA0: 'Quick freeze function setting',
			0xA1: 'Quick refrigeration function setting',
			0xA4: 'Icemaker setting',
			0xA5: 'Icemaker operation status',
			0xA6: 'Icemaker tank status',
			0xA8: 'Refrigerator compartment humidification function setting',
			0xA9: 'Vegetable compartment humidification function setting',
			0xAD: 'Deodorization function setting'
		},
		0xB8: { # Combination microwave oven (Electronic oven) class
			0x80: 'Operation status',
			0xB0: 'Door open/close status',
			0xB1: 'Heating status',
			0xB2: 'Heating setting',
			0xE0: 'Heating mode setting',
			0xE1: 'Automatic heating setting',
			0xE2: 'Automatic heating level setting',
			0xD0: 'Automatic heating menu setting',
			0xD1: 'Oven mode setting',
			0xD5: 'Oven preheating setting',
			0xD6: 'Fermenting mode setting',
			0xE3: 'Chamber temperature setting',
			0xE4: 'Food temperature setting',
			0xE5: 'Heating time setting',
			0xE6: 'Remaining heating time setting',
			0xE7: 'Microwave heating power setting',
			0xE8: 'Prompt message setting',
			0xE9: 'Accessories to combination microwave oven setting',
			0xEA: 'Display character string setting',
			0xEB: 'Two-stage microwave heating setting (duration)',
			0xEC: 'Two-stage microwave heating setting (heating power)'
		},
		0xB9: { # Cooking heater class
			0x80: 'Operation status',
			0xB1: 'Heating status',
			0xB2: 'Heating setting',
			0xB3: 'All stop setting',
			0xE7: 'Heating power setting',
			0xE3: 'Heating temperature setting',
			0xE0: '“Heating modes of stoves” setting',
			0x96: 'Relative time settings of OFF timers',
			0xA1: 'Child lock setting',
			0xA2: 'Radiant heater lock setting'
		},
		0xBB: { # Raice cooker class
			0x80: 'Operation status',
			0xB0: 'Cover open/close status',
			0xB1: 'Rice cooking status',
			0xB2: 'Rice cooking control setting',
			0xE1: 'Warmer setting',
			0xE5: 'Inner pot removal status',
			0xE6: 'Cover removal status',
			0x90: 'Rice cooking reservation setting',
			0x91: 'Set value of rice cooking reservation setting time',
			0x92: 'Set value of rice cooking reservation setting relative time'
		},
		0xC5: { # Washing machine class
			0x80: 'Operation status',
			0xB0: 'Door/cover open/close status',
			0xB2: 'Washing machine setting',
			0xE1: 'Current stage of washing cycle',
			0xE6: 'Time remaining to complete washing cycle',
			0x90: 'ON timer reservation setting',
			0x91: 'ON timer setting',
			0x92: 'Relative time-based ON timer setting'
		},
		0xCE: { # Commercial show case class
			0x80: 'Operation status',
			0xB0: 'Operating mode',
			0xBD: 'Discharge temperature measurement',
			0xE0: 'Internal lighting operation status',
			0xE1: 'External lighting operation status',
			0xE2: 'Compressor operation status',
			0xE3: 'Internal temperature measurement',
			0xE4: 'Freezing capability value',
			0xE5: 'Defrosting heater power consumption',
			0xE6: 'Fan motor power consumption',
			0xCA: 'Group information',
			0xE7: 'Heater mode'
		},
		0xC6: { # Clothes dryer class
			0x80: 'Operation status',
			0xB0: 'Door/cover open/close status',
			0xB2: 'Drying setting',
			0xE1: 'Drying status',
			0xE6: 'Remaining drying time',
			0x90: 'ON timer reservation setting',
			0x91: 'ON timer setting',
			0x92: 'Relative time-based ON timer setting'
		},
		0xD3: { # Washer and dryer class
			0x80: 'Operation status',
			0xB0: 'Door/cover open/close status',
			0xB2: 'Washer and dryer setting',
			0xD0: 'Washer and dryer cycle setting 1',
			0xD1: 'Washer and dryer cycle setting 2',
			0xD2: 'Drying cycle setting',
			0xD3: 'Washer and dryer cycle option list 1',
			0xD4: 'Washer and dryer cycle option list 2',
			0xD5: 'Washer and dryer cycle option list 3',
			0xD6: 'Water flow rate setting',
			0xD7: '“Rotation speed for spin drying” setting',
			0xD8: '“Degree of drying” setting',
			0xDB: 'Remaining washing time',
			0xDC: 'Remaining drying time',
			0xDF: 'Elapsed time on the ON timer',
			0xE1: 'Presoaking time setting',
			0xE2: 'Current stage of washer and dryer cycle',
			0xE3: 'Water volume setting 1',
			0xE4: 'Water volume setting 2',
			0xE5: 'Washing time setting',
			0xE6: '“Number of times of rinsing” setting',
			0xE7: 'Rinsing process setting',
			0xE8: 'Spin drying time setting',
			0xE9: 'Drying time setting',
			0xEA: 'Warm water setting',
			0xEB: 'Bathtub water recycle setting',
			0xEC: 'Wrinkling minimization setting',
			0xED: 'Time remaining to complete washer and dryer cycle',
			0xEE: 'Door/cover lock setting',
			0xEF: 'Washer and dryer cycle',
			0x90: 'ON timer reservation setting',
			0x91: 'ON timer setting',
			0x92: 'Relative time-based ON timer setting'
		},
		0xD4: { # Commercial show case outdoor unit class
			0x80: 'Operation status',
			0xAA: 'Exceptional status',
			0xB0: 'Operating mode',
			0xBE: 'Outdoor air temperature measurement',
			0xE2: 'Compressor operation status',
			0xCA: 'Group information'
		}
	},
	0x04: { # Health-related device class group
		0x01: { # Weighing machine class
			0x80: 'Operation status',
			0xE0: 'Measured value of body weight',
			0xE1: 'Measured value of body fat'
		}
	},
	0x05: { # Management/control-related device class group
		0xFD: { # Switch (supporting JEM-A/HA terminals) class
			0x80: 'Operation status',
			0xE0: 'Connected device'
		}
	},
	0x06: { # AV-related device class group
		0x01: { # Display class
			0x80: 'Operation status',
			0xB0: 'Display control setting',
			0xB1: 'Character string setting acceptance status',
			0xB2: 'Supported character codes',
			0xB3: 'Character string to present to the user',
			0xB4: 'Length of character string accepted '
		},
		0x02: { # Television class
			0x80: 'Operation status',
			0xB0: 'Display control setting',
			0xB1: 'Character string setting acceptance status',
			0xB2: 'Supported character codes',
			0xB3: 'Character string to present to the user',
			0xB4: 'Length of character string accepted'
		},
		0x03: { # Audio class
			0x80: 'Operation status',
			0xB8: 'Volume setting',
			0xB9: 'Mute setting',
			0xBC: 'Input source setting'
		},
		0x04: { # Network camera class
			0x80: 'Operation status',
			0xC0: 'Still image photography setting acceptance status',
			0xC1: 'Still image photography setting',
			0xD0: 'Transfer setting'
		}
	},
	0x0E: { # Profile class group
		0xF0: { # Node profile class
			0x80: 'Operating status',
			0x82: 'Version information',
			0x83: 'Identification number',
			0x89: 'Fault content',
			0xBF: 'Unique identifier data',
			0xD3: 'Number of self-node instances',
			0xD4: 'Number of self-node classes',
			0xD5: 'Instance list notification',
			0xD6: 'Self-node instance list S',
			0xD7: 'Self-node class list S',
			# Super Class of the Profile class group
			0x88: 'Fault status',
			0x8A: 'Manufacturer code',
			0x8B: 'Business facility code',
			0x8C: 'Product code',
			0x8D: 'Production number ',
			0x8E: 'Production date',
			0x9D: 'Status change announcement property map',
			0x9E: 'Set property map',
			0x9F: 'Get property map'
		}
	}
}

EPC_SUPER = {
	0x80: 'Operation status',
	0x81: 'Installation location',
	0x82: 'Standard version information',
	0x83: 'Identification number',
	0x84: 'Measured instantaneous power consumption',
	0x85: 'Measured cumulative power consumption',
	0x86: 'Manufacturers fault code',
	0x87: 'Current limit setting',
	0x88: 'Fault status',
	0x89: 'Fault description',
	0x8A: 'Manufacturer code',
	0x8B: 'Business facility code',
	0x8C: 'Product code',
	0x8D: 'Production number',
	0x8E: 'Production date',
	0x8F: 'Power-saving operation setting',
	0x93: 'Remote control setting',
	0x97: 'Current time setting',
	0x98: 'Current date setting',
	0x99: 'Power limit setting',
	0x9A: 'Cumulative operating time',
	0x9B: 'SetM property map',
	0x9C: 'GetM property map',
	0x9D: 'Status change announcement property map',
	0x9E: 'Set property map',
	0x9F: 'Get property map',
}
