import * as kinesis from '@aws-cdk/aws-kinesis';
import * as lambda from '@aws-cdk/aws-lambda';
import { StreamEventSource, StreamEventSourceProps } from './stream';
/**
 * @stability stable
 */
export interface KinesisEventSourceProps extends StreamEventSourceProps {
}
/**
 * Use an Amazon Kinesis stream as an event source for AWS Lambda.
 *
 * @stability stable
 */
export declare class KinesisEventSource extends StreamEventSource {
    readonly stream: kinesis.IStream;
    private _eventSourceMappingId?;
    /**
     * @stability stable
     */
    constructor(stream: kinesis.IStream, props: KinesisEventSourceProps);
    /**
     * Called by `lambda.addEventSource` to allow the event source to bind to this function.
     *
     * @stability stable
     */
    bind(target: lambda.IFunction): void;
    /**
     * The identifier for this EventSourceMapping.
     *
     * @stability stable
     */
    get eventSourceMappingId(): string;
}
