import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ValidatingWebhookConfigurationV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#id ValidatingWebhookConfigurationV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#metadata ValidatingWebhookConfigurationV1#metadata}
    */
    readonly metadata: ValidatingWebhookConfigurationV1Metadata;
    /**
    * webhook block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#webhook ValidatingWebhookConfigurationV1#webhook}
    */
    readonly webhook: ValidatingWebhookConfigurationV1Webhook[] | cdktf.IResolvable;
}
export interface ValidatingWebhookConfigurationV1Metadata {
    /**
    * An unstructured key value map stored with the validating webhook configuration that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#annotations ValidatingWebhookConfigurationV1#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Prefix, used by the server, to generate a unique name ONLY IF the `name` field has not been provided. This value will also be combined with a unique suffix. Read more: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#idempotency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#generate_name ValidatingWebhookConfigurationV1#generate_name}
    */
    readonly generateName?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the validating webhook configuration. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#labels ValidatingWebhookConfigurationV1#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the validating webhook configuration, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#name ValidatingWebhookConfigurationV1#name}
    */
    readonly name?: string;
}
export declare function validatingWebhookConfigurationV1MetadataToTerraform(struct?: ValidatingWebhookConfigurationV1MetadataOutputReference | ValidatingWebhookConfigurationV1Metadata): any;
export declare class ValidatingWebhookConfigurationV1MetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ValidatingWebhookConfigurationV1Metadata | undefined;
    set internalValue(value: ValidatingWebhookConfigurationV1Metadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _generateName?;
    get generateName(): string;
    set generateName(value: string);
    resetGenerateName(): void;
    get generateNameInput(): string | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface ValidatingWebhookConfigurationV1WebhookClientConfigService {
    /**
    * `name` is the name of the service. Required
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#name ValidatingWebhookConfigurationV1#name}
    */
    readonly name: string;
    /**
    * `namespace` is the namespace of the service. Required
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#namespace ValidatingWebhookConfigurationV1#namespace}
    */
    readonly namespace: string;
    /**
    * `path` is an optional URL path which will be sent in any request to this service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#path ValidatingWebhookConfigurationV1#path}
    */
    readonly path?: string;
    /**
    * If specified, the port on the service that hosting webhook. Default to 443 for backward compatibility. `port` should be a valid port number (1-65535, inclusive).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#port ValidatingWebhookConfigurationV1#port}
    */
    readonly port?: number;
}
export declare function validatingWebhookConfigurationV1WebhookClientConfigServiceToTerraform(struct?: ValidatingWebhookConfigurationV1WebhookClientConfigServiceOutputReference | ValidatingWebhookConfigurationV1WebhookClientConfigService): any;
export declare class ValidatingWebhookConfigurationV1WebhookClientConfigServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ValidatingWebhookConfigurationV1WebhookClientConfigService | undefined;
    set internalValue(value: ValidatingWebhookConfigurationV1WebhookClientConfigService | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
}
export interface ValidatingWebhookConfigurationV1WebhookClientConfig {
    /**
    * `caBundle` is a PEM encoded CA bundle which will be used to validate the webhook's server certificate. If unspecified, system trust roots on the apiserver are used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#ca_bundle ValidatingWebhookConfigurationV1#ca_bundle}
    */
    readonly caBundle?: string;
    /**
    * `url` gives the location of the webhook, in standard URL form (`scheme://host:port/path`). Exactly one of `url` or `service` must be specified.
  
  The `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.
  
  Please note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.
  
  The scheme must be "https"; the URL must begin with "https://".
  
  A path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.
  
  Attempting to use a user or basic auth e.g. "user:password@" is not allowed. Fragments ("#...") and query parameters ("?...") are not allowed, either.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#url ValidatingWebhookConfigurationV1#url}
    */
    readonly url?: string;
    /**
    * service block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#service ValidatingWebhookConfigurationV1#service}
    */
    readonly service?: ValidatingWebhookConfigurationV1WebhookClientConfigService;
}
export declare function validatingWebhookConfigurationV1WebhookClientConfigToTerraform(struct?: ValidatingWebhookConfigurationV1WebhookClientConfigOutputReference | ValidatingWebhookConfigurationV1WebhookClientConfig): any;
export declare class ValidatingWebhookConfigurationV1WebhookClientConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ValidatingWebhookConfigurationV1WebhookClientConfig | undefined;
    set internalValue(value: ValidatingWebhookConfigurationV1WebhookClientConfig | undefined);
    private _caBundle?;
    get caBundle(): string;
    set caBundle(value: string);
    resetCaBundle(): void;
    get caBundleInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
    private _service;
    get service(): ValidatingWebhookConfigurationV1WebhookClientConfigServiceOutputReference;
    putService(value: ValidatingWebhookConfigurationV1WebhookClientConfigService): void;
    resetService(): void;
    get serviceInput(): ValidatingWebhookConfigurationV1WebhookClientConfigService | undefined;
}
export interface ValidatingWebhookConfigurationV1WebhookNamespaceSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#key ValidatingWebhookConfigurationV1#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#operator ValidatingWebhookConfigurationV1#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#values ValidatingWebhookConfigurationV1#values}
    */
    readonly values?: string[];
}
export declare function validatingWebhookConfigurationV1WebhookNamespaceSelectorMatchExpressionsToTerraform(struct?: ValidatingWebhookConfigurationV1WebhookNamespaceSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class ValidatingWebhookConfigurationV1WebhookNamespaceSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ValidatingWebhookConfigurationV1WebhookNamespaceSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: ValidatingWebhookConfigurationV1WebhookNamespaceSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class ValidatingWebhookConfigurationV1WebhookNamespaceSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ValidatingWebhookConfigurationV1WebhookNamespaceSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ValidatingWebhookConfigurationV1WebhookNamespaceSelectorMatchExpressionsOutputReference;
}
export interface ValidatingWebhookConfigurationV1WebhookNamespaceSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#match_labels ValidatingWebhookConfigurationV1#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#match_expressions ValidatingWebhookConfigurationV1#match_expressions}
    */
    readonly matchExpressions?: ValidatingWebhookConfigurationV1WebhookNamespaceSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function validatingWebhookConfigurationV1WebhookNamespaceSelectorToTerraform(struct?: ValidatingWebhookConfigurationV1WebhookNamespaceSelectorOutputReference | ValidatingWebhookConfigurationV1WebhookNamespaceSelector): any;
export declare class ValidatingWebhookConfigurationV1WebhookNamespaceSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ValidatingWebhookConfigurationV1WebhookNamespaceSelector | undefined;
    set internalValue(value: ValidatingWebhookConfigurationV1WebhookNamespaceSelector | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): ValidatingWebhookConfigurationV1WebhookNamespaceSelectorMatchExpressionsList;
    putMatchExpressions(value: ValidatingWebhookConfigurationV1WebhookNamespaceSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | ValidatingWebhookConfigurationV1WebhookNamespaceSelectorMatchExpressions[] | undefined;
}
export interface ValidatingWebhookConfigurationV1WebhookObjectSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#key ValidatingWebhookConfigurationV1#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#operator ValidatingWebhookConfigurationV1#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#values ValidatingWebhookConfigurationV1#values}
    */
    readonly values?: string[];
}
export declare function validatingWebhookConfigurationV1WebhookObjectSelectorMatchExpressionsToTerraform(struct?: ValidatingWebhookConfigurationV1WebhookObjectSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class ValidatingWebhookConfigurationV1WebhookObjectSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ValidatingWebhookConfigurationV1WebhookObjectSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: ValidatingWebhookConfigurationV1WebhookObjectSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class ValidatingWebhookConfigurationV1WebhookObjectSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ValidatingWebhookConfigurationV1WebhookObjectSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ValidatingWebhookConfigurationV1WebhookObjectSelectorMatchExpressionsOutputReference;
}
export interface ValidatingWebhookConfigurationV1WebhookObjectSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#match_labels ValidatingWebhookConfigurationV1#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#match_expressions ValidatingWebhookConfigurationV1#match_expressions}
    */
    readonly matchExpressions?: ValidatingWebhookConfigurationV1WebhookObjectSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function validatingWebhookConfigurationV1WebhookObjectSelectorToTerraform(struct?: ValidatingWebhookConfigurationV1WebhookObjectSelectorOutputReference | ValidatingWebhookConfigurationV1WebhookObjectSelector): any;
export declare class ValidatingWebhookConfigurationV1WebhookObjectSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ValidatingWebhookConfigurationV1WebhookObjectSelector | undefined;
    set internalValue(value: ValidatingWebhookConfigurationV1WebhookObjectSelector | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): ValidatingWebhookConfigurationV1WebhookObjectSelectorMatchExpressionsList;
    putMatchExpressions(value: ValidatingWebhookConfigurationV1WebhookObjectSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | ValidatingWebhookConfigurationV1WebhookObjectSelectorMatchExpressions[] | undefined;
}
export interface ValidatingWebhookConfigurationV1WebhookRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#api_groups ValidatingWebhookConfigurationV1#api_groups}
    */
    readonly apiGroups: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#api_versions ValidatingWebhookConfigurationV1#api_versions}
    */
    readonly apiVersions: string[];
    /**
    * Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#operations ValidatingWebhookConfigurationV1#operations}
    */
    readonly operations: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#resources ValidatingWebhookConfigurationV1#resources}
    */
    readonly resources: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#scope ValidatingWebhookConfigurationV1#scope}
    */
    readonly scope?: string;
}
export declare function validatingWebhookConfigurationV1WebhookRuleToTerraform(struct?: ValidatingWebhookConfigurationV1WebhookRule | cdktf.IResolvable): any;
export declare class ValidatingWebhookConfigurationV1WebhookRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ValidatingWebhookConfigurationV1WebhookRule | cdktf.IResolvable | undefined;
    set internalValue(value: ValidatingWebhookConfigurationV1WebhookRule | cdktf.IResolvable | undefined);
    private _apiGroups?;
    get apiGroups(): string[];
    set apiGroups(value: string[]);
    get apiGroupsInput(): string[] | undefined;
    private _apiVersions?;
    get apiVersions(): string[];
    set apiVersions(value: string[]);
    get apiVersionsInput(): string[] | undefined;
    private _operations?;
    get operations(): string[];
    set operations(value: string[]);
    get operationsInput(): string[] | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    get resourcesInput(): string[] | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
}
export declare class ValidatingWebhookConfigurationV1WebhookRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ValidatingWebhookConfigurationV1WebhookRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ValidatingWebhookConfigurationV1WebhookRuleOutputReference;
}
export interface ValidatingWebhookConfigurationV1Webhook {
    /**
    * AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects. API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, validation will fail for this object. If a persisted webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail and be subject to the failure policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#admission_review_versions ValidatingWebhookConfigurationV1#admission_review_versions}
    */
    readonly admissionReviewVersions?: string[];
    /**
    * FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Fail.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#failure_policy ValidatingWebhookConfigurationV1#failure_policy}
    */
    readonly failurePolicy?: string;
    /**
    * matchPolicy defines how the "rules" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".
  
  - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the webhook.
  
  - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the webhook.
  
  Defaults to "Equivalent"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#match_policy ValidatingWebhookConfigurationV1#match_policy}
    */
    readonly matchPolicy?: string;
    /**
    * The name of the admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where "imagepolicy" is the name of the webhook, and kubernetes.io is the name of the organization. Required.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#name ValidatingWebhookConfigurationV1#name}
    */
    readonly name: string;
    /**
    * SideEffects states whether this webhook has side effects. Acceptable values are: None, NoneOnDryRun (webhooks created via v1beta1 may also specify Some or Unknown). Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission chain and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#side_effects ValidatingWebhookConfigurationV1#side_effects}
    */
    readonly sideEffects?: string;
    /**
    * TimeoutSeconds specifies the timeout for this webhook. After the timeout passes, the webhook call will be ignored or the API call will fail based on the failure policy. The timeout value must be between 1 and 30 seconds. Default to 10 seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#timeout_seconds ValidatingWebhookConfigurationV1#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * client_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#client_config ValidatingWebhookConfigurationV1#client_config}
    */
    readonly clientConfig: ValidatingWebhookConfigurationV1WebhookClientConfig;
    /**
    * namespace_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#namespace_selector ValidatingWebhookConfigurationV1#namespace_selector}
    */
    readonly namespaceSelector?: ValidatingWebhookConfigurationV1WebhookNamespaceSelector;
    /**
    * object_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#object_selector ValidatingWebhookConfigurationV1#object_selector}
    */
    readonly objectSelector?: ValidatingWebhookConfigurationV1WebhookObjectSelector;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1#rule ValidatingWebhookConfigurationV1#rule}
    */
    readonly rule?: ValidatingWebhookConfigurationV1WebhookRule[] | cdktf.IResolvable;
}
export declare function validatingWebhookConfigurationV1WebhookToTerraform(struct?: ValidatingWebhookConfigurationV1Webhook | cdktf.IResolvable): any;
export declare class ValidatingWebhookConfigurationV1WebhookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ValidatingWebhookConfigurationV1Webhook | cdktf.IResolvable | undefined;
    set internalValue(value: ValidatingWebhookConfigurationV1Webhook | cdktf.IResolvable | undefined);
    private _admissionReviewVersions?;
    get admissionReviewVersions(): string[];
    set admissionReviewVersions(value: string[]);
    resetAdmissionReviewVersions(): void;
    get admissionReviewVersionsInput(): string[] | undefined;
    private _failurePolicy?;
    get failurePolicy(): string;
    set failurePolicy(value: string);
    resetFailurePolicy(): void;
    get failurePolicyInput(): string | undefined;
    private _matchPolicy?;
    get matchPolicy(): string;
    set matchPolicy(value: string);
    resetMatchPolicy(): void;
    get matchPolicyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sideEffects?;
    get sideEffects(): string;
    set sideEffects(value: string);
    resetSideEffects(): void;
    get sideEffectsInput(): string | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _clientConfig;
    get clientConfig(): ValidatingWebhookConfigurationV1WebhookClientConfigOutputReference;
    putClientConfig(value: ValidatingWebhookConfigurationV1WebhookClientConfig): void;
    get clientConfigInput(): ValidatingWebhookConfigurationV1WebhookClientConfig | undefined;
    private _namespaceSelector;
    get namespaceSelector(): ValidatingWebhookConfigurationV1WebhookNamespaceSelectorOutputReference;
    putNamespaceSelector(value: ValidatingWebhookConfigurationV1WebhookNamespaceSelector): void;
    resetNamespaceSelector(): void;
    get namespaceSelectorInput(): ValidatingWebhookConfigurationV1WebhookNamespaceSelector | undefined;
    private _objectSelector;
    get objectSelector(): ValidatingWebhookConfigurationV1WebhookObjectSelectorOutputReference;
    putObjectSelector(value: ValidatingWebhookConfigurationV1WebhookObjectSelector): void;
    resetObjectSelector(): void;
    get objectSelectorInput(): ValidatingWebhookConfigurationV1WebhookObjectSelector | undefined;
    private _rule;
    get rule(): ValidatingWebhookConfigurationV1WebhookRuleList;
    putRule(value: ValidatingWebhookConfigurationV1WebhookRule[] | cdktf.IResolvable): void;
    resetRule(): void;
    get ruleInput(): cdktf.IResolvable | ValidatingWebhookConfigurationV1WebhookRule[] | undefined;
}
export declare class ValidatingWebhookConfigurationV1WebhookList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ValidatingWebhookConfigurationV1Webhook[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ValidatingWebhookConfigurationV1WebhookOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1 kubernetes_validating_webhook_configuration_v1}
*/
export declare class ValidatingWebhookConfigurationV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_validating_webhook_configuration_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration_v1 kubernetes_validating_webhook_configuration_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ValidatingWebhookConfigurationV1Config
    */
    constructor(scope: Construct, id: string, config: ValidatingWebhookConfigurationV1Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): ValidatingWebhookConfigurationV1MetadataOutputReference;
    putMetadata(value: ValidatingWebhookConfigurationV1Metadata): void;
    get metadataInput(): ValidatingWebhookConfigurationV1Metadata | undefined;
    private _webhook;
    get webhook(): ValidatingWebhookConfigurationV1WebhookList;
    putWebhook(value: ValidatingWebhookConfigurationV1Webhook[] | cdktf.IResolvable): void;
    get webhookInput(): cdktf.IResolvable | ValidatingWebhookConfigurationV1Webhook[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
