import { ReplicationControllerMetadata, ReplicationControllerMetadataOutputReference, ReplicationControllerSpec, ReplicationControllerSpecOutputReference, ReplicationControllerTimeouts, ReplicationControllerTimeoutsOutputReference } from './index-structs';
export * from './index-structs';
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ReplicationControllerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#id ReplicationController#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#metadata ReplicationController#metadata}
    */
    readonly metadata: ReplicationControllerMetadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#spec ReplicationController#spec}
    */
    readonly spec: ReplicationControllerSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller#timeouts ReplicationController#timeouts}
    */
    readonly timeouts?: ReplicationControllerTimeouts;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller kubernetes_replication_controller}
*/
export declare class ReplicationController extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_replication_controller";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller kubernetes_replication_controller} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ReplicationControllerConfig
    */
    constructor(scope: Construct, id: string, config: ReplicationControllerConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): ReplicationControllerMetadataOutputReference;
    putMetadata(value: ReplicationControllerMetadata): void;
    get metadataInput(): ReplicationControllerMetadata | undefined;
    private _spec;
    get spec(): ReplicationControllerSpecOutputReference;
    putSpec(value: ReplicationControllerSpec): void;
    get specInput(): ReplicationControllerSpec | undefined;
    private _timeouts;
    get timeouts(): ReplicationControllerTimeoutsOutputReference;
    putTimeouts(value: ReplicationControllerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ReplicationControllerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
