import { PodMetadata, PodMetadataOutputReference, PodSpec, PodSpecOutputReference, PodTimeouts, PodTimeoutsOutputReference } from './index-structs';
export * from './index-structs';
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PodConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#id Pod#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#metadata Pod#metadata}
    */
    readonly metadata: PodMetadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#spec Pod#spec}
    */
    readonly spec: PodSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#timeouts Pod#timeouts}
    */
    readonly timeouts?: PodTimeouts;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/pod kubernetes_pod}
*/
export declare class Pod extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_pod";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/pod kubernetes_pod} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PodConfig
    */
    constructor(scope: Construct, id: string, config: PodConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): PodMetadataOutputReference;
    putMetadata(value: PodMetadata): void;
    get metadataInput(): PodMetadata | undefined;
    private _spec;
    get spec(): PodSpecOutputReference;
    putSpec(value: PodSpec): void;
    get specInput(): PodSpec | undefined;
    private _timeouts;
    get timeouts(): PodTimeoutsOutputReference;
    putTimeouts(value: PodTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PodTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
