import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LimitRangeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range#id LimitRange#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range#metadata LimitRange#metadata}
    */
    readonly metadata: LimitRangeMetadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range#spec LimitRange#spec}
    */
    readonly spec?: LimitRangeSpec;
}
export interface LimitRangeMetadata {
    /**
    * An unstructured key value map stored with the limit range that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range#annotations LimitRange#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Prefix, used by the server, to generate a unique name ONLY IF the `name` field has not been provided. This value will also be combined with a unique suffix. Read more: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#idempotency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range#generate_name LimitRange#generate_name}
    */
    readonly generateName?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the limit range. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range#labels LimitRange#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the limit range, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range#name LimitRange#name}
    */
    readonly name?: string;
    /**
    * Namespace defines the space within which name of the limit range must be unique.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range#namespace LimitRange#namespace}
    */
    readonly namespace?: string;
}
export declare function limitRangeMetadataToTerraform(struct?: LimitRangeMetadataOutputReference | LimitRangeMetadata): any;
export declare class LimitRangeMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LimitRangeMetadata | undefined;
    set internalValue(value: LimitRangeMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _generateName?;
    get generateName(): string;
    set generateName(value: string);
    resetGenerateName(): void;
    get generateNameInput(): string | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface LimitRangeSpecLimit {
    /**
    * Default resource requirement limit value by resource name if resource limit is omitted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range#default LimitRange#default}
    */
    readonly default?: {
        [key: string]: string;
    };
    /**
    * The default resource requirement request value by resource name if resource request is omitted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range#default_request LimitRange#default_request}
    */
    readonly defaultRequest?: {
        [key: string]: string;
    };
    /**
    * Max usage constraints on this kind by resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range#max LimitRange#max}
    */
    readonly max?: {
        [key: string]: string;
    };
    /**
    * The named resource must have a request and limit that are both non-zero where limit divided by request is less than or equal to the enumerated value; this represents the max burst for the named resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range#max_limit_request_ratio LimitRange#max_limit_request_ratio}
    */
    readonly maxLimitRequestRatio?: {
        [key: string]: string;
    };
    /**
    * Min usage constraints on this kind by resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range#min LimitRange#min}
    */
    readonly min?: {
        [key: string]: string;
    };
    /**
    * Type of resource that this limit applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range#type LimitRange#type}
    */
    readonly type?: string;
}
export declare function limitRangeSpecLimitToTerraform(struct?: LimitRangeSpecLimit | cdktf.IResolvable): any;
export declare class LimitRangeSpecLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LimitRangeSpecLimit | cdktf.IResolvable | undefined;
    set internalValue(value: LimitRangeSpecLimit | cdktf.IResolvable | undefined);
    private _default?;
    get default(): {
        [key: string]: string;
    };
    set default(value: {
        [key: string]: string;
    });
    resetDefault(): void;
    get defaultInput(): {
        [key: string]: string;
    } | undefined;
    private _defaultRequest?;
    get defaultRequest(): {
        [key: string]: string;
    };
    set defaultRequest(value: {
        [key: string]: string;
    });
    resetDefaultRequest(): void;
    get defaultRequestInput(): {
        [key: string]: string;
    } | undefined;
    private _max?;
    get max(): {
        [key: string]: string;
    };
    set max(value: {
        [key: string]: string;
    });
    resetMax(): void;
    get maxInput(): {
        [key: string]: string;
    } | undefined;
    private _maxLimitRequestRatio?;
    get maxLimitRequestRatio(): {
        [key: string]: string;
    };
    set maxLimitRequestRatio(value: {
        [key: string]: string;
    });
    resetMaxLimitRequestRatio(): void;
    get maxLimitRequestRatioInput(): {
        [key: string]: string;
    } | undefined;
    private _min?;
    get min(): {
        [key: string]: string;
    };
    set min(value: {
        [key: string]: string;
    });
    resetMin(): void;
    get minInput(): {
        [key: string]: string;
    } | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class LimitRangeSpecLimitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LimitRangeSpecLimit[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LimitRangeSpecLimitOutputReference;
}
export interface LimitRangeSpec {
    /**
    * limit block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range#limit LimitRange#limit}
    */
    readonly limit?: LimitRangeSpecLimit[] | cdktf.IResolvable;
}
export declare function limitRangeSpecToTerraform(struct?: LimitRangeSpecOutputReference | LimitRangeSpec): any;
export declare class LimitRangeSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LimitRangeSpec | undefined;
    set internalValue(value: LimitRangeSpec | undefined);
    private _limit;
    get limit(): LimitRangeSpecLimitList;
    putLimit(value: LimitRangeSpecLimit[] | cdktf.IResolvable): void;
    resetLimit(): void;
    get limitInput(): cdktf.IResolvable | LimitRangeSpecLimit[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range kubernetes_limit_range}
*/
export declare class LimitRange extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_limit_range";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/limit_range kubernetes_limit_range} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LimitRangeConfig
    */
    constructor(scope: Construct, id: string, config: LimitRangeConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): LimitRangeMetadataOutputReference;
    putMetadata(value: LimitRangeMetadata): void;
    get metadataInput(): LimitRangeMetadata | undefined;
    private _spec;
    get spec(): LimitRangeSpecOutputReference;
    putSpec(value: LimitRangeSpec): void;
    resetSpec(): void;
    get specInput(): LimitRangeSpec | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
