import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HorizontalPodAutoscalerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#id HorizontalPodAutoscaler#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#metadata HorizontalPodAutoscaler#metadata}
    */
    readonly metadata: HorizontalPodAutoscalerMetadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#spec HorizontalPodAutoscaler#spec}
    */
    readonly spec: HorizontalPodAutoscalerSpec;
}
export interface HorizontalPodAutoscalerMetadata {
    /**
    * An unstructured key value map stored with the horizontal pod autoscaler that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#annotations HorizontalPodAutoscaler#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Prefix, used by the server, to generate a unique name ONLY IF the `name` field has not been provided. This value will also be combined with a unique suffix. Read more: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#idempotency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#generate_name HorizontalPodAutoscaler#generate_name}
    */
    readonly generateName?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the horizontal pod autoscaler. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#labels HorizontalPodAutoscaler#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the horizontal pod autoscaler, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#name HorizontalPodAutoscaler#name}
    */
    readonly name?: string;
    /**
    * Namespace defines the space within which name of the horizontal pod autoscaler must be unique.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#namespace HorizontalPodAutoscaler#namespace}
    */
    readonly namespace?: string;
}
export declare function horizontalPodAutoscalerMetadataToTerraform(struct?: HorizontalPodAutoscalerMetadataOutputReference | HorizontalPodAutoscalerMetadata): any;
export declare class HorizontalPodAutoscalerMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerMetadata | undefined;
    set internalValue(value: HorizontalPodAutoscalerMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _generateName?;
    get generateName(): string;
    set generateName(value: string);
    resetGenerateName(): void;
    get generateNameInput(): string | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface HorizontalPodAutoscalerSpecBehaviorScaleDownPolicy {
    /**
    * Period specifies the window of time for which the policy should hold true. PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#period_seconds HorizontalPodAutoscaler#period_seconds}
    */
    readonly periodSeconds: number;
    /**
    * Type is used to specify the scaling policy: Percent or Pods
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#type HorizontalPodAutoscaler#type}
    */
    readonly type: string;
    /**
    * Value contains the amount of change which is permitted by the policy. It must be greater than zero.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#value HorizontalPodAutoscaler#value}
    */
    readonly value: number;
}
export declare function horizontalPodAutoscalerSpecBehaviorScaleDownPolicyToTerraform(struct?: HorizontalPodAutoscalerSpecBehaviorScaleDownPolicy | cdktf.IResolvable): any;
export declare class HorizontalPodAutoscalerSpecBehaviorScaleDownPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HorizontalPodAutoscalerSpecBehaviorScaleDownPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecBehaviorScaleDownPolicy | cdktf.IResolvable | undefined);
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    get periodSecondsInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export declare class HorizontalPodAutoscalerSpecBehaviorScaleDownPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HorizontalPodAutoscalerSpecBehaviorScaleDownPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HorizontalPodAutoscalerSpecBehaviorScaleDownPolicyOutputReference;
}
export interface HorizontalPodAutoscalerSpecBehaviorScaleDown {
    /**
    * Used to specify which policy should be used. If not set, the default value Max is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#select_policy HorizontalPodAutoscaler#select_policy}
    */
    readonly selectPolicy?: string;
    /**
    * Number of seconds for which past recommendations should be considered while scaling up or scaling down. This value must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#stabilization_window_seconds HorizontalPodAutoscaler#stabilization_window_seconds}
    */
    readonly stabilizationWindowSeconds?: number;
    /**
    * policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#policy HorizontalPodAutoscaler#policy}
    */
    readonly policy: HorizontalPodAutoscalerSpecBehaviorScaleDownPolicy[] | cdktf.IResolvable;
}
export declare function horizontalPodAutoscalerSpecBehaviorScaleDownToTerraform(struct?: HorizontalPodAutoscalerSpecBehaviorScaleDown | cdktf.IResolvable): any;
export declare class HorizontalPodAutoscalerSpecBehaviorScaleDownOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HorizontalPodAutoscalerSpecBehaviorScaleDown | cdktf.IResolvable | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecBehaviorScaleDown | cdktf.IResolvable | undefined);
    private _selectPolicy?;
    get selectPolicy(): string;
    set selectPolicy(value: string);
    resetSelectPolicy(): void;
    get selectPolicyInput(): string | undefined;
    private _stabilizationWindowSeconds?;
    get stabilizationWindowSeconds(): number;
    set stabilizationWindowSeconds(value: number);
    resetStabilizationWindowSeconds(): void;
    get stabilizationWindowSecondsInput(): number | undefined;
    private _policy;
    get policy(): HorizontalPodAutoscalerSpecBehaviorScaleDownPolicyList;
    putPolicy(value: HorizontalPodAutoscalerSpecBehaviorScaleDownPolicy[] | cdktf.IResolvable): void;
    get policyInput(): cdktf.IResolvable | HorizontalPodAutoscalerSpecBehaviorScaleDownPolicy[] | undefined;
}
export declare class HorizontalPodAutoscalerSpecBehaviorScaleDownList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HorizontalPodAutoscalerSpecBehaviorScaleDown[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HorizontalPodAutoscalerSpecBehaviorScaleDownOutputReference;
}
export interface HorizontalPodAutoscalerSpecBehaviorScaleUpPolicy {
    /**
    * Period specifies the window of time for which the policy should hold true. PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#period_seconds HorizontalPodAutoscaler#period_seconds}
    */
    readonly periodSeconds: number;
    /**
    * Type is used to specify the scaling policy: Percent or Pods
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#type HorizontalPodAutoscaler#type}
    */
    readonly type: string;
    /**
    * Value contains the amount of change which is permitted by the policy. It must be greater than zero.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#value HorizontalPodAutoscaler#value}
    */
    readonly value: number;
}
export declare function horizontalPodAutoscalerSpecBehaviorScaleUpPolicyToTerraform(struct?: HorizontalPodAutoscalerSpecBehaviorScaleUpPolicy | cdktf.IResolvable): any;
export declare class HorizontalPodAutoscalerSpecBehaviorScaleUpPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HorizontalPodAutoscalerSpecBehaviorScaleUpPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecBehaviorScaleUpPolicy | cdktf.IResolvable | undefined);
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    get periodSecondsInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export declare class HorizontalPodAutoscalerSpecBehaviorScaleUpPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HorizontalPodAutoscalerSpecBehaviorScaleUpPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HorizontalPodAutoscalerSpecBehaviorScaleUpPolicyOutputReference;
}
export interface HorizontalPodAutoscalerSpecBehaviorScaleUp {
    /**
    * Used to specify which policy should be used. If not set, the default value Max is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#select_policy HorizontalPodAutoscaler#select_policy}
    */
    readonly selectPolicy?: string;
    /**
    * Number of seconds for which past recommendations should be considered while scaling up or scaling down. This value must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#stabilization_window_seconds HorizontalPodAutoscaler#stabilization_window_seconds}
    */
    readonly stabilizationWindowSeconds?: number;
    /**
    * policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#policy HorizontalPodAutoscaler#policy}
    */
    readonly policy: HorizontalPodAutoscalerSpecBehaviorScaleUpPolicy[] | cdktf.IResolvable;
}
export declare function horizontalPodAutoscalerSpecBehaviorScaleUpToTerraform(struct?: HorizontalPodAutoscalerSpecBehaviorScaleUp | cdktf.IResolvable): any;
export declare class HorizontalPodAutoscalerSpecBehaviorScaleUpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HorizontalPodAutoscalerSpecBehaviorScaleUp | cdktf.IResolvable | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecBehaviorScaleUp | cdktf.IResolvable | undefined);
    private _selectPolicy?;
    get selectPolicy(): string;
    set selectPolicy(value: string);
    resetSelectPolicy(): void;
    get selectPolicyInput(): string | undefined;
    private _stabilizationWindowSeconds?;
    get stabilizationWindowSeconds(): number;
    set stabilizationWindowSeconds(value: number);
    resetStabilizationWindowSeconds(): void;
    get stabilizationWindowSecondsInput(): number | undefined;
    private _policy;
    get policy(): HorizontalPodAutoscalerSpecBehaviorScaleUpPolicyList;
    putPolicy(value: HorizontalPodAutoscalerSpecBehaviorScaleUpPolicy[] | cdktf.IResolvable): void;
    get policyInput(): cdktf.IResolvable | HorizontalPodAutoscalerSpecBehaviorScaleUpPolicy[] | undefined;
}
export declare class HorizontalPodAutoscalerSpecBehaviorScaleUpList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HorizontalPodAutoscalerSpecBehaviorScaleUp[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HorizontalPodAutoscalerSpecBehaviorScaleUpOutputReference;
}
export interface HorizontalPodAutoscalerSpecBehavior {
    /**
    * scale_down block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#scale_down HorizontalPodAutoscaler#scale_down}
    */
    readonly scaleDown?: HorizontalPodAutoscalerSpecBehaviorScaleDown[] | cdktf.IResolvable;
    /**
    * scale_up block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#scale_up HorizontalPodAutoscaler#scale_up}
    */
    readonly scaleUp?: HorizontalPodAutoscalerSpecBehaviorScaleUp[] | cdktf.IResolvable;
}
export declare function horizontalPodAutoscalerSpecBehaviorToTerraform(struct?: HorizontalPodAutoscalerSpecBehaviorOutputReference | HorizontalPodAutoscalerSpecBehavior): any;
export declare class HorizontalPodAutoscalerSpecBehaviorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerSpecBehavior | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecBehavior | undefined);
    private _scaleDown;
    get scaleDown(): HorizontalPodAutoscalerSpecBehaviorScaleDownList;
    putScaleDown(value: HorizontalPodAutoscalerSpecBehaviorScaleDown[] | cdktf.IResolvable): void;
    resetScaleDown(): void;
    get scaleDownInput(): cdktf.IResolvable | HorizontalPodAutoscalerSpecBehaviorScaleDown[] | undefined;
    private _scaleUp;
    get scaleUp(): HorizontalPodAutoscalerSpecBehaviorScaleUpList;
    putScaleUp(value: HorizontalPodAutoscalerSpecBehaviorScaleUp[] | cdktf.IResolvable): void;
    resetScaleUp(): void;
    get scaleUpInput(): cdktf.IResolvable | HorizontalPodAutoscalerSpecBehaviorScaleUp[] | undefined;
}
export interface HorizontalPodAutoscalerSpecMetricContainerResourceTarget {
    /**
    * averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#average_utilization HorizontalPodAutoscaler#average_utilization}
    */
    readonly averageUtilization?: number;
    /**
    * averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#average_value HorizontalPodAutoscaler#average_value}
    */
    readonly averageValue?: string;
    /**
    * type represents whether the metric type is Utilization, Value, or AverageValue
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#type HorizontalPodAutoscaler#type}
    */
    readonly type: string;
    /**
    * value is the target value of the metric (as a quantity).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#value HorizontalPodAutoscaler#value}
    */
    readonly value?: string;
}
export declare function horizontalPodAutoscalerSpecMetricContainerResourceTargetToTerraform(struct?: HorizontalPodAutoscalerSpecMetricContainerResourceTargetOutputReference | HorizontalPodAutoscalerSpecMetricContainerResourceTarget): any;
export declare class HorizontalPodAutoscalerSpecMetricContainerResourceTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerSpecMetricContainerResourceTarget | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecMetricContainerResourceTarget | undefined);
    private _averageUtilization?;
    get averageUtilization(): number;
    set averageUtilization(value: number);
    resetAverageUtilization(): void;
    get averageUtilizationInput(): number | undefined;
    private _averageValue?;
    get averageValue(): string;
    set averageValue(value: string);
    resetAverageValue(): void;
    get averageValueInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export interface HorizontalPodAutoscalerSpecMetricContainerResource {
    /**
    * name of the container in the pods of the scaling target
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#container HorizontalPodAutoscaler#container}
    */
    readonly container: string;
    /**
    * name of the resource in question
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#name HorizontalPodAutoscaler#name}
    */
    readonly name: string;
    /**
    * target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#target HorizontalPodAutoscaler#target}
    */
    readonly target?: HorizontalPodAutoscalerSpecMetricContainerResourceTarget;
}
export declare function horizontalPodAutoscalerSpecMetricContainerResourceToTerraform(struct?: HorizontalPodAutoscalerSpecMetricContainerResourceOutputReference | HorizontalPodAutoscalerSpecMetricContainerResource): any;
export declare class HorizontalPodAutoscalerSpecMetricContainerResourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerSpecMetricContainerResource | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecMetricContainerResource | undefined);
    private _container?;
    get container(): string;
    set container(value: string);
    get containerInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _target;
    get target(): HorizontalPodAutoscalerSpecMetricContainerResourceTargetOutputReference;
    putTarget(value: HorizontalPodAutoscalerSpecMetricContainerResourceTarget): void;
    resetTarget(): void;
    get targetInput(): HorizontalPodAutoscalerSpecMetricContainerResourceTarget | undefined;
}
export interface HorizontalPodAutoscalerSpecMetricExternalMetricSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#key HorizontalPodAutoscaler#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#operator HorizontalPodAutoscaler#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#values HorizontalPodAutoscaler#values}
    */
    readonly values?: string[];
}
export declare function horizontalPodAutoscalerSpecMetricExternalMetricSelectorMatchExpressionsToTerraform(struct?: HorizontalPodAutoscalerSpecMetricExternalMetricSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class HorizontalPodAutoscalerSpecMetricExternalMetricSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HorizontalPodAutoscalerSpecMetricExternalMetricSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecMetricExternalMetricSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class HorizontalPodAutoscalerSpecMetricExternalMetricSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HorizontalPodAutoscalerSpecMetricExternalMetricSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HorizontalPodAutoscalerSpecMetricExternalMetricSelectorMatchExpressionsOutputReference;
}
export interface HorizontalPodAutoscalerSpecMetricExternalMetricSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#match_labels HorizontalPodAutoscaler#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#match_expressions HorizontalPodAutoscaler#match_expressions}
    */
    readonly matchExpressions?: HorizontalPodAutoscalerSpecMetricExternalMetricSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function horizontalPodAutoscalerSpecMetricExternalMetricSelectorToTerraform(struct?: HorizontalPodAutoscalerSpecMetricExternalMetricSelector | cdktf.IResolvable): any;
export declare class HorizontalPodAutoscalerSpecMetricExternalMetricSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HorizontalPodAutoscalerSpecMetricExternalMetricSelector | cdktf.IResolvable | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecMetricExternalMetricSelector | cdktf.IResolvable | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): HorizontalPodAutoscalerSpecMetricExternalMetricSelectorMatchExpressionsList;
    putMatchExpressions(value: HorizontalPodAutoscalerSpecMetricExternalMetricSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | HorizontalPodAutoscalerSpecMetricExternalMetricSelectorMatchExpressions[] | undefined;
}
export declare class HorizontalPodAutoscalerSpecMetricExternalMetricSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HorizontalPodAutoscalerSpecMetricExternalMetricSelector[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HorizontalPodAutoscalerSpecMetricExternalMetricSelectorOutputReference;
}
export interface HorizontalPodAutoscalerSpecMetricExternalMetric {
    /**
    * name is the name of the given metric
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#name HorizontalPodAutoscaler#name}
    */
    readonly name: string;
    /**
    * selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#selector HorizontalPodAutoscaler#selector}
    */
    readonly selector?: HorizontalPodAutoscalerSpecMetricExternalMetricSelector[] | cdktf.IResolvable;
}
export declare function horizontalPodAutoscalerSpecMetricExternalMetricToTerraform(struct?: HorizontalPodAutoscalerSpecMetricExternalMetricOutputReference | HorizontalPodAutoscalerSpecMetricExternalMetric): any;
export declare class HorizontalPodAutoscalerSpecMetricExternalMetricOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerSpecMetricExternalMetric | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecMetricExternalMetric | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _selector;
    get selector(): HorizontalPodAutoscalerSpecMetricExternalMetricSelectorList;
    putSelector(value: HorizontalPodAutoscalerSpecMetricExternalMetricSelector[] | cdktf.IResolvable): void;
    resetSelector(): void;
    get selectorInput(): cdktf.IResolvable | HorizontalPodAutoscalerSpecMetricExternalMetricSelector[] | undefined;
}
export interface HorizontalPodAutoscalerSpecMetricExternalTarget {
    /**
    * averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#average_utilization HorizontalPodAutoscaler#average_utilization}
    */
    readonly averageUtilization?: number;
    /**
    * averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#average_value HorizontalPodAutoscaler#average_value}
    */
    readonly averageValue?: string;
    /**
    * type represents whether the metric type is Utilization, Value, or AverageValue
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#type HorizontalPodAutoscaler#type}
    */
    readonly type: string;
    /**
    * value is the target value of the metric (as a quantity).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#value HorizontalPodAutoscaler#value}
    */
    readonly value?: string;
}
export declare function horizontalPodAutoscalerSpecMetricExternalTargetToTerraform(struct?: HorizontalPodAutoscalerSpecMetricExternalTargetOutputReference | HorizontalPodAutoscalerSpecMetricExternalTarget): any;
export declare class HorizontalPodAutoscalerSpecMetricExternalTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerSpecMetricExternalTarget | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecMetricExternalTarget | undefined);
    private _averageUtilization?;
    get averageUtilization(): number;
    set averageUtilization(value: number);
    resetAverageUtilization(): void;
    get averageUtilizationInput(): number | undefined;
    private _averageValue?;
    get averageValue(): string;
    set averageValue(value: string);
    resetAverageValue(): void;
    get averageValueInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export interface HorizontalPodAutoscalerSpecMetricExternal {
    /**
    * metric block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#metric HorizontalPodAutoscaler#metric}
    */
    readonly metric: HorizontalPodAutoscalerSpecMetricExternalMetric;
    /**
    * target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#target HorizontalPodAutoscaler#target}
    */
    readonly target?: HorizontalPodAutoscalerSpecMetricExternalTarget;
}
export declare function horizontalPodAutoscalerSpecMetricExternalToTerraform(struct?: HorizontalPodAutoscalerSpecMetricExternalOutputReference | HorizontalPodAutoscalerSpecMetricExternal): any;
export declare class HorizontalPodAutoscalerSpecMetricExternalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerSpecMetricExternal | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecMetricExternal | undefined);
    private _metric;
    get metric(): HorizontalPodAutoscalerSpecMetricExternalMetricOutputReference;
    putMetric(value: HorizontalPodAutoscalerSpecMetricExternalMetric): void;
    get metricInput(): HorizontalPodAutoscalerSpecMetricExternalMetric | undefined;
    private _target;
    get target(): HorizontalPodAutoscalerSpecMetricExternalTargetOutputReference;
    putTarget(value: HorizontalPodAutoscalerSpecMetricExternalTarget): void;
    resetTarget(): void;
    get targetInput(): HorizontalPodAutoscalerSpecMetricExternalTarget | undefined;
}
export interface HorizontalPodAutoscalerSpecMetricObjectDescribedObject {
    /**
    * API version of the referent
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#api_version HorizontalPodAutoscaler#api_version}
    */
    readonly apiVersion: string;
    /**
    * Kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#kind HorizontalPodAutoscaler#kind}
    */
    readonly kind: string;
    /**
    * Name of the referent; More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#name HorizontalPodAutoscaler#name}
    */
    readonly name: string;
}
export declare function horizontalPodAutoscalerSpecMetricObjectDescribedObjectToTerraform(struct?: HorizontalPodAutoscalerSpecMetricObjectDescribedObjectOutputReference | HorizontalPodAutoscalerSpecMetricObjectDescribedObject): any;
export declare class HorizontalPodAutoscalerSpecMetricObjectDescribedObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerSpecMetricObjectDescribedObject | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecMetricObjectDescribedObject | undefined);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    get apiVersionInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface HorizontalPodAutoscalerSpecMetricObjectMetricSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#key HorizontalPodAutoscaler#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#operator HorizontalPodAutoscaler#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#values HorizontalPodAutoscaler#values}
    */
    readonly values?: string[];
}
export declare function horizontalPodAutoscalerSpecMetricObjectMetricSelectorMatchExpressionsToTerraform(struct?: HorizontalPodAutoscalerSpecMetricObjectMetricSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class HorizontalPodAutoscalerSpecMetricObjectMetricSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HorizontalPodAutoscalerSpecMetricObjectMetricSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecMetricObjectMetricSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class HorizontalPodAutoscalerSpecMetricObjectMetricSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HorizontalPodAutoscalerSpecMetricObjectMetricSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HorizontalPodAutoscalerSpecMetricObjectMetricSelectorMatchExpressionsOutputReference;
}
export interface HorizontalPodAutoscalerSpecMetricObjectMetricSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#match_labels HorizontalPodAutoscaler#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#match_expressions HorizontalPodAutoscaler#match_expressions}
    */
    readonly matchExpressions?: HorizontalPodAutoscalerSpecMetricObjectMetricSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function horizontalPodAutoscalerSpecMetricObjectMetricSelectorToTerraform(struct?: HorizontalPodAutoscalerSpecMetricObjectMetricSelector | cdktf.IResolvable): any;
export declare class HorizontalPodAutoscalerSpecMetricObjectMetricSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HorizontalPodAutoscalerSpecMetricObjectMetricSelector | cdktf.IResolvable | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecMetricObjectMetricSelector | cdktf.IResolvable | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): HorizontalPodAutoscalerSpecMetricObjectMetricSelectorMatchExpressionsList;
    putMatchExpressions(value: HorizontalPodAutoscalerSpecMetricObjectMetricSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | HorizontalPodAutoscalerSpecMetricObjectMetricSelectorMatchExpressions[] | undefined;
}
export declare class HorizontalPodAutoscalerSpecMetricObjectMetricSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HorizontalPodAutoscalerSpecMetricObjectMetricSelector[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HorizontalPodAutoscalerSpecMetricObjectMetricSelectorOutputReference;
}
export interface HorizontalPodAutoscalerSpecMetricObjectMetric {
    /**
    * name is the name of the given metric
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#name HorizontalPodAutoscaler#name}
    */
    readonly name: string;
    /**
    * selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#selector HorizontalPodAutoscaler#selector}
    */
    readonly selector?: HorizontalPodAutoscalerSpecMetricObjectMetricSelector[] | cdktf.IResolvable;
}
export declare function horizontalPodAutoscalerSpecMetricObjectMetricToTerraform(struct?: HorizontalPodAutoscalerSpecMetricObjectMetricOutputReference | HorizontalPodAutoscalerSpecMetricObjectMetric): any;
export declare class HorizontalPodAutoscalerSpecMetricObjectMetricOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerSpecMetricObjectMetric | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecMetricObjectMetric | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _selector;
    get selector(): HorizontalPodAutoscalerSpecMetricObjectMetricSelectorList;
    putSelector(value: HorizontalPodAutoscalerSpecMetricObjectMetricSelector[] | cdktf.IResolvable): void;
    resetSelector(): void;
    get selectorInput(): cdktf.IResolvable | HorizontalPodAutoscalerSpecMetricObjectMetricSelector[] | undefined;
}
export interface HorizontalPodAutoscalerSpecMetricObjectTarget {
    /**
    * averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#average_utilization HorizontalPodAutoscaler#average_utilization}
    */
    readonly averageUtilization?: number;
    /**
    * averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#average_value HorizontalPodAutoscaler#average_value}
    */
    readonly averageValue?: string;
    /**
    * type represents whether the metric type is Utilization, Value, or AverageValue
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#type HorizontalPodAutoscaler#type}
    */
    readonly type: string;
    /**
    * value is the target value of the metric (as a quantity).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#value HorizontalPodAutoscaler#value}
    */
    readonly value?: string;
}
export declare function horizontalPodAutoscalerSpecMetricObjectTargetToTerraform(struct?: HorizontalPodAutoscalerSpecMetricObjectTargetOutputReference | HorizontalPodAutoscalerSpecMetricObjectTarget): any;
export declare class HorizontalPodAutoscalerSpecMetricObjectTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerSpecMetricObjectTarget | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecMetricObjectTarget | undefined);
    private _averageUtilization?;
    get averageUtilization(): number;
    set averageUtilization(value: number);
    resetAverageUtilization(): void;
    get averageUtilizationInput(): number | undefined;
    private _averageValue?;
    get averageValue(): string;
    set averageValue(value: string);
    resetAverageValue(): void;
    get averageValueInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export interface HorizontalPodAutoscalerSpecMetricObject {
    /**
    * described_object block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#described_object HorizontalPodAutoscaler#described_object}
    */
    readonly describedObject: HorizontalPodAutoscalerSpecMetricObjectDescribedObject;
    /**
    * metric block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#metric HorizontalPodAutoscaler#metric}
    */
    readonly metric: HorizontalPodAutoscalerSpecMetricObjectMetric;
    /**
    * target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#target HorizontalPodAutoscaler#target}
    */
    readonly target?: HorizontalPodAutoscalerSpecMetricObjectTarget;
}
export declare function horizontalPodAutoscalerSpecMetricObjectToTerraform(struct?: HorizontalPodAutoscalerSpecMetricObjectOutputReference | HorizontalPodAutoscalerSpecMetricObject): any;
export declare class HorizontalPodAutoscalerSpecMetricObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerSpecMetricObject | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecMetricObject | undefined);
    private _describedObject;
    get describedObject(): HorizontalPodAutoscalerSpecMetricObjectDescribedObjectOutputReference;
    putDescribedObject(value: HorizontalPodAutoscalerSpecMetricObjectDescribedObject): void;
    get describedObjectInput(): HorizontalPodAutoscalerSpecMetricObjectDescribedObject | undefined;
    private _metric;
    get metric(): HorizontalPodAutoscalerSpecMetricObjectMetricOutputReference;
    putMetric(value: HorizontalPodAutoscalerSpecMetricObjectMetric): void;
    get metricInput(): HorizontalPodAutoscalerSpecMetricObjectMetric | undefined;
    private _target;
    get target(): HorizontalPodAutoscalerSpecMetricObjectTargetOutputReference;
    putTarget(value: HorizontalPodAutoscalerSpecMetricObjectTarget): void;
    resetTarget(): void;
    get targetInput(): HorizontalPodAutoscalerSpecMetricObjectTarget | undefined;
}
export interface HorizontalPodAutoscalerSpecMetricPodsMetricSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#key HorizontalPodAutoscaler#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#operator HorizontalPodAutoscaler#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#values HorizontalPodAutoscaler#values}
    */
    readonly values?: string[];
}
export declare function horizontalPodAutoscalerSpecMetricPodsMetricSelectorMatchExpressionsToTerraform(struct?: HorizontalPodAutoscalerSpecMetricPodsMetricSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class HorizontalPodAutoscalerSpecMetricPodsMetricSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HorizontalPodAutoscalerSpecMetricPodsMetricSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecMetricPodsMetricSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class HorizontalPodAutoscalerSpecMetricPodsMetricSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HorizontalPodAutoscalerSpecMetricPodsMetricSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HorizontalPodAutoscalerSpecMetricPodsMetricSelectorMatchExpressionsOutputReference;
}
export interface HorizontalPodAutoscalerSpecMetricPodsMetricSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#match_labels HorizontalPodAutoscaler#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#match_expressions HorizontalPodAutoscaler#match_expressions}
    */
    readonly matchExpressions?: HorizontalPodAutoscalerSpecMetricPodsMetricSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function horizontalPodAutoscalerSpecMetricPodsMetricSelectorToTerraform(struct?: HorizontalPodAutoscalerSpecMetricPodsMetricSelector | cdktf.IResolvable): any;
export declare class HorizontalPodAutoscalerSpecMetricPodsMetricSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HorizontalPodAutoscalerSpecMetricPodsMetricSelector | cdktf.IResolvable | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecMetricPodsMetricSelector | cdktf.IResolvable | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): HorizontalPodAutoscalerSpecMetricPodsMetricSelectorMatchExpressionsList;
    putMatchExpressions(value: HorizontalPodAutoscalerSpecMetricPodsMetricSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | HorizontalPodAutoscalerSpecMetricPodsMetricSelectorMatchExpressions[] | undefined;
}
export declare class HorizontalPodAutoscalerSpecMetricPodsMetricSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HorizontalPodAutoscalerSpecMetricPodsMetricSelector[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HorizontalPodAutoscalerSpecMetricPodsMetricSelectorOutputReference;
}
export interface HorizontalPodAutoscalerSpecMetricPodsMetric {
    /**
    * name is the name of the given metric
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#name HorizontalPodAutoscaler#name}
    */
    readonly name: string;
    /**
    * selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#selector HorizontalPodAutoscaler#selector}
    */
    readonly selector?: HorizontalPodAutoscalerSpecMetricPodsMetricSelector[] | cdktf.IResolvable;
}
export declare function horizontalPodAutoscalerSpecMetricPodsMetricToTerraform(struct?: HorizontalPodAutoscalerSpecMetricPodsMetricOutputReference | HorizontalPodAutoscalerSpecMetricPodsMetric): any;
export declare class HorizontalPodAutoscalerSpecMetricPodsMetricOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerSpecMetricPodsMetric | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecMetricPodsMetric | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _selector;
    get selector(): HorizontalPodAutoscalerSpecMetricPodsMetricSelectorList;
    putSelector(value: HorizontalPodAutoscalerSpecMetricPodsMetricSelector[] | cdktf.IResolvable): void;
    resetSelector(): void;
    get selectorInput(): cdktf.IResolvable | HorizontalPodAutoscalerSpecMetricPodsMetricSelector[] | undefined;
}
export interface HorizontalPodAutoscalerSpecMetricPodsTarget {
    /**
    * averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#average_utilization HorizontalPodAutoscaler#average_utilization}
    */
    readonly averageUtilization?: number;
    /**
    * averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#average_value HorizontalPodAutoscaler#average_value}
    */
    readonly averageValue?: string;
    /**
    * type represents whether the metric type is Utilization, Value, or AverageValue
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#type HorizontalPodAutoscaler#type}
    */
    readonly type: string;
    /**
    * value is the target value of the metric (as a quantity).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#value HorizontalPodAutoscaler#value}
    */
    readonly value?: string;
}
export declare function horizontalPodAutoscalerSpecMetricPodsTargetToTerraform(struct?: HorizontalPodAutoscalerSpecMetricPodsTargetOutputReference | HorizontalPodAutoscalerSpecMetricPodsTarget): any;
export declare class HorizontalPodAutoscalerSpecMetricPodsTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerSpecMetricPodsTarget | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecMetricPodsTarget | undefined);
    private _averageUtilization?;
    get averageUtilization(): number;
    set averageUtilization(value: number);
    resetAverageUtilization(): void;
    get averageUtilizationInput(): number | undefined;
    private _averageValue?;
    get averageValue(): string;
    set averageValue(value: string);
    resetAverageValue(): void;
    get averageValueInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export interface HorizontalPodAutoscalerSpecMetricPods {
    /**
    * metric block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#metric HorizontalPodAutoscaler#metric}
    */
    readonly metric: HorizontalPodAutoscalerSpecMetricPodsMetric;
    /**
    * target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#target HorizontalPodAutoscaler#target}
    */
    readonly target?: HorizontalPodAutoscalerSpecMetricPodsTarget;
}
export declare function horizontalPodAutoscalerSpecMetricPodsToTerraform(struct?: HorizontalPodAutoscalerSpecMetricPodsOutputReference | HorizontalPodAutoscalerSpecMetricPods): any;
export declare class HorizontalPodAutoscalerSpecMetricPodsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerSpecMetricPods | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecMetricPods | undefined);
    private _metric;
    get metric(): HorizontalPodAutoscalerSpecMetricPodsMetricOutputReference;
    putMetric(value: HorizontalPodAutoscalerSpecMetricPodsMetric): void;
    get metricInput(): HorizontalPodAutoscalerSpecMetricPodsMetric | undefined;
    private _target;
    get target(): HorizontalPodAutoscalerSpecMetricPodsTargetOutputReference;
    putTarget(value: HorizontalPodAutoscalerSpecMetricPodsTarget): void;
    resetTarget(): void;
    get targetInput(): HorizontalPodAutoscalerSpecMetricPodsTarget | undefined;
}
export interface HorizontalPodAutoscalerSpecMetricResourceTarget {
    /**
    * averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#average_utilization HorizontalPodAutoscaler#average_utilization}
    */
    readonly averageUtilization?: number;
    /**
    * averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#average_value HorizontalPodAutoscaler#average_value}
    */
    readonly averageValue?: string;
    /**
    * type represents whether the metric type is Utilization, Value, or AverageValue
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#type HorizontalPodAutoscaler#type}
    */
    readonly type: string;
    /**
    * value is the target value of the metric (as a quantity).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#value HorizontalPodAutoscaler#value}
    */
    readonly value?: string;
}
export declare function horizontalPodAutoscalerSpecMetricResourceTargetToTerraform(struct?: HorizontalPodAutoscalerSpecMetricResourceTargetOutputReference | HorizontalPodAutoscalerSpecMetricResourceTarget): any;
export declare class HorizontalPodAutoscalerSpecMetricResourceTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerSpecMetricResourceTarget | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecMetricResourceTarget | undefined);
    private _averageUtilization?;
    get averageUtilization(): number;
    set averageUtilization(value: number);
    resetAverageUtilization(): void;
    get averageUtilizationInput(): number | undefined;
    private _averageValue?;
    get averageValue(): string;
    set averageValue(value: string);
    resetAverageValue(): void;
    get averageValueInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export interface HorizontalPodAutoscalerSpecMetricResource {
    /**
    * name is the name of the resource in question.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#name HorizontalPodAutoscaler#name}
    */
    readonly name: string;
    /**
    * target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#target HorizontalPodAutoscaler#target}
    */
    readonly target?: HorizontalPodAutoscalerSpecMetricResourceTarget;
}
export declare function horizontalPodAutoscalerSpecMetricResourceToTerraform(struct?: HorizontalPodAutoscalerSpecMetricResourceOutputReference | HorizontalPodAutoscalerSpecMetricResource): any;
export declare class HorizontalPodAutoscalerSpecMetricResourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerSpecMetricResource | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecMetricResource | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _target;
    get target(): HorizontalPodAutoscalerSpecMetricResourceTargetOutputReference;
    putTarget(value: HorizontalPodAutoscalerSpecMetricResourceTarget): void;
    resetTarget(): void;
    get targetInput(): HorizontalPodAutoscalerSpecMetricResourceTarget | undefined;
}
export interface HorizontalPodAutoscalerSpecMetric {
    /**
    * type is the type of metric source. It should be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each mapping to a matching field in the object. Note: "ContainerResource" type is available on when the feature-gate HPAContainerMetrics is enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#type HorizontalPodAutoscaler#type}
    */
    readonly type: string;
    /**
    * container_resource block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#container_resource HorizontalPodAutoscaler#container_resource}
    */
    readonly containerResource?: HorizontalPodAutoscalerSpecMetricContainerResource;
    /**
    * external block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#external HorizontalPodAutoscaler#external}
    */
    readonly external?: HorizontalPodAutoscalerSpecMetricExternal;
    /**
    * object block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#object HorizontalPodAutoscaler#object}
    */
    readonly object?: HorizontalPodAutoscalerSpecMetricObject;
    /**
    * pods block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#pods HorizontalPodAutoscaler#pods}
    */
    readonly pods?: HorizontalPodAutoscalerSpecMetricPods;
    /**
    * resource block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#resource HorizontalPodAutoscaler#resource}
    */
    readonly resource?: HorizontalPodAutoscalerSpecMetricResource;
}
export declare function horizontalPodAutoscalerSpecMetricToTerraform(struct?: HorizontalPodAutoscalerSpecMetric | cdktf.IResolvable): any;
export declare class HorizontalPodAutoscalerSpecMetricOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HorizontalPodAutoscalerSpecMetric | cdktf.IResolvable | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecMetric | cdktf.IResolvable | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _containerResource;
    get containerResource(): HorizontalPodAutoscalerSpecMetricContainerResourceOutputReference;
    putContainerResource(value: HorizontalPodAutoscalerSpecMetricContainerResource): void;
    resetContainerResource(): void;
    get containerResourceInput(): HorizontalPodAutoscalerSpecMetricContainerResource | undefined;
    private _external;
    get external(): HorizontalPodAutoscalerSpecMetricExternalOutputReference;
    putExternal(value: HorizontalPodAutoscalerSpecMetricExternal): void;
    resetExternal(): void;
    get externalInput(): HorizontalPodAutoscalerSpecMetricExternal | undefined;
    private _object;
    get object(): HorizontalPodAutoscalerSpecMetricObjectOutputReference;
    putObject(value: HorizontalPodAutoscalerSpecMetricObject): void;
    resetObject(): void;
    get objectInput(): HorizontalPodAutoscalerSpecMetricObject | undefined;
    private _pods;
    get pods(): HorizontalPodAutoscalerSpecMetricPodsOutputReference;
    putPods(value: HorizontalPodAutoscalerSpecMetricPods): void;
    resetPods(): void;
    get podsInput(): HorizontalPodAutoscalerSpecMetricPods | undefined;
    private _resource;
    get resource(): HorizontalPodAutoscalerSpecMetricResourceOutputReference;
    putResource(value: HorizontalPodAutoscalerSpecMetricResource): void;
    resetResource(): void;
    get resourceInput(): HorizontalPodAutoscalerSpecMetricResource | undefined;
}
export declare class HorizontalPodAutoscalerSpecMetricList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HorizontalPodAutoscalerSpecMetric[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HorizontalPodAutoscalerSpecMetricOutputReference;
}
export interface HorizontalPodAutoscalerSpecScaleTargetRef {
    /**
    * API version of the referent
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#api_version HorizontalPodAutoscaler#api_version}
    */
    readonly apiVersion?: string;
    /**
    * Kind of the referent. e.g. `ReplicationController`. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#kind HorizontalPodAutoscaler#kind}
    */
    readonly kind: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#name HorizontalPodAutoscaler#name}
    */
    readonly name: string;
}
export declare function horizontalPodAutoscalerSpecScaleTargetRefToTerraform(struct?: HorizontalPodAutoscalerSpecScaleTargetRefOutputReference | HorizontalPodAutoscalerSpecScaleTargetRef): any;
export declare class HorizontalPodAutoscalerSpecScaleTargetRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerSpecScaleTargetRef | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpecScaleTargetRef | undefined);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    resetApiVersion(): void;
    get apiVersionInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface HorizontalPodAutoscalerSpec {
    /**
    * Upper limit for the number of pods that can be set by the autoscaler.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#max_replicas HorizontalPodAutoscaler#max_replicas}
    */
    readonly maxReplicas: number;
    /**
    * Lower limit for the number of pods that can be set by the autoscaler, defaults to `1`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#min_replicas HorizontalPodAutoscaler#min_replicas}
    */
    readonly minReplicas?: number;
    /**
    * Target average CPU utilization (represented as a percentage of requested CPU) over all the pods. If not specified the default autoscaling policy will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#target_cpu_utilization_percentage HorizontalPodAutoscaler#target_cpu_utilization_percentage}
    */
    readonly targetCpuUtilizationPercentage?: number;
    /**
    * behavior block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#behavior HorizontalPodAutoscaler#behavior}
    */
    readonly behavior?: HorizontalPodAutoscalerSpecBehavior;
    /**
    * metric block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#metric HorizontalPodAutoscaler#metric}
    */
    readonly metric?: HorizontalPodAutoscalerSpecMetric[] | cdktf.IResolvable;
    /**
    * scale_target_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler#scale_target_ref HorizontalPodAutoscaler#scale_target_ref}
    */
    readonly scaleTargetRef: HorizontalPodAutoscalerSpecScaleTargetRef;
}
export declare function horizontalPodAutoscalerSpecToTerraform(struct?: HorizontalPodAutoscalerSpecOutputReference | HorizontalPodAutoscalerSpec): any;
export declare class HorizontalPodAutoscalerSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerSpec | undefined;
    set internalValue(value: HorizontalPodAutoscalerSpec | undefined);
    private _maxReplicas?;
    get maxReplicas(): number;
    set maxReplicas(value: number);
    get maxReplicasInput(): number | undefined;
    private _minReplicas?;
    get minReplicas(): number;
    set minReplicas(value: number);
    resetMinReplicas(): void;
    get minReplicasInput(): number | undefined;
    private _targetCpuUtilizationPercentage?;
    get targetCpuUtilizationPercentage(): number;
    set targetCpuUtilizationPercentage(value: number);
    resetTargetCpuUtilizationPercentage(): void;
    get targetCpuUtilizationPercentageInput(): number | undefined;
    private _behavior;
    get behavior(): HorizontalPodAutoscalerSpecBehaviorOutputReference;
    putBehavior(value: HorizontalPodAutoscalerSpecBehavior): void;
    resetBehavior(): void;
    get behaviorInput(): HorizontalPodAutoscalerSpecBehavior | undefined;
    private _metric;
    get metric(): HorizontalPodAutoscalerSpecMetricList;
    putMetric(value: HorizontalPodAutoscalerSpecMetric[] | cdktf.IResolvable): void;
    resetMetric(): void;
    get metricInput(): cdktf.IResolvable | HorizontalPodAutoscalerSpecMetric[] | undefined;
    private _scaleTargetRef;
    get scaleTargetRef(): HorizontalPodAutoscalerSpecScaleTargetRefOutputReference;
    putScaleTargetRef(value: HorizontalPodAutoscalerSpecScaleTargetRef): void;
    get scaleTargetRefInput(): HorizontalPodAutoscalerSpecScaleTargetRef | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler kubernetes_horizontal_pod_autoscaler}
*/
export declare class HorizontalPodAutoscaler extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_horizontal_pod_autoscaler";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler kubernetes_horizontal_pod_autoscaler} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HorizontalPodAutoscalerConfig
    */
    constructor(scope: Construct, id: string, config: HorizontalPodAutoscalerConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): HorizontalPodAutoscalerMetadataOutputReference;
    putMetadata(value: HorizontalPodAutoscalerMetadata): void;
    get metadataInput(): HorizontalPodAutoscalerMetadata | undefined;
    private _spec;
    get spec(): HorizontalPodAutoscalerSpecOutputReference;
    putSpec(value: HorizontalPodAutoscalerSpec): void;
    get specInput(): HorizontalPodAutoscalerSpec | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
