import { DataKubernetesPodSpecList, DataKubernetesPodMetadata, DataKubernetesPodMetadataOutputReference } from './index-structs';
export * from './index-structs';
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataKubernetesPodConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/pod#id DataKubernetesPod#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/pod#metadata DataKubernetesPod#metadata}
    */
    readonly metadata: DataKubernetesPodMetadata;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/d/pod kubernetes_pod}
*/
export declare class DataKubernetesPod extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "kubernetes_pod";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/d/pod kubernetes_pod} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataKubernetesPodConfig
    */
    constructor(scope: Construct, id: string, config: DataKubernetesPodConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _spec;
    get spec(): DataKubernetesPodSpecList;
    get status(): string;
    private _metadata;
    get metadata(): DataKubernetesPodMetadataOutputReference;
    putMetadata(value: DataKubernetesPodMetadata): void;
    get metadataInput(): DataKubernetesPodMetadata | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
