import { DataKubernetesPodV1SpecList, DataKubernetesPodV1Metadata, DataKubernetesPodV1MetadataOutputReference } from './index-structs';
export * from './index-structs';
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataKubernetesPodV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/pod_v1#id DataKubernetesPodV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/pod_v1#metadata DataKubernetesPodV1#metadata}
    */
    readonly metadata: DataKubernetesPodV1Metadata;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/d/pod_v1 kubernetes_pod_v1}
*/
export declare class DataKubernetesPodV1 extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "kubernetes_pod_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/d/pod_v1 kubernetes_pod_v1} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataKubernetesPodV1Config
    */
    constructor(scope: Construct, id: string, config: DataKubernetesPodV1Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _spec;
    get spec(): DataKubernetesPodV1SpecList;
    get status(): string;
    private _metadata;
    get metadata(): DataKubernetesPodV1MetadataOutputReference;
    putMetadata(value: DataKubernetesPodV1Metadata): void;
    get metadataInput(): DataKubernetesPodV1Metadata | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
