import * as cdktf from 'cdktf';
export interface DaemonsetMetadata {
    /**
    * An unstructured key value map stored with the daemonset that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#annotations Daemonset#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Prefix, used by the server, to generate a unique name ONLY IF the `name` field has not been provided. This value will also be combined with a unique suffix. Read more: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#idempotency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#generate_name Daemonset#generate_name}
    */
    readonly generateName?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the daemonset. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#labels Daemonset#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the daemonset, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * Namespace defines the space within which name of the daemonset must be unique.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#namespace Daemonset#namespace}
    */
    readonly namespace?: string;
}
export declare function daemonsetMetadataToTerraform(struct?: DaemonsetMetadataOutputReference | DaemonsetMetadata): any;
export declare class DaemonsetMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetMetadata | undefined;
    set internalValue(value: DaemonsetMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _generateName?;
    get generateName(): string;
    set generateName(value: string);
    resetGenerateName(): void;
    get generateNameInput(): string | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface DaemonsetSpecSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#key Daemonset#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#operator Daemonset#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#values Daemonset#values}
    */
    readonly values?: string[];
}
export declare function daemonsetSpecSelectorMatchExpressionsToTerraform(struct?: DaemonsetSpecSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class DaemonsetSpecSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class DaemonsetSpecSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecSelectorMatchExpressionsOutputReference;
}
export interface DaemonsetSpecSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#match_labels Daemonset#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#match_expressions Daemonset#match_expressions}
    */
    readonly matchExpressions?: DaemonsetSpecSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function daemonsetSpecSelectorToTerraform(struct?: DaemonsetSpecSelectorOutputReference | DaemonsetSpecSelector): any;
export declare class DaemonsetSpecSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecSelector | undefined;
    set internalValue(value: DaemonsetSpecSelector | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): DaemonsetSpecSelectorMatchExpressionsList;
    putMatchExpressions(value: DaemonsetSpecSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | DaemonsetSpecSelectorMatchExpressions[] | undefined;
}
export interface DaemonsetSpecStrategyRollingUpdate {
    /**
    * The maximum number of DaemonSet pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total number of DaemonSet pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up. This cannot be 0. Default value is 1. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their pods stopped for an update at any given time. The update starts by stopping at most 30% of those DaemonSet pods and then brings up new DaemonSet pods in their place. Once the new pods are available, it then proceeds onto other DaemonSet pods, thus ensuring that at least 70% of original number of DaemonSet pods are available at all times during the update.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#max_unavailable Daemonset#max_unavailable}
    */
    readonly maxUnavailable?: string;
}
export declare function daemonsetSpecStrategyRollingUpdateToTerraform(struct?: DaemonsetSpecStrategyRollingUpdateOutputReference | DaemonsetSpecStrategyRollingUpdate): any;
export declare class DaemonsetSpecStrategyRollingUpdateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecStrategyRollingUpdate | undefined;
    set internalValue(value: DaemonsetSpecStrategyRollingUpdate | undefined);
    private _maxUnavailable?;
    get maxUnavailable(): string;
    set maxUnavailable(value: string);
    resetMaxUnavailable(): void;
    get maxUnavailableInput(): string | undefined;
}
export interface DaemonsetSpecStrategy {
    /**
    * Type of deployment. Can be 'RollingUpdate' or 'OnDelete'. Default is RollingUpdate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#type Daemonset#type}
    */
    readonly type?: string;
    /**
    * rolling_update block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#rolling_update Daemonset#rolling_update}
    */
    readonly rollingUpdate?: DaemonsetSpecStrategyRollingUpdate;
}
export declare function daemonsetSpecStrategyToTerraform(struct?: DaemonsetSpecStrategyOutputReference | DaemonsetSpecStrategy): any;
export declare class DaemonsetSpecStrategyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecStrategy | undefined;
    set internalValue(value: DaemonsetSpecStrategy | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _rollingUpdate;
    get rollingUpdate(): DaemonsetSpecStrategyRollingUpdateOutputReference;
    putRollingUpdate(value: DaemonsetSpecStrategyRollingUpdate): void;
    resetRollingUpdate(): void;
    get rollingUpdateInput(): DaemonsetSpecStrategyRollingUpdate | undefined;
}
export interface DaemonsetSpecTemplateMetadata {
    /**
    * An unstructured key value map stored with the daemon set that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#annotations Daemonset#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Prefix, used by the server, to generate a unique name ONLY IF the `name` field has not been provided. This value will also be combined with a unique suffix. Read more: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#idempotency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#generate_name Daemonset#generate_name}
    */
    readonly generateName?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the daemon set. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#labels Daemonset#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the daemon set, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
}
export declare function daemonsetSpecTemplateMetadataToTerraform(struct?: DaemonsetSpecTemplateMetadataOutputReference | DaemonsetSpecTemplateMetadata): any;
export declare class DaemonsetSpecTemplateMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateMetadata | undefined;
    set internalValue(value: DaemonsetSpecTemplateMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _generateName?;
    get generateName(): string;
    set generateName(value: string);
    resetGenerateName(): void;
    get generateNameInput(): string | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#key Daemonset#key}
    */
    readonly key?: string;
    /**
    * Operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#operator Daemonset#operator}
    */
    readonly operator?: string;
    /**
    * Values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#values Daemonset#values}
    */
    readonly values?: string[];
}
export declare function daemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressionsToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressionsOutputReference;
}
export interface DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference {
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#match_expressions Daemonset#match_expressions}
    */
    readonly matchExpressions?: DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceOutputReference | DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference): any;
export declare class DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference | undefined);
    private _matchExpressions;
    get matchExpressions(): DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressionsList;
    putMatchExpressions(value: DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions[] | undefined;
}
export interface DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
    * weight is in the range 1-100
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#weight Daemonset#weight}
    */
    readonly weight: number;
    /**
    * preference block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#preference Daemonset#preference}
    */
    readonly preference: DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference;
}
export declare function daemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined);
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    private _preference;
    get preference(): DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceOutputReference;
    putPreference(value: DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference): void;
    get preferenceInput(): DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference | undefined;
}
export declare class DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionOutputReference;
}
export interface DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#key Daemonset#key}
    */
    readonly key?: string;
    /**
    * Operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#operator Daemonset#operator}
    */
    readonly operator?: string;
    /**
    * Values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#values Daemonset#values}
    */
    readonly values?: string[];
}
export declare function daemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressionsToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressionsOutputReference;
}
export interface DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm {
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#match_expressions Daemonset#match_expressions}
    */
    readonly matchExpressions?: DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm | cdktf.IResolvable | undefined);
    private _matchExpressions;
    get matchExpressions(): DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressionsList;
    putMatchExpressions(value: DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermOutputReference;
}
export interface DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
    * node_selector_term block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#node_selector_term Daemonset#node_selector_term}
    */
    readonly nodeSelectorTerm?: DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionOutputReference | DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution): any;
export declare class DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined);
    private _nodeSelectorTerm;
    get nodeSelectorTerm(): DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermList;
    putNodeSelectorTerm(value: DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm[] | cdktf.IResolvable): void;
    resetNodeSelectorTerm(): void;
    get nodeSelectorTermInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm[] | undefined;
}
export interface DaemonsetSpecTemplateSpecAffinityNodeAffinity {
    /**
    * preferred_during_scheduling_ignored_during_execution block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#preferred_during_scheduling_ignored_during_execution Daemonset#preferred_during_scheduling_ignored_during_execution}
    */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * required_during_scheduling_ignored_during_execution block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#required_during_scheduling_ignored_during_execution Daemonset#required_during_scheduling_ignored_during_execution}
    */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution;
}
export declare function daemonsetSpecTemplateSpecAffinityNodeAffinityToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityNodeAffinityOutputReference | DaemonsetSpecTemplateSpecAffinityNodeAffinity): any;
export declare class DaemonsetSpecTemplateSpecAffinityNodeAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecAffinityNodeAffinity | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinityNodeAffinity | undefined);
    private _preferredDuringSchedulingIgnoredDuringExecution;
    get preferredDuringSchedulingIgnoredDuringExecution(): DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionList;
    putPreferredDuringSchedulingIgnoredDuringExecution(value: DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable): void;
    resetPreferredDuringSchedulingIgnoredDuringExecution(): void;
    get preferredDuringSchedulingIgnoredDuringExecutionInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | undefined;
    private _requiredDuringSchedulingIgnoredDuringExecution;
    get requiredDuringSchedulingIgnoredDuringExecution(): DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionOutputReference;
    putRequiredDuringSchedulingIgnoredDuringExecution(value: DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution): void;
    resetRequiredDuringSchedulingIgnoredDuringExecution(): void;
    get requiredDuringSchedulingIgnoredDuringExecutionInput(): DaemonsetSpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined;
}
export interface DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#key Daemonset#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#operator Daemonset#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#values Daemonset#values}
    */
    readonly values?: string[];
}
export declare function daemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsOutputReference;
}
export interface DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#match_labels Daemonset#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#match_expressions Daemonset#match_expressions}
    */
    readonly matchExpressions?: DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | cdktf.IResolvable | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsList;
    putMatchExpressions(value: DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorOutputReference;
}
export interface DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
    * namespaces specifies which namespaces the labelSelector applies to (matches against); null or empty list means 'this pod's namespace'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#namespaces Daemonset#namespaces}
    */
    readonly namespaces?: string[];
    /**
    * empty topology key is interpreted by the scheduler as 'all topologies'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#topology_key Daemonset#topology_key}
    */
    readonly topologyKey: string;
    /**
    * label_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#label_selector Daemonset#label_selector}
    */
    readonly labelSelector?: DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermOutputReference | DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm): any;
export declare class DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined);
    private _namespaces?;
    get namespaces(): string[];
    set namespaces(value: string[]);
    resetNamespaces(): void;
    get namespacesInput(): string[] | undefined;
    private _topologyKey?;
    get topologyKey(): string;
    set topologyKey(value: string);
    get topologyKeyInput(): string | undefined;
    private _labelSelector;
    get labelSelector(): DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorList;
    putLabelSelector(value: DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | cdktf.IResolvable): void;
    resetLabelSelector(): void;
    get labelSelectorInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | undefined;
}
export interface DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
    * weight associated with matching the corresponding podAffinityTerm, in the range 1-100
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#weight Daemonset#weight}
    */
    readonly weight: number;
    /**
    * pod_affinity_term block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#pod_affinity_term Daemonset#pod_affinity_term}
    */
    readonly podAffinityTerm: DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
}
export declare function daemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined);
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    private _podAffinityTerm;
    get podAffinityTerm(): DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermOutputReference;
    putPodAffinityTerm(value: DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm): void;
    get podAffinityTermInput(): DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined;
}
export declare class DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionOutputReference;
}
export interface DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#key Daemonset#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#operator Daemonset#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#values Daemonset#values}
    */
    readonly values?: string[];
}
export declare function daemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsOutputReference;
}
export interface DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#match_labels Daemonset#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#match_expressions Daemonset#match_expressions}
    */
    readonly matchExpressions?: DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | cdktf.IResolvable | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsList;
    putMatchExpressions(value: DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorOutputReference;
}
export interface DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
    * namespaces specifies which namespaces the labelSelector applies to (matches against); null or empty list means 'this pod's namespace'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#namespaces Daemonset#namespaces}
    */
    readonly namespaces?: string[];
    /**
    * empty topology key is interpreted by the scheduler as 'all topologies'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#topology_key Daemonset#topology_key}
    */
    readonly topologyKey: string;
    /**
    * label_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#label_selector Daemonset#label_selector}
    */
    readonly labelSelector?: DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined);
    private _namespaces?;
    get namespaces(): string[];
    set namespaces(value: string[]);
    resetNamespaces(): void;
    get namespacesInput(): string[] | undefined;
    private _topologyKey?;
    get topologyKey(): string;
    set topologyKey(value: string);
    get topologyKeyInput(): string | undefined;
    private _labelSelector;
    get labelSelector(): DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorList;
    putLabelSelector(value: DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | cdktf.IResolvable): void;
    resetLabelSelector(): void;
    get labelSelectorInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionOutputReference;
}
export interface DaemonsetSpecTemplateSpecAffinityPodAffinity {
    /**
    * preferred_during_scheduling_ignored_during_execution block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#preferred_during_scheduling_ignored_during_execution Daemonset#preferred_during_scheduling_ignored_during_execution}
    */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * required_during_scheduling_ignored_during_execution block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#required_during_scheduling_ignored_during_execution Daemonset#required_during_scheduling_ignored_during_execution}
    */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecAffinityPodAffinityToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityPodAffinityOutputReference | DaemonsetSpecTemplateSpecAffinityPodAffinity): any;
export declare class DaemonsetSpecTemplateSpecAffinityPodAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecAffinityPodAffinity | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinityPodAffinity | undefined);
    private _preferredDuringSchedulingIgnoredDuringExecution;
    get preferredDuringSchedulingIgnoredDuringExecution(): DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionList;
    putPreferredDuringSchedulingIgnoredDuringExecution(value: DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable): void;
    resetPreferredDuringSchedulingIgnoredDuringExecution(): void;
    get preferredDuringSchedulingIgnoredDuringExecutionInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | undefined;
    private _requiredDuringSchedulingIgnoredDuringExecution;
    get requiredDuringSchedulingIgnoredDuringExecution(): DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionList;
    putRequiredDuringSchedulingIgnoredDuringExecution(value: DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable): void;
    resetRequiredDuringSchedulingIgnoredDuringExecution(): void;
    get requiredDuringSchedulingIgnoredDuringExecutionInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | undefined;
}
export interface DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#key Daemonset#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#operator Daemonset#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#values Daemonset#values}
    */
    readonly values?: string[];
}
export declare function daemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsOutputReference;
}
export interface DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#match_labels Daemonset#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#match_expressions Daemonset#match_expressions}
    */
    readonly matchExpressions?: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | cdktf.IResolvable | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsList;
    putMatchExpressions(value: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorOutputReference;
}
export interface DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
    * namespaces specifies which namespaces the labelSelector applies to (matches against); null or empty list means 'this pod's namespace'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#namespaces Daemonset#namespaces}
    */
    readonly namespaces?: string[];
    /**
    * empty topology key is interpreted by the scheduler as 'all topologies'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#topology_key Daemonset#topology_key}
    */
    readonly topologyKey: string;
    /**
    * label_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#label_selector Daemonset#label_selector}
    */
    readonly labelSelector?: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermOutputReference | DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm): any;
export declare class DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined);
    private _namespaces?;
    get namespaces(): string[];
    set namespaces(value: string[]);
    resetNamespaces(): void;
    get namespacesInput(): string[] | undefined;
    private _topologyKey?;
    get topologyKey(): string;
    set topologyKey(value: string);
    get topologyKeyInput(): string | undefined;
    private _labelSelector;
    get labelSelector(): DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorList;
    putLabelSelector(value: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | cdktf.IResolvable): void;
    resetLabelSelector(): void;
    get labelSelectorInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | undefined;
}
export interface DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
    * weight associated with matching the corresponding podAffinityTerm, in the range 1-100
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#weight Daemonset#weight}
    */
    readonly weight: number;
    /**
    * pod_affinity_term block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#pod_affinity_term Daemonset#pod_affinity_term}
    */
    readonly podAffinityTerm: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
}
export declare function daemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined);
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    private _podAffinityTerm;
    get podAffinityTerm(): DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermOutputReference;
    putPodAffinityTerm(value: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm): void;
    get podAffinityTermInput(): DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined;
}
export declare class DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionOutputReference;
}
export interface DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#key Daemonset#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#operator Daemonset#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#values Daemonset#values}
    */
    readonly values?: string[];
}
export declare function daemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsOutputReference;
}
export interface DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#match_labels Daemonset#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#match_expressions Daemonset#match_expressions}
    */
    readonly matchExpressions?: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | cdktf.IResolvable | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsList;
    putMatchExpressions(value: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorOutputReference;
}
export interface DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
    * namespaces specifies which namespaces the labelSelector applies to (matches against); null or empty list means 'this pod's namespace'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#namespaces Daemonset#namespaces}
    */
    readonly namespaces?: string[];
    /**
    * empty topology key is interpreted by the scheduler as 'all topologies'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#topology_key Daemonset#topology_key}
    */
    readonly topologyKey: string;
    /**
    * label_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#label_selector Daemonset#label_selector}
    */
    readonly labelSelector?: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined);
    private _namespaces?;
    get namespaces(): string[];
    set namespaces(value: string[]);
    resetNamespaces(): void;
    get namespacesInput(): string[] | undefined;
    private _topologyKey?;
    get topologyKey(): string;
    set topologyKey(value: string);
    get topologyKeyInput(): string | undefined;
    private _labelSelector;
    get labelSelector(): DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorList;
    putLabelSelector(value: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | cdktf.IResolvable): void;
    resetLabelSelector(): void;
    get labelSelectorInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionOutputReference;
}
export interface DaemonsetSpecTemplateSpecAffinityPodAntiAffinity {
    /**
    * preferred_during_scheduling_ignored_during_execution block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#preferred_during_scheduling_ignored_during_execution Daemonset#preferred_during_scheduling_ignored_during_execution}
    */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * required_during_scheduling_ignored_during_execution block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#required_during_scheduling_ignored_during_execution Daemonset#required_during_scheduling_ignored_during_execution}
    */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecAffinityPodAntiAffinityToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityOutputReference | DaemonsetSpecTemplateSpecAffinityPodAntiAffinity): any;
export declare class DaemonsetSpecTemplateSpecAffinityPodAntiAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecAffinityPodAntiAffinity | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinityPodAntiAffinity | undefined);
    private _preferredDuringSchedulingIgnoredDuringExecution;
    get preferredDuringSchedulingIgnoredDuringExecution(): DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionList;
    putPreferredDuringSchedulingIgnoredDuringExecution(value: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable): void;
    resetPreferredDuringSchedulingIgnoredDuringExecution(): void;
    get preferredDuringSchedulingIgnoredDuringExecutionInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | undefined;
    private _requiredDuringSchedulingIgnoredDuringExecution;
    get requiredDuringSchedulingIgnoredDuringExecution(): DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionList;
    putRequiredDuringSchedulingIgnoredDuringExecution(value: DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable): void;
    resetRequiredDuringSchedulingIgnoredDuringExecution(): void;
    get requiredDuringSchedulingIgnoredDuringExecutionInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | undefined;
}
export interface DaemonsetSpecTemplateSpecAffinity {
    /**
    * node_affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#node_affinity Daemonset#node_affinity}
    */
    readonly nodeAffinity?: DaemonsetSpecTemplateSpecAffinityNodeAffinity;
    /**
    * pod_affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#pod_affinity Daemonset#pod_affinity}
    */
    readonly podAffinity?: DaemonsetSpecTemplateSpecAffinityPodAffinity;
    /**
    * pod_anti_affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#pod_anti_affinity Daemonset#pod_anti_affinity}
    */
    readonly podAntiAffinity?: DaemonsetSpecTemplateSpecAffinityPodAntiAffinity;
}
export declare function daemonsetSpecTemplateSpecAffinityToTerraform(struct?: DaemonsetSpecTemplateSpecAffinityOutputReference | DaemonsetSpecTemplateSpecAffinity): any;
export declare class DaemonsetSpecTemplateSpecAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecAffinity | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecAffinity | undefined);
    private _nodeAffinity;
    get nodeAffinity(): DaemonsetSpecTemplateSpecAffinityNodeAffinityOutputReference;
    putNodeAffinity(value: DaemonsetSpecTemplateSpecAffinityNodeAffinity): void;
    resetNodeAffinity(): void;
    get nodeAffinityInput(): DaemonsetSpecTemplateSpecAffinityNodeAffinity | undefined;
    private _podAffinity;
    get podAffinity(): DaemonsetSpecTemplateSpecAffinityPodAffinityOutputReference;
    putPodAffinity(value: DaemonsetSpecTemplateSpecAffinityPodAffinity): void;
    resetPodAffinity(): void;
    get podAffinityInput(): DaemonsetSpecTemplateSpecAffinityPodAffinity | undefined;
    private _podAntiAffinity;
    get podAntiAffinity(): DaemonsetSpecTemplateSpecAffinityPodAntiAffinityOutputReference;
    putPodAntiAffinity(value: DaemonsetSpecTemplateSpecAffinityPodAntiAffinity): void;
    resetPodAntiAffinity(): void;
    get podAntiAffinityInput(): DaemonsetSpecTemplateSpecAffinityPodAntiAffinity | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerEnvValueFromConfigMapKeyRef {
    /**
    * The key to select.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#key Daemonset#key}
    */
    readonly key?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * Specify whether the ConfigMap or its key must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#optional Daemonset#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecContainerEnvValueFromConfigMapKeyRefToTerraform(struct?: DaemonsetSpecTemplateSpecContainerEnvValueFromConfigMapKeyRefOutputReference | DaemonsetSpecTemplateSpecContainerEnvValueFromConfigMapKeyRef): any;
export declare class DaemonsetSpecTemplateSpecContainerEnvValueFromConfigMapKeyRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerEnvValueFromConfigMapKeyRef | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerEnvValueFromConfigMapKeyRef | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerEnvValueFromFieldRef {
    /**
    * Version of the schema the FieldPath is written in terms of, defaults to "v1".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#api_version Daemonset#api_version}
    */
    readonly apiVersion?: string;
    /**
    * Path of the field to select in the specified API version
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#field_path Daemonset#field_path}
    */
    readonly fieldPath?: string;
}
export declare function daemonsetSpecTemplateSpecContainerEnvValueFromFieldRefToTerraform(struct?: DaemonsetSpecTemplateSpecContainerEnvValueFromFieldRefOutputReference | DaemonsetSpecTemplateSpecContainerEnvValueFromFieldRef): any;
export declare class DaemonsetSpecTemplateSpecContainerEnvValueFromFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerEnvValueFromFieldRef | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerEnvValueFromFieldRef | undefined);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    resetApiVersion(): void;
    get apiVersionInput(): string | undefined;
    private _fieldPath?;
    get fieldPath(): string;
    set fieldPath(value: string);
    resetFieldPath(): void;
    get fieldPathInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerEnvValueFromResourceFieldRef {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#container_name Daemonset#container_name}
    */
    readonly containerName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#divisor Daemonset#divisor}
    */
    readonly divisor?: string;
    /**
    * Resource to select
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#resource Daemonset#resource}
    */
    readonly resource: string;
}
export declare function daemonsetSpecTemplateSpecContainerEnvValueFromResourceFieldRefToTerraform(struct?: DaemonsetSpecTemplateSpecContainerEnvValueFromResourceFieldRefOutputReference | DaemonsetSpecTemplateSpecContainerEnvValueFromResourceFieldRef): any;
export declare class DaemonsetSpecTemplateSpecContainerEnvValueFromResourceFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerEnvValueFromResourceFieldRef | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerEnvValueFromResourceFieldRef | undefined);
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    resetContainerName(): void;
    get containerNameInput(): string | undefined;
    private _divisor?;
    get divisor(): string;
    set divisor(value: string);
    resetDivisor(): void;
    get divisorInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerEnvValueFromSecretKeyRef {
    /**
    * The key of the secret to select from. Must be a valid secret key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#key Daemonset#key}
    */
    readonly key?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * Specify whether the Secret or its key must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#optional Daemonset#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecContainerEnvValueFromSecretKeyRefToTerraform(struct?: DaemonsetSpecTemplateSpecContainerEnvValueFromSecretKeyRefOutputReference | DaemonsetSpecTemplateSpecContainerEnvValueFromSecretKeyRef): any;
export declare class DaemonsetSpecTemplateSpecContainerEnvValueFromSecretKeyRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerEnvValueFromSecretKeyRef | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerEnvValueFromSecretKeyRef | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerEnvValueFrom {
    /**
    * config_map_key_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#config_map_key_ref Daemonset#config_map_key_ref}
    */
    readonly configMapKeyRef?: DaemonsetSpecTemplateSpecContainerEnvValueFromConfigMapKeyRef;
    /**
    * field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#field_ref Daemonset#field_ref}
    */
    readonly fieldRef?: DaemonsetSpecTemplateSpecContainerEnvValueFromFieldRef;
    /**
    * resource_field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#resource_field_ref Daemonset#resource_field_ref}
    */
    readonly resourceFieldRef?: DaemonsetSpecTemplateSpecContainerEnvValueFromResourceFieldRef;
    /**
    * secret_key_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#secret_key_ref Daemonset#secret_key_ref}
    */
    readonly secretKeyRef?: DaemonsetSpecTemplateSpecContainerEnvValueFromSecretKeyRef;
}
export declare function daemonsetSpecTemplateSpecContainerEnvValueFromToTerraform(struct?: DaemonsetSpecTemplateSpecContainerEnvValueFromOutputReference | DaemonsetSpecTemplateSpecContainerEnvValueFrom): any;
export declare class DaemonsetSpecTemplateSpecContainerEnvValueFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerEnvValueFrom | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerEnvValueFrom | undefined);
    private _configMapKeyRef;
    get configMapKeyRef(): DaemonsetSpecTemplateSpecContainerEnvValueFromConfigMapKeyRefOutputReference;
    putConfigMapKeyRef(value: DaemonsetSpecTemplateSpecContainerEnvValueFromConfigMapKeyRef): void;
    resetConfigMapKeyRef(): void;
    get configMapKeyRefInput(): DaemonsetSpecTemplateSpecContainerEnvValueFromConfigMapKeyRef | undefined;
    private _fieldRef;
    get fieldRef(): DaemonsetSpecTemplateSpecContainerEnvValueFromFieldRefOutputReference;
    putFieldRef(value: DaemonsetSpecTemplateSpecContainerEnvValueFromFieldRef): void;
    resetFieldRef(): void;
    get fieldRefInput(): DaemonsetSpecTemplateSpecContainerEnvValueFromFieldRef | undefined;
    private _resourceFieldRef;
    get resourceFieldRef(): DaemonsetSpecTemplateSpecContainerEnvValueFromResourceFieldRefOutputReference;
    putResourceFieldRef(value: DaemonsetSpecTemplateSpecContainerEnvValueFromResourceFieldRef): void;
    resetResourceFieldRef(): void;
    get resourceFieldRefInput(): DaemonsetSpecTemplateSpecContainerEnvValueFromResourceFieldRef | undefined;
    private _secretKeyRef;
    get secretKeyRef(): DaemonsetSpecTemplateSpecContainerEnvValueFromSecretKeyRefOutputReference;
    putSecretKeyRef(value: DaemonsetSpecTemplateSpecContainerEnvValueFromSecretKeyRef): void;
    resetSecretKeyRef(): void;
    get secretKeyRefInput(): DaemonsetSpecTemplateSpecContainerEnvValueFromSecretKeyRef | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerEnv {
    /**
    * Name of the environment variable. Must be a C_IDENTIFIER
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name: string;
    /**
    * Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#value Daemonset#value}
    */
    readonly value?: string;
    /**
    * value_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#value_from Daemonset#value_from}
    */
    readonly valueFrom?: DaemonsetSpecTemplateSpecContainerEnvValueFrom;
}
export declare function daemonsetSpecTemplateSpecContainerEnvToTerraform(struct?: DaemonsetSpecTemplateSpecContainerEnv | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecContainerEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecContainerEnv | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerEnv | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _valueFrom;
    get valueFrom(): DaemonsetSpecTemplateSpecContainerEnvValueFromOutputReference;
    putValueFrom(value: DaemonsetSpecTemplateSpecContainerEnvValueFrom): void;
    resetValueFrom(): void;
    get valueFromInput(): DaemonsetSpecTemplateSpecContainerEnvValueFrom | undefined;
}
export declare class DaemonsetSpecTemplateSpecContainerEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecContainerEnv[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecContainerEnvOutputReference;
}
export interface DaemonsetSpecTemplateSpecContainerEnvFromConfigMapRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name: string;
    /**
    * Specify whether the ConfigMap must be defined
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#optional Daemonset#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecContainerEnvFromConfigMapRefToTerraform(struct?: DaemonsetSpecTemplateSpecContainerEnvFromConfigMapRefOutputReference | DaemonsetSpecTemplateSpecContainerEnvFromConfigMapRef): any;
export declare class DaemonsetSpecTemplateSpecContainerEnvFromConfigMapRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerEnvFromConfigMapRef | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerEnvFromConfigMapRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerEnvFromSecretRef {
    /**
    * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name: string;
    /**
    * Specify whether the Secret must be defined
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#optional Daemonset#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecContainerEnvFromSecretRefToTerraform(struct?: DaemonsetSpecTemplateSpecContainerEnvFromSecretRefOutputReference | DaemonsetSpecTemplateSpecContainerEnvFromSecretRef): any;
export declare class DaemonsetSpecTemplateSpecContainerEnvFromSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerEnvFromSecretRef | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerEnvFromSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerEnvFrom {
    /**
    * An optional identifer to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#prefix Daemonset#prefix}
    */
    readonly prefix?: string;
    /**
    * config_map_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#config_map_ref Daemonset#config_map_ref}
    */
    readonly configMapRef?: DaemonsetSpecTemplateSpecContainerEnvFromConfigMapRef;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#secret_ref Daemonset#secret_ref}
    */
    readonly secretRef?: DaemonsetSpecTemplateSpecContainerEnvFromSecretRef;
}
export declare function daemonsetSpecTemplateSpecContainerEnvFromToTerraform(struct?: DaemonsetSpecTemplateSpecContainerEnvFrom | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecContainerEnvFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecContainerEnvFrom | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerEnvFrom | cdktf.IResolvable | undefined);
    private _prefix?;
    get prefix(): string;
    set prefix(value: string);
    resetPrefix(): void;
    get prefixInput(): string | undefined;
    private _configMapRef;
    get configMapRef(): DaemonsetSpecTemplateSpecContainerEnvFromConfigMapRefOutputReference;
    putConfigMapRef(value: DaemonsetSpecTemplateSpecContainerEnvFromConfigMapRef): void;
    resetConfigMapRef(): void;
    get configMapRefInput(): DaemonsetSpecTemplateSpecContainerEnvFromConfigMapRef | undefined;
    private _secretRef;
    get secretRef(): DaemonsetSpecTemplateSpecContainerEnvFromSecretRefOutputReference;
    putSecretRef(value: DaemonsetSpecTemplateSpecContainerEnvFromSecretRef): void;
    resetSecretRef(): void;
    get secretRefInput(): DaemonsetSpecTemplateSpecContainerEnvFromSecretRef | undefined;
}
export declare class DaemonsetSpecTemplateSpecContainerEnvFromList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecContainerEnvFrom[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecContainerEnvFromOutputReference;
}
export interface DaemonsetSpecTemplateSpecContainerLifecyclePostStartExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#command Daemonset#command}
    */
    readonly command?: string[];
}
export declare function daemonsetSpecTemplateSpecContainerLifecyclePostStartExecToTerraform(struct?: DaemonsetSpecTemplateSpecContainerLifecyclePostStartExecOutputReference | DaemonsetSpecTemplateSpecContainerLifecyclePostStartExec): any;
export declare class DaemonsetSpecTemplateSpecContainerLifecyclePostStartExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerLifecyclePostStartExec | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerLifecyclePostStartExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#value Daemonset#value}
    */
    readonly value?: string;
}
export declare function daemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeaderToTerraform(struct?: DaemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeaderOutputReference;
}
export interface DaemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#host Daemonset#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#path Daemonset#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#scheme Daemonset#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#http_header Daemonset#http_header}
    */
    readonly httpHeader?: DaemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGetToTerraform(struct?: DaemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGetOutputReference | DaemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGet): any;
export declare class DaemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGet | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): DaemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeaderList;
    putHttpHeader(value: DaemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader[] | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerLifecyclePostStartTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port: string;
}
export declare function daemonsetSpecTemplateSpecContainerLifecyclePostStartTcpSocketToTerraform(struct?: DaemonsetSpecTemplateSpecContainerLifecyclePostStartTcpSocket | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecContainerLifecyclePostStartTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecContainerLifecyclePostStartTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerLifecyclePostStartTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecContainerLifecyclePostStartTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecContainerLifecyclePostStartTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecContainerLifecyclePostStartTcpSocketOutputReference;
}
export interface DaemonsetSpecTemplateSpecContainerLifecyclePostStart {
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#exec Daemonset#exec}
    */
    readonly exec?: DaemonsetSpecTemplateSpecContainerLifecyclePostStartExec;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#http_get Daemonset#http_get}
    */
    readonly httpGet?: DaemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#tcp_socket Daemonset#tcp_socket}
    */
    readonly tcpSocket?: DaemonsetSpecTemplateSpecContainerLifecyclePostStartTcpSocket[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecContainerLifecyclePostStartToTerraform(struct?: DaemonsetSpecTemplateSpecContainerLifecyclePostStart | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecContainerLifecyclePostStartOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecContainerLifecyclePostStart | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerLifecyclePostStart | cdktf.IResolvable | undefined);
    private _exec;
    get exec(): DaemonsetSpecTemplateSpecContainerLifecyclePostStartExecOutputReference;
    putExec(value: DaemonsetSpecTemplateSpecContainerLifecyclePostStartExec): void;
    resetExec(): void;
    get execInput(): DaemonsetSpecTemplateSpecContainerLifecyclePostStartExec | undefined;
    private _httpGet;
    get httpGet(): DaemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGetOutputReference;
    putHttpGet(value: DaemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): DaemonsetSpecTemplateSpecContainerLifecyclePostStartHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): DaemonsetSpecTemplateSpecContainerLifecyclePostStartTcpSocketList;
    putTcpSocket(value: DaemonsetSpecTemplateSpecContainerLifecyclePostStartTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecContainerLifecyclePostStartTcpSocket[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecContainerLifecyclePostStartList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecContainerLifecyclePostStart[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecContainerLifecyclePostStartOutputReference;
}
export interface DaemonsetSpecTemplateSpecContainerLifecyclePreStopExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#command Daemonset#command}
    */
    readonly command?: string[];
}
export declare function daemonsetSpecTemplateSpecContainerLifecyclePreStopExecToTerraform(struct?: DaemonsetSpecTemplateSpecContainerLifecyclePreStopExecOutputReference | DaemonsetSpecTemplateSpecContainerLifecyclePreStopExec): any;
export declare class DaemonsetSpecTemplateSpecContainerLifecyclePreStopExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerLifecyclePreStopExec | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerLifecyclePreStopExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#value Daemonset#value}
    */
    readonly value?: string;
}
export declare function daemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeaderToTerraform(struct?: DaemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeaderOutputReference;
}
export interface DaemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#host Daemonset#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#path Daemonset#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#scheme Daemonset#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#http_header Daemonset#http_header}
    */
    readonly httpHeader?: DaemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGetToTerraform(struct?: DaemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGetOutputReference | DaemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGet): any;
export declare class DaemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGet | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): DaemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeaderList;
    putHttpHeader(value: DaemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader[] | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerLifecyclePreStopTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port: string;
}
export declare function daemonsetSpecTemplateSpecContainerLifecyclePreStopTcpSocketToTerraform(struct?: DaemonsetSpecTemplateSpecContainerLifecyclePreStopTcpSocket | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecContainerLifecyclePreStopTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecContainerLifecyclePreStopTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerLifecyclePreStopTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecContainerLifecyclePreStopTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecContainerLifecyclePreStopTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecContainerLifecyclePreStopTcpSocketOutputReference;
}
export interface DaemonsetSpecTemplateSpecContainerLifecyclePreStop {
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#exec Daemonset#exec}
    */
    readonly exec?: DaemonsetSpecTemplateSpecContainerLifecyclePreStopExec;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#http_get Daemonset#http_get}
    */
    readonly httpGet?: DaemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#tcp_socket Daemonset#tcp_socket}
    */
    readonly tcpSocket?: DaemonsetSpecTemplateSpecContainerLifecyclePreStopTcpSocket[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecContainerLifecyclePreStopToTerraform(struct?: DaemonsetSpecTemplateSpecContainerLifecyclePreStop | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecContainerLifecyclePreStopOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecContainerLifecyclePreStop | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerLifecyclePreStop | cdktf.IResolvable | undefined);
    private _exec;
    get exec(): DaemonsetSpecTemplateSpecContainerLifecyclePreStopExecOutputReference;
    putExec(value: DaemonsetSpecTemplateSpecContainerLifecyclePreStopExec): void;
    resetExec(): void;
    get execInput(): DaemonsetSpecTemplateSpecContainerLifecyclePreStopExec | undefined;
    private _httpGet;
    get httpGet(): DaemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGetOutputReference;
    putHttpGet(value: DaemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): DaemonsetSpecTemplateSpecContainerLifecyclePreStopHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): DaemonsetSpecTemplateSpecContainerLifecyclePreStopTcpSocketList;
    putTcpSocket(value: DaemonsetSpecTemplateSpecContainerLifecyclePreStopTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecContainerLifecyclePreStopTcpSocket[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecContainerLifecyclePreStopList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecContainerLifecyclePreStop[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecContainerLifecyclePreStopOutputReference;
}
export interface DaemonsetSpecTemplateSpecContainerLifecycle {
    /**
    * post_start block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#post_start Daemonset#post_start}
    */
    readonly postStart?: DaemonsetSpecTemplateSpecContainerLifecyclePostStart[] | cdktf.IResolvable;
    /**
    * pre_stop block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#pre_stop Daemonset#pre_stop}
    */
    readonly preStop?: DaemonsetSpecTemplateSpecContainerLifecyclePreStop[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecContainerLifecycleToTerraform(struct?: DaemonsetSpecTemplateSpecContainerLifecycleOutputReference | DaemonsetSpecTemplateSpecContainerLifecycle): any;
export declare class DaemonsetSpecTemplateSpecContainerLifecycleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerLifecycle | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerLifecycle | undefined);
    private _postStart;
    get postStart(): DaemonsetSpecTemplateSpecContainerLifecyclePostStartList;
    putPostStart(value: DaemonsetSpecTemplateSpecContainerLifecyclePostStart[] | cdktf.IResolvable): void;
    resetPostStart(): void;
    get postStartInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecContainerLifecyclePostStart[] | undefined;
    private _preStop;
    get preStop(): DaemonsetSpecTemplateSpecContainerLifecyclePreStopList;
    putPreStop(value: DaemonsetSpecTemplateSpecContainerLifecyclePreStop[] | cdktf.IResolvable): void;
    resetPreStop(): void;
    get preStopInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecContainerLifecyclePreStop[] | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerLivenessProbeExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#command Daemonset#command}
    */
    readonly command?: string[];
}
export declare function daemonsetSpecTemplateSpecContainerLivenessProbeExecToTerraform(struct?: DaemonsetSpecTemplateSpecContainerLivenessProbeExecOutputReference | DaemonsetSpecTemplateSpecContainerLivenessProbeExec): any;
export declare class DaemonsetSpecTemplateSpecContainerLivenessProbeExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerLivenessProbeExec | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerLivenessProbeExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#value Daemonset#value}
    */
    readonly value?: string;
}
export declare function daemonsetSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeaderToTerraform(struct?: DaemonsetSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeaderOutputReference;
}
export interface DaemonsetSpecTemplateSpecContainerLivenessProbeHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#host Daemonset#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#path Daemonset#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#scheme Daemonset#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#http_header Daemonset#http_header}
    */
    readonly httpHeader?: DaemonsetSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecContainerLivenessProbeHttpGetToTerraform(struct?: DaemonsetSpecTemplateSpecContainerLivenessProbeHttpGetOutputReference | DaemonsetSpecTemplateSpecContainerLivenessProbeHttpGet): any;
export declare class DaemonsetSpecTemplateSpecContainerLivenessProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerLivenessProbeHttpGet | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerLivenessProbeHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): DaemonsetSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeaderList;
    putHttpHeader(value: DaemonsetSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader[] | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerLivenessProbeTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port: string;
}
export declare function daemonsetSpecTemplateSpecContainerLivenessProbeTcpSocketToTerraform(struct?: DaemonsetSpecTemplateSpecContainerLivenessProbeTcpSocket | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecContainerLivenessProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecContainerLivenessProbeTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerLivenessProbeTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecContainerLivenessProbeTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecContainerLivenessProbeTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecContainerLivenessProbeTcpSocketOutputReference;
}
export interface DaemonsetSpecTemplateSpecContainerLivenessProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#failure_threshold Daemonset#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before liveness probes are initiated. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#initial_delay_seconds Daemonset#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#period_seconds Daemonset#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Minimum consecutive successes for the probe to be considered successful after having failed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#success_threshold Daemonset#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Number of seconds after which the probe times out. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#timeout_seconds Daemonset#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#exec Daemonset#exec}
    */
    readonly exec?: DaemonsetSpecTemplateSpecContainerLivenessProbeExec;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#http_get Daemonset#http_get}
    */
    readonly httpGet?: DaemonsetSpecTemplateSpecContainerLivenessProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#tcp_socket Daemonset#tcp_socket}
    */
    readonly tcpSocket?: DaemonsetSpecTemplateSpecContainerLivenessProbeTcpSocket[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecContainerLivenessProbeToTerraform(struct?: DaemonsetSpecTemplateSpecContainerLivenessProbeOutputReference | DaemonsetSpecTemplateSpecContainerLivenessProbe): any;
export declare class DaemonsetSpecTemplateSpecContainerLivenessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerLivenessProbe | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerLivenessProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _exec;
    get exec(): DaemonsetSpecTemplateSpecContainerLivenessProbeExecOutputReference;
    putExec(value: DaemonsetSpecTemplateSpecContainerLivenessProbeExec): void;
    resetExec(): void;
    get execInput(): DaemonsetSpecTemplateSpecContainerLivenessProbeExec | undefined;
    private _httpGet;
    get httpGet(): DaemonsetSpecTemplateSpecContainerLivenessProbeHttpGetOutputReference;
    putHttpGet(value: DaemonsetSpecTemplateSpecContainerLivenessProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): DaemonsetSpecTemplateSpecContainerLivenessProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): DaemonsetSpecTemplateSpecContainerLivenessProbeTcpSocketList;
    putTcpSocket(value: DaemonsetSpecTemplateSpecContainerLivenessProbeTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecContainerLivenessProbeTcpSocket[] | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerPort {
    /**
    * Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#container_port Daemonset#container_port}
    */
    readonly containerPort: number;
    /**
    * What host IP to bind the external port to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#host_ip Daemonset#host_ip}
    */
    readonly hostIp?: string;
    /**
    * Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#host_port Daemonset#host_port}
    */
    readonly hostPort?: number;
    /**
    * If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * Protocol for port. Must be UDP or TCP. Defaults to "TCP".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#protocol Daemonset#protocol}
    */
    readonly protocol?: string;
}
export declare function daemonsetSpecTemplateSpecContainerPortToTerraform(struct?: DaemonsetSpecTemplateSpecContainerPort | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecContainerPortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecContainerPort | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerPort | cdktf.IResolvable | undefined);
    private _containerPort?;
    get containerPort(): number;
    set containerPort(value: number);
    get containerPortInput(): number | undefined;
    private _hostIp?;
    get hostIp(): string;
    set hostIp(value: string);
    resetHostIp(): void;
    get hostIpInput(): string | undefined;
    private _hostPort?;
    get hostPort(): number;
    set hostPort(value: number);
    resetHostPort(): void;
    get hostPortInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecContainerPortList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecContainerPort[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecContainerPortOutputReference;
}
export interface DaemonsetSpecTemplateSpecContainerReadinessProbeExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#command Daemonset#command}
    */
    readonly command?: string[];
}
export declare function daemonsetSpecTemplateSpecContainerReadinessProbeExecToTerraform(struct?: DaemonsetSpecTemplateSpecContainerReadinessProbeExecOutputReference | DaemonsetSpecTemplateSpecContainerReadinessProbeExec): any;
export declare class DaemonsetSpecTemplateSpecContainerReadinessProbeExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerReadinessProbeExec | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerReadinessProbeExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#value Daemonset#value}
    */
    readonly value?: string;
}
export declare function daemonsetSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeaderToTerraform(struct?: DaemonsetSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeaderOutputReference;
}
export interface DaemonsetSpecTemplateSpecContainerReadinessProbeHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#host Daemonset#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#path Daemonset#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#scheme Daemonset#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#http_header Daemonset#http_header}
    */
    readonly httpHeader?: DaemonsetSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecContainerReadinessProbeHttpGetToTerraform(struct?: DaemonsetSpecTemplateSpecContainerReadinessProbeHttpGetOutputReference | DaemonsetSpecTemplateSpecContainerReadinessProbeHttpGet): any;
export declare class DaemonsetSpecTemplateSpecContainerReadinessProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerReadinessProbeHttpGet | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerReadinessProbeHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): DaemonsetSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeaderList;
    putHttpHeader(value: DaemonsetSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader[] | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerReadinessProbeTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port: string;
}
export declare function daemonsetSpecTemplateSpecContainerReadinessProbeTcpSocketToTerraform(struct?: DaemonsetSpecTemplateSpecContainerReadinessProbeTcpSocket | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecContainerReadinessProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecContainerReadinessProbeTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerReadinessProbeTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecContainerReadinessProbeTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecContainerReadinessProbeTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecContainerReadinessProbeTcpSocketOutputReference;
}
export interface DaemonsetSpecTemplateSpecContainerReadinessProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#failure_threshold Daemonset#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before liveness probes are initiated. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#initial_delay_seconds Daemonset#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#period_seconds Daemonset#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Minimum consecutive successes for the probe to be considered successful after having failed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#success_threshold Daemonset#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Number of seconds after which the probe times out. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#timeout_seconds Daemonset#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#exec Daemonset#exec}
    */
    readonly exec?: DaemonsetSpecTemplateSpecContainerReadinessProbeExec;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#http_get Daemonset#http_get}
    */
    readonly httpGet?: DaemonsetSpecTemplateSpecContainerReadinessProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#tcp_socket Daemonset#tcp_socket}
    */
    readonly tcpSocket?: DaemonsetSpecTemplateSpecContainerReadinessProbeTcpSocket[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecContainerReadinessProbeToTerraform(struct?: DaemonsetSpecTemplateSpecContainerReadinessProbeOutputReference | DaemonsetSpecTemplateSpecContainerReadinessProbe): any;
export declare class DaemonsetSpecTemplateSpecContainerReadinessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerReadinessProbe | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerReadinessProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _exec;
    get exec(): DaemonsetSpecTemplateSpecContainerReadinessProbeExecOutputReference;
    putExec(value: DaemonsetSpecTemplateSpecContainerReadinessProbeExec): void;
    resetExec(): void;
    get execInput(): DaemonsetSpecTemplateSpecContainerReadinessProbeExec | undefined;
    private _httpGet;
    get httpGet(): DaemonsetSpecTemplateSpecContainerReadinessProbeHttpGetOutputReference;
    putHttpGet(value: DaemonsetSpecTemplateSpecContainerReadinessProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): DaemonsetSpecTemplateSpecContainerReadinessProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): DaemonsetSpecTemplateSpecContainerReadinessProbeTcpSocketList;
    putTcpSocket(value: DaemonsetSpecTemplateSpecContainerReadinessProbeTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecContainerReadinessProbeTcpSocket[] | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerResources {
    /**
    * Describes the maximum amount of compute resources allowed. More info: http://kubernetes.io/docs/user-guide/compute-resources/
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#limits Daemonset#limits}
    */
    readonly limits?: {
        [key: string]: string;
    };
    /**
    * Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#requests Daemonset#requests}
    */
    readonly requests?: {
        [key: string]: string;
    };
}
export declare function daemonsetSpecTemplateSpecContainerResourcesToTerraform(struct?: DaemonsetSpecTemplateSpecContainerResourcesOutputReference | DaemonsetSpecTemplateSpecContainerResources): any;
export declare class DaemonsetSpecTemplateSpecContainerResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerResources | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerResources | undefined);
    private _limits?;
    get limits(): {
        [key: string]: string;
    };
    set limits(value: {
        [key: string]: string;
    });
    resetLimits(): void;
    get limitsInput(): {
        [key: string]: string;
    } | undefined;
    private _requests?;
    get requests(): {
        [key: string]: string;
    };
    set requests(value: {
        [key: string]: string;
    });
    resetRequests(): void;
    get requestsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerSecurityContextCapabilities {
    /**
    * Added capabilities
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#add Daemonset#add}
    */
    readonly add?: string[];
    /**
    * Removed capabilities
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#drop Daemonset#drop}
    */
    readonly drop?: string[];
}
export declare function daemonsetSpecTemplateSpecContainerSecurityContextCapabilitiesToTerraform(struct?: DaemonsetSpecTemplateSpecContainerSecurityContextCapabilitiesOutputReference | DaemonsetSpecTemplateSpecContainerSecurityContextCapabilities): any;
export declare class DaemonsetSpecTemplateSpecContainerSecurityContextCapabilitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerSecurityContextCapabilities | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerSecurityContextCapabilities | undefined);
    private _add?;
    get add(): string[];
    set add(value: string[]);
    resetAdd(): void;
    get addInput(): string[] | undefined;
    private _drop?;
    get drop(): string[];
    set drop(value: string[]);
    resetDrop(): void;
    get dropInput(): string[] | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerSecurityContextSeLinuxOptions {
    /**
    * Level is SELinux level label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#level Daemonset#level}
    */
    readonly level?: string;
    /**
    * Role is a SELinux role label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#role Daemonset#role}
    */
    readonly role?: string;
    /**
    * Type is a SELinux type label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#type Daemonset#type}
    */
    readonly type?: string;
    /**
    * User is a SELinux user label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#user Daemonset#user}
    */
    readonly user?: string;
}
export declare function daemonsetSpecTemplateSpecContainerSecurityContextSeLinuxOptionsToTerraform(struct?: DaemonsetSpecTemplateSpecContainerSecurityContextSeLinuxOptionsOutputReference | DaemonsetSpecTemplateSpecContainerSecurityContextSeLinuxOptions): any;
export declare class DaemonsetSpecTemplateSpecContainerSecurityContextSeLinuxOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerSecurityContextSeLinuxOptions | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerSecurityContextSeLinuxOptions | undefined);
    private _level?;
    get level(): string;
    set level(value: string);
    resetLevel(): void;
    get levelInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerSecurityContextSeccompProfile {
    /**
    * Localhost Profile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#localhost_profile Daemonset#localhost_profile}
    */
    readonly localhostProfile?: string;
    /**
    * Type indicates which kind of seccomp profile will be applied. Valid options are: Localhost, RuntimeDefault, Unconfined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#type Daemonset#type}
    */
    readonly type?: string;
}
export declare function daemonsetSpecTemplateSpecContainerSecurityContextSeccompProfileToTerraform(struct?: DaemonsetSpecTemplateSpecContainerSecurityContextSeccompProfileOutputReference | DaemonsetSpecTemplateSpecContainerSecurityContextSeccompProfile): any;
export declare class DaemonsetSpecTemplateSpecContainerSecurityContextSeccompProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerSecurityContextSeccompProfile | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerSecurityContextSeccompProfile | undefined);
    private _localhostProfile?;
    get localhostProfile(): string;
    set localhostProfile(value: string);
    resetLocalhostProfile(): void;
    get localhostProfileInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerSecurityContext {
    /**
    * AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#allow_privilege_escalation Daemonset#allow_privilege_escalation}
    */
    readonly allowPrivilegeEscalation?: boolean | cdktf.IResolvable;
    /**
    * Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#privileged Daemonset#privileged}
    */
    readonly privileged?: boolean | cdktf.IResolvable;
    /**
    * Whether this container has a read-only root filesystem. Default is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#read_only_root_filesystem Daemonset#read_only_root_filesystem}
    */
    readonly readOnlyRootFilesystem?: boolean | cdktf.IResolvable;
    /**
    * The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#run_as_group Daemonset#run_as_group}
    */
    readonly runAsGroup?: string;
    /**
    * Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#run_as_non_root Daemonset#run_as_non_root}
    */
    readonly runAsNonRoot?: boolean | cdktf.IResolvable;
    /**
    * The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#run_as_user Daemonset#run_as_user}
    */
    readonly runAsUser?: string;
    /**
    * capabilities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#capabilities Daemonset#capabilities}
    */
    readonly capabilities?: DaemonsetSpecTemplateSpecContainerSecurityContextCapabilities;
    /**
    * se_linux_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#se_linux_options Daemonset#se_linux_options}
    */
    readonly seLinuxOptions?: DaemonsetSpecTemplateSpecContainerSecurityContextSeLinuxOptions;
    /**
    * seccomp_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#seccomp_profile Daemonset#seccomp_profile}
    */
    readonly seccompProfile?: DaemonsetSpecTemplateSpecContainerSecurityContextSeccompProfile;
}
export declare function daemonsetSpecTemplateSpecContainerSecurityContextToTerraform(struct?: DaemonsetSpecTemplateSpecContainerSecurityContextOutputReference | DaemonsetSpecTemplateSpecContainerSecurityContext): any;
export declare class DaemonsetSpecTemplateSpecContainerSecurityContextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerSecurityContext | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerSecurityContext | undefined);
    private _allowPrivilegeEscalation?;
    get allowPrivilegeEscalation(): boolean | cdktf.IResolvable;
    set allowPrivilegeEscalation(value: boolean | cdktf.IResolvable);
    resetAllowPrivilegeEscalation(): void;
    get allowPrivilegeEscalationInput(): boolean | cdktf.IResolvable | undefined;
    private _privileged?;
    get privileged(): boolean | cdktf.IResolvable;
    set privileged(value: boolean | cdktf.IResolvable);
    resetPrivileged(): void;
    get privilegedInput(): boolean | cdktf.IResolvable | undefined;
    private _readOnlyRootFilesystem?;
    get readOnlyRootFilesystem(): boolean | cdktf.IResolvable;
    set readOnlyRootFilesystem(value: boolean | cdktf.IResolvable);
    resetReadOnlyRootFilesystem(): void;
    get readOnlyRootFilesystemInput(): boolean | cdktf.IResolvable | undefined;
    private _runAsGroup?;
    get runAsGroup(): string;
    set runAsGroup(value: string);
    resetRunAsGroup(): void;
    get runAsGroupInput(): string | undefined;
    private _runAsNonRoot?;
    get runAsNonRoot(): boolean | cdktf.IResolvable;
    set runAsNonRoot(value: boolean | cdktf.IResolvable);
    resetRunAsNonRoot(): void;
    get runAsNonRootInput(): boolean | cdktf.IResolvable | undefined;
    private _runAsUser?;
    get runAsUser(): string;
    set runAsUser(value: string);
    resetRunAsUser(): void;
    get runAsUserInput(): string | undefined;
    private _capabilities;
    get capabilities(): DaemonsetSpecTemplateSpecContainerSecurityContextCapabilitiesOutputReference;
    putCapabilities(value: DaemonsetSpecTemplateSpecContainerSecurityContextCapabilities): void;
    resetCapabilities(): void;
    get capabilitiesInput(): DaemonsetSpecTemplateSpecContainerSecurityContextCapabilities | undefined;
    private _seLinuxOptions;
    get seLinuxOptions(): DaemonsetSpecTemplateSpecContainerSecurityContextSeLinuxOptionsOutputReference;
    putSeLinuxOptions(value: DaemonsetSpecTemplateSpecContainerSecurityContextSeLinuxOptions): void;
    resetSeLinuxOptions(): void;
    get seLinuxOptionsInput(): DaemonsetSpecTemplateSpecContainerSecurityContextSeLinuxOptions | undefined;
    private _seccompProfile;
    get seccompProfile(): DaemonsetSpecTemplateSpecContainerSecurityContextSeccompProfileOutputReference;
    putSeccompProfile(value: DaemonsetSpecTemplateSpecContainerSecurityContextSeccompProfile): void;
    resetSeccompProfile(): void;
    get seccompProfileInput(): DaemonsetSpecTemplateSpecContainerSecurityContextSeccompProfile | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerStartupProbeExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#command Daemonset#command}
    */
    readonly command?: string[];
}
export declare function daemonsetSpecTemplateSpecContainerStartupProbeExecToTerraform(struct?: DaemonsetSpecTemplateSpecContainerStartupProbeExecOutputReference | DaemonsetSpecTemplateSpecContainerStartupProbeExec): any;
export declare class DaemonsetSpecTemplateSpecContainerStartupProbeExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerStartupProbeExec | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerStartupProbeExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerStartupProbeHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#value Daemonset#value}
    */
    readonly value?: string;
}
export declare function daemonsetSpecTemplateSpecContainerStartupProbeHttpGetHttpHeaderToTerraform(struct?: DaemonsetSpecTemplateSpecContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecContainerStartupProbeHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecContainerStartupProbeHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecContainerStartupProbeHttpGetHttpHeaderOutputReference;
}
export interface DaemonsetSpecTemplateSpecContainerStartupProbeHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#host Daemonset#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#path Daemonset#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#scheme Daemonset#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#http_header Daemonset#http_header}
    */
    readonly httpHeader?: DaemonsetSpecTemplateSpecContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecContainerStartupProbeHttpGetToTerraform(struct?: DaemonsetSpecTemplateSpecContainerStartupProbeHttpGetOutputReference | DaemonsetSpecTemplateSpecContainerStartupProbeHttpGet): any;
export declare class DaemonsetSpecTemplateSpecContainerStartupProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerStartupProbeHttpGet | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerStartupProbeHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): DaemonsetSpecTemplateSpecContainerStartupProbeHttpGetHttpHeaderList;
    putHttpHeader(value: DaemonsetSpecTemplateSpecContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecContainerStartupProbeHttpGetHttpHeader[] | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerStartupProbeTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port: string;
}
export declare function daemonsetSpecTemplateSpecContainerStartupProbeTcpSocketToTerraform(struct?: DaemonsetSpecTemplateSpecContainerStartupProbeTcpSocket | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecContainerStartupProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecContainerStartupProbeTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerStartupProbeTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecContainerStartupProbeTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecContainerStartupProbeTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecContainerStartupProbeTcpSocketOutputReference;
}
export interface DaemonsetSpecTemplateSpecContainerStartupProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#failure_threshold Daemonset#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before liveness probes are initiated. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#initial_delay_seconds Daemonset#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#period_seconds Daemonset#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Minimum consecutive successes for the probe to be considered successful after having failed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#success_threshold Daemonset#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Number of seconds after which the probe times out. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#timeout_seconds Daemonset#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#exec Daemonset#exec}
    */
    readonly exec?: DaemonsetSpecTemplateSpecContainerStartupProbeExec;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#http_get Daemonset#http_get}
    */
    readonly httpGet?: DaemonsetSpecTemplateSpecContainerStartupProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#tcp_socket Daemonset#tcp_socket}
    */
    readonly tcpSocket?: DaemonsetSpecTemplateSpecContainerStartupProbeTcpSocket[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecContainerStartupProbeToTerraform(struct?: DaemonsetSpecTemplateSpecContainerStartupProbeOutputReference | DaemonsetSpecTemplateSpecContainerStartupProbe): any;
export declare class DaemonsetSpecTemplateSpecContainerStartupProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecContainerStartupProbe | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerStartupProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _exec;
    get exec(): DaemonsetSpecTemplateSpecContainerStartupProbeExecOutputReference;
    putExec(value: DaemonsetSpecTemplateSpecContainerStartupProbeExec): void;
    resetExec(): void;
    get execInput(): DaemonsetSpecTemplateSpecContainerStartupProbeExec | undefined;
    private _httpGet;
    get httpGet(): DaemonsetSpecTemplateSpecContainerStartupProbeHttpGetOutputReference;
    putHttpGet(value: DaemonsetSpecTemplateSpecContainerStartupProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): DaemonsetSpecTemplateSpecContainerStartupProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): DaemonsetSpecTemplateSpecContainerStartupProbeTcpSocketList;
    putTcpSocket(value: DaemonsetSpecTemplateSpecContainerStartupProbeTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecContainerStartupProbeTcpSocket[] | undefined;
}
export interface DaemonsetSpecTemplateSpecContainerVolumeMount {
    /**
    * Path within the container at which the volume should be mounted. Must not contain ':'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#mount_path Daemonset#mount_path}
    */
    readonly mountPath: string;
    /**
    * Mount propagation mode. mount_propagation determines how mounts are propagated from the host to container and the other way around. Valid values are None (default), HostToContainer and Bidirectional.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#mount_propagation Daemonset#mount_propagation}
    */
    readonly mountPropagation?: string;
    /**
    * This must match the Name of a Volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name: string;
    /**
    * Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#read_only Daemonset#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#sub_path Daemonset#sub_path}
    */
    readonly subPath?: string;
}
export declare function daemonsetSpecTemplateSpecContainerVolumeMountToTerraform(struct?: DaemonsetSpecTemplateSpecContainerVolumeMount | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecContainerVolumeMountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecContainerVolumeMount | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainerVolumeMount | cdktf.IResolvable | undefined);
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    get mountPathInput(): string | undefined;
    private _mountPropagation?;
    get mountPropagation(): string;
    set mountPropagation(value: string);
    resetMountPropagation(): void;
    get mountPropagationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _subPath?;
    get subPath(): string;
    set subPath(value: string);
    resetSubPath(): void;
    get subPathInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecContainerVolumeMountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecContainerVolumeMount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecContainerVolumeMountOutputReference;
}
export interface DaemonsetSpecTemplateSpecContainer {
    /**
    * Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/containers#containers-and-commands
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#args Daemonset#args}
    */
    readonly args?: string[];
    /**
    * Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/containers#containers-and-commands
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#command Daemonset#command}
    */
    readonly command?: string[];
    /**
    * Docker image name. More info: http://kubernetes.io/docs/user-guide/images
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#image Daemonset#image}
    */
    readonly image?: string;
    /**
    * Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/images#updating-images
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#image_pull_policy Daemonset#image_pull_policy}
    */
    readonly imagePullPolicy?: string;
    /**
    * Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name: string;
    /**
    * Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#stdin Daemonset#stdin}
    */
    readonly stdin?: boolean | cdktf.IResolvable;
    /**
    * Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#stdin_once Daemonset#stdin_once}
    */
    readonly stdinOnce?: boolean | cdktf.IResolvable;
    /**
    * Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Defaults to /dev/termination-log. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#termination_message_path Daemonset#termination_message_path}
    */
    readonly terminationMessagePath?: string;
    /**
    * Optional: Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#termination_message_policy Daemonset#termination_message_policy}
    */
    readonly terminationMessagePolicy?: string;
    /**
    * Whether this container should allocate a TTY for itself
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#tty Daemonset#tty}
    */
    readonly tty?: boolean | cdktf.IResolvable;
    /**
    * Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#working_dir Daemonset#working_dir}
    */
    readonly workingDir?: string;
    /**
    * env block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#env Daemonset#env}
    */
    readonly env?: DaemonsetSpecTemplateSpecContainerEnv[] | cdktf.IResolvable;
    /**
    * env_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#env_from Daemonset#env_from}
    */
    readonly envFrom?: DaemonsetSpecTemplateSpecContainerEnvFrom[] | cdktf.IResolvable;
    /**
    * lifecycle block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#lifecycle Daemonset#lifecycle}
    */
    readonly lifecycle?: DaemonsetSpecTemplateSpecContainerLifecycle;
    /**
    * liveness_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#liveness_probe Daemonset#liveness_probe}
    */
    readonly livenessProbe?: DaemonsetSpecTemplateSpecContainerLivenessProbe;
    /**
    * port block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port?: DaemonsetSpecTemplateSpecContainerPort[] | cdktf.IResolvable;
    /**
    * readiness_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#readiness_probe Daemonset#readiness_probe}
    */
    readonly readinessProbe?: DaemonsetSpecTemplateSpecContainerReadinessProbe;
    /**
    * resources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#resources Daemonset#resources}
    */
    readonly resources?: DaemonsetSpecTemplateSpecContainerResources;
    /**
    * security_context block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#security_context Daemonset#security_context}
    */
    readonly securityContext?: DaemonsetSpecTemplateSpecContainerSecurityContext;
    /**
    * startup_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#startup_probe Daemonset#startup_probe}
    */
    readonly startupProbe?: DaemonsetSpecTemplateSpecContainerStartupProbe;
    /**
    * volume_mount block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#volume_mount Daemonset#volume_mount}
    */
    readonly volumeMount?: DaemonsetSpecTemplateSpecContainerVolumeMount[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecContainerToTerraform(struct?: DaemonsetSpecTemplateSpecContainer | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecContainerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecContainer | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecContainer | cdktf.IResolvable | undefined);
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _imagePullPolicy?;
    get imagePullPolicy(): string;
    set imagePullPolicy(value: string);
    resetImagePullPolicy(): void;
    get imagePullPolicyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _stdin?;
    get stdin(): boolean | cdktf.IResolvable;
    set stdin(value: boolean | cdktf.IResolvable);
    resetStdin(): void;
    get stdinInput(): boolean | cdktf.IResolvable | undefined;
    private _stdinOnce?;
    get stdinOnce(): boolean | cdktf.IResolvable;
    set stdinOnce(value: boolean | cdktf.IResolvable);
    resetStdinOnce(): void;
    get stdinOnceInput(): boolean | cdktf.IResolvable | undefined;
    private _terminationMessagePath?;
    get terminationMessagePath(): string;
    set terminationMessagePath(value: string);
    resetTerminationMessagePath(): void;
    get terminationMessagePathInput(): string | undefined;
    private _terminationMessagePolicy?;
    get terminationMessagePolicy(): string;
    set terminationMessagePolicy(value: string);
    resetTerminationMessagePolicy(): void;
    get terminationMessagePolicyInput(): string | undefined;
    private _tty?;
    get tty(): boolean | cdktf.IResolvable;
    set tty(value: boolean | cdktf.IResolvable);
    resetTty(): void;
    get ttyInput(): boolean | cdktf.IResolvable | undefined;
    private _workingDir?;
    get workingDir(): string;
    set workingDir(value: string);
    resetWorkingDir(): void;
    get workingDirInput(): string | undefined;
    private _env;
    get env(): DaemonsetSpecTemplateSpecContainerEnvList;
    putEnv(value: DaemonsetSpecTemplateSpecContainerEnv[] | cdktf.IResolvable): void;
    resetEnv(): void;
    get envInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecContainerEnv[] | undefined;
    private _envFrom;
    get envFrom(): DaemonsetSpecTemplateSpecContainerEnvFromList;
    putEnvFrom(value: DaemonsetSpecTemplateSpecContainerEnvFrom[] | cdktf.IResolvable): void;
    resetEnvFrom(): void;
    get envFromInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecContainerEnvFrom[] | undefined;
    private _lifecycle;
    get lifecycle(): DaemonsetSpecTemplateSpecContainerLifecycleOutputReference;
    putLifecycle(value: DaemonsetSpecTemplateSpecContainerLifecycle): void;
    resetLifecycle(): void;
    get lifecycleInput(): DaemonsetSpecTemplateSpecContainerLifecycle | undefined;
    private _livenessProbe;
    get livenessProbe(): DaemonsetSpecTemplateSpecContainerLivenessProbeOutputReference;
    putLivenessProbe(value: DaemonsetSpecTemplateSpecContainerLivenessProbe): void;
    resetLivenessProbe(): void;
    get livenessProbeInput(): DaemonsetSpecTemplateSpecContainerLivenessProbe | undefined;
    private _port;
    get port(): DaemonsetSpecTemplateSpecContainerPortList;
    putPort(value: DaemonsetSpecTemplateSpecContainerPort[] | cdktf.IResolvable): void;
    resetPort(): void;
    get portInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecContainerPort[] | undefined;
    private _readinessProbe;
    get readinessProbe(): DaemonsetSpecTemplateSpecContainerReadinessProbeOutputReference;
    putReadinessProbe(value: DaemonsetSpecTemplateSpecContainerReadinessProbe): void;
    resetReadinessProbe(): void;
    get readinessProbeInput(): DaemonsetSpecTemplateSpecContainerReadinessProbe | undefined;
    private _resources;
    get resources(): DaemonsetSpecTemplateSpecContainerResourcesOutputReference;
    putResources(value: DaemonsetSpecTemplateSpecContainerResources): void;
    resetResources(): void;
    get resourcesInput(): DaemonsetSpecTemplateSpecContainerResources | undefined;
    private _securityContext;
    get securityContext(): DaemonsetSpecTemplateSpecContainerSecurityContextOutputReference;
    putSecurityContext(value: DaemonsetSpecTemplateSpecContainerSecurityContext): void;
    resetSecurityContext(): void;
    get securityContextInput(): DaemonsetSpecTemplateSpecContainerSecurityContext | undefined;
    private _startupProbe;
    get startupProbe(): DaemonsetSpecTemplateSpecContainerStartupProbeOutputReference;
    putStartupProbe(value: DaemonsetSpecTemplateSpecContainerStartupProbe): void;
    resetStartupProbe(): void;
    get startupProbeInput(): DaemonsetSpecTemplateSpecContainerStartupProbe | undefined;
    private _volumeMount;
    get volumeMount(): DaemonsetSpecTemplateSpecContainerVolumeMountList;
    putVolumeMount(value: DaemonsetSpecTemplateSpecContainerVolumeMount[] | cdktf.IResolvable): void;
    resetVolumeMount(): void;
    get volumeMountInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecContainerVolumeMount[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecContainerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecContainer[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecContainerOutputReference;
}
export interface DaemonsetSpecTemplateSpecDnsConfigOption {
    /**
    * Name of the option.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name: string;
    /**
    * Value of the option. Optional: Defaults to empty.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#value Daemonset#value}
    */
    readonly value?: string;
}
export declare function daemonsetSpecTemplateSpecDnsConfigOptionToTerraform(struct?: DaemonsetSpecTemplateSpecDnsConfigOption | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecDnsConfigOptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecDnsConfigOption | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecDnsConfigOption | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecDnsConfigOptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecDnsConfigOption[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecDnsConfigOptionOutputReference;
}
export interface DaemonsetSpecTemplateSpecDnsConfig {
    /**
    * A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#nameservers Daemonset#nameservers}
    */
    readonly nameservers?: string[];
    /**
    * A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#searches Daemonset#searches}
    */
    readonly searches?: string[];
    /**
    * option block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#option Daemonset#option}
    */
    readonly option?: DaemonsetSpecTemplateSpecDnsConfigOption[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecDnsConfigToTerraform(struct?: DaemonsetSpecTemplateSpecDnsConfigOutputReference | DaemonsetSpecTemplateSpecDnsConfig): any;
export declare class DaemonsetSpecTemplateSpecDnsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecDnsConfig | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecDnsConfig | undefined);
    private _nameservers?;
    get nameservers(): string[];
    set nameservers(value: string[]);
    resetNameservers(): void;
    get nameserversInput(): string[] | undefined;
    private _searches?;
    get searches(): string[];
    set searches(value: string[]);
    resetSearches(): void;
    get searchesInput(): string[] | undefined;
    private _option;
    get option(): DaemonsetSpecTemplateSpecDnsConfigOptionList;
    putOption(value: DaemonsetSpecTemplateSpecDnsConfigOption[] | cdktf.IResolvable): void;
    resetOption(): void;
    get optionInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecDnsConfigOption[] | undefined;
}
export interface DaemonsetSpecTemplateSpecHostAliases {
    /**
    * Hostnames for the IP address.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#hostnames Daemonset#hostnames}
    */
    readonly hostnames: string[];
    /**
    * IP address of the host file entry.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#ip Daemonset#ip}
    */
    readonly ip: string;
}
export declare function daemonsetSpecTemplateSpecHostAliasesToTerraform(struct?: DaemonsetSpecTemplateSpecHostAliases | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecHostAliasesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecHostAliases | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecHostAliases | cdktf.IResolvable | undefined);
    private _hostnames?;
    get hostnames(): string[];
    set hostnames(value: string[]);
    get hostnamesInput(): string[] | undefined;
    private _ip?;
    get ip(): string;
    set ip(value: string);
    get ipInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecHostAliasesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecHostAliases[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecHostAliasesOutputReference;
}
export interface DaemonsetSpecTemplateSpecImagePullSecrets {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name: string;
}
export declare function daemonsetSpecTemplateSpecImagePullSecretsToTerraform(struct?: DaemonsetSpecTemplateSpecImagePullSecrets | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecImagePullSecretsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecImagePullSecrets | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecImagePullSecrets | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecImagePullSecretsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecImagePullSecrets[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecImagePullSecretsOutputReference;
}
export interface DaemonsetSpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRef {
    /**
    * The key to select.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#key Daemonset#key}
    */
    readonly key?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * Specify whether the ConfigMap or its key must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#optional Daemonset#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRefToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRefOutputReference | DaemonsetSpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRef): any;
export declare class DaemonsetSpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRef | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRef | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerEnvValueFromFieldRef {
    /**
    * Version of the schema the FieldPath is written in terms of, defaults to "v1".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#api_version Daemonset#api_version}
    */
    readonly apiVersion?: string;
    /**
    * Path of the field to select in the specified API version
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#field_path Daemonset#field_path}
    */
    readonly fieldPath?: string;
}
export declare function daemonsetSpecTemplateSpecInitContainerEnvValueFromFieldRefToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerEnvValueFromFieldRefOutputReference | DaemonsetSpecTemplateSpecInitContainerEnvValueFromFieldRef): any;
export declare class DaemonsetSpecTemplateSpecInitContainerEnvValueFromFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerEnvValueFromFieldRef | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerEnvValueFromFieldRef | undefined);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    resetApiVersion(): void;
    get apiVersionInput(): string | undefined;
    private _fieldPath?;
    get fieldPath(): string;
    set fieldPath(value: string);
    resetFieldPath(): void;
    get fieldPathInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerEnvValueFromResourceFieldRef {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#container_name Daemonset#container_name}
    */
    readonly containerName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#divisor Daemonset#divisor}
    */
    readonly divisor?: string;
    /**
    * Resource to select
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#resource Daemonset#resource}
    */
    readonly resource: string;
}
export declare function daemonsetSpecTemplateSpecInitContainerEnvValueFromResourceFieldRefToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerEnvValueFromResourceFieldRefOutputReference | DaemonsetSpecTemplateSpecInitContainerEnvValueFromResourceFieldRef): any;
export declare class DaemonsetSpecTemplateSpecInitContainerEnvValueFromResourceFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerEnvValueFromResourceFieldRef | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerEnvValueFromResourceFieldRef | undefined);
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    resetContainerName(): void;
    get containerNameInput(): string | undefined;
    private _divisor?;
    get divisor(): string;
    set divisor(value: string);
    resetDivisor(): void;
    get divisorInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerEnvValueFromSecretKeyRef {
    /**
    * The key of the secret to select from. Must be a valid secret key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#key Daemonset#key}
    */
    readonly key?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * Specify whether the Secret or its key must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#optional Daemonset#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecInitContainerEnvValueFromSecretKeyRefToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerEnvValueFromSecretKeyRefOutputReference | DaemonsetSpecTemplateSpecInitContainerEnvValueFromSecretKeyRef): any;
export declare class DaemonsetSpecTemplateSpecInitContainerEnvValueFromSecretKeyRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerEnvValueFromSecretKeyRef | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerEnvValueFromSecretKeyRef | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerEnvValueFrom {
    /**
    * config_map_key_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#config_map_key_ref Daemonset#config_map_key_ref}
    */
    readonly configMapKeyRef?: DaemonsetSpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRef;
    /**
    * field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#field_ref Daemonset#field_ref}
    */
    readonly fieldRef?: DaemonsetSpecTemplateSpecInitContainerEnvValueFromFieldRef;
    /**
    * resource_field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#resource_field_ref Daemonset#resource_field_ref}
    */
    readonly resourceFieldRef?: DaemonsetSpecTemplateSpecInitContainerEnvValueFromResourceFieldRef;
    /**
    * secret_key_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#secret_key_ref Daemonset#secret_key_ref}
    */
    readonly secretKeyRef?: DaemonsetSpecTemplateSpecInitContainerEnvValueFromSecretKeyRef;
}
export declare function daemonsetSpecTemplateSpecInitContainerEnvValueFromToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerEnvValueFromOutputReference | DaemonsetSpecTemplateSpecInitContainerEnvValueFrom): any;
export declare class DaemonsetSpecTemplateSpecInitContainerEnvValueFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerEnvValueFrom | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerEnvValueFrom | undefined);
    private _configMapKeyRef;
    get configMapKeyRef(): DaemonsetSpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRefOutputReference;
    putConfigMapKeyRef(value: DaemonsetSpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRef): void;
    resetConfigMapKeyRef(): void;
    get configMapKeyRefInput(): DaemonsetSpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRef | undefined;
    private _fieldRef;
    get fieldRef(): DaemonsetSpecTemplateSpecInitContainerEnvValueFromFieldRefOutputReference;
    putFieldRef(value: DaemonsetSpecTemplateSpecInitContainerEnvValueFromFieldRef): void;
    resetFieldRef(): void;
    get fieldRefInput(): DaemonsetSpecTemplateSpecInitContainerEnvValueFromFieldRef | undefined;
    private _resourceFieldRef;
    get resourceFieldRef(): DaemonsetSpecTemplateSpecInitContainerEnvValueFromResourceFieldRefOutputReference;
    putResourceFieldRef(value: DaemonsetSpecTemplateSpecInitContainerEnvValueFromResourceFieldRef): void;
    resetResourceFieldRef(): void;
    get resourceFieldRefInput(): DaemonsetSpecTemplateSpecInitContainerEnvValueFromResourceFieldRef | undefined;
    private _secretKeyRef;
    get secretKeyRef(): DaemonsetSpecTemplateSpecInitContainerEnvValueFromSecretKeyRefOutputReference;
    putSecretKeyRef(value: DaemonsetSpecTemplateSpecInitContainerEnvValueFromSecretKeyRef): void;
    resetSecretKeyRef(): void;
    get secretKeyRefInput(): DaemonsetSpecTemplateSpecInitContainerEnvValueFromSecretKeyRef | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerEnv {
    /**
    * Name of the environment variable. Must be a C_IDENTIFIER
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name: string;
    /**
    * Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#value Daemonset#value}
    */
    readonly value?: string;
    /**
    * value_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#value_from Daemonset#value_from}
    */
    readonly valueFrom?: DaemonsetSpecTemplateSpecInitContainerEnvValueFrom;
}
export declare function daemonsetSpecTemplateSpecInitContainerEnvToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerEnv | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecInitContainerEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerEnv | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerEnv | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _valueFrom;
    get valueFrom(): DaemonsetSpecTemplateSpecInitContainerEnvValueFromOutputReference;
    putValueFrom(value: DaemonsetSpecTemplateSpecInitContainerEnvValueFrom): void;
    resetValueFrom(): void;
    get valueFromInput(): DaemonsetSpecTemplateSpecInitContainerEnvValueFrom | undefined;
}
export declare class DaemonsetSpecTemplateSpecInitContainerEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecInitContainerEnv[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecInitContainerEnvOutputReference;
}
export interface DaemonsetSpecTemplateSpecInitContainerEnvFromConfigMapRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name: string;
    /**
    * Specify whether the ConfigMap must be defined
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#optional Daemonset#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecInitContainerEnvFromConfigMapRefToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerEnvFromConfigMapRefOutputReference | DaemonsetSpecTemplateSpecInitContainerEnvFromConfigMapRef): any;
export declare class DaemonsetSpecTemplateSpecInitContainerEnvFromConfigMapRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerEnvFromConfigMapRef | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerEnvFromConfigMapRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerEnvFromSecretRef {
    /**
    * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name: string;
    /**
    * Specify whether the Secret must be defined
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#optional Daemonset#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecInitContainerEnvFromSecretRefToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerEnvFromSecretRefOutputReference | DaemonsetSpecTemplateSpecInitContainerEnvFromSecretRef): any;
export declare class DaemonsetSpecTemplateSpecInitContainerEnvFromSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerEnvFromSecretRef | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerEnvFromSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerEnvFrom {
    /**
    * An optional identifer to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#prefix Daemonset#prefix}
    */
    readonly prefix?: string;
    /**
    * config_map_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#config_map_ref Daemonset#config_map_ref}
    */
    readonly configMapRef?: DaemonsetSpecTemplateSpecInitContainerEnvFromConfigMapRef;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#secret_ref Daemonset#secret_ref}
    */
    readonly secretRef?: DaemonsetSpecTemplateSpecInitContainerEnvFromSecretRef;
}
export declare function daemonsetSpecTemplateSpecInitContainerEnvFromToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerEnvFrom | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecInitContainerEnvFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerEnvFrom | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerEnvFrom | cdktf.IResolvable | undefined);
    private _prefix?;
    get prefix(): string;
    set prefix(value: string);
    resetPrefix(): void;
    get prefixInput(): string | undefined;
    private _configMapRef;
    get configMapRef(): DaemonsetSpecTemplateSpecInitContainerEnvFromConfigMapRefOutputReference;
    putConfigMapRef(value: DaemonsetSpecTemplateSpecInitContainerEnvFromConfigMapRef): void;
    resetConfigMapRef(): void;
    get configMapRefInput(): DaemonsetSpecTemplateSpecInitContainerEnvFromConfigMapRef | undefined;
    private _secretRef;
    get secretRef(): DaemonsetSpecTemplateSpecInitContainerEnvFromSecretRefOutputReference;
    putSecretRef(value: DaemonsetSpecTemplateSpecInitContainerEnvFromSecretRef): void;
    resetSecretRef(): void;
    get secretRefInput(): DaemonsetSpecTemplateSpecInitContainerEnvFromSecretRef | undefined;
}
export declare class DaemonsetSpecTemplateSpecInitContainerEnvFromList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecInitContainerEnvFrom[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecInitContainerEnvFromOutputReference;
}
export interface DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#command Daemonset#command}
    */
    readonly command?: string[];
}
export declare function daemonsetSpecTemplateSpecInitContainerLifecyclePostStartExecToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartExecOutputReference | DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartExec): any;
export declare class DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartExec | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#value Daemonset#value}
    */
    readonly value?: string;
}
export declare function daemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeaderToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeaderOutputReference;
}
export interface DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#host Daemonset#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#path Daemonset#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#scheme Daemonset#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#http_header Daemonset#http_header}
    */
    readonly httpHeader?: DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGetToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGetOutputReference | DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGet): any;
export declare class DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGet | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeaderList;
    putHttpHeader(value: DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader[] | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port: string;
}
export declare function daemonsetSpecTemplateSpecInitContainerLifecyclePostStartTcpSocketToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartTcpSocket | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartTcpSocketOutputReference;
}
export interface DaemonsetSpecTemplateSpecInitContainerLifecyclePostStart {
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#exec Daemonset#exec}
    */
    readonly exec?: DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartExec;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#http_get Daemonset#http_get}
    */
    readonly httpGet?: DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#tcp_socket Daemonset#tcp_socket}
    */
    readonly tcpSocket?: DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartTcpSocket[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecInitContainerLifecyclePostStartToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerLifecyclePostStart | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerLifecyclePostStart | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerLifecyclePostStart | cdktf.IResolvable | undefined);
    private _exec;
    get exec(): DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartExecOutputReference;
    putExec(value: DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartExec): void;
    resetExec(): void;
    get execInput(): DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartExec | undefined;
    private _httpGet;
    get httpGet(): DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGetOutputReference;
    putHttpGet(value: DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartTcpSocketList;
    putTcpSocket(value: DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartTcpSocket[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecInitContainerLifecyclePostStart[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartOutputReference;
}
export interface DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#command Daemonset#command}
    */
    readonly command?: string[];
}
export declare function daemonsetSpecTemplateSpecInitContainerLifecyclePreStopExecToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopExecOutputReference | DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopExec): any;
export declare class DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopExec | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#value Daemonset#value}
    */
    readonly value?: string;
}
export declare function daemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeaderToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeaderOutputReference;
}
export interface DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#host Daemonset#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#path Daemonset#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#scheme Daemonset#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#http_header Daemonset#http_header}
    */
    readonly httpHeader?: DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGetToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGetOutputReference | DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGet): any;
export declare class DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGet | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeaderList;
    putHttpHeader(value: DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader[] | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port: string;
}
export declare function daemonsetSpecTemplateSpecInitContainerLifecyclePreStopTcpSocketToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopTcpSocket | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopTcpSocketOutputReference;
}
export interface DaemonsetSpecTemplateSpecInitContainerLifecyclePreStop {
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#exec Daemonset#exec}
    */
    readonly exec?: DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopExec;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#http_get Daemonset#http_get}
    */
    readonly httpGet?: DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#tcp_socket Daemonset#tcp_socket}
    */
    readonly tcpSocket?: DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopTcpSocket[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecInitContainerLifecyclePreStopToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerLifecyclePreStop | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerLifecyclePreStop | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerLifecyclePreStop | cdktf.IResolvable | undefined);
    private _exec;
    get exec(): DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopExecOutputReference;
    putExec(value: DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopExec): void;
    resetExec(): void;
    get execInput(): DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopExec | undefined;
    private _httpGet;
    get httpGet(): DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGetOutputReference;
    putHttpGet(value: DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopTcpSocketList;
    putTcpSocket(value: DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopTcpSocket[] | undefined;
}
export declare class DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecInitContainerLifecyclePreStop[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopOutputReference;
}
export interface DaemonsetSpecTemplateSpecInitContainerLifecycle {
    /**
    * post_start block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#post_start Daemonset#post_start}
    */
    readonly postStart?: DaemonsetSpecTemplateSpecInitContainerLifecyclePostStart[] | cdktf.IResolvable;
    /**
    * pre_stop block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#pre_stop Daemonset#pre_stop}
    */
    readonly preStop?: DaemonsetSpecTemplateSpecInitContainerLifecyclePreStop[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecInitContainerLifecycleToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerLifecycleOutputReference | DaemonsetSpecTemplateSpecInitContainerLifecycle): any;
export declare class DaemonsetSpecTemplateSpecInitContainerLifecycleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerLifecycle | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerLifecycle | undefined);
    private _postStart;
    get postStart(): DaemonsetSpecTemplateSpecInitContainerLifecyclePostStartList;
    putPostStart(value: DaemonsetSpecTemplateSpecInitContainerLifecyclePostStart[] | cdktf.IResolvable): void;
    resetPostStart(): void;
    get postStartInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecInitContainerLifecyclePostStart[] | undefined;
    private _preStop;
    get preStop(): DaemonsetSpecTemplateSpecInitContainerLifecyclePreStopList;
    putPreStop(value: DaemonsetSpecTemplateSpecInitContainerLifecyclePreStop[] | cdktf.IResolvable): void;
    resetPreStop(): void;
    get preStopInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecInitContainerLifecyclePreStop[] | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerLivenessProbeExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#command Daemonset#command}
    */
    readonly command?: string[];
}
export declare function daemonsetSpecTemplateSpecInitContainerLivenessProbeExecToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerLivenessProbeExecOutputReference | DaemonsetSpecTemplateSpecInitContainerLivenessProbeExec): any;
export declare class DaemonsetSpecTemplateSpecInitContainerLivenessProbeExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerLivenessProbeExec | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerLivenessProbeExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#value Daemonset#value}
    */
    readonly value?: string;
}
export declare function daemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeaderToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeaderOutputReference;
}
export interface DaemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#host Daemonset#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#path Daemonset#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#scheme Daemonset#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#http_header Daemonset#http_header}
    */
    readonly httpHeader?: DaemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGetToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGetOutputReference | DaemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGet): any;
export declare class DaemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGet | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): DaemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeaderList;
    putHttpHeader(value: DaemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader[] | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerLivenessProbeTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port: string;
}
export declare function daemonsetSpecTemplateSpecInitContainerLivenessProbeTcpSocketToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerLivenessProbeTcpSocket | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecInitContainerLivenessProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerLivenessProbeTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerLivenessProbeTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecInitContainerLivenessProbeTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecInitContainerLivenessProbeTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecInitContainerLivenessProbeTcpSocketOutputReference;
}
export interface DaemonsetSpecTemplateSpecInitContainerLivenessProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#failure_threshold Daemonset#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before liveness probes are initiated. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#initial_delay_seconds Daemonset#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#period_seconds Daemonset#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Minimum consecutive successes for the probe to be considered successful after having failed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#success_threshold Daemonset#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Number of seconds after which the probe times out. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#timeout_seconds Daemonset#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#exec Daemonset#exec}
    */
    readonly exec?: DaemonsetSpecTemplateSpecInitContainerLivenessProbeExec;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#http_get Daemonset#http_get}
    */
    readonly httpGet?: DaemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#tcp_socket Daemonset#tcp_socket}
    */
    readonly tcpSocket?: DaemonsetSpecTemplateSpecInitContainerLivenessProbeTcpSocket[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecInitContainerLivenessProbeToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerLivenessProbeOutputReference | DaemonsetSpecTemplateSpecInitContainerLivenessProbe): any;
export declare class DaemonsetSpecTemplateSpecInitContainerLivenessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerLivenessProbe | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerLivenessProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _exec;
    get exec(): DaemonsetSpecTemplateSpecInitContainerLivenessProbeExecOutputReference;
    putExec(value: DaemonsetSpecTemplateSpecInitContainerLivenessProbeExec): void;
    resetExec(): void;
    get execInput(): DaemonsetSpecTemplateSpecInitContainerLivenessProbeExec | undefined;
    private _httpGet;
    get httpGet(): DaemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGetOutputReference;
    putHttpGet(value: DaemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): DaemonsetSpecTemplateSpecInitContainerLivenessProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): DaemonsetSpecTemplateSpecInitContainerLivenessProbeTcpSocketList;
    putTcpSocket(value: DaemonsetSpecTemplateSpecInitContainerLivenessProbeTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecInitContainerLivenessProbeTcpSocket[] | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerPort {
    /**
    * Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#container_port Daemonset#container_port}
    */
    readonly containerPort: number;
    /**
    * What host IP to bind the external port to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#host_ip Daemonset#host_ip}
    */
    readonly hostIp?: string;
    /**
    * Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#host_port Daemonset#host_port}
    */
    readonly hostPort?: number;
    /**
    * If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * Protocol for port. Must be UDP or TCP. Defaults to "TCP".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#protocol Daemonset#protocol}
    */
    readonly protocol?: string;
}
export declare function daemonsetSpecTemplateSpecInitContainerPortToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerPort | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecInitContainerPortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerPort | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerPort | cdktf.IResolvable | undefined);
    private _containerPort?;
    get containerPort(): number;
    set containerPort(value: number);
    get containerPortInput(): number | undefined;
    private _hostIp?;
    get hostIp(): string;
    set hostIp(value: string);
    resetHostIp(): void;
    get hostIpInput(): string | undefined;
    private _hostPort?;
    get hostPort(): number;
    set hostPort(value: number);
    resetHostPort(): void;
    get hostPortInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecInitContainerPortList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecInitContainerPort[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecInitContainerPortOutputReference;
}
export interface DaemonsetSpecTemplateSpecInitContainerReadinessProbeExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#command Daemonset#command}
    */
    readonly command?: string[];
}
export declare function daemonsetSpecTemplateSpecInitContainerReadinessProbeExecToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerReadinessProbeExecOutputReference | DaemonsetSpecTemplateSpecInitContainerReadinessProbeExec): any;
export declare class DaemonsetSpecTemplateSpecInitContainerReadinessProbeExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerReadinessProbeExec | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerReadinessProbeExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#value Daemonset#value}
    */
    readonly value?: string;
}
export declare function daemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeaderToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeaderOutputReference;
}
export interface DaemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#host Daemonset#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#path Daemonset#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#scheme Daemonset#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#http_header Daemonset#http_header}
    */
    readonly httpHeader?: DaemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGetToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGetOutputReference | DaemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGet): any;
export declare class DaemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGet | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): DaemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeaderList;
    putHttpHeader(value: DaemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader[] | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerReadinessProbeTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port: string;
}
export declare function daemonsetSpecTemplateSpecInitContainerReadinessProbeTcpSocketToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerReadinessProbeTcpSocket | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecInitContainerReadinessProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerReadinessProbeTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerReadinessProbeTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecInitContainerReadinessProbeTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecInitContainerReadinessProbeTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecInitContainerReadinessProbeTcpSocketOutputReference;
}
export interface DaemonsetSpecTemplateSpecInitContainerReadinessProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#failure_threshold Daemonset#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before liveness probes are initiated. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#initial_delay_seconds Daemonset#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#period_seconds Daemonset#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Minimum consecutive successes for the probe to be considered successful after having failed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#success_threshold Daemonset#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Number of seconds after which the probe times out. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#timeout_seconds Daemonset#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#exec Daemonset#exec}
    */
    readonly exec?: DaemonsetSpecTemplateSpecInitContainerReadinessProbeExec;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#http_get Daemonset#http_get}
    */
    readonly httpGet?: DaemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#tcp_socket Daemonset#tcp_socket}
    */
    readonly tcpSocket?: DaemonsetSpecTemplateSpecInitContainerReadinessProbeTcpSocket[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecInitContainerReadinessProbeToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerReadinessProbeOutputReference | DaemonsetSpecTemplateSpecInitContainerReadinessProbe): any;
export declare class DaemonsetSpecTemplateSpecInitContainerReadinessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerReadinessProbe | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerReadinessProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _exec;
    get exec(): DaemonsetSpecTemplateSpecInitContainerReadinessProbeExecOutputReference;
    putExec(value: DaemonsetSpecTemplateSpecInitContainerReadinessProbeExec): void;
    resetExec(): void;
    get execInput(): DaemonsetSpecTemplateSpecInitContainerReadinessProbeExec | undefined;
    private _httpGet;
    get httpGet(): DaemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGetOutputReference;
    putHttpGet(value: DaemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): DaemonsetSpecTemplateSpecInitContainerReadinessProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): DaemonsetSpecTemplateSpecInitContainerReadinessProbeTcpSocketList;
    putTcpSocket(value: DaemonsetSpecTemplateSpecInitContainerReadinessProbeTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecInitContainerReadinessProbeTcpSocket[] | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerResources {
    /**
    * Describes the maximum amount of compute resources allowed. More info: http://kubernetes.io/docs/user-guide/compute-resources/
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#limits Daemonset#limits}
    */
    readonly limits?: {
        [key: string]: string;
    };
    /**
    * Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#requests Daemonset#requests}
    */
    readonly requests?: {
        [key: string]: string;
    };
}
export declare function daemonsetSpecTemplateSpecInitContainerResourcesToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerResourcesOutputReference | DaemonsetSpecTemplateSpecInitContainerResources): any;
export declare class DaemonsetSpecTemplateSpecInitContainerResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerResources | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerResources | undefined);
    private _limits?;
    get limits(): {
        [key: string]: string;
    };
    set limits(value: {
        [key: string]: string;
    });
    resetLimits(): void;
    get limitsInput(): {
        [key: string]: string;
    } | undefined;
    private _requests?;
    get requests(): {
        [key: string]: string;
    };
    set requests(value: {
        [key: string]: string;
    });
    resetRequests(): void;
    get requestsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerSecurityContextCapabilities {
    /**
    * Added capabilities
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#add Daemonset#add}
    */
    readonly add?: string[];
    /**
    * Removed capabilities
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#drop Daemonset#drop}
    */
    readonly drop?: string[];
}
export declare function daemonsetSpecTemplateSpecInitContainerSecurityContextCapabilitiesToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerSecurityContextCapabilitiesOutputReference | DaemonsetSpecTemplateSpecInitContainerSecurityContextCapabilities): any;
export declare class DaemonsetSpecTemplateSpecInitContainerSecurityContextCapabilitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerSecurityContextCapabilities | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerSecurityContextCapabilities | undefined);
    private _add?;
    get add(): string[];
    set add(value: string[]);
    resetAdd(): void;
    get addInput(): string[] | undefined;
    private _drop?;
    get drop(): string[];
    set drop(value: string[]);
    resetDrop(): void;
    get dropInput(): string[] | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerSecurityContextSeLinuxOptions {
    /**
    * Level is SELinux level label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#level Daemonset#level}
    */
    readonly level?: string;
    /**
    * Role is a SELinux role label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#role Daemonset#role}
    */
    readonly role?: string;
    /**
    * Type is a SELinux type label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#type Daemonset#type}
    */
    readonly type?: string;
    /**
    * User is a SELinux user label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#user Daemonset#user}
    */
    readonly user?: string;
}
export declare function daemonsetSpecTemplateSpecInitContainerSecurityContextSeLinuxOptionsToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerSecurityContextSeLinuxOptionsOutputReference | DaemonsetSpecTemplateSpecInitContainerSecurityContextSeLinuxOptions): any;
export declare class DaemonsetSpecTemplateSpecInitContainerSecurityContextSeLinuxOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerSecurityContextSeLinuxOptions | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerSecurityContextSeLinuxOptions | undefined);
    private _level?;
    get level(): string;
    set level(value: string);
    resetLevel(): void;
    get levelInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerSecurityContextSeccompProfile {
    /**
    * Localhost Profile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#localhost_profile Daemonset#localhost_profile}
    */
    readonly localhostProfile?: string;
    /**
    * Type indicates which kind of seccomp profile will be applied. Valid options are: Localhost, RuntimeDefault, Unconfined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#type Daemonset#type}
    */
    readonly type?: string;
}
export declare function daemonsetSpecTemplateSpecInitContainerSecurityContextSeccompProfileToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerSecurityContextSeccompProfileOutputReference | DaemonsetSpecTemplateSpecInitContainerSecurityContextSeccompProfile): any;
export declare class DaemonsetSpecTemplateSpecInitContainerSecurityContextSeccompProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerSecurityContextSeccompProfile | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerSecurityContextSeccompProfile | undefined);
    private _localhostProfile?;
    get localhostProfile(): string;
    set localhostProfile(value: string);
    resetLocalhostProfile(): void;
    get localhostProfileInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerSecurityContext {
    /**
    * AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#allow_privilege_escalation Daemonset#allow_privilege_escalation}
    */
    readonly allowPrivilegeEscalation?: boolean | cdktf.IResolvable;
    /**
    * Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#privileged Daemonset#privileged}
    */
    readonly privileged?: boolean | cdktf.IResolvable;
    /**
    * Whether this container has a read-only root filesystem. Default is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#read_only_root_filesystem Daemonset#read_only_root_filesystem}
    */
    readonly readOnlyRootFilesystem?: boolean | cdktf.IResolvable;
    /**
    * The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#run_as_group Daemonset#run_as_group}
    */
    readonly runAsGroup?: string;
    /**
    * Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#run_as_non_root Daemonset#run_as_non_root}
    */
    readonly runAsNonRoot?: boolean | cdktf.IResolvable;
    /**
    * The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#run_as_user Daemonset#run_as_user}
    */
    readonly runAsUser?: string;
    /**
    * capabilities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#capabilities Daemonset#capabilities}
    */
    readonly capabilities?: DaemonsetSpecTemplateSpecInitContainerSecurityContextCapabilities;
    /**
    * se_linux_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#se_linux_options Daemonset#se_linux_options}
    */
    readonly seLinuxOptions?: DaemonsetSpecTemplateSpecInitContainerSecurityContextSeLinuxOptions;
    /**
    * seccomp_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#seccomp_profile Daemonset#seccomp_profile}
    */
    readonly seccompProfile?: DaemonsetSpecTemplateSpecInitContainerSecurityContextSeccompProfile;
}
export declare function daemonsetSpecTemplateSpecInitContainerSecurityContextToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerSecurityContextOutputReference | DaemonsetSpecTemplateSpecInitContainerSecurityContext): any;
export declare class DaemonsetSpecTemplateSpecInitContainerSecurityContextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerSecurityContext | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerSecurityContext | undefined);
    private _allowPrivilegeEscalation?;
    get allowPrivilegeEscalation(): boolean | cdktf.IResolvable;
    set allowPrivilegeEscalation(value: boolean | cdktf.IResolvable);
    resetAllowPrivilegeEscalation(): void;
    get allowPrivilegeEscalationInput(): boolean | cdktf.IResolvable | undefined;
    private _privileged?;
    get privileged(): boolean | cdktf.IResolvable;
    set privileged(value: boolean | cdktf.IResolvable);
    resetPrivileged(): void;
    get privilegedInput(): boolean | cdktf.IResolvable | undefined;
    private _readOnlyRootFilesystem?;
    get readOnlyRootFilesystem(): boolean | cdktf.IResolvable;
    set readOnlyRootFilesystem(value: boolean | cdktf.IResolvable);
    resetReadOnlyRootFilesystem(): void;
    get readOnlyRootFilesystemInput(): boolean | cdktf.IResolvable | undefined;
    private _runAsGroup?;
    get runAsGroup(): string;
    set runAsGroup(value: string);
    resetRunAsGroup(): void;
    get runAsGroupInput(): string | undefined;
    private _runAsNonRoot?;
    get runAsNonRoot(): boolean | cdktf.IResolvable;
    set runAsNonRoot(value: boolean | cdktf.IResolvable);
    resetRunAsNonRoot(): void;
    get runAsNonRootInput(): boolean | cdktf.IResolvable | undefined;
    private _runAsUser?;
    get runAsUser(): string;
    set runAsUser(value: string);
    resetRunAsUser(): void;
    get runAsUserInput(): string | undefined;
    private _capabilities;
    get capabilities(): DaemonsetSpecTemplateSpecInitContainerSecurityContextCapabilitiesOutputReference;
    putCapabilities(value: DaemonsetSpecTemplateSpecInitContainerSecurityContextCapabilities): void;
    resetCapabilities(): void;
    get capabilitiesInput(): DaemonsetSpecTemplateSpecInitContainerSecurityContextCapabilities | undefined;
    private _seLinuxOptions;
    get seLinuxOptions(): DaemonsetSpecTemplateSpecInitContainerSecurityContextSeLinuxOptionsOutputReference;
    putSeLinuxOptions(value: DaemonsetSpecTemplateSpecInitContainerSecurityContextSeLinuxOptions): void;
    resetSeLinuxOptions(): void;
    get seLinuxOptionsInput(): DaemonsetSpecTemplateSpecInitContainerSecurityContextSeLinuxOptions | undefined;
    private _seccompProfile;
    get seccompProfile(): DaemonsetSpecTemplateSpecInitContainerSecurityContextSeccompProfileOutputReference;
    putSeccompProfile(value: DaemonsetSpecTemplateSpecInitContainerSecurityContextSeccompProfile): void;
    resetSeccompProfile(): void;
    get seccompProfileInput(): DaemonsetSpecTemplateSpecInitContainerSecurityContextSeccompProfile | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerStartupProbeExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#command Daemonset#command}
    */
    readonly command?: string[];
}
export declare function daemonsetSpecTemplateSpecInitContainerStartupProbeExecToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerStartupProbeExecOutputReference | DaemonsetSpecTemplateSpecInitContainerStartupProbeExec): any;
export declare class DaemonsetSpecTemplateSpecInitContainerStartupProbeExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerStartupProbeExec | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerStartupProbeExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#name Daemonset#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#value Daemonset#value}
    */
    readonly value?: string;
}
export declare function daemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeaderToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeaderOutputReference;
}
export interface DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#host Daemonset#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#path Daemonset#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#port Daemonset#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#scheme Daemonset#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#http_header Daemonset#http_header}
    */
    readonly httpHeader?: DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function daemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetToTerraform(struct?: DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetOutputReference | DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGet): any;
export declare class DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGet | undefined;
    set internalValue(value: DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeaderList;
    putHttpHeader(value: DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | DaemonsetSpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader[] | undefined;
}
