import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CsiDriverV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver_v1#id CsiDriverV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver_v1#metadata CsiDriverV1#metadata}
    */
    readonly metadata: CsiDriverV1Metadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver_v1#spec CsiDriverV1#spec}
    */
    readonly spec?: CsiDriverV1Spec;
}
export interface CsiDriverV1Metadata {
    /**
    * An unstructured key value map stored with the csi driver that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver_v1#annotations CsiDriverV1#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Prefix, used by the server, to generate a unique name ONLY IF the `name` field has not been provided. This value will also be combined with a unique suffix. Read more: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#idempotency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver_v1#generate_name CsiDriverV1#generate_name}
    */
    readonly generateName?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the csi driver. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver_v1#labels CsiDriverV1#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the csi driver, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver_v1#name CsiDriverV1#name}
    */
    readonly name?: string;
}
export declare function csiDriverV1MetadataToTerraform(struct?: CsiDriverV1MetadataOutputReference | CsiDriverV1Metadata): any;
export declare class CsiDriverV1MetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CsiDriverV1Metadata | undefined;
    set internalValue(value: CsiDriverV1Metadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _generateName?;
    get generateName(): string;
    set generateName(value: string);
    resetGenerateName(): void;
    get generateNameInput(): string | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface CsiDriverV1Spec {
    /**
    * Indicates if the CSI volume driver requires an attach operation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver_v1#attach_required CsiDriverV1#attach_required}
    */
    readonly attachRequired: boolean | cdktf.IResolvable;
    /**
    * Indicates that the CSI volume driver requires additional pod information (like podName, podUID, etc.) during mount operations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver_v1#pod_info_on_mount CsiDriverV1#pod_info_on_mount}
    */
    readonly podInfoOnMount?: boolean | cdktf.IResolvable;
    /**
    * Defines what kind of volumes this CSI volume driver supports
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver_v1#volume_lifecycle_modes CsiDriverV1#volume_lifecycle_modes}
    */
    readonly volumeLifecycleModes?: string[];
}
export declare function csiDriverV1SpecToTerraform(struct?: CsiDriverV1SpecOutputReference | CsiDriverV1Spec): any;
export declare class CsiDriverV1SpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CsiDriverV1Spec | undefined;
    set internalValue(value: CsiDriverV1Spec | undefined);
    private _attachRequired?;
    get attachRequired(): boolean | cdktf.IResolvable;
    set attachRequired(value: boolean | cdktf.IResolvable);
    get attachRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _podInfoOnMount?;
    get podInfoOnMount(): boolean | cdktf.IResolvable;
    set podInfoOnMount(value: boolean | cdktf.IResolvable);
    resetPodInfoOnMount(): void;
    get podInfoOnMountInput(): boolean | cdktf.IResolvable | undefined;
    private _volumeLifecycleModes?;
    get volumeLifecycleModes(): string[];
    set volumeLifecycleModes(value: string[]);
    resetVolumeLifecycleModes(): void;
    get volumeLifecycleModesInput(): string[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver_v1 kubernetes_csi_driver_v1}
*/
export declare class CsiDriverV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_csi_driver_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/csi_driver_v1 kubernetes_csi_driver_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CsiDriverV1Config
    */
    constructor(scope: Construct, id: string, config: CsiDriverV1Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): CsiDriverV1MetadataOutputReference;
    putMetadata(value: CsiDriverV1Metadata): void;
    get metadataInput(): CsiDriverV1Metadata | undefined;
    private _spec;
    get spec(): CsiDriverV1SpecOutputReference;
    putSpec(value: CsiDriverV1Spec): void;
    resetSpec(): void;
    get specInput(): CsiDriverV1Spec | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
