import { CronJobV1Metadata, CronJobV1MetadataOutputReference, CronJobV1Spec, CronJobV1SpecOutputReference, CronJobV1Timeouts, CronJobV1TimeoutsOutputReference } from './index-structs';
export * from './index-structs';
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CronJobV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cron_job_v1#id CronJobV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cron_job_v1#metadata CronJobV1#metadata}
    */
    readonly metadata: CronJobV1Metadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cron_job_v1#spec CronJobV1#spec}
    */
    readonly spec: CronJobV1Spec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cron_job_v1#timeouts CronJobV1#timeouts}
    */
    readonly timeouts?: CronJobV1Timeouts;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/cron_job_v1 kubernetes_cron_job_v1}
*/
export declare class CronJobV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_cron_job_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/cron_job_v1 kubernetes_cron_job_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CronJobV1Config
    */
    constructor(scope: Construct, id: string, config: CronJobV1Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): CronJobV1MetadataOutputReference;
    putMetadata(value: CronJobV1Metadata): void;
    get metadataInput(): CronJobV1Metadata | undefined;
    private _spec;
    get spec(): CronJobV1SpecOutputReference;
    putSpec(value: CronJobV1Spec): void;
    get specInput(): CronJobV1Spec | undefined;
    private _timeouts;
    get timeouts(): CronJobV1TimeoutsOutputReference;
    putTimeouts(value: CronJobV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CronJobV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
