import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ConfigMapV1DataConfig extends cdktf.TerraformMetaArguments {
    /**
    * The data we want to add to the ConfigMap.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/config_map_v1_data#data ConfigMapV1Data#data}
    */
    readonly data: {
        [key: string]: string;
    };
    /**
    * Force overwriting data that is managed outside of Terraform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/config_map_v1_data#force ConfigMapV1Data#force}
    */
    readonly force?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/config_map_v1_data#id ConfigMapV1Data#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/config_map_v1_data#metadata ConfigMapV1Data#metadata}
    */
    readonly metadata: ConfigMapV1DataMetadata;
}
export interface ConfigMapV1DataMetadata {
    /**
    * The name of the ConfigMap.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/config_map_v1_data#name ConfigMapV1Data#name}
    */
    readonly name: string;
    /**
    * The namespace of the ConfigMap.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/config_map_v1_data#namespace ConfigMapV1Data#namespace}
    */
    readonly namespace?: string;
}
export declare function configMapV1DataMetadataToTerraform(struct?: ConfigMapV1DataMetadataOutputReference | ConfigMapV1DataMetadata): any;
export declare class ConfigMapV1DataMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConfigMapV1DataMetadata | undefined;
    set internalValue(value: ConfigMapV1DataMetadata | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/config_map_v1_data kubernetes_config_map_v1_data}
*/
export declare class ConfigMapV1Data extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_config_map_v1_data";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/config_map_v1_data kubernetes_config_map_v1_data} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ConfigMapV1DataConfig
    */
    constructor(scope: Construct, id: string, config: ConfigMapV1DataConfig);
    private _data?;
    get data(): {
        [key: string]: string;
    };
    set data(value: {
        [key: string]: string;
    });
    get dataInput(): {
        [key: string]: string;
    } | undefined;
    private _force?;
    get force(): boolean | cdktf.IResolvable;
    set force(value: boolean | cdktf.IResolvable);
    resetForce(): void;
    get forceInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): ConfigMapV1DataMetadataOutputReference;
    putMetadata(value: ConfigMapV1DataMetadata): void;
    get metadataInput(): ConfigMapV1DataMetadata | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
