import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AnnotationsConfig extends cdktf.TerraformMetaArguments {
    /**
    * A map of annotations to apply to the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/annotations#annotations Annotations#annotations}
    */
    readonly annotations: {
        [key: string]: string;
    };
    /**
    * The apiVersion of the resource to annotate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/annotations#api_version Annotations#api_version}
    */
    readonly apiVersion: string;
    /**
    * Force overwriting annotations that were created or edited outside of Terraform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/annotations#force Annotations#force}
    */
    readonly force?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/annotations#id Annotations#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The kind of the resource to annotate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/annotations#kind Annotations#kind}
    */
    readonly kind: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/annotations#metadata Annotations#metadata}
    */
    readonly metadata: AnnotationsMetadata;
}
export interface AnnotationsMetadata {
    /**
    * The name of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/annotations#name Annotations#name}
    */
    readonly name: string;
    /**
    * The namespace of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/annotations#namespace Annotations#namespace}
    */
    readonly namespace?: string;
}
export declare function annotationsMetadataToTerraform(struct?: AnnotationsMetadataOutputReference | AnnotationsMetadata): any;
export declare class AnnotationsMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AnnotationsMetadata | undefined;
    set internalValue(value: AnnotationsMetadata | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/annotations kubernetes_annotations}
*/
export declare class Annotations extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_annotations";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/annotations kubernetes_annotations} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AnnotationsConfig
    */
    constructor(scope: Construct, id: string, config: AnnotationsConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    get apiVersionInput(): string | undefined;
    private _force?;
    get force(): boolean | cdktf.IResolvable;
    set force(value: boolean | cdktf.IResolvable);
    resetForce(): void;
    get forceInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _metadata;
    get metadata(): AnnotationsMetadataOutputReference;
    putMetadata(value: AnnotationsMetadata): void;
    get metadataInput(): AnnotationsMetadata | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
