import { ICertificate } from 'aws-cdk-lib/aws-certificatemanager';
import { IUserPool } from 'aws-cdk-lib/aws-cognito';
import { Function as CdkFunction } from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
export interface RemixCustomDomainProps {
    readonly certificate: ICertificate;
    readonly domainName: string;
}
export interface RemixCognitoAuthProps {
    readonly authDomain: string;
    readonly userPool: IUserPool;
}
export interface RemixAppProps {
    readonly customDomain?: RemixCustomDomainProps;
    readonly remixPath: string;
    readonly cognitoAuth?: RemixCognitoAuthProps;
    readonly ddbSessions?: boolean;
    readonly isDev?: boolean;
}
export declare class RemixApp extends Construct {
    readonly handler: CdkFunction;
    readonly cdnDomainName: string;
    readonly cdnDistributionId: string;
    constructor(scope: Construct, id: string, { ddbSessions, customDomain, remixPath, cognitoAuth, isDev, }: RemixAppProps);
}
